var portal = window.portal || {};
(function() {
    var g = document.getElementsByTagName("script");
    var k = g[g.length - 1];
    var h = k ? String(k.src) : "./";
    var l = h.substring(0, h.lastIndexOf("/"));
    portal.baseURI = l + "/..";
    portal.xml = {};
    portal.xml.getLocalName = function(b) {
        return b.localName || b.baseName
    };
    portal.xml.getTextContent = function(b) {
        return b.textContent || b.text || ""
    };
    portal.xml.hasAttribute = function(c, b) {
        return c.hasAttribute ? c.hasAttribute(b) : function(d) {
            return d && d.specified
        }(c.attributes.getNamedItem(b))
    };
    portal.form = {};

    function i(b, d, c) {
        if (b[d]) {
            if (typeof b[d] == "string") {
                b[d] = [b[d]]
            }
            b[d].push(c)
        } else {
            b[d] = c
        }
    }
    portal.form.getData = function(s) {
        var f = {},
            e, u, r, b, c, t, d;
        for (var e = 0, u = s.elements.length; e < u; e++) {
            c = s.elements[e];
            t = c.name;
            if (t && !c.disabled) {
                switch (c.type) {
                    case "file":
                    case undefined:
                    case "reset":
                        break;
                    case "radio":
                    case "checkbox":
                        if (c.checked) {
                            i(f, t, c.value)
                        }
                        break;
                    case "submit":
                        if (document.activeElement === c) {
                            i(f, t, c.value)
                        }
                        break;
                    case "select-one":
                        if (c.selectedIndex > -1) {
                            d = c.options[c.selectedIndex];
                            i(f, t, (d.attributes.value && d.attributes.value.specified) ? d.value : (d.text || d.innerText || ""))
                        }
                        break;
                    case "select-multiple":
                        if (c.selectedIndex > -1) {
                            for (r = c.selectedIndex, b = c.options.length; r < b; r++) {
                                d = c.options[r];
                                if (d.selected) {
                                    i(f, t, (d.attributes.value && d.attributes.value.specified) ? d.value : (d.text || d.innerText || ""))
                                }
                            }
                        }
                        break;
                    default:
                        i(f, t, c.value);
                        break
                }
            }
        }
        return f
    };
    portal.locale = {};
    portal.getLocale = function(b) {
        return portal.locale[b] || b
    };
    portal.version = "4.2.2 (20100618-0120)";

    function j(c) {
        var b = new Function;
        b.prototype = c.prototype;
        return new b
    }
    portal.gadget = {};
    portal.gadget.Gadget = function(d, e, c, b) {
        window[d] = this;
        this.identifier = d;
        this.loading = true;
        this.src = c.src;
        this.body = e;
        e.id = d;
        this.preferences = c.preferences;
        this.includes = [];
        this._class = c;
        this._window = b
    };
    portal.gadget.Gadget.prototype.body = null;
    portal.gadget.Gadget.prototype.identifier = null;
    portal.gadget.Gadget.prototype.loading = null;
    portal.gadget.Gadget.prototype.preferences = null;
    portal.gadget.Gadget.prototype.src = null;
    portal.gadget.Gadget.prototype.title = null;
    portal.gadget.Gadget.prototype.icon = null;
    portal.gadget.Gadget.prototype.includes = null;
    portal.gadget.Gadget.prototype.setTitle = function(b) {
        return this._window.setTitle(b)
    };
    portal.gadget.Gadget.prototype.setIcon = function(b) {
        return this._window.setIcon(b)
    };
    portal.gadget.Gadget.prototype.showLoading = function() {
        return this._window.showLoading()
    };
    portal.gadget.Gadget.prototype.hideLoading = function() {
        return this._window.hideLoading()
    };
    portal.gadget.Gadget.prototype.showPreferences = function() {
        return this._window.showPreferences()
    };
    portal.gadget.Gadget.prototype.hidePreferences = function() {
        return this._window.hidePreferences()
    };
    portal.gadget.Gadget.prototype.maximize = function() {
        return this._window.maximize()
    };
    portal.gadget.Gadget.prototype.minimize = function() {
        return this._window.minimize()
    };
    portal.gadget.Gadget.prototype.restore = function() {
        return this._window.restore()
    };
    portal.gadget.Gadget.prototype.setPreference = function(c, b) {
        return this._window.setPreference(c, b)
    };
    portal.gadget.Gadget.prototype.getPreference = function(b) {
        return this._window.getPreference(b)
    };
    portal.gadget.Gadget.prototype.setPreferenceFromElement = function(b) {
        return this._window.setPreferenceFromElement(b)
    };
    portal.gadget.Gadget.prototype.setAutoRefresh = function(b) {
        return this._window.setAutoRefresh(b)
    };
    portal.gadget.Gadget.prototype.registerInclude = function(b) {
        this.includes.push(b)
    };
    portal.gadget.Gadget.prototype.refreshIncludes = function(b) {
        var d = this.includes,
            c = d.length;
        b = b || function() {};
        if (c) {
            for (var e = 0; e < d.length; ++e) {
                d[e].refresh(function() {
                    !--c && b()
                })
            }
        } else {
            b()
        }
    };
    portal.gadget.Template = function(f) {
        var e = f,
            b = -1,
            c = [],
            m = {},
            d = "";
        while ((b = e.indexOf("${")) >= 0) {
            if (b !== 0) {
                c.push(e.slice(0, b));
                e = e.slice(b)
            }
            b = e.indexOf("}");
            if (b < 0) {
                throw new Error("Template instance creation failed! Reason: incomplete replacement variable definition.")
            }
            d = e.slice(2, b);
            if (!d) {
                throw new Error("Template instance creation failed! Reason: empty variable definition.")
            }
            c.push("");
            m[d] = c.length - 1;
            e = e.slice(b + 1)
        }
        c.push(e);
        this._compiled = c;
        this._variables = m
    };
    portal.gadget.Template.prototype.generate = function(d) {
        var e = typeof d == "function" ? d : function(m) {
                return d[m]
            },
            f = this._variables,
            b = this._compiled;
        for (var c in f) {
            if (f.hasOwnProperty(c)) {
                b[f[c]] = e(c)
            }
        }
        return b.join("")
    };
    portal.gadget.HttpParam = function(c, b, d, e) {
        this.name = new portal.gadget.Template(c || String(portal.gadget.HttpParam.id++));
        this.value = new portal.gadget.Template(String(b));
        this.destination = d == "proxy" ? "proxy" : "target";
        this.method = e || "GET"
    };
    portal.gadget.HttpParam.id = 0;
    portal.gadget.HttpParam.PROXY_PARAM_PREFIX = "internal-";
    portal.gadget.HttpParam.prototype.toQueryString = function(b) {
        return encodeURIComponent(this.getName(b)) + "=" + encodeURIComponent(this.getValue(b))
    };
    portal.gadget.HttpParam.prototype.getName = function(c) {
        function b(e) {
            return c.getPreference(e)
        }
        var d = this.name.generate(b);
        if (this.destination == "proxy" && this.method == "POST") {
            d = portal.gadget.HttpParam.PROXY_PARAM_PREFIX + d
        }
        return d
    };
    portal.gadget.HttpParam.prototype.getValue = function(c) {
        function b(d) {
            return c.getPreference(d)
        }
        return this.value.generate(b)
    };
    portal.gadget.HttpPreferenceParam = function(b, c) {
        portal.gadget.HttpParam.call(this, b, "", "target", c)
    };
    portal.gadget.HttpPreferenceParam.prototype = j(portal.gadget.HttpParam);
    portal.gadget.HttpPreferenceParam.prototype.getValue = function(b) {
        return b.getPreference(this.getName(b))
    };
    portal.gadget.HttpPreferenceParam.prototype.toQueryString = function(b) {
        var c = [];
        var f = this.getValue(b).split(",");
        var e = encodeURIComponent(this.getName(b)) + "=";
        for (var d = 0; d < f.length; d++) {
            c.push(e + encodeURIComponent(f[d]))
        }
        return c.join("&")
    };
    portal.gadget.HttpParams = function() {
        this._params = []
    };
    portal.gadget.HttpParams.prototype.add = function(b) {
        if (b instanceof portal.gadget.HttpParam) {
            this._params.push(b)
        } else {
            throw new Error("Attempt to add not an HttpParam instance to HttpParams collection!")
        }
    };
    portal.gadget.HttpParams.prototype.toQueryString = function(c, n, e) {
        var d = this._params,
            b = [],
            f = null;
        for (var o = 0; o < d.length; ++o) {
            f = d[o];
            if (f.method == n && (!e || f.destination == e)) {
                b.push(f.toQueryString(c))
            }
        }
        return b.join("&")
    };
    portal.gadget.HttpParams.prototype.toJSONObject = function(f, d, b) {
        var t = this._params,
            e = {},
            u = null,
            r = null;
        for (var s = 0; s < t.length; ++s) {
            u = t[s];
            if (u.method == d && (!b || u.destination == b)) {
                var q = u.getName(f);
                var c = u.getValue(f);
                if (!e[q]) {
                    e[q] = c
                } else {
                    if (typeof e[q] == "string") {
                        e[q] = [e[q], c]
                    } else {
                        e[q].push(c)
                    }
                }
            }
        }
        return e
    };
    portal.gadget.IncludeConfig = function(o) {
        var d = o.url,
            q = d.match(/([^\?]*)\??([^\?]*)/);
        this.url = new portal.gadget.Template(q[1]);
        this.proxy = o.proxy;
        this.method = o.method;
        var e = q[2],
            c = e ? e.split("&") : [],
            b = null,
            f = new portal.gadget.HttpParams();
        for (var p = 0; p < c.length; ++p) {
            b = c[p].split("=");
            if (b[1]) {
                f.add(new portal.gadget.HttpParam(b.shift(), b.join("="), "target", "GET"))
            }
        }
        this.httpParams = f
    };
    portal.gadget.IncludeConfig.CSS_CLASS = "p-include";
    portal.gadget.Include = function(d, c, b) {
        if (!(d instanceof portal.gadget.Gadget)) {
            throw new Error("Not a portal.gadget instance passed to portal.gadget.Include!")
        }
        if (!c || c.nodeType != 1) {
            throw new Error("Incorrect view gate was passed to portal.gadget.Include!")
        }
        if (!(b instanceof portal.gadget.IncludeConfig)) {
            throw new Error("Not a portal.gadget.IncludeConfig instance passed to portal.gadget.Include!")
        }
        this.gadget = d;
        this.viewGate = c;
        this.config = b
    };
    portal.gadget.Include.setTitleFromHttpHeader = false;
    portal.gadget.Include.prototype.setContent = function(b, d) {
        var c = this.viewGate;
        while (c.firstChild) {
            c.removeChild(c.firstChild)
        }
        if (d) {
            while (b.firstChild) {
                c.appendChild(b.firstChild)
            }
        } else {
            c.appendChild(b)
        }
    };
    portal.gadget.Include.prototype.refresh = function(c) {
        function b(m) {
            return o.getPreference(m)
        }
        c = c || function() {};
        var n = this,
            o = this.gadget,
            e = this.config.httpParams,
            f = e.toQueryString(o, "GET", "target"),
            d = this.config.url.generate(b);
        if (!this.config.proxy) {
            d = bb.uri.resolveUri(d, o.src)
        }
        d = d + (f ? (d.indexOf("?") != -1 ? "&" : "?") + f : "");
        if (this.config.proxy) {
            d = gadgets.io.getProxyUrl(d, e.toJSONObject(o, "GET", "proxy"))
        }
        gadgets.io.makeRequest(d, function(q) {
            if (portal.gadget.Include.setTitleFromHttpHeader) {
                var r = q.getHeader("X-BB-Portal-Title");
                if (r) {
                    o.setTitle(r)
                } else {
                    var m = o._class;
                    o.setTitle(m.title || "")
                }
            }
            n.setContent(bb.html.createElementFromString("<div>" + q.text + "</div>"), true);
            c.call(o, q)
        }, {
            method: this.config.method,
            headers: {
                Referer: o.src
            },
            data: this.config.method == "POST" ? e.toQueryString(o, "POST") : ""
        })
    }
})();
var gadgets = window.gadgets || {};
if (!gadgets.config) {
    gadgets.config = {
        proxyUrl: "proxy"
    }
}
if (window.portal) {
    gadgets.config.proxyUrl = portal.baseURI + "/" + gadgets.config.proxyUrl
}
gadgets.io = function() {
    return {
        encodeValues: function(g) {
            var h = [],
                i;
            for (var j in g) {
                if (g.hasOwnProperty(j)) {
                    i = g[j];
                    if (typeof i == "object" && i.length) {
                        for (var f = 0; f < i.length; f++) {
                            h.push(encodeURIComponent(j), "=", encodeURIComponent(i[f]), "&")
                        }
                    } else {
                        h.push(encodeURIComponent(j), "=", encodeURIComponent(i), "&")
                    }
                }
            }
            return h.join("")
        },
        getProxyUrl: function(d, c) {
            c = c || {};
            if (d) {
                c.url = d
            }
            return gadgets.config.proxyUrl + (gadgets.config.proxyUrl.indexOf("?") == -1 ? "?" : "&") + gadgets.io.encodeValues(c)
        },
        makeRequest: function(q, k, p) {
            p = p || {};
            var r = p[gadgets.io.RequestParameters.METHOD] || gadgets.io.MethodType.GET;
            var o = p[gadgets.io.RequestParameters.HEADERS] || {};
            var m = p[gadgets.io.RequestParameters.POST_DATA] || null;
            var l = p[gadgets.io.RequestParameters.TIMEOUT] || 30000;
            if (r === gadgets.io.MethodType.POST && !o["Content-Type"] && m) {
                o["Content-Type"] = "application/x-www-form-urlencoded"
            }
            var i = new XMLHttpRequest();
            i.open(r, q, true);
            for (var n in o) {
                if (o.hasOwnProperty(n)) {
                    i.setRequestHeader(n, o[n])
                }
            }
            if (l) {
                if (typeof l != "number") {
                    l = parseInt(l, 10)
                }
                l = setTimeout(function() {
                    i.abort()
                }, l)
            }
            i.onreadystatechange = function() {
                if (i.readyState == 2) {
                    i._headersReceived = true
                }
                if (i.readyState == 4) {
                    if (l) {
                        clearTimeout(l)
                    }
                    if (k) {
                        var f = {
                            text: i.responseText,
                            data: null,
                            errors: [],
                            status: i.status,
                            headers: {}
                        };
                        var b = i._headersReceived ? String(i.getAllResponseHeaders()).split("\n") : [];
                        for (var d = 0; d < b.length; d++) {
                            var e = bb.string.trim(b[d]).split(": ");
                            if (e.length > 1) {
                                f.headers[e.shift()] = e.join(": ")
                            }
                        }
                        f.getHeader = function(h) {
                            h = (h || "").toLowerCase();
                            for (var g in this.headers) {
                                if (this.headers.hasOwnProperty(g)) {
                                    if ((g || "").toLowerCase() == h) {
                                        return this.headers[g]
                                    }
                                }
                            }
                            return null
                        };
                        if (bb.browser.opera && !i.status) {
                            i.status = 204;
                            i.statusText = "No Content"
                        }
                        if ((!i.status && (location.protocol == "file:" || location.protocol == "chrome:")) || (i.status >= 200 && i.status < 300) || i.status == 304 || i.status == 1223) {
                            switch (p[gadgets.io.RequestParameters.CONTENT_TYPE]) {
                                case gadgets.io.ContentType.DOM:
                                    f.data = i.responseXML;
                                    break;
                                case gadgets.io.ContentType.JSON:
                                    try {
                                        f.data = gadgets.json.parse(i.responseText)
                                    } catch (c) {
                                        f.errors[f.errors.length] = c.message || c
                                    }
                                    break;
                                case gadgets.io.ContentType.FEED:
                                    f.errors[f.errors.length] = "Not implemented";
                                    break;
                                case gadgets.io.ContentType.TEXT:
                                default:
                                    f.data = i.responseText;
                                    break
                            }
                        } else {
                            if (i.status == 0) {
                                f.errors[f.errors.length] = "No connection to server"
                            } else {
                                f.errors[f.errors.length] = "HTTP error:" + i.status;
                                if (i.statusText) {
                                    f.errors[f.errors.length] = i.statusText
                                }
                            }
                        }
                        k(f)
                    }
                }
            };
            i.send(m);
            return i
        }
    }
}();
gadgets.io.RequestParameters = {
    METHOD: "method",
    CONTENT_TYPE: "type",
    POST_DATA: "data",
    HEADERS: "headers",
    AUTHORIZATION: "authorization",
    NUM_ENTRIES: "NUM_ENTRIES",
    GET_SUMMARIES: "GET_SUMMARIES",
    TIMEOUT: "timeout"
};
gadgets.io.MethodType = {
    GET: "GET",
    POST: "POST",
    PUT: "PUT",
    DELETE: "DELETE",
    HEAD: "HEAD"
};
gadgets.io.ContentType = {
    TEXT: "text",
    DOM: "xml",
    JSON: "json",
    FEED: "feed"
};
gadgets.io.AuthorizationType = {
    NONE: "NONE",
    SIGNED: "SIGNED",
    OAUTH: "OAUTH"
};
gadgets.io.ProxyUrlRequestParameters = {
    REFRESH_INTERVAL: "refresh",
    BACKBASE_PTC_PIPE: "pipe"
};
if (!this.JSON) {
    JSON = {}
}(function() {
    function f(n) {
        return n < 10 ? "0" + n : n
    }
    if (typeof Date.prototype.toJSON !== "function") {
        Date.prototype.toJSON = function(key) {
            return this.getUTCFullYear() + "-" + f(this.getUTCMonth() + 1) + "-" + f(this.getUTCDate()) + "T" + f(this.getUTCHours()) + ":" + f(this.getUTCMinutes()) + ":" + f(this.getUTCSeconds()) + "Z"
        };
        String.prototype.toJSON = Number.prototype.toJSON = Boolean.prototype.toJSON = function(key) {
            return this.valueOf()
        }
    }
    var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        gap, indent, meta = {
            "\b": "\\b",
            "\t": "\\t",
            "\n": "\\n",
            "\f": "\\f",
            "\r": "\\r",
            '"': '\\"',
            "\\": "\\\\"
        },
        rep;

    function quote(string) {
        escapable.lastIndex = 0;
        return escapable.test(string) ? '"' + string.replace(escapable, function(a) {
            var c = meta[a];
            return typeof c === "string" ? c : "\\u" + ("0000" + a.charCodeAt(0).toString(16)).slice(-4)
        }) + '"' : '"' + string + '"'
    }

    function str(key, holder) {
        var i, k, v, length, mind = gap,
            partial, value = holder[key];
        if (value && typeof value === "object" && typeof value.toJSON === "function") {
            value = value.toJSON(key)
        }
        if (typeof rep === "function") {
            value = rep.call(holder, key, value)
        }
        switch (typeof value) {
            case "string":
                return quote(value);
            case "number":
                return isFinite(value) ? String(value) : "null";
            case "boolean":
            case "null":
                return String(value);
            case "object":
                if (!value) {
                    return "null"
                }
                gap += indent;
                partial = [];
                if (Object.prototype.toString.apply(value) === "[object Array]") {
                    length = value.length;
                    for (i = 0; i < length; i += 1) {
                        partial[i] = str(i, value) || "null"
                    }
                    v = partial.length === 0 ? "[]" : gap ? "[\n" + gap + partial.join(",\n" + gap) + "\n" + mind + "]" : "[" + partial.join(",") + "]";
                    gap = mind;
                    return v
                }
                if (rep && typeof rep === "object") {
                    length = rep.length;
                    for (i = 0; i < length; i += 1) {
                        k = rep[i];
                        if (typeof k === "string") {
                            v = str(k, value);
                            if (v) {
                                partial.push(quote(k) + (gap ? ": " : ":") + v)
                            }
                        }
                    }
                } else {
                    for (k in value) {
                        if (Object.hasOwnProperty.call(value, k)) {
                            v = str(k, value);
                            if (v) {
                                partial.push(quote(k) + (gap ? ": " : ":") + v)
                            }
                        }
                    }
                }
                v = partial.length === 0 ? "{}" : gap ? "{\n" + gap + partial.join(",\n" + gap) + "\n" + mind + "}" : "{" + partial.join(",") + "}";
                gap = mind;
                return v
        }
    }
    if (typeof JSON.stringify !== "function") {
        JSON.stringify = function(value, replacer, space) {
            var i;
            gap = "";
            indent = "";
            if (typeof space === "number") {
                for (i = 0; i < space; i += 1) {
                    indent += " "
                }
            } else {
                if (typeof space === "string") {
                    indent = space
                }
            }
            rep = replacer;
            if (replacer && typeof replacer !== "function" && (typeof replacer !== "object" || typeof replacer.length !== "number")) {
                throw new Error("JSON.stringify")
            }
            return str("", {
                "": value
            })
        }
    }
    if (typeof JSON.parse !== "function") {
        JSON.parse = function(text, reviver) {
            var j;

            function walk(holder, key) {
                var k, v, value = holder[key];
                if (value && typeof value === "object") {
                    for (k in value) {
                        if (Object.hasOwnProperty.call(value, k)) {
                            v = walk(value, k);
                            if (v !== undefined) {
                                value[k] = v
                            } else {
                                delete value[k]
                            }
                        }
                    }
                }
                return reviver.call(holder, key, value)
            }
            cx.lastIndex = 0;
            if (cx.test(text)) {
                text = text.replace(cx, function(a) {
                    return "\\u" + ("0000" + a.charCodeAt(0).toString(16)).slice(-4)
                })
            }
            if (/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, "@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, "]").replace(/(?:^|:|,)(?:\s*\[)+/g, ""))) {
                j = eval("(" + text + ")");
                return typeof reviver === "function" ? walk({
                    "": j
                }, "") : j
            }
            throw new SyntaxError("JSON.parse")
        }
    }
})();
gadgets.json = function() {
    return {
        stringify: JSON.stringify,
        parse: function(c) {
            c = c.replace(/\\x(..)/g, "\\u00$1");
            try {
                c = JSON.parse(c)
            } catch (d) {
                d.message += ". Source: " + c;
                throw d
            }
            return c
        }
    }
}();
gadgets.pubsub = function() {
    return {
        publish: function(e, f) {
            var d = bb.document.createEvent("CustomEvent");
            d.initCustomEventNS("gadgets.pubsub", e, false, false, f);
            bb.document.dispatchEvent(d)
        },
        subscribe: function(d, c) {
            c._subscribeEvent = function(b) {
                c(b.detail)
            };
            bb.document.addEventListenerNS("gadgets.pubsub", d, c._subscribeEvent, false)
        },
        unsubscribe: function(d, c) {
            bb.document.removeEventListenerNS("gadgets.pubsub", d, c._subscribeEvent, false);
            c._subscribeEvent = null
        }
    }
}();
gadgets.util = function() {
    function g(c) {
        var b;
        var d = c;
        var k = d.indexOf("?");
        var j = d.indexOf("#");
        if (j === -1) {
            b = d.substr(k + 1)
        } else {
            b = [d.substr(k + 1, j - k - 1), "&", d.substr(j + 1)].join("")
        }
        return b.split("&")
    }
    var h = null;
    var f = {
        0: false,
        10: true,
        13: true,
        34: true,
        39: true,
        60: true,
        62: true,
        92: true,
        8232: true,
        8233: true
    };

    function e(c, b) {
        return String.fromCharCode(b)
    }
    return {
        getUrlParameters: function(b) {
            if (h !== null && typeof b === "undefined") {
                return h
            }
            var j = {};
            h = {};
            var r = g(b || document.location.href);
            var d = window.decodeURIComponent ? decodeURIComponent : unescape;
            for (var p = 0, q = r.length; p < q; ++p) {
                var i = r[p].indexOf("=");
                if (i === -1) {
                    continue
                }
                var s = r[p].substring(0, i);
                var c = r[p].substring(i + 1);
                c = c.replace(/\+/g, " ");
                j[s] = d(c)
            }
            if (typeof b === "undefined") {
                h = j
            }
            return j
        },
        escapeString: function(c) {
            if (!c) {
                return c
            }
            var j = [],
                d, b;
            for (var i = 0, m = c.length; i < m; ++i) {
                d = c.charCodeAt(i);
                b = f[d];
                if (b === true) {
                    j.push("&#", d, ";")
                } else {
                    if (b !== false) {
                        j.push(c.charAt(i))
                    }
                }
            }
            return j.join("")
        },
        unescapeString: function(b) {
            if (!b) {
                return b
            }
            return b.replace(/&#([0-9]+);/g, e)
        }
    }
}();
gadgets.util.getUrlParameters();
bb.preRegisterXMLString('<d:tdl xmlns:d="http://www.backbase.com/2006/tdl" xmlns:xi="http://www.w3.org/2001/XInclude" xml:base=""><d:tdl xmlns="http://www.w3.org/1999/xhtml" xmlns:xs="http://www.w3.org/2001/XMLSchema" xml:base="../bcf/4_4_9_1/bindings/www.w3.org.1999.xhtml/xhtml.xml"><d:namespace name="http://www.w3.org/1999/xhtml"><d:element name="xhtmlElement" abstract="true"><d:resource type="text/javascript">xhtml={namespaceURI:"http://www.w3.org/1999/xhtml",handlers:{ieclick:function(){var a=bb.getControllerFromView(this);if(this.type=="radio"&amp;&amp;!a.hasAttribute("name")){this.checked=true;}if(a.__oldChecked!=this.checked){bb.command.fireEvent(a,"change",true,false);a.__oldChecked=this.checked;}},iefocusin:function(){bb.getControllerFromView(this).__oldChecked=this.checked;},change:function(){bb.command.fireEvent(bb.getControllerFromView(this),"change",true,false);},select:function(){bb.command.fireEvent(bb.getControllerFromView(this),"select",true,false);},submit:function(d){d=d||event;var c=bb.getControllerFromView(this);var a=true;try{a=!bb.command.fireEvent(c,"submit",true,true).defaultPrevented;}catch(b){a=false;}if(!a){if(d.preventDefault){d.preventDefault();}d.returnValue=false;return false;}},reset:function(){var c=bb.getControllerFromView(this);if(!bb.command.fireEvent(c,"reset",true,false).defaultPrevented&amp;&amp;(bb.browser.gecko||bb.browser.webkit)){var a=c.viewNode.getElementsByTagName("form");for(var b=a.length-1;b&gt;=0;b--){a[b].reset();}}},select_focusHandler:function(){var a=bb.getControllerFromView(this);a._._initialValue=this.value;},select_blurHandler:function(){var a=bb.getControllerFromView(this);if(a._._initialValue!=this.value){xhtml.handlers.change.call(this);}},select_clickHandler:function(){var a=bb.getControllerFromView(this);a._._mouseClick=true;},select_keydownHandler:function(){var a=bb.getControllerFromView(this);a._._mouseClick=false;},select_changeHandler:function(){var a=bb.getControllerFromView(this);if(a._._mouseClick){a._._initialValue=this.value;xhtml.handlers.change.call(this);}}}};</d:resource><d:attribute name="id" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="class" onmap="if(bb.browser.ie){ this.viewNode.className = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="title" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="lang" namespace="http://www.w3.org/XML/1998/namespace" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="dir" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="style" onmap="if(bb.browser.ie){ this.viewNode.style.cssText = value; }else{ this.viewNode.setAttribute(name, value) }"/><d:template type="text/javascript">var a=document.createElement(this.modelNode.localName||this.modelNode.baseName);return[a,a];</d:template></d:element><d:element name="xhtmlFocusableElement" extends="xhtmlElement" abstract="true"><d:attribute name="accesskey" onmap="if(bb.browser.ie){ this.viewNode.accessKey = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="tabindex" onmap="if(bb.browser.ie){ this.viewNode.tabIndex = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:method name="focus"><d:body type="text/javascript">if(this.viewNode&amp;&amp;this.viewNode.focus){this.viewNode.focus();}</d:body></d:method><d:method name="blur"><d:body type="text/javascript">if(this.viewNode&amp;&amp;this.viewNode.blur){this.viewNode.blur();}</d:body></d:method></d:element><d:element name="body" extends="xhtmlElement"/><d:element name="head"><d:attribute name="profile"/></d:element><d:element name="html"><d:attribute name="version"/><d:attribute name="xmlns"/></d:element><d:element name="title"/><d:element name="address" extends="xhtmlElement"/><d:element name="blockquote" extends="xhtmlElement"><d:attribute name="cite" onmap="this.viewNode.setAttribute(name, value)"/></d:element><d:element name="div" extends="xhtmlElement"/><d:element name="p" extends="xhtmlElement"/><d:element name="pre" extends="xhtmlElement"><d:attribute name="space" namespace="http://www.w3.org/XML/1998/namespace" default="preserve" onmap="this.viewNode.setAttribute(name, value)"/></d:element><d:element name="abbr" extends="xhtmlElement"/><d:element name="acronym" extends="xhtmlElement"/><d:element name="br" extends="xhtmlElement"/><d:element name="cite" extends="xhtmlElement"/><d:element name="code" extends="xhtmlElement"/><d:element name="dfn" extends="xhtmlElement"/><d:element name="em" extends="xhtmlElement"/><d:element name="kbd" extends="xhtmlElement"/><d:element name="q" extends="xhtmlElement"><d:attribute name="cite" onmap="this.viewNode.setAttribute(name, value)"/></d:element><d:element name="samp" extends="xhtmlElement"/><d:element name="span" extends="xhtmlElement"/><d:element name="strong" extends="xhtmlElement"/><d:element name="var" extends="xhtmlElement"/><d:element name="h1" extends="xhtmlElement"/><d:element name="h2" extends="xhtmlElement"/><d:element name="h3" extends="xhtmlElement"/><d:element name="h4" extends="xhtmlElement"/><d:element name="h5" extends="xhtmlElement"/><d:element name="h6" extends="xhtmlElement"/><d:element name="a" extends="xhtmlFocusableElement"><d:attribute name="charset" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="href"><d:mapper type="text/javascript">var a;if(bb.browser.ie&amp;&amp;this.viewNode.childNodes.length==1&amp;&amp;(a=this.viewNode.firstChild).nodeType==3&amp;&amp;a.nodeValue.indexOf("@")!=-1){this.viewNode.removeChild(a);this.viewNode.href=this.getProperty(name);this.viewNode.appendChild(a);}else{this.viewNode.href=this.getProperty(name);}</d:mapper></d:attribute><d:attribute name="hreflang" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="rel" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="rev" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="type" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="target" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="name" onmap="this.viewNode.setAttribute(name, value);"/><d:template type="text/javascript">var b=document.createElement("a");if(bb.browser.ie){var a=this.modelNode.getAttribute("coords");var c=this.modelNode.getAttribute("shape");if(a!=null&amp;&amp;c!=null){b=document.createElement(\'&lt;a shape="\'+c+\'" coords="\'+a+\'"&gt;\');}}return[b,b];</d:template><d:attribute name="coords" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="shape" onmap="this.viewNode.setAttribute(name, value)"/><d:property name="href" onget="return bb.uri.resolveUri( this.getAttribute(name), this.getProperty(\'baseURI\') );" onset="this.setAttribute(name,  value);"/></d:element><d:element name="dl" extends="xhtmlElement"/><d:element name="dt" extends="xhtmlElement"/><d:element name="dd" extends="xhtmlElement"/><d:element name="ol" extends="xhtmlElement"/><d:element name="ul" extends="xhtmlElement"/><d:element name="li" extends="xhtmlElement"/><d:element name="b" extends="xhtmlElement"/><d:element name="big" extends="xhtmlElement"/><d:element name="hr" extends="xhtmlElement"/><d:element name="i" extends="xhtmlElement"/><d:element name="small" extends="xhtmlElement"/><d:element name="sub" extends="xhtmlElement"/><d:element name="sup" extends="xhtmlElement"/><d:element name="tt" extends="xhtmlElement"/><d:element name="edit" extends="xhtmlElement" abstract="true"><d:attribute name="cite" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="datetime" onmap="if(bb.browser.ie){ this.viewNode.dateTime = value; }else{ this.viewNode.setAttribute(name, value); }"/></d:element><d:element name="ins" extends="edit"/><d:element name="del" extends="edit"/><d:element name="bdo" extends="xhtmlElement"/><d:element name="form" extends="xhtmlElement"><d:template type="text/javascript">var a=bb.browser.ie?document.createElement(\'&lt;form name="\'+this.modelNode.getAttribute("name")+\'"&gt;\'):document.createElement("form");return[a,a];</d:template><d:constructor type="text/javascript">bb.html.addEventListener(this.viewNode,"submit",xhtml.handlers.submit);bb.html.addEventListener(this.viewNode,"reset",xhtml.handlers.reset);</d:constructor><d:destructor type="text/javascript">bb.html.removeEventListener(this.viewNode,"submit",xhtml.handlers.submit);bb.html.removeEventListener(this.viewNode,"reset",xhtml.handlers.reset);if(bb.browser.ie){this.viewNode.removeNode();}</d:destructor><d:attribute name="accept" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="accept-charset" onmap="if(bb.browser.ie){this.viewNode.acceptCharset = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="action" onmap="this.viewNode.action = this.getProperty(name);"/><d:attribute name="method" onmap="this.viewNode.setAttribute(name, value)" default="GET"/><d:attribute name="enctype" onmap="if(bb.browser.ie) this.viewNode.encoding = value; this.viewNode[name] = value;" default="application/x-www-form-urlencoded"/><d:attribute name="target" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="name" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="autocomplete" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="mode" default="replaceChildren"/><d:property name="action" onget="return bb.uri.resolveUri(this.getAttribute(name), this.getProperty(\'baseURI\') );" onset="this.setAttribute(name,  value);"/><d:property name="method" onget="return this.viewNode[name].toUpperCase();" onset="this.setAttribute(name,  value);"/><d:property name="enctype" onget="return this.viewNode[name];" onset="this.setAttribute(name,  value);"/><d:property name="elements"><d:getter type="text/javascript">var b=this.viewNode.elements;var c=[];for(var a=0;a&lt;b.length;a++){c.push(bb.getControllerFromView(b[a]));}return c;</d:getter></d:property><d:method name="submit"><d:body type="text/javascript">this.viewNode.submit();</d:body></d:method></d:element><d:element name="xhtmlControlElement" extends="xhtmlFocusableElement" abstract="true"><d:template type="text/javascript">var a=document.createElement(this.modelNode.localName||this.modelNode.baseName);return[a,a];</d:template><d:attribute name="name" onmap="this.viewNode.name = value"/><d:attribute name="disabled" onmap="this.viewNode.disabled = value == name"/><d:attribute name="autocomplete" onmap="this.viewNode.setAttribute(name, value);"/><d:property name="form" onget="return this.viewNode[name] ? bb.getControllerFromView(this.viewNode[name]) : null;"/><d:property name="disabled" onget="return this.viewNode[name];" onset="this.viewNode[name] = value;"/><d:property name="name" onget="return this.viewNode[name];" onset="this.viewNode[name] = value;"/><d:property name="value" onget="return this.viewNode[name];" onset="this.viewNode[name] = value;"/><d:property name="type" onget="return this.viewNode[name];" onset="this.viewNode[name] = value;"/></d:element><d:element name="input" extends="xhtmlControlElement"><d:resource type="text/javascript">xhtml.input={DOMActivateTypes:{radio:true,checkbox:true,button:true,submit:true,reset:true}};</d:resource><d:method name="__children"><d:body type="text/javascript"/></d:method><d:template type="text/javascript">var e;if(bb.browser.ie){var d="&lt;input ";var c=0,b,a=this.modelNode.attributes;while(b=a[c++]){if(b.nodeName.indexOf("on")!=0){d+=b.nodeName+\'="\'+bb.string.escapeXml(b.nodeValue)+\'" \';}}d+="/&gt;";e=bb.html.createElementFromString(d);}else{e=document.createElement("input");}return[e,e];</d:template><d:constructor type="text/javascript">if(bb.browser.ie&amp;&amp;(this.viewNode.type=="checkbox"||this.viewNode.type=="radio")){bb.html.addEventListener(this.viewNode,"focusin",xhtml.handlers.iefocusin);bb.html.addEventListener(this.viewNode,"click",xhtml.handlers.ieclick);}else{bb.html.addEventListener(this.viewNode,"change",xhtml.handlers.change);}bb.html.addEventListener(this.viewNode,"select",xhtml.handlers.select);</d:constructor><d:destructor type="text/javascript">bb.html.removeEventListener(this.viewNode,"change",xhtml.handlers.change);bb.html.removeEventListener(this.viewNode,"select",xhtml.handlers.select);</d:destructor><d:attribute name="accept" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="alt" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="checked" onmap="this.viewNode.defaultChecked = value == name;"/><d:attribute name="maxlength" onmap="this.viewNode.maxLength = value;"/><d:attribute name="readonly" onmap="this.viewNode.readOnly = value == name;"/><d:attribute name="size" onmap="this.viewNode.size = value;"/><d:attribute name="src" onmap="this.viewNode.src = this.getProperty(name);"/><d:attribute name="type" default="text" onmap="this.viewNode.type = value"/><d:attribute name="value" onmap="this.viewNode.defaultValue = value;"/><d:attribute name="ismap" onmap="this.viewNode.isMap = value == name;"/><d:attribute name="usemap" onmap="if(bb.browser.ie){ this.viewNode.useMap = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:property name="src" onget="return bb.uri.resolveUri(this.getAttribute(name), this.getProperty(\'baseURI\') );" onset="this.setAttribute(name,  value);"/><d:property name="value" onget="return this.viewNode[name];" onset="this.viewNode[name] = value;"/><d:property name="checked" onget="return this.viewNode[name];" onset="this.viewNode[name] = value;"/><d:handler event="click" type="text/javascript">if(this.getProperty("type") in xhtml.input.DOMActivateTypes){var a=bb.document.createEvent("UIEvents");a.initUIEvent("DOMActivate",true,true,window,event.detail);if(!this.dispatchEvent(a)){event.preventDefault();}}</d:handler></d:element><d:element name="textarea" extends="xhtmlControlElement"><d:attribute name="accesskey" onmap="if(bb.browser.ie){ this.viewNode.accessKey = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="cols" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="readonly" onmap="this.viewNode.readOnly = value == name;"/><d:attribute name="rows" onmap="this.viewNode.setAttribute(name, value)"/><d:method name="__children"><d:body type="text/javascript"/></d:method><d:constructor type="text/javascript">var a=this.getProperty("textContent");this.viewNode.defaultValue=a;this.viewNode.value=a;bb.html.addEventListener(this.viewNode,"change",xhtml.handlers.change);bb.html.addEventListener(this.viewNode,"select",xhtml.handlers.select);</d:constructor><d:destructor type="text/javascript">bb.html.removeEventListener(this.viewNode,"change",xhtml.handlers.change);bb.html.removeEventListener(this.viewNode,"select",xhtml.handlers.select);</d:destructor></d:element><d:element name="select" extends="xhtmlControlElement"><d:template type="text/javascript">var e;if(bb.browser.ie){var d="&lt;select ";var c=0,b,a=this.modelNode.attributes;while(b=a[c++]){if(b.nodeName.indexOf("on")!=0){d+=b.nodeName+\'="\'+b.nodeValue+\'" \';}}d+="&gt;&lt;/select&gt;";e=bb.html.createElementFromString(d);}else{e=document.createElement("select");e.multiple=this.modelNode.getAttribute("multiple")=="multiple";}return[e,e];</d:template><d:constructor type="text/javascript">if(bb.browser.ie||bb.browser.opera){bb.html.addEventListener(this.viewNode,"focus",xhtml.handlers.select_focusHandler);bb.html.addEventListener(this.viewNode,"blur",xhtml.handlers.select_blurHandler);bb.html.addEventListener(this.viewNode,"click",xhtml.handlers.select_clickHandler);bb.html.addEventListener(this.viewNode,"keydown",xhtml.handlers.select_keydownHandler);bb.html.addEventListener(this.viewNode,"change",xhtml.handlers.select_changeHandler);}else{bb.html.addEventListener(this.viewNode,"change",xhtml.handlers.change);}</d:constructor><d:destructor type="text/javascript">if(bb.browser.ie||bb.browser.opera){bb.html.removeEventListener(this.viewNode,"focus",xhtml.handlers.select_focusHandler);bb.html.removeEventListener(this.viewNode,"blur",xhtml.handlers.select_blurHandler);bb.html.removeEventListener(this.viewNode,"click",xhtml.handlers.select_clickHandler);bb.html.removeEventListener(this.viewNode,"keydown",xhtml.handlers.select_keydownHandler);bb.html.removeEventListener(this.viewNode,"change",xhtml.handlers.select_changeHandler);}else{bb.html.removeEventListener(this.viewNode,"change",xhtml.handlers.change);}</d:destructor><d:attribute name="size" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="multiple" onmap="this.viewNode.multiple = value == name;"/><d:property name="type" onget="return this.viewNode[name];" onset="this.setAttribute(name,  value)"/><d:property name="value" onget="return this.viewNode[name];" onset="this.viewNode[name] = value;"/><d:property name="multiple" onget="return this.viewNode[name];" onset="this.setAttribute(name,  value)"/><d:property name="selectedIndex" onget="return this.viewNode[name];" onset="this.viewNode[name] = value;"/><d:property name="options"><d:getter type="text/javascript">var a=this.viewNode.options;var c=[];for(var b=0;b&lt;a.length;b++){c.push(bb.getControllerFromView(a[b]));}return c;</d:getter></d:property><d:method name="blur"><d:body type="text/javascript">if(this.viewNode&amp;&amp;this.viewNode.blur){this.viewNode.blur();}if(bb.browser.ie){document.body.focus();}</d:body></d:method><d:handler event="DOMNodeInserted" type="text/javascript">if(bb.browser.ie&amp;&amp;bb.browser.version==7){var a=this.viewNode.style.width;if(!a||a=="auto"){this.viewNode.style.width="auto";}}</d:handler></d:element><d:element name="option" extends="xhtmlElement"><d:template type="text/javascript">var b=document.createElement(this.modelNode.localName||this.modelNode.baseName);var a=this.modelNode.getAttribute("selected");if(a=="selected"||a=="true"){b.defaultSelected=true;}return[b,b];</d:template><d:attribute name="disabled" onmap="this.viewNode.disabled = value == name"/><d:attribute name="label" onmap="if(bb.browser.ie){ this.viewNode.text = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="selected" onmap="this.viewNode.selected = value == name"/><d:attribute name="value" onmap="this.viewNode.setAttribute(name, value)"/><d:property name="disabled" onget="return this.viewNode[name];" onset="this.viewNode[name] = value"/><d:property name="selected" onget="return this.viewNode[name];" onset="this.viewNode[name] = value"/><d:property name="value" onget="return this.viewNode[name];" onset="this.viewNode[name] = value"/><d:constructor type="text/javascript">if(bb.browser.ie&amp;&amp;!this.hasAttribute("value")){this.viewNode.value=this.getProperty("textContent");}</d:constructor><d:handler event="DOMCharacterDataModified" type="text/javascript">if(bb.browser.ie&amp;&amp;!this.hasAttribute("value")){this.viewNode.value=this.getProperty("textContent");}</d:handler><d:handler event="click" type="text/javascript">var a=bb.document.createEvent("UIEvents");a.initUIEvent("DOMActivate",true,true,window,event.detail);if(!this.dispatchEvent(a)){event.preventDefault();}</d:handler></d:element><d:element name="button" extends="xhtmlControlElement"><d:template type="text/javascript">var a;if(bb.browser.ie){a=document.createElement(\'&lt;button type="\'+this.getAttribute("type")+\'" name="\'+(this.modelNode.getAttribute("name")||"")+\'" value="\'+(this.modelNode.getAttribute("value")||"")+\'"&gt;\');}else{a=document.createElement("button");}return[a,a];</d:template><d:attribute name="type" default="submit" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="value"><d:mapper type="text/javascript">if(!bb.browser.ie){this.viewNode.setAttribute(name,value);}</d:mapper></d:attribute><d:property name="type" onget="return this.viewNode[name];" onset="this.setAttribute(name,  value)"/><d:property name="value"><d:getter type="text/javascript">if(!bb.browser.ie){return this.viewNode[name];}else{return this.modelNode.getAttribute("value")||"";}</d:getter><d:setter type="text/javascript">if(!bb.browser.ie){this.viewNode[name]=value;}else{this.modelNode.setAttribute("value",value);}</d:setter></d:property><d:handler event="click" type="text/javascript">var a=bb.document.createEvent("UIEvents");a.initUIEvent("DOMActivate",true,true,window,event.detail);if(!this.dispatchEvent(a)){event.preventDefault();}</d:handler></d:element><d:element name="fieldset" extends="xhtmlElement"/><d:element name="label" extends="xhtmlElement"><d:attribute name="accesskey" onmap="if(bb.browser.ie){ this.viewNode.accessKey = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="for" onmap="if(bb.browser.ie){ this.viewNode.htmlFor = value; }else{ this.viewNode.setAttribute(name, value); }"/></d:element><d:element name="legend" extends="xhtmlElement"><d:attribute name="accesskey" onmap="if(bb.browser.ie){ this.viewNode.accessKey = value; }else{ this.viewNode.setAttribute(name, value); }"/></d:element><d:element name="optgroup" extends="xhtmlElement"><d:attribute name="disabled" onmap="this.viewNode.disabled = value == name;"/><d:attribute name="label" onmap="this.viewNode.setAttribute(name, value)"/></d:element><d:element name="table" extends="xhtmlElement"><d:attribute name="border" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="cellpadding" onmap="if(bb.browser.ie){ this.viewNode.cellPadding = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="cellspacing" onmap="if(bb.browser.ie){ this.viewNode.cellSpacing = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="frame" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="rules" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="summary" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="width" onmap="this.viewNode.setAttribute(name, value)"/></d:element><d:element name="tableChild" extends="xhtmlElement" abstract="true"><d:attribute name="align" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="char" onmap="if(bb.browser.ie){ this.viewNode.ch = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="charoff" onmap="if(bb.browser.ie){ this.viewNode.chOff = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="valign" onmap="if(bb.browser.ie){ this.viewNode.vAlign = value; }else{ this.viewNode.setAttribute(name, value); }"/></d:element><d:element name="caption" extends="xhtmlElement"/><d:element name="tableCol" extends="tableChild" abstract="true"><d:attribute name="span" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="width" onmap="this.viewNode.setAttribute(name, value)"/></d:element><d:element name="colgroup" extends="tableCol"/><d:element name="col" extends="tableCol"><d:template type="text/javascript">var c=document.createElement("col");var a=c;var b=this.getProperty("parentNode");if(bb.browser.ie&amp;&amp;b&amp;&amp;b.getProperty("localName")!="colgroup"){c=document.createElement(\'&lt;col span="\'+this.modelNode.getAttribute("span")+\'"&gt;\');a=document.createElement("colgroup");a.appendChild(c);}return[a,c];</d:template></d:element><d:element name="tr" extends="tableChild"><d:template type="text/javascript">var b=document.createElement("tr");if(bb.browser.ie){var a=this.getProperty("parentNode");if(a&amp;&amp;a.viewGate&amp;&amp;a.viewGate.nodeName=="TABLE"){if(!a.viewGate.tBodies[0]){a.viewGate.appendChild(document.createElement("tbody"));}a.viewGate=a.viewGate.tBodies[0];}}return[b,b];</d:template></d:element><d:element name="tbody" extends="tableChild"/><d:element name="thead" extends="tableChild"/><d:element name="tfoot" extends="tableChild"/><d:element name="tableCell" extends="tableChild" abstract="true"><d:attribute name="abbr" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="axis" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="colspan" onmap="if(bb.browser.ie){ this.viewNode.colSpan = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="headers" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="rowspan" onmap="if(bb.browser.ie){ this.viewNode.rowSpan = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="scope" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="width" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="height" onmap="this.viewNode.setAttribute(name, value)"/></d:element><d:element name="th" extends="tableCell"/><d:element name="td" extends="tableCell"/><d:element name="img" extends="xhtmlElement"><d:template type="text/javascript">var b;var a=b=document.createElement("img");if(bb.browser.ie){b=document.createElement("span");}return[a,b];</d:template><d:attribute name="alt" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="height"><d:mapper type="text/javascript">if(bb.browser.ie){this.viewNode.style.height=value;}else{this.viewNode.setAttribute(name,value);}if(this.modelNode.getAttribute("width")==null){this.setAttribute("width",value);}</d:mapper></d:attribute><d:attribute name="longdesc" onmap="if(bb.browser.ie){ this.viewNode.longDesc = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="src" onchange="this.viewNode.src = this.getProperty(name);"/><d:handler event="DOMNodeInsertedIntoDocument" type="text/javascript">if(this.hasAttribute("src")){if(bb.browser.ie&amp;&amp;bb.browser.version&lt;7){var a=this;setTimeout(function(){if(a.viewNode){a.viewNode.src=a.getProperty("src");}});}else{this.viewNode.src=this.getProperty("src");}}</d:handler><d:attribute name="width"><d:mapper type="text/javascript">if(bb.browser.ie){this.viewNode.style.width=value;}else{this.viewNode.setAttribute(name,value);}if(this.modelNode.getAttribute("height")==null){this.setAttribute("height",value);}</d:mapper></d:attribute><d:attribute name="name" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="ismap" onmap="if(bb.browser.ie){ this.viewNode.isMap = (value == name); }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="usemap" onmap="if(bb.browser.ie){ this.viewNode.useMap = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:property name="src" onget="return bb.uri.resolveUri(this.getAttribute(name), this.getProperty(\'baseURI\'));" onset="this.setAttribute(name,  value);"/></d:element><d:element name="object" extends="xhtmlFocusableElement"><d:template type="text/javascript">var c=this.modelNode.cloneNode(true),a,b=0;while(a=c.attributes[b++]){if(a.nodeName.indexOf("on")==0){c.removeAttribute(a.nodeName);}}var d=bb.html.createElementFromString(bb.xml.serialize(c));return[d,d];</d:template><d:attribute name="archive" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="classid" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="codebase" onmap="if(bb.browser.ie){ this.viewNode.codeBase = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="codetype" onmap="if(bb.browser.ie){ this.viewNode.codeType = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="data" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="declare" onmap="this.viewNode.declare = value == name;"/><d:attribute name="height" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="name" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="standby" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="type" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="width" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="usemap" onmap="if(bb.browser.ie){ this.viewNode.useMap = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:method name="__children"><d:body type="text/javascript"/></d:method></d:element><d:element name="param"><d:attribute name="id" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="name" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="type" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="value" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="valuetype" onmap="this.viewNode.setAttribute(name, value)"/></d:element><d:element name="area" extends="xhtmlFocusableElement"><d:template type="text/javascript">var b=document.createElement("area");var a=this.modelNode.getAttribute("coords");var c=this.modelNode.getAttribute("shape");if(a!=null&amp;&amp;c!=null&amp;&amp;bb.browser.ie){b=document.createElement(\'&lt;area shape="\'+c+\'" coords="\'+a+\'"&gt;\');}return[b,b];</d:template><d:attribute name="alt" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="coords" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="href" onmap="this.viewNode.href = this.getProperty(name);"/><d:attribute name="nohref" onmap="this.viewNode.noHref = value == name;"/><d:attribute name="shape" onmap="this.viewNode.setAttribute(name, value)"/><d:attribute name="target" onmap="this.viewNode.setAttribute(name, value);"/><d:property name="href" onget="return bb.uri.resolveUri(this.getAttribute(name), this.getProperty(\'baseURI\'));" onset="this.setAttribute(name,  value);"/></d:element><d:element name="map" extends="xhtmlElement"><d:attribute name="id" onmap="this.viewNode.setAttribute(name, value); this.viewNode.setAttribute(\'name\', value);"/><d:attribute name="name" onmap="this.viewNode.setAttribute(name, value);"/><d:template type="text/javascript">var a=bb.browser.ie?document.createElement(\'&lt;map name="\'+this.modelNode.getAttribute("id")+\'"&gt;\'):document.createElement("map");return[a,a];</d:template></d:element><d:element name="frameset" extends="xhtmlElement"><d:attribute name="cols" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="rows" onmap="this.viewNode.setAttribute(name, value);"/></d:element><d:element name="frame" extends="xhtmlElement"><d:attribute name="frameborder" onmap="if(bb.browser.ie){ this.viewNode.frameBorder = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="longdesc" onmap="if(bb.browser.ie){ this.viewNode.longDesc = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="marginheight" onmap="if(bb.browser.ie){ this.viewNode.marginHeight = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="marginwidth" onmap="if(bb.browser.ie){ this.viewNode.marginWidth = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="marginwidth" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="noresize" onmap="if(bb.browser.ie){ this.viewNode.noResize = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="scrolling" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="src" onmap="this.viewNode.src = this.getProperty(name);"/><d:attribute name="name" onmap="this.viewNode.setAttribute(name, value);"/><d:property name="src" onget="return bb.uri.resolveUri(this.getAttribute(name), this.getProperty(\'baseURI\'));" onset="this.setAttribute(name,  value);"/></d:element><d:element name="noframes" extends="xhtmlElement"/><d:element name="iframe" extends="xhtmlElement"><d:attribute name="frameborder" onmap="if(bb.browser.ie){ this.viewNode.frameBorder = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="height" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="longdesc" onmap="if(bb.browser.ie){ this.viewNode.longDesc = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="marginheight" onmap="if(bb.browser.ie){ this.viewNode.marginHeight = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="marginwidth" onmap="if(bb.browser.ie){ this.viewNode.marginWidth = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="scrolling" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="src" onmap="this.viewNode.src = this.getProperty(name);"/><d:attribute name="width" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="name" onmap="this.viewNode.setAttribute(name, value);"/><d:property name="src" onget="return bb.uri.resolveUri(this.getAttribute(name), this.getProperty(\'baseURI\'));" onset="this.setAttribute(name,  value);"/><d:template type="text/javascript">var a=null;if(bb.browser.ie){a=document.createElement(\'&lt;iframe name="\'+this.getAttribute("name")+\'"&gt;\');}else{a=document.createElement("iframe");}return[a,a];</d:template></d:element><d:element name="meta"><d:attribute name="content" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="http-equiv" onmap="if(bb.browser.ie){ this.viewNode.httpEquiv = value; }else{ this.viewNode.setAttribute(name, value); }"/><d:attribute name="name" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="scheme" onmap="this.viewNode.setAttribute(name, value);"/></d:element><d:element name="script" extends="xhtmlElement"><d:template type="text/javascript">var a=document.createElement("script");return[a,null];</d:template><d:method name="__children"><d:body type="application/javascript"/></d:method><d:handler event="DOMNodeInsertedIntoDocument" type="text/javascript">var a=[];for(oXmlNode=this.modelNode.firstChild;oXmlNode;oXmlNode=oXmlNode.nextSibling){a.push(oXmlNode.nodeType==1?"":oXmlNode.nodeValue||oXmlNode.data||"");}if(a.length){this.viewNode.text=a.join("");}</d:handler><d:attribute name="charset" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="defer" onmap="this.viewNode.defer = value == name;"/><d:attribute name="src" onmap="this.viewNode.src = this.getProperty(name);"/><d:attribute name="type" onmap="this.viewNode.type = value == \'application/javascript\' ? \'text/javascript\' : value;"/><d:attribute name="space" namespace="http://www.w3.org/XML/1998/namespace" default="preserve" onmap="this.viewNode.setAttribute(name, value);"/><d:property name="src" onget="return bb.uri.resolveUri( this.getAttribute(name), this.getProperty(\'baseURI\') );" onset="this.setAttribute(name,  value);"/></d:element><d:element name="style" extends="xhtmlElement"><d:template type="text/javascript">var a=bb.html.addStyleSheet(this.getProperty("textContent"));if(bb.browser.webkit){a=document.createElement("style");}return[a,null];</d:template><d:attribute name="media" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="title" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="type" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="space" namespace="http://www.w3.org/XML/1998/namespace" default="preserve" onmap="this.viewNode.setAttribute(name, value);"/></d:element><d:element name="link" extends="xhtmlElement"><d:attribute name="charset" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="href" onmap="this.viewNode.href = this.getProperty(name);"/><d:attribute name="hreflang" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="media" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="rel" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="rev" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="type" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="target" onmap="this.viewNode.setAttribute(name, value);"/><d:property name="href" onget="return bb.uri.resolveUri( this.getAttribute(name), this.getProperty(\'baseURI\') );" onset="this.setAttribute(name,  value);"/></d:element><d:element name="base" extends="xhtmlElement"><d:attribute name="href" onmap="this.viewNode.setAttribute(name, value);"/><d:attribute name="target" onmap="this.viewNode.setAttribute(name, value);"/></d:element></d:namespace></d:tdl><d:tdl xmlns="http://www.w3.org/1999/xhtml" xmlns:b="http://www.backbase.com/2006/btl" xmlns:bb="http://www.backbase.com/2006/client" xml:base="../bcf/4_4_9_1/bindings/www.backbase.com.2006.btl/dragAndDrop/dragAndDrop.xml"><d:namespace name="http://www.backbase.com/2006/btl" xml:base="../btl.xml"><d:resource type="text/css">.btl-repaint{zoom:1;background-color:transparent;-moz-outline:none;}</d:resource><d:resource type="text/javascript">if(!window.btl){var btl={};}btl.namespaceURI="http://www.backbase.com/2006/btl";btl.funcReturnFalse=function btl_funcReturnFalse(){return false;};btl.funcReturnTrue=function btl_funcReturnTrue(){return true;};btl.isInsideHead=function btl_isInsideHead(b,c,a){if(a&amp;&amp;a!=c){return false;}while(b&amp;&amp;b.nodeType==1){if(bb.html.hasClass(b,"btl-head")){return true;}if(b.controller==c){break;}b=b.parentNode;}return false;};btl.repaint=function btl_repaint(a){bb.html.addClass(a,"btl-repaint");setTimeout(function(){if(a){bb.html.removeClass(a,"btl-repaint");}a=null;},1);};btl.isTrueValue=function btl_isTrueValue(a,b){return b=="true"||b==a;};btl.isFalseValue=function btl_isFalseValue(a,b){return b!="true"&amp;&amp;b!=a;};btl.containsElement=function btl_containsElement(b,a){while(a){if(b==a){return true;}a=a.parentNode;}return false;};btl.getScrollLeft=function btl_getScrollLeft(b){var a=0;while(b){if(b.scrollLeft){a+=b.scrollLeft;}b=b.parentNode;}return a;};btl.getScrollTop=function btl_getScrollTop(a){var b=0;while(a){if(a.scrollTop){b+=a.scrollTop;}a=a.parentNode;}return b;};btl.setPrivateProperty=function btl_setPrivateProperty(a,b,c){a._["_btl_"+b]=c;};btl.getPrivateProperty=function btl_getPrivateProperty(a,b){return a._["_btl_"+b];};btl.html={};btl.html.stretch=function btl_html_stretch(l){var a=l.parentNode;l.style.height="1px";var i;var j;var d;var e;var f;var o;var c;var m=bb.html.getBoxObject(a,"content").height;var h;var p=a.firstChild;var g;while(p){var k=p.nodeType===1&amp;&amp;bb.html.getStyle(p,"position")!=="absolute"&amp;&amp;bb.html.getStyle(p,"display")!=="none";var b=p.nextSibling;if(k){var n=bb.html.getBoxObject(p);if(d===undefined){d=n.top;}if(j===undefined&amp;&amp;p===l){g=p;j=n.top;i=j-d;e=0;}else{if(j!==undefined&amp;&amp;c===undefined){c=n.top;e=n.height;}else{f=n.top;o=n.height;e=f+o-c;}}}p=b;}h=m-i-e;if(l&amp;&amp;h&gt;0){btl.html.setHeight(l,h);}};btl.html.setHeight=function btl_html_setHeight(a,b){b-=bb.html.getStyle(a,"box-sizing")=="content-box"?bb.html.getBoxObject(a,"border").height-bb.html.getBoxObject(a,"content").height:0;bb.html.setStyle(a,"height",b+"px");};btl.html.setWidth=function btl_html_setWidth(a,b){b-=bb.html.getStyle(a,"box-sizing")=="content-box"?bb.html.getBoxObject(a,"border").width-bb.html.getBoxObject(a,"content").width:0;bb.html.setStyle(a,"width",b+"px");};btl.controller={};btl.controller.containsElement=function btl_controller_containsElement(b,a){while(a){a=a.getProperty("parentNode");if(b===a){return true;}}return false;};</d:resource><d:behavior name="btlBehavior"/></d:namespace><d:namespace name="http://www.backbase.com/2006/btl"><d:resource type="text/css">.btl-drag-outlineElement{position:absolute;top:-10000px;left:-10000px;width:100px;height:100px;z-index:9999;border-width:1px;border-style:solid;background-color:#DFE0E1;border-color:#8B8D91;}</d:resource><d:attribute name="dragReceive"><d:mapper type="text/javascript">var b=this._.oldDragReceive;if(b){for(var a=0;a&lt;b.length;a++){var c=btl.drag.droppables[b[a]];if(c){bb.array.removeObject(c,this);}}}b=this._.oldDragReceive=value.split(" ");for(var a=0;a&lt;b.length;a++){if(!btl.drag.droppables[b[a]]){btl.drag.droppables[b[a]]=[];}btl.drag.droppables[b[a]].push(this);}if(value){if(!this.instanceOf(btl.namespaceURI,"dragTarget")){bb.addBehavior(this,btl.namespaceURI,"dragTarget");}}else{bb.removeBehavior(this,btl.namespaceURI,"dragTarget");}</d:mapper></d:attribute><d:behavior name="dragTarget" extends="b:btlBehavior"><d:handler event="destruct" type="application/javascript">this.setAttributeNS("http://www.backbase.com/2006/btl","dragReceive","");</d:handler><d:handler event="dragEnter" type="application/javascript">if(event.dragSource&amp;&amp;event.dragSource.modelNode&amp;&amp;event.dragSource.instanceOf("http://www.backbase.com/2006/btl","drag")){var f=["*"];var b=event.dragSource.getAttribute("dragGroup");if(b){f.push(b.split(" "));}b=event.dragSource.getAttribute("dragItem");if(b){f.push(b.split(" "));}var a=[];for(var e=0;e&lt;f.length;e++){var c=btl.drag.droppables[f[e]];if(c){for(var d=0;d&lt;c.length;d++){if(this==c[d]){btl.drag.dragManager.acceptDragDrop(this);break;}}}}}</d:handler><d:handler event="dragDrop" type="application/javascript">if(!event.defaultPrevented&amp;&amp;event.dragSource.getAttribute("dropMode")!="none"){var a=event.dragSource.modelNode;var b=false;for(var c=this.modelNode;c&amp;&amp;!b&amp;&amp;(c.nodeType==1);c=c.parentNode){b=(c==a);}if(!b){this.appendChild(event.dragSource);}}</d:handler></d:behavior><d:behavior name="dragBase" extends="b:btlBehavior"><d:resource type="text/javascript">btl.drag={};btl.drag.droppables={};btl.drag.dragManager={isDragging:false,constraint:null,currentTop:null,currentLeft:null,offsetTop:null,offsetLeft:null,symbol:null,target:null,acceptDragDrop:function dragManager_acceptDragDrop(b){var a=this.acceptTarget;this.acceptTarget=b;if(this.symbol){if(b&amp;&amp;b.modelNode){bb.html.addClass(this.symbol,"btl-drag-target");bb.html.addClass(b.viewNode,"btl-drag-target");}else{bb.html.removeClass(this.symbol,"btl-drag-target");if(a&amp;&amp;a.modelNode){bb.html.removeClass(a.viewNode,"btl-drag-target");}}}},doDrag:function dragManager_doDrag(k,b,l,j,f,e,d,h,m,n,c){var g=btl.drag.dragManager;if(!g.isDragging){g.controller=k;g.target=null;g.acceptTarget=null;g.source=b;g.constraint=c;g.symbol=f;g.offsetTop=d;g.offsetLeft=e;g.currentTop=j;g.currentLeft=l;g.droppables=n&amp;&amp;n.length?n:null;g.allowMove=m;if(h&lt;1){f._originalOpacity=bb.html.getStyle(f,"opacity");bb.html.setStyle(f,"opacity",h);}var a=g.currentLeft+e;var o=g.currentTop+d;if(f.offsetParent&amp;&amp;f.offsetParent!=document.body){var i=bb.html.getBoxObject(f.offsetParent,bb.html.getStyle(f,"position")=="absolute"?"padding":"content");a-=i.left;o-=i.top;}f.style.left=a+"px";f.style.top=o+"px";bb.html.disableUserSelect(document.body);bb.document.addEventListener("keydown",btl.drag.handleKeyDown,false);bb.document.addEventListener("mouseup",btl.drag.handleMouseUp,false);bb.document.addEventListener("mousemove",btl.drag.handleMouseMove,false);g.isDragging=true;}}};btl.drag.handleKeyDown=function drag_handleKeyDown(a){if(a.keyIdentifier&amp;&amp;a.keyIdentifier.toLowerCase()=="u+001b"&amp;&amp;btl.drag.dragManager.isDragging){a.preventDefault();btl.drag.dragManager.acceptDragDrop();btl.drag.stopDrag();}};btl.drag.handleMouseUp=function drag_handleMouseUp(a){if(a.button==0){btl.drag.stopDrag();}};btl.drag.startPoint=null;btl.drag.handleMouseMoveBeforeStart=function drag_handleMouseMoveBeforeStart(g){var e=btl.drag.dragManager;if(btl.drag.startPoint!=null){var f=6;var c=btl.drag.startPoint.startX;var a=btl.drag.startPoint.startY;var d=g.pageX;var b=g.pageY;if(c-d&gt;f||c-d&lt;-f||a-b&gt;f||a-b&lt;-f){btl.drag.startDrag(g);}}};btl.drag.startDrag=function drag_startDrag(d){if(btl.drag.startPoint&amp;&amp;(!btl.resize||!btl.resize.isResizing)){bb.document.removeEventListener("mousemove",btl.drag.handleMouseMoveBeforeStart,false);bb.document.removeEventListener("mouseup",btl.drag.handleMouseUpBeforeStart,false);var c=btl.drag.startPoint.startX;var a=btl.drag.startPoint.startY;var b=btl.drag.startPoint.controller;var e=bb.document.createEvent("MouseEvents");e.initMouseEvent("dragStart",true,true,d.view,d.detail,d.screenX,d.screenY,d.clientX,d.clientY,d.ctrlKey,d.altKey,d.shiftKey,d.metaKey,d.button,d.relatedTarget);e.startX=c;e.startY=a;e.viewTarget=btl.drag.startPoint.viewNode;e.dragManager=btl.drag.dragManager;b.dispatchEvent(e);}btl.drag.startPoint=null;};btl.drag.handleMouseUpBeforeStart=function drag_handleMouseUpBeforeStart(a){if(btl.drag.startPoint!=null){clearTimeout(btl.drag.dragTimeout);btl.drag.startPoint=null;bb.document.removeEventListener("mousemove",btl.drag.handleMouseMoveBeforeStart,false);bb.document.removeEventListener("mouseup",btl.drag.handleMouseUpBeforeStart,false);bb.html.enableUserSelect(document.body);}};btl.drag.handleMouseMove=function drag_handleMove(q){var k=btl.drag.dragManager;if(k.isDragging){var x=q.pageX+k.offsetLeft;var v=q.pageY+k.offsetTop;if(k.constraint){var m=bb.html.getBoxObject(k.constraint==document.body?bb.viewport:k.constraint,bb.html.getStyle(k.controller.viewNode,"position")=="absolute"?"padding":"content");var n=bb.html.getBoxObject(k.symbol);if(x&lt;m.left||n.width&gt;m.width){x=m.left;}else{var y=m.left+m.width-n.width;if(x&gt;y){x=y;}}k.currentLeft=x-k.offsetLeft;if(v&lt;m.top||n.height&gt;m.height){v=m.top;}else{var j=m.top+m.height-n.height;if(v&gt;j){v=j;}}k.currentTop=v-k.offsetTop;}else{k.currentLeft=q.pageX;k.currentTop=q.pageY;}var h;var p=k.symbol;var b=q.viewTarget,f=false;while(b.parentNode){if(b==p){f=true;break;}b=b.parentNode;}if(!f||k.droppables){var a,s=k.target,h;if(!k.droppables){a=q.viewTarget;}else{var w=k.currentLeft,u=k.currentTop,d=0,c=0,e=Infinity,o=Infinity,t=k.droppables;for(var r=0;r&lt;t.length;r++){var g=t[r];if(g.offsetHeight){var l=bb.html.getBoxObject(g);if(w&gt;=l.x&amp;&amp;w&lt;=l.x+l.w&amp;&amp;u&gt;=l.y&amp;&amp;u&lt;=l.y+l.h){if(l.x&gt;=d&amp;&amp;l.y&gt;=c&amp;&amp;l.w+l.x&lt;=e&amp;&amp;l.h+l.y&lt;=o){d=l.x;c=l.y;e=l.x+l.w;o=l.y+l.h;a=g;}}}}}k.target=a;if(a!=s){if(s){h=bb.document.createEvent("Events");h.initEvent("dragLeave",false,true);h.dragInitiator=k.controller;h.dragSource=k.source;h.viewTarget=q.viewTarget;h.dragTarget=a?bb.getControllerFromView(a):null;h.dragViewTarget=a;bb.getControllerFromView(s).dispatchEvent(h);if(h.defaultPrevented){}else{k.acceptDragDrop();}}if(k.isDragging&amp;&amp;a){h=bb.document.createEvent("Events");h.initEvent("dragEnter",false,true);h.dragInitiator=k.controller;h.dragSource=k.source;h.viewTarget=q.viewTarget;h.dragTarget=a?bb.getControllerFromView(a):null;h.dragViewTarget=a;bb.getControllerFromView(a).dispatchEvent(h);if(k.isDragging){h=bb.document.createEvent("Events");h.initEvent("dragOver",true,true);h.dragInitiator=k.controller;h.dragSource=k.source;h.viewTarget=q.viewTarget;h.dragTarget=a?bb.getControllerFromView(a):null;h.dragViewTarget=a;bb.getControllerFromView(a).dispatchEvent(h);}}}}h=bb.document.createEvent("MouseEvents");h.initMouseEvent("drag",false,true,q.view,q.detail,q.screenX,q.screenY,q.clientX,q.clientY,q.ctrlKey,q.altKey,q.shiftKey,q.metaKey,q.button,q.relatedTarget);h.viewTarget=q.viewTarget;h.pageX=q.pageX;h.pageY=q.pageY;h.dragInitiator=k.controller;h.dragSource=k.source;h.dragTarget=a?bb.getControllerFromView(a):null;h.dragViewTarget=a;k.controller.dispatchEvent(h);if(!h.defaultPrevented&amp;&amp;k.symbol){if(k.symbol.offsetParent&amp;&amp;k.symbol.offsetParent!=document.body){var m=bb.html.getBoxObject(k.symbol.offsetParent,bb.html.getStyle(k.symbol,"position")=="absolute"?"padding":"content");x-=m.left;v-=m.top;}p.style.left=x+"px";p.style.top=v+"px";}}};btl.drag.stopDrag=function drag_stopDrag(){var a=btl.drag.dragManager;if(a.isDragging){if(a.allowMove||a.acceptTarget){if(a.symbol){bb.html.removeClass(a.symbol,"btl-drag-target");}if(a.acceptTarget){bb.html.removeClass(a.acceptTarget.viewNode,"btl-drag-target");var d=bb.document.createEvent("Events");d.initEvent("dragDrop",false,true);d.dragInitiator=a.controller;d.dragSource=a.source;a.acceptTarget.dispatchEvent(d);}if((!d||!d.defaultPrevented)&amp;&amp;a.allowMove){var f=a.currentLeft+a.offsetLeft;var c=a.currentTop+a.offsetTop;var g=a.controller.viewNode.bPosition?a.controller.viewNode.sPosition:bb.html.getStyle(a.controller.viewNode,"position");if(g!="absolute"&amp;&amp;g!="fixed"){g=a.controller.viewNode.style.position="absolute";a.controller.viewNode.bPosition=false;}if(g=="absolute"||g=="relative"){var e=a.controller.viewNode.offsetParent;if(e&amp;&amp;e!=document.body){var b=bb.html.getBoxObject(e,g=="absolute"?"padding":"content");f-=b.x;c-=b.y;}}a.controller.viewNode.style.left=f+"px";a.controller.viewNode.style.top=c+"px";}}bb.html.enableUserSelect(document.body);bb.document.removeEventListener("keydown",btl.drag.handleKeyDown,false);bb.document.removeEventListener("mouseup",btl.drag.handleMouseUp,false);bb.document.removeEventListener("mousemove",btl.drag.handleMouseMove,false);d=bb.document.createEvent("Events");d.initEvent("dragEnd",false,false);d.dragInitiator=a.controller;d.dragSource=a.source;a.controller.dispatchEvent(d);a.isDragging=false;}};</d:resource><d:handler event="mousedown" type="text/javascript">if(event.button==0&amp;&amp;btl.drag.dragManager.isDragging){btl.drag.stopDrag();}if(event.button==0&amp;&amp;btl.drag.dragStartPoint==null){var a=event.target;btl.drag.startPoint={startX:event.pageX,startY:event.pageY,controller:a,viewNode:event.viewTarget};bb.document.addEventListener("mousemove",btl.drag.handleMouseMoveBeforeStart,false);bb.document.addEventListener("mouseup",btl.drag.handleMouseUpBeforeStart,false);btl.drag.dragTimeout=setTimeout(function(){btl.drag.startDrag(event);},500);}</d:handler><d:handler event="DOMNodeInsertedIntoDocument" type="text/javascript">if(this.viewNode&amp;&amp;this.viewNode.tagName=="IMG"){bb.html.disableUserSelect(this.viewNode);}</d:handler></d:behavior><d:behavior name="drag" extends="b:dragBase"><d:attribute name="dragGroup"/><d:attribute name="dragItem"/><d:attribute name="dragConstraint"/><d:attribute name="dragMode" default="outline"/><d:attribute name="dragSymbol"/><d:attribute name="dropMode" default="move"/><d:attribute name="dragBehavior" default="drop"/><d:attribute name="useDragRole" default="false"><d:mapper type="text/javascript">if(value!="false"){bb.command.trace(this,"The useDragRole attribute is deprecated, use useDragClass instead.",2);}</d:mapper></d:attribute><d:attribute name="useDragClass" default="false"/><d:handler event="DOMNodeInsertedIntoDocument" type="text/javascript">if(!btl.isTrueValue("useDragRole",this.getAttribute("useDragRole"))&amp;&amp;!btl.isTrueValue("useDragClass",this.getAttribute("useDragClass"))){bb.html.disableUserSelect(this.viewNode);}</d:handler><d:handler event="dragStart" type="text/javascript">if(event.defaultPrevented||btl.drag.dragManager.isDragging){return;}var o=event.target;var f=this;var s=null;var c=this.getAttribute("dragGroup");if(c&amp;&amp;c.length){if(o!=this){c=" "+c+" ";if(-1==c.indexOf(" * ")){for(var g=o;g&amp;&amp;(g.modelNode.nodeType==1);g=g.getProperty("parentNode")){var k=g.getAttribute("dragItem");if(-1!=c.indexOf(" "+k+" ")){break;}}if(!g||(g.modelNode.nodeType!=1)){return false;}o=g;}}else{var k=this.getAttribute("dragItem");if(!k||!k.length){return false;}}}var l=o.getAttribute("dragBehavior")=="move"||this.getAttribute("dragBehavior")=="move";if(btl.isTrueValue("useDragClass",this.getAttribute("useDragClass"))){if(bb.selector.queryAncestor(event.viewTarget,".btl-dragMove",event.target.viewNode)){l=true;}else{if(bb.selector.queryAncestor(event.viewTarget,".btl-dragDrop",event.target.viewNode)){l=false;}else{if(!bb.selector.queryAncestor(event.viewTarget,".btl-dragItem",event.target.viewNode)){return;}}}}else{if(btl.isTrueValue("useDragRole",this.getAttribute("useDragRole"))){if(bb.selector.queryAncestor(event.viewTarget,"[role~=dragMove]",event.target.viewNode)){l=true;}else{if(bb.selector.queryAncestor(event.viewTarget,"[role~=dragDrop]",event.target.viewNode)){l=false;}else{if(!bb.selector.queryAncestor(event.viewTarget,"[role~=dragItem]",event.target.viewNode)){return;}}}}}var m=["*"];var s=this.getAttribute("dragGroup");if(s){m.push(s.split(" "));}s=this.getAttribute("dragItem");if(s){m.push(s.split(" "));}var u=[];for(var t=0;t&lt;m.length;t++){var p=btl.drag.droppables[m[t]];if(p){for(var r=0;r&lt;p.length;r++){if(bb.array.indexOf(u,p[r].viewNode)==-1){u.push(p[r].viewNode);}}}}var b=this.getAttribute("dragConstraint"),a;if(b&amp;&amp;(b!="")){a=bb.evaluateSmart(b,this,this);if(a){a=a.viewGate;}}var q;var e=0.5;var n=bb.html.getBoxObject(this.viewNode,"border");switch(this.getAttribute("dragMode")){case"real":q=this.viewNode;var h=bb.html.getStyle(this.viewNode,"position");if(h!="absolute"&amp;&amp;h!="fixed"){this.viewNode.bPosition=true;this.viewNode.sPosition=this.viewNode.style.position;this.viewNode.style.position="absolute";}xOffset=n.left-event.startX;yOffset=n.top-event.startY;break;case"symbol":var d=bb.evaluateSmart(this.getAttribute("dragSymbol"),this,this);if(d){if(typeof d=="string"){d=bb.html.createElementFromString(d);}else{if(d.viewNode){d=d.viewNode;}if("cloneNode" in d){d=d.cloneNode(true);}}e=1;btl.drag.dragSymbol=q=d;btl.drag.dragSymbol.style.position="absolute";document.body.appendChild(btl.drag.dragSymbol);xOffset=10;yOffset=10;}else{bb.command.trace(this,"dragSymbol attribute is missing or incorrect, set it to an XPath value which should be the symbol!");return;}break;case"outline":default:if(!btl.drag.outlineElement){btl.drag.outlineElement=document.createElement("div");btl.drag.outlineElement.className="btl-drag-outlineElement";document.body.appendChild(btl.drag.outlineElement);}q=btl.drag.outlineElement;q.style.width=n.width+"px";q.style.height=n.height+"px";xOffset=n.left-event.startX;yOffset=n.top-event.startY;break;}if(!l){if(!btl.drag._savedStyle){btl.drag._savedStyle=bb.html.addStyleSheet("html * { cursor: not-allowed !important;} .btl-drag-target, .btl-drag-target * { cursor: default !important;}");}else{document.head.appendChild(btl.drag._savedStyle);}}btl.drag.dragManager.doDrag(this,this,event.startX,event.startY,q,xOffset,yOffset,e,l,u,a);</d:handler><d:handler event="dragEnd" type="text/javascript">if(this.viewNode.bPosition){this.viewNode.bPosition=false;this.viewNode.style.position=this.viewNode.sPosition;this.viewNode.style.left="";this.viewNode.style.top="";}if(btl.drag._savedStyle&amp;&amp;btl.drag._savedStyle.parentNode==document.head){document.head.removeChild(btl.drag._savedStyle);}if(this.viewNode._originalOpacity!=null){bb.html.setStyle(this.viewNode,"opacity",this.viewNode._originalOpacity);this.viewNode._originalOpacity=null;}if(btl.drag.outlineElement){btl.drag.outlineElement.style.left="";btl.drag.outlineElement.style.top="";}if(btl.drag.dragSymbol){document.body.removeChild(btl.drag.dragSymbol);btl.drag.dragSymbol=null;}</d:handler></d:behavior></d:namespace></d:tdl><d:tdl xmlns="http://www.w3.org/1999/xhtml" xmlns:b="http://www.backbase.com/2006/btl" xmlns:bb="http://www.backbase.com/2006/client" xml:base="../bcf/4_4_9_1/bindings/www.backbase.com.2006.btl/resize/resize.xml"><d:namespace name="http://www.backbase.com/2006/btl"><d:resource type="text/css">.btl-resize-cursorElement{position:absolute;top:-10000px;left:-10000px;width:100px;height:100px;z-index:10000;opacity:0;-ms-filter:"alpha(opacity=0)";filter:alpha(opacity=0);background:white;}.btl-resize-lineElement{position:absolute;top:-10000px;left:-10000px;width:1px;height:100px;z-index:9999;border-width:1px;border-style:solid;border-color:#8B8D91;overflow:hidden;}.btl-resize-outlineElement{position:absolute;top:-10000px;left:-10000px;width:100px;height:100px;z-index:9999;border-width:1px;border-style:solid;opacity:.4;-ms-filter:"alpha(opacity=40)";filter:alpha(opacity=40);background-color:#DFE0E1;border-color:#8B8D91;}</d:resource><d:behavior name="resizeBase" extends="b:btlBehavior"><d:resource type="text/javascript">btl.resize={};btl.resize.currentSymbol=null;btl.resize.currentElement=null;btl.resize.currentController=null;btl.resize.currentResizeEdge=0;btl.resize.isResizing=false;btl.resize.WEST=btl.resize.LEFT=1;btl.resize.EAST=btl.resize.RIGHT=2;btl.resize.NORTH=btl.resize.TOP=4;btl.resize.SOUTH=btl.resize.BOTTOM=8;btl.resize.NORTHWEST=5;btl.resize.NORTHEAST=6;btl.resize.SOUTHWEST=9;btl.resize.SOUTHEAST=10;btl.resize.HORIZONTAL=3;btl.resize.VERTICAL=12;btl.resize.ALL=15;btl.resize.cursorElement=document.createElement("div");btl.resize.cursorElement.className="btl-resize-cursorElement";document.body.appendChild(btl.resize.cursorElement);if(bb.browser.opera){btl.resize.iCursor=0;btl.resize.aCursors=[btl.resize.cursorElement];btl.resize.aCursors[1]=btl.resize.cursorElement.cloneNode(true);document.body.appendChild(btl.resize.aCursors[1]);}btl.resize.lineElement=document.createElement("div");btl.resize.lineElement.className="btl-resize-lineElement";document.body.appendChild(btl.resize.lineElement);btl.resize.outlineElement=document.createElement("div");btl.resize.outlineElement.className="btl-resize-outlineElement";document.body.appendChild(btl.resize.outlineElement);btl.resize.detectResizeEdge=function resize_detectEdge(b,i,h,e,c){var a=bb.html.getBoxObject(b);var f=i-a.left;var d=h-a.top;var j=new RegExp(e.replace(/(^\\s+)|(\\s+$)/g,"").replace(/ +/g,"|"),"");var g=0;if(f&gt;=0&amp;&amp;d&gt;=0&amp;&amp;f&lt;=a.width&amp;&amp;d&lt;=a.height){if((j.test("top")||j.test("north"))&amp;&amp;d&lt;=c){g|=btl.resize.TOP;}else{if((j.test("bottom")||j.test("south"))&amp;&amp;d&gt;=(a.height-c)){g|=btl.resize.BOTTOM;}}if((j.test("left")||j.test("west"))&amp;&amp;f&lt;=c){g|=btl.resize.LEFT;}else{if((j.test("right")||j.test("east"))&amp;&amp;f&gt;=(a.width-c)){g|=btl.resize.RIGHT;}}}btl.resize.currentResizeEdge=g;return g;};btl.resize.startResize=function resize_startResize(f,c,l,n,k,j,i,e,g,o,m){btl.resize.currentController=f;btl.resize.currentElement=c||f.viewNode;btl.resize.currentSymbol=j;btl.resize.currentResizeEdge=l;var h=bb.html.getStyle(btl.resize.currentElement,"box-sizing")=="border-box",b=bb.html.getBoxObject(btl.resize.currentElement,"border"),a;if(!h){a=bb.html.getBoxObject(btl.resize.currentElement,"content");}btl.resize.newX=btl.resize.originalX=b.left;btl.resize.newY=btl.resize.originalY=b.top;btl.resize.newW=btl.resize.originalW=h?b.width:a.width;btl.resize.newH=btl.resize.originalH=h?b.height:a.height;btl.resize.boxModelW=h?0:b.width-a.width;btl.resize.boxModelH=h?0:b.height-a.height;btl.resize.deltaX=0;btl.resize.deltaY=0;btl.resize.offsetLeft=0;btl.resize.offsetTop=0;btl.resize.originalClientX=n;btl.resize.originalClientY=k;var d=btl.resize.sendEvent(f,"resizeStart",true,true);if(d){bb.document.addEventListener("mousemove",btl.resize.handleMouseMove,false);bb.document.addEventListener("mouseup",btl.resize.handleMouseUp,false);bb.document.addEventListener("keydown",btl.resize.handleKeyDown,false);bb.document.addEventListener("click",btl.resize.handleClick,false);bb.html.disableUserSelect(document.body);btl.resize.iMinW=i||0;btl.resize.iMinH=e||0;btl.resize.iMaxW=g||20000;btl.resize.iMaxH=o||20000;btl.resize.oConstraint=m||false;if(j&amp;&amp;j!=c){j.style.display="";btl.resize.applyCoordinates(j,true);}btl.resize.isResizing=true;}return d;};btl.resize.cancelResize=function cancelResize(){btl.resize.newX=btl.resize.originalX;btl.resize.newY=btl.resize.originalY;btl.resize.newW=btl.resize.originalW;btl.resize.newH=btl.resize.originalH;};btl.resize.stopResize=function resize_stopResize(a){if(btl.resize.isResizing){var c=btl.resize.currentController;var b=btl.resize.sendEvent(c,"resizeEnd",true,true,a);if(!b){btl.resize.cancelResize();if(btl.resize.currentElement==btl.resize.currentSymbol){btl.resize.applyCoordinates(btl.resize.currentElement);}}btl.resize.stopAndClean();bb.ui.reflow(c,false,true);return b;}};btl.resize.applyCoordinates=function(a,k){if(a){var c=btl.resize.newX;var b=btl.resize.newY;if(a.offsetParent&amp;&amp;a.offsetParent!=document.body){var f=bb.html.getBoxObject(a.offsetParent,bb.html.getStyle(a,"position")=="absolute"?"padding":"content");c-=f.left;b-=f.top;}var i=a.style;if(btl.resize.currentController&amp;&amp;btl.resize.currentController.viewNode==a&amp;&amp;btl.resize.currentController.instanceOf(btl.namespaceURI,"dimensionElement")){var d=btl.resize.currentController;if(k||btl.resize.currentResizeEdge&amp;btl.resize.LEFT){i.left=c+"px";}if(k||btl.resize.currentResizeEdge&amp;btl.resize.TOP){i.top=b+"px";}if(k||btl.resize.currentResizeEdge&amp;btl.resize.HORIZONTAL){d.setProperty("width",btl.resize.newW+"px");}if(k||btl.resize.currentResizeEdge&amp;btl.resize.VERTICAL){d.setProperty("height",btl.resize.newH+"px");}}else{var e=btl.resize.newW;var j=btl.resize.newH;if(btl.resize.currentElement!=a&amp;&amp;bb.html.getStyle(a,"box-sizing")=="content-box"){var g=bb.html.getBoxObject(a,"border");var h=bb.html.getBoxObject(a,"content");e+=btl.resize.boxModelW-(g.width-h.width);j+=btl.resize.boxModelH-(g.height-h.height);}if(k||btl.resize.currentResizeEdge&amp;btl.resize.LEFT){i.left=c+"px";}if(k||btl.resize.currentResizeEdge&amp;btl.resize.TOP){i.top=b+"px";}if(k||btl.resize.currentResizeEdge&amp;btl.resize.HORIZONTAL){i.width=e+"px";}if(k||btl.resize.currentResizeEdge&amp;btl.resize.VERTICAL){i.height=j+"px";}}}};btl.resize.determineCoordinates=function(n,l){var m=btl.resize.currentResizeEdge;var h=btl.resize.iMinW;var d=btl.resize.iMinH;btl.resize.deltaX=n-btl.resize.originalClientX;btl.resize.deltaY=l-btl.resize.originalClientY;var g;var b=bb.html.getStyle(btl.resize.currentElement,"position")=="absolute";if(btl.resize.oConstraint){g=bb.html.getBoxObject(btl.resize.oConstraint==document.body?bb.viewport:btl.resize.oConstraint,b?"padding":"content");}btl.resize.offsetLeft=0;btl.resize.offsetTop=0;if(btl.resize.currentElement.offsetParent&amp;&amp;btl.resize.currentElement.offsetParent!=document.body){var k=bb.html.getBoxObject(btl.resize.currentElement.offsetParent,b?"padding":"content");btl.resize.offsetLeft=k.left;btl.resize.offsetTop=k.top;}var i=bb.html.getBoxObject(bb.viewport);if(m&amp;btl.resize.HORIZONTAL){var f=btl.resize.originalW;var e=btl.resize.originalX;if(m&amp;btl.resize.RIGHT){f+=btl.resize.deltaX;}else{if(m&amp;btl.resize.LEFT){f-=btl.resize.deltaX;}}f=Math.max(f,h,1);f=Math.min(f,btl.resize.iMaxW,Math.max(i.width,bb.viewport.scrollWidth));if(m&amp;btl.resize.LEFT){e-=(f-btl.resize.originalW);}if(e&lt;0){e=0;}if(btl.resize.oConstraint){if(m&amp;btl.resize.RIGHT&amp;&amp;m&amp;btl.resize.LEFT){e=g.left;f=Math.min(f,btl.resize.iMaxW,g.width);}else{if(e&lt;g.left){f-=g.left-e;e=g.left;}else{if(e&gt;(g.left+g.width-h)){e=(g.left+g.width-h);}}var j=g.left+g.width-e-btl.resize.boxModelW;if(f&lt;h){f=h;}else{if(f&gt;j){f=j;}}}}btl.resize.newX=e;btl.resize.newW=f;}if(m&amp;btl.resize.VERTICAL){var o=btl.resize.originalH;var c=btl.resize.originalY;if(m&amp;btl.resize.BOTTOM){o+=btl.resize.deltaY;}else{if(m&amp;btl.resize.TOP){o-=btl.resize.deltaY;}}o=Math.max(o,d,1);o=Math.min(o,btl.resize.iMaxH,Math.max(i.height,bb.viewport.scrollHeight));if(m&amp;btl.resize.TOP){c-=(o-btl.resize.originalH);}if(c&lt;0){c=0;}if(btl.resize.oConstraint){if(m&amp;btl.resize.TOP&amp;&amp;m&amp;btl.resize.BOTTOM){c=g.top;o=Math.min(o,btl.resize.iMaxH,g.height);}else{if(c&lt;g.top){o-=g.top-c;c=g.top;}else{if(c&gt;(g.top+g.height-d)){c=(g.top+g.height-d);}}var a=g.top+g.height-c-btl.resize.boxModelH;if(o&gt;a){o=a;}if(o&lt;d){o=d;}}}btl.resize.newY=c;btl.resize.newH=o;}};btl.resize.sendEvent=function sendEvent(d,g,b,e,c){if(c){var f=bb.document.createEvent("MouseEvents");f.initMouseEvent(g,Boolean(b),Boolean(e),c.view,c.detail,c.screenX,c.screenY,c.clientX,c.clientY,c.ctrlKey,c.altKey,c.shiftKey,c.metaKey,c.button,c.relatedTarget);f.pageX=c.pageX;f.pageY=c.pageY;f.viewTarget=c.viewTarget;}else{var f=bb.document.createEvent("Events");f.initEvent(String(g),Boolean(b),Boolean(e));}f.resizeEdge=btl.resize.currentResizeEdge;var a=[];if(btl.resize.currentResizeEdge&amp;btl.resize.VERTICAL){a.push("vertical");}if(btl.resize.currentResizeEdge&amp;btl.resize.HORIZONTAL){a.push("horizontal");}if(btl.resize.currentResizeEdge&amp;btl.resize.LEFT){a.push("left");}if(btl.resize.currentResizeEdge&amp;btl.resize.TOP){a.push("top");}if(btl.resize.currentResizeEdge&amp;btl.resize.RIGHT){a.push("right");}if(btl.resize.currentResizeEdge&amp;btl.resize.BOTTOM){a.push("bottom");}f.resizeEdges=a.length?a.join(" "):"none";f.originalLeft=this.originalX;f.originalTop=this.originalY;f.originalWidth=this.originalW;f.originalHeight=this.originalH;f.newLeft=this.newX;f.newTop=this.newY;f.newWidth=this.newW;f.newHeight=this.newH;f.deltaX=this.deltaX;f.deltaY=this.deltaY;f.offsetLeft=this.offsetLeft;f.offsetTop=this.offsetTop;d.dispatchEvent(f);return !f.defaultPrevented;};btl.resize.stopAndClean=function resize_stopAndClean(){if(btl.resize.isResizing){bb.document.removeEventListener("mouseup",btl.resize.handleMouseUp,false);bb.document.removeEventListener("mousemove",btl.resize.handleMouseMove,false);bb.document.removeEventListener("keydown",btl.resize.handleKeyDown,false);bb.document.removeEventListener("click",btl.resize.handleClick,false);bb.html.enableUserSelect(document.body);if(btl.resize.currentSymbol&amp;&amp;btl.resize.currentSymbol!=btl.resize.currentElement){btl.resize.currentSymbol.style.display="none";}btl.resize.outlineElement.style.top="-10000px";btl.resize.lineElement.style.top="-10000px";btl.resize.currentSymbol=null;btl.resize.currentElement=null;btl.resize.currentController=null;btl.resize.currentResizeEdge=0;btl.resize.isResizing=false;}};btl.resize.positionCursor=function positionCursor(c,a,d,b){a=(a&gt;bb.viewport.scrollWidth-50?bb.viewport.scrollWidth-50:a)-50;d=(d&gt;bb.viewport.scrollHeight-50?bb.viewport.scrollHeight-50:d)-50;if(b&amp;&amp;b!=btl.resize.cursorElement.style.cursor){if(bb.browser.opera){btl.resize.cursorElement.style.left="-100px";btl.resize.cursorElement.style.top="-100px";btl.resize.cursorElement=btl.resize.aCursors[btl.resize.iCursor=++btl.resize.iCursor%2];}btl.resize.cursorElement.style.cursor=b;}btl.resize.cursorElement.style.left=a+"px";btl.resize.cursorElement.style.top=d+"px";btl.resize.cursorElement.controller=c;};btl.resize.handleMouseMove=function handleMouseMove(b){var a={newX:btl.resize.newX,newY:btl.resize.newY,newW:btl.resize.newW,newH:btl.resize.newH};btl.resize.determineCoordinates(b.pageX,b.pageY);if(btl.resize.sendEvent(btl.resize.currentController,"resize",false,true,b)){btl.resize.applyCoordinates(btl.resize.currentSymbol);if(btl.resize.currentSymbol==btl.resize.currentElement){bb.ui.reflow(btl.resize.currentController,false,true);}}else{btl.resize.newX=a.newX;btl.resize.newY=a.newY;btl.resize.newW=a.newW;btl.resize.newH=a.newH;}};btl.resize.handleMouseUp=function resize_handleMouseUp(a){if(a.button==0){a.preventDefault();a.stopImmediatePropagation();btl.resize.stopResize(a);}};btl.resize.handleClick=function handleClick(a){if(a.button==0){a.stopImmediatePropagation();a.preventDefault();bb.document.removeEventListener("click",arguments.callee,true);}};btl.resize.handleKeyDown=function handleKeyDown(a){if(a.keyIdentifier=="U+001B"){a.preventDefault();var b=btl.resize.currentController;btl.resize.cancelResize();btl.resize.sendEvent(b,"resizeEnd",true,true);if(btl.resize.currentElement==btl.resize.currentSymbol){btl.resize.applyCoordinates(btl.resize.currentElement);}btl.resize.stopAndClean();}};</d:resource></d:behavior><d:behavior name="resize" extends="b:resizeBase"><d:attribute name="resizeEdges" default="left top right bottom"/><d:attribute name="resizeGripSize" default="8"/><d:attribute name="resizeType" default="outline"/><d:attribute name="resizeConstraint"/><d:property name="resizeConstraint"><d:getter type="text/javascript">var a=this.getAttribute("resizeConstraint");if(a&amp;&amp;(a!="")){var b=bb.evaluateSmart(a,this,this);return b?b.viewGate:null;}</d:getter></d:property><d:attribute name="resizeMinWidth" default="10px"/><d:attribute name="resizeMinHeight" default="10px"/><d:attribute name="resizeMaxWidth"/><d:attribute name="resizeMaxHeight"/><d:attribute name="minimized" default="false" onchange="this.setProperty(name, btl.isTrueValue(name, value))"/><d:attribute name="maximized" default="false" onchange="this.setProperty(name, btl.isTrueValue(name, value))"/><d:property name="resizable"><d:getter type="text/javascript">return(this._._resizable===false?false:true);</d:getter></d:property><d:property name="minimized" type="boolean"><d:setter type="text/javascript">if(value){this.minimize();}else{if(this._._minimized){this.restore();}}</d:setter><d:getter type="text/javascript">return btl.isTrueValue("minimized",this.getAttribute("minimized"));</d:getter></d:property><d:property name="maximized" type="boolean"><d:setter type="text/javascript">if(value){this.maximize();}else{if(this._._maximized){this.restore();}}</d:setter><d:getter type="text/javascript">return btl.isTrueValue("maximized",this.getAttribute("maximized"));</d:getter></d:property><d:property name="restoreCoordinates"/><d:method name="maximize"><d:body type="text/javascript">if(btl.resize.isResizing||(!this._._minimized&amp;&amp;this._._maximized)||this.getAttribute("resizeType")=="abstract"){return;}btl.resize.startResize(this,this.viewNode,btl.resize.ALL,0,0,this.viewNode,parseInt(this.getAttribute("resizeMinWidth")||"0",10),parseInt(this.getAttribute("resizeMinHeight")||"0",10),parseInt(this.getAttribute("resizeMaxWidth")||"0",10),parseInt(this.getAttribute("resizeMaxHeight")||"0",10),this.getProperty("resizeConstraint")||this.viewNode.offsetParent);if(btl.resize.isResizing){var c={left:btl.resize.originalX,top:btl.resize.originalY,width:btl.resize.originalW,height:btl.resize.originalH};btl.resize.determineCoordinates(10000,10000);btl.resize.applyCoordinates(this.viewNode);var b=this._._minimized;var a=this._._maximized;this._._isCurrentlyMaximized=true;this._._minimized=false;this._._maximized=true;if(btl.resize.stopResize()){this._._resizable=false;if(!b&amp;&amp;!a){this.setProperty("restoreCoordinates",c);}this.setAttribute("minimized","false");this.setAttribute("maximized","true");}else{this._._minimized=b;this._._maximized=a;}this._._isCurrentlyMaximized=false;}</d:body></d:method><d:method name="restore"><d:body type="text/javascript">if(this._._minimized&amp;&amp;this._._maximized){this._._maximized=false;return this.maximize();}if(btl.resize.isResizing||!(Boolean(this._._minimized)^Boolean(this._._maximized))||this.getAttribute("resizeType")=="abstract"){return;}var c=this.getProperty("restoreCoordinates");if(!c){return;}btl.resize.startResize(this,this.viewNode,btl.resize.ALL,0,0,this.viewNode,parseInt(this.getAttribute("resizeMinWidth")||"0",10),parseInt(this.getAttribute("resizeMinHeight")||"0",10),parseInt(this.getAttribute("resizeMaxWidth")||"0",10),parseInt(this.getAttribute("resizeMaxHeight")||"0",10),this.getProperty("resizeConstraint")||this.viewNode.offsetParent);if(btl.resize.isResizing){btl.resize.newX=c.left;btl.resize.newY=c.top;btl.resize.newW=c.width;btl.resize.newH=c.height;btl.resize.applyCoordinates(this.viewNode);var b=this._._minimized;var a=this._._maximized;this._._minimized=false;this._._maximized=false;if(btl.resize.stopResize()){this._._resizable=true;this.setAttribute("minimized","false");this.setAttribute("maximized","false");this.setProperty("restoreCoordinates",null);}else{this._._minimized=b;this._._maximized=a;}}</d:body></d:method><d:method name="minimize"><d:body type="text/javascript">if(btl.resize.isResizing||this._._minimized||this.getAttribute("resizeType")=="abstract"){return;}btl.resize.startResize(this,this.viewNode,btl.resize.RIGHT|btl.resize.BOTTOM,0,0,this.viewNode,parseInt(this.getAttribute("resizeMinWidth")||"0",10),parseInt(this.getAttribute("resizeMinHeight")||"0",10),parseInt(this.getAttribute("resizeMaxWidth")||"0",10),parseInt(this.getAttribute("resizeMaxHeight")||"0",10),this.getProperty("resizeConstraint")||this.viewNode.offsetParent);if(btl.resize.isResizing){var a={left:btl.resize.originalX,top:btl.resize.originalY,width:btl.resize.originalW,height:btl.resize.originalH};btl.resize.determineCoordinates(-10000,-10000);this._._minimized=true;btl.resize.applyCoordinates(this.viewNode);if(btl.resize.stopResize()){this._._resizable=false;if(!this._._maximized){this.setProperty("restoreCoordinates",a);}this.setAttribute("minimized","true");}else{this._._minimized=false;}}</d:body></d:method><d:handler event="reflow" type="text/javascript">if(!this._._isCurrentlyMaximized&amp;&amp;this._._maximized&amp;&amp;!this._._minimized){this._._minimized=true;this._._maximized=false;this.maximize();this._._minimized=false;}</d:handler><d:handler event="construct" type="text/javascript">this._._resizable=true;bb.ui.reflow.add(this);</d:handler><d:handler event="mouseleave" type="text/javascript">if(btl.resize.isResizing){return;}btl.resize.currentResizeEdge=0;btl.resize.positionCursor(null,-100,-100);</d:handler><d:handler event="mousedown" type="text/javascript">if(!btl.resize.isResizing&amp;&amp;event.button==0&amp;&amp;btl.resize.currentResizeEdge&gt;0){event.stopImmediatePropagation();event.preventDefault();var b=this;var a;switch(this.getAttribute("resizeType")){case"abstract":break;case"real":a=this.viewNode;break;case"line":a=btl.resize.lineElement;a.style.borderLeftStyle=btl.resize.currentResizeEdge&amp;btl.resize.LEFT?"solid":"none";a.style.borderRightStyle=btl.resize.currentResizeEdge&amp;btl.resize.RIGHT?"solid":"none";a.style.borderTopStyle=btl.resize.currentResizeEdge&amp;btl.resize.TOP?"solid":"none";a.style.borderBottomStyle=btl.resize.currentResizeEdge&amp;btl.resize.BOTTOM?"solid":"none";break;case"outline":default:a=btl.resize.outlineElement;}btl.resize.startResize(this,this.viewNode,btl.resize.currentResizeEdge,event.pageX,event.pageY,a,parseInt(this.getAttribute("resizeMinWidth")||"0",10),parseInt(this.getAttribute("resizeMinHeight")||"0",10),parseInt(this.getAttribute("resizeMaxWidth")||"0",10),parseInt(this.getAttribute("resizeMaxHeight")||"0",10),this.getProperty("resizeConstraint"));}</d:handler><d:handler event="mousemove" type="text/javascript">if(btl.resize.isResizing){return;}if(this!=event.target||!this.getProperty("resizable")){return;}var d=this.getAttribute("resizeEdges");if(this.getAttribute("resizeType")!="abstract"){var e=bb.html.getStyle(this.viewNode,"position");if(!e||e=="static"){d=d.replace(/top|left/g,"");}}var a=parseInt(this.getAttribute("resizeGripSize")||"0",10);var b=btl.resize.detectResizeEdge(this.viewNode,event.pageX,event.pageY,d,a);if(b){var c=[];if(b&amp;btl.resize.TOP){c.push("n");}if(b&amp;btl.resize.BOTTOM){c.push("s");}if(b&amp;btl.resize.RIGHT){c.push("e");}if(b&amp;btl.resize.LEFT){c.push("w");}c.push("-resize");btl.resize.positionCursor(this,event.pageX,event.pageY,c.join(""));}else{btl.resize.positionCursor(null,-100,-100);}</d:handler><d:handler event="resize" type="text/javascript">btl.resize.positionCursor(btl.resize.currentController,event.pageX,event.pageY);</d:handler><d:handler event="resizeEnd" type="text/javascript">if(this.getAttribute("resizeType")!="abstract"){btl.resize.applyCoordinates(btl.resize.currentElement);}btl.resize.positionCursor(null,-100,-100);</d:handler><d:handler event="DOMNodeInsertedIntoDocument" type="text/javascript">if(btl.isTrueValue("maximized",this.getAttribute("maximized"))){this.maximize();}else{if(btl.isTrueValue("minimized",this.getAttribute("minimized"))){this.minimize();}}</d:handler></d:behavior></d:namespace></d:tdl><d:namespace xmlns:p="http://www.backbase.com/2008/portal" name="http://www.backbase.com/2008/portal" xml:base="bindings/www.backbase.com.2008.portal/portal/portal.xml"><d:element name="portalItem" abstract="true"><d:property name="loaded" onset="" onget="return this._._loaded || false;"/><d:property name="portal" onset=""/><d:property name="settings" type="object" onset=""/><d:property name="templateId" onset=""/><d:method name="getPreference"><d:argument name="name" type="string" required="true"/><d:body type="text/javascript">return this._._preferences[name]||null;</d:body></d:method><d:method name="setPreference"><d:argument name="name" type="string" required="true"/><d:argument name="value"/><d:body type="text/javascript">if(this._._preferences[name]!=value){var b=this._._preferences[name];this._._preferences[name]=value;var a=bb.document.createEvent("MutationEvent");a.initMutationEvent("preferenceModified",true,false,null,b,this._._preferences[name],name);this.dispatchEvent(a);this.synchronize("update");}</d:body></d:method><d:method name="getSetting"><d:argument name="sName" type="string" required="true"/><d:argument name="sType" type="string"/><d:body type="text/javascript">var a={portal:{animationSpeed:"300",containerReorder:"true",gadgetWindowButtons:"unload;Close,maximize;Maximize,restore;Restore,minimize;Minimize,showPreferences;Edit preferences,hidePreferences;Close preferences,refresh;Refresh",gadgetWindowMargin:"8",gadgetWindowTemplate:"",maxContainers:"0",minColWidth:"100px",portalSyncType:"delta",portalSyncURL:"session",portalPTCURL:"proxy"},container:{className:"",closable:"true",colResizable:"false",draggable:"true",inlineTitleEdit:"true"},gadgetWindow:{autoRefresh:"0",className:"",closable:"true",denyInsert:"none",draggable:"true",editable:"true",maximizable:"true",maximizedMode:"exactfit",minimizable:"true",refreshable:"true"}};var c="";if(portal.overRideAnimation&amp;&amp;sName=="animationSpeed"){c="0";}else{if(this._._settings&amp;&amp;sName in this._._settings){c=String(this._._settings[sName]);}else{var b=this.getProperty("localName");if(sName in a[b]){c=String(a[b][sName]);}}}switch(sType){case"boolean":return c=="true";break;case"integer":return isNaN(parseInt(c,10))?0:parseInt(c,10);break;case"float":return isNaN(parseFloat(c,10))?0:parseFloat(c,10);break;default:return c;break;}</d:body></d:method><d:method name="synchronize"><d:argument name="sAction" type="string" required="true"/><d:argument name="fnUserCallback" type="function"/><d:body type="application/javascript">var m=this.getProperty("portal");var a=m.getProperty("session");if(!a){return;}var e={};var g=this.getProperty("localName")=="gadgetWindow"?"gadgets":(this.getProperty("localName")+"s");var s=function(C,u,A,v,t,w,B){if(!w){if(B){B(false);}return;}var z={};var y=false;for(var x in t){if(t[x]||(typeof t[x]=="string")||!isNaN(parseInt(t[x]))){y=true;if(typeof t[x]=="object"){z[x]=gadgets.json.stringify(t[x]);}else{z[x]=t[x];}}}if(A=="update"&amp;&amp;!y){return;}z.module=t.module=u.getProperty("localName")=="gadgetWindow"?"gadget":u.getProperty("localName");z.action=t.action=A;if(v){z.id=t.id=v;}C.updateSession(u,z,t,w,B);};var k=this._._id||this.getAttribute("id");var o=k?a[g][k]:false;var q=this.getProperty(this.getProperty("localName")=="gadgetWindow"?"container":"portal");if(q&amp;&amp;q._){e.pid=q._._id;}switch(sAction){case"add":if(!k&amp;&amp;!o){e.preferences=this._._preferences.copy();if(this._._templateId){e.tid=this._._templateId;}e.occurrences=q.getOccurrence(this);var d=this;var l=function(t){if(d.getProperty("localName")=="gadgetWindow"){a.gadgets[t.id]={src:d._._src,tid:t.tid,preferences:t.preferences};}else{a.containers[t.id]={content:{},tid:t.tid,preferences:t.preferences};}q.updateOccurrences(t);};}break;case"update":if(o){var j=false;var b=this.getProperty("localName")=="gadgetWindow";if(!this._._preferences.equals(o.preferences)){j=true;e.preferences=this._._preferences.copy();if(b){var f=this.getProperty("class").preferences;for(var n in f){if(f.hasOwnProperty(n)){var h=f[n];if(h.type=="readonly"){delete e.preferences[n];}}}}}if(this!=m){var q=this.getProperty(b?"container":"portal");var r=this._orgContainer||q;var p=a[r.getProperty("localName")+"s"][r._._id];var c=p.content=p.content||{};var i=q.getOccurrence(this);if(q!=r||!i.equals(c[k])){j=true;if(q!=r){e.opid=r._._id;}e.occurrences=i;}}if(j){var l=function(t){if(t.preferences){o.preferences=t.preferences;}if(t.occurrences||t.opid){q.updateOccurrences(t);}};}}break;case"reset":case"remove":if(o){var d=this;var l=function(v){if(g=="portals"||g=="containers"){var w=(a[g][k]||0).content||{};var u=k;var t=g;g=t=="portals"?"containers":"gadgets";for(k in w){l(v);}g=t;k=u;}delete a[g][k];};}break;}s(m,this,sAction,k,e,l,fnUserCallback);</d:body></d:method></d:element><d:element name="portalContainerItem" extends="p:portalItem" abstract="true"><d:property name="gadgets" type="array" onget="return this.getElementsByTagNameNS(\'http://www.backbase.com/2008/portal\', \'gadgetWindow\')" onset=""/><d:method name="getGadgetsByTemplateId"><d:argument name="templateId" required="true"/><d:body type="text/javascript">var c=this.getProperty("gadgets");var a=[];for(var b=0;b&lt;c.length;b++){if(c[b].getProperty("templateId")==templateId){a.push(c[b]);}}return a;</d:body></d:method></d:element><d:element name="portal" extends="p:portalContainerItem"><d:resource type="text/javascript" xml:base="portal.js">portal.TEMPLATE_NAME=/__GADGET__/g;portal.LAYOUT_CHECK_TIMEOUT=40;portal.GADGET_PLACEHOLDER="gadget-placeholder";portal.GADGET_UNMANAGED="unmanaged";portal.overRideAnimation=false;portal._autoRefresh={list:[],startTime:new Date(),poolingInterval:60,queueInterval:5,poolingId:0,set:function set(a,c){if(isNaN(c)){c=0;}var d=-1;for(var b=0;b&lt;this.list.length&amp;&amp;d&lt;0;b++){if(a==this.list[b][0]){d=b;}}if(d&gt;=0){if(c){this.list[d][1]=c;return true;}else{this.list.splice(d,1);}}else{if(c){this.list.push([a,c]);return true;}}return false;},queue:[],start:function start(){var a=this;this.queue=[];this.poolingId=setInterval(function b(){var e=Math.round((new Date()-a.startTime)/60000);var f,c;if(a.queue.length){return;}for(var d=0;d&lt;a.list.length;d++){c=a.list[d][0];if(!c||!c._){a.list.splice(d--,1);continue;}if(e%a.list[d][1]===0){a.queue[a.queue.length]=c;}}if(a.queue.length){(function(){if(a.queue.length){var l=Math.round((new Date()-a.startTime)/1000);var k,g,j=Math.round((60-l%60)/a.queueInterval);for(var h=j&gt;0?Math.ceil(a.queue.length/j):a.queue.length;a.queue.length&amp;&amp;h&gt;0;h--){g=a.queue.pop();if(g&amp;&amp;g._){g.refresh();}}}if(a.queue.length){setTimeout(arguments.callee,a.queueInterval*1000);}})();}},a.poolingInterval*1000);},stop:function stop(){if(this.poolingId){this.queue=[];clearInterval(this.poolingId);}}};portal._autoRefresh.start();portal._getGadgetDimensions=function _getGadgetDimensions(a){return{top:a.absoluteTop,left:a.parentColumn?a.parentColumn.pixLeft:0,width:portal._getGadgetWidth(a.parentColumn,a),height:100};};portal._getGadgetWidth=function _getGadgetWidth(b,c){var a=c.colSpan?portal._calculateColSpanWidth(b,c):b.pixWidth;if(bb.html.getStyle(c,"box-sizing")=="content-box"){a-=portal._getBorderPaddingWidth(c);}return a;};var oldConvert=bb.html.convertToPixels;bb.html.convertToPixels=function convertToPixels(){return oldConvert.apply(this,arguments);};var oldGetStyle=bb.html.getStyle;bb.html.getStyle=function getStyle(){return oldGetStyle.apply(this,arguments);};portal._getBorderPaddingWidth=function _getBorderPaddingWidth(a){var b=a.offsetWidth-a.clientWidth;b+=bb.html.convertToPixels(bb.html.getStyle(a,"padding-left"),a);b+=bb.html.convertToPixels(bb.html.getStyle(a,"padding-right"),a);return b;};portal._getNodeWidth=function _getNodeWidth(b){var a=b.offsetWidth;return bb.html.getStyle(b,"box-sizing")=="content-box"?a-portal._getBorderPaddingWidth(b):a;};portal._getMaximizedGadgetWidth=function _getMaximizedGadgetWidth(b,a){var c=b.viewGate.offsetWidth-portal._getBorderPaddingWidth(b.viewGate);if(bb.html.getStyle(a.viewNode,"box-sizing")=="content-box"){c-=portal._getBorderPaddingWidth(a.viewNode);}return c;};portal._getGadgetHeight=function _getGadgetHeight(d,f){if(f.colSpanItem){return portal._getGadgetHeight(f.colSpanItem.parentColumn,f.colSpanItem);}if(!f.offsetHeight){return 0;}var c=portal._getGadgetWidth(d,f);if(!c||!f.offsetHeight||c==portal._getNodeWidth(f)){return f.offsetHeight;}var e,a=f.style.width;bb.html.setStyle(f,"width",c+"px");if(f.controller){var b=bb.document.createEvent("CustomEvent");b.initEvent("resize",false,false);f.controller.dispatchEvent(b);}e=f.offsetHeight;bb.html.setStyle(f,"width",a);return e;};portal._getGadgetNextTop=function _getGadgetNextTop(b,d,a,e){if(d){var c=portal._getGadgetHeight(b,d);if(c!=0){c+=e;}a=d.absoluteTop+c;}return a;};portal._calculateColSpanTop=function _calculateColSpanTop(f,e,g){if(f.colSpan&amp;&amp;f.colSpanItems){for(var c=0;c&lt;f.colSpan;c++){var b=f.colSpanItems[c];if(b&amp;&amp;b.parentColumn){if(b.parentColumn==f.parentColumn){break;}var d=b.parentColumn;var a=portal._getGadgetNextTop(d,d.items[bb.array.indexOf(d.items,b)-1],0,g);if(a&gt;e){e=a;}}}}else{if(f.colSpanItem){e=portal._calculateColSpanTop(f.colSpanItem,e,g);}}return e;};portal._updateColSpan=function _updateColSpan(d,f,e){if(f.colSpanItem){return;}if(!("colSpanMax" in f)){f.colSpanMax=0;}if(f.colSpanMax&lt;e){e=f.colSpanMax;}var a=Math.min(f.colSpanItems instanceof Array?f.colSpanItems.length:0,f.colSpanMax);if(f.colSpanMax&lt;a){while(f.colSpanItems.length&gt;f.colSpanMax){var c=f.colSpanItems.pop();if(c&amp;&amp;c.parentColumn){d.removeFromColumn(c);}}a=f.colSpanMax;}f.colSpan=a;if(f.colSpan&gt;e){for(var b=e;b&lt;f.colSpan;b++){var c=f.colSpanItems[b];if(c&amp;&amp;c.parentColumn){d.removeFromColumn(c);}}f.colSpanItems.splice(e,f.colSpan-e);f.colSpan=e;f.style.width=portal._getGadgetWidth(f.parentColumn,f)+"px";}else{if(e&gt;f.colSpan){var g=f.parentColumn,b=0;while(b++&lt;f.colSpan){g=g.nextColumn;}if(!f.colSpanItems){f.colSpanItems=[];}for(b=f.colSpan;b&lt;e;b++){g=g.nextColumn;if(!g){break;}if(!f.colSpanItems[b]){f.colSpanItems[b]={colSpanItem:f,iInitIndex:0};}d.appendToColumn(g,f.colSpanItems[b],0);f.colSpan++;}}}};portal._calculateColSpanWidth=function _calculateColSpanWidth(d,e){var a=d;for(var b=0,c=d;c&amp;&amp;b&lt;e.colSpan;b++){c=a.nextColumn;if(c){a=c;}}return a.pixLeft+a.pixWidth-d.pixLeft;};portal._applyColumnWidth=function _applyColumnWidth(a,f,c,e){var g;var h=a.getSetting("gadgetWindowMargin","integer");var b=a.getSetting("animationSpeed","integer");while(g=f.items[c++]){g.absoluteTop=e;if(!g.colSpanItem&amp;&amp;(f.pixLeft||f.pixWidth)){var d=portal._getGadgetWidth(f,g);if(b===0){bb.html.setStyle(g,"top",e+"px");bb.html.setStyle(g,"left",f.pixLeft+"px");bb.html.setStyle(g,"width",d+"px");}else{g.iAniTop=bb.smil.animate(g,{attributeName:"top",dur:b+"ms",to:e+"px",fill:"freeze"});bb.smil.animate(g,{attributeName:"left",dur:b+"ms",to:f.pixLeft+"px",fill:"freeze"});bb.smil.animate(g,{attributeName:"width",dur:b+"ms",to:d+"px",fill:"freeze"});}}e=portal._getGadgetNextTop(f,g,0,h);e=portal._calculateColSpanTop(g,e,h);}};portal._getColumnWidth=function _getColumnWidth(c,e,b){var d=portal._getNodeWidth(c.viewGate);if(e.cachedTotalWidth!==d){var f=c.getSetting("gadgetWindowMargin","integer");e.cachedTotalWidth=d;var a=0;if(e.width.match(/%$/)){d-=(f*(b-1));a=Math.round(parseFloat(e.width)/100*d);}else{a=parseInt(e.width);}e.cachedWidth=a;}return e.cachedWidth;};portal._layoutHeightChecker=function _layoutHeightChecker(h){if(h&amp;&amp;h._&amp;&amp;!h.pauseLayout){var a=h.getProperty("activeContainer");var o=a?a._._columns||[]:[];var v=0;var p=h.getSetting("gadgetWindowMargin","integer");var d=0;var k,x=0;if(a&amp;&amp;a._._maximizedGadget){var c=a._._maximizedGadget;c.viewNode.style.top=c.viewNode.style.left="0px";if(bb.html.getBoxObject(h.viewGate,"content").width!=bb.html.getBoxObject(c.viewNode,"border").width){bb.html.setStyle(c.viewNode,"width",portal._getMaximizedGadgetWidth(h,c)+"px");var n=bb.document.createEvent("CustomEvent");n.initEvent("resize",false,false);c.dispatchEvent(n);}if(c.getSetting("maximizedMode")=="exactfit"){var e=bb.html.getBoxObject(bb.viewport);var g=bb.html.getBoxObject(c.viewGate,"content");var s=bb.html.getBoxObject(c.viewNode);var q=0;var u=bb.html.getBoxObject(h.viewNode,"content");q=document.body.offsetHeight-(u.top+u.height)+4;var l=g.top-((g.top+g.height)-(s.top+s.height));var b=(e.height-l-q);if(b&lt;400){b=400;}if(b!=c.viewGate.offsetHeight){c.viewGate.style.height=b+"px";var n=bb.document.createEvent("CustomEvent");n.initEvent("resize",false,false);c.dispatchEvent(n);}}else{if(c.viewGate.style.height){c.viewGate.style.height="";}}v=c.viewNode.offsetHeight;}else{while(k=o[x++]){var w=portal._getColumnWidth(h,k,o.length);if(k.pixLeft!=d||k.pixWidth!=w){k.isChanged=true;k.pixLeft=d;k.pixWidth=w;}d+=w+p;}var k,x=0;while(k=o[x++]){var r=k.items,t=0,m,f=null,l=0;while(m=r[t++]){if(k.isChanged&amp;&amp;!m.colSpanItem){bb.html.setStyle(m,"left",k.pixLeft+"px");bb.html.setStyle(m,"width",portal._getGadgetWidth(k,m)+"px");if(m.controller){var n=bb.document.createEvent("CustomEvent");n.initEvent("resize",false,false);m.controller.dispatchEvent(n);}}if(m.colSpanItem){l=m.absoluteTop=m.colSpanItem.absoluteTop;}else{l=portal._getGadgetNextTop(k,f,l,p);l=portal._calculateColSpanTop(m,l,p);if(l!==m.absoluteTop){if(m.iAniTop){bb.smil.stop(m.iAniTop);m.iAniTop=null;}bb.html.setStyle(m,"top",l+"px");m.absoluteTop=l;}}v=Math.max(l+portal._getGadgetHeight(k,m),v);f=m;}delete k.isChanged;}}if(v!==h.viewGate.cachedHeight){h.viewGate.cachedHeight=v;h.viewGate.style.height=v+"px";}}};portal._object=function portal_object(b){if(b instanceof Object){var c=this.copy(b);for(var a in c){if(c.hasOwnProperty(a)){this[a]=c[a];}}}};portal._object.prototype={};portal._object.prototype.copy=function portal_object_copy(d){var b;if(!arguments.length){d=this;}if(d instanceof Array){b=[];for(var c=0;c&lt;d.length;c++){b[c]=arguments.callee(d[c]);}}else{if(d instanceof Object){b={};for(var a in d){if(d.hasOwnProperty(a)){b[a]=arguments.callee(d[a]);}}}else{if(typeof d=="function"){}else{b=d;}}}return b;};portal._object.prototype.equals=function portal_object_equals(c,a){if(c instanceof Object){for(var b in this){if(this.hasOwnProperty(b)&amp;&amp;!(b in c)){return false;}}for(var b in c){if(c.hasOwnProperty(b)){if(!(b in this)){return false;}else{if(this[b] instanceof Object){if(!portal._object.prototype.equals.call(this[b],c[b],a)){return false;}}else{if(a&amp;&amp;this[b]!==c[b]){return false;}else{if(this[b]!=c[b]){return false;}}}}}}return true;}return a?(c===this):(c==this);};(function(){var o="http://www.backbase.com/2008/gadget",r="http://www.backbase.com/2006/tdl",a="http://www.w3.org/1999/xhtml";function c(s){s=s||{};this.requireSubmit=false;this.preferences={};this.handlers={};this.includes=[];this.src=String(s.src);this.content="";this.icon="";this.title="";this.htmlClass="";this.htmlStyle="";this.bodyClass="";this.bodyStyle="";this.noVisiblePreferences=true;this.isLoaded=Boolean(s.isLoaded)||false;this.callbackQueue=[];if(!this.isLoaded){this.requiresQueue={internal:false};}}c.prototype.executeWhenReady=function(t){if(this.isLoaded){var s=this;setTimeout(function(){t(s);},1);}else{this.callbackQueue.push(t);}};c.prototype.build=function(s){if(this.isLoaded){return;}var E=s.documentElement;var Q=s.getElementsByTagName("head")[0];var D=s.getElementsByTagName("body")[0];if(Q){var A=Q.getElementsByTagName("*"),w=0,K,v=[],C,y=[];while(K=A[w++]){C=K.getAttribute("name");switch(K.namespaceURI){case"http://www.backbase.com/2008/gadget":switch(portal.xml.getLocalName(K)){case"preferences":this.requireSubmit=K.getAttribute("requireSubmit")=="true";break;case"preference":this.preferences[C]={type:K.getAttribute("type"),"default":K.getAttribute("default")||"",label:K.getAttribute("label"),onchange:K.getAttribute("onchange"),values:[]};if(this.preferences[C].type=="range"){var L=parseInt(K.getAttribute("min"),10);var M=parseInt(K.getAttribute("max"),10);var F=parseInt(K.getAttribute("step"),10)||1;for(var O=L;O&lt;=M;O=O+F){this.preferences[C].values.push({value:O});}}break;case"enumeration":var R={value:K.getAttribute("value")||K.textContent||K.text};R.label=K.getAttribute("label")||R.value;this.preferences[K.parentNode.getAttribute("name")].values.push(R);break;default:throw"Unknown element in gadget definition "+K.nodeName;break;}break;case"http://www.w3.org/1999/xhtml":switch(portal.xml.getLocalName(K)){case"style":v.push(K.textContent||K.text||"");break;case"link":var N=K.getAttribute("href");if(N){if(N.match(/standalone\\.css$/)){break;}N=bb.uri.resolveUri(N,this.src);var J=K.getAttribute("rel");if(J=="icon"){this.icon=N;}else{if(J=="stylesheet"){if(!e[N]){e[N]={loaded:true,src:N};var x=document.createElement("link");x.type="text/css";x.rel=J;x.href=N;document.head.appendChild(x);}}}}break;case"script":var N=K.getAttribute("src");if(!N){N=K.textContent||K.text||"";if(N.length){f(this,N,"internal_javascript");}}else{if(N.match(/standalone\\.js$/)||N.match(/engine\\/backbase\\.js$/)){break;}f(this,bb.uri.resolveUri(N,this.src),"external_javascript");}break;case"title":this.title=bb.xml.serialize(K,true);break;}break;}}var z=v.join("");if(z.length){bb.html.addStyleSheet(i(z,this.src));}}var A=D.getElementsByTagName("*"),w=0,K,u;while(K=A[w++]){switch(K.namespaceURI){case"http://www.w3.org/1999/xhtml":var P=portal.xml.getLocalName(K);switch(P){case"area":case"a":u=K.getAttribute("href");if(u&amp;&amp;u.indexOf("://")&lt;0){K.setAttribute("href",bb.uri.resolveUri(u,this.src));}break;case"img":case"input":case"iframe":u=K.getAttribute("src");if(u&amp;&amp;u.indexOf("://")&lt;0){var H=bb.uri.resolveUri(u,this.src);if(P=="iframe"&amp;&amp;bb.browser.gecko){var G=K.ownerDocument.createElement("dummy");K.parentNode.replaceChild(G,K);K.setAttribute("src",H);G.parentNode.replaceChild(K,G);}else{K.setAttribute("src",H);}}break;case"form":u=K.getAttribute("action");if(u&amp;&amp;u.indexOf("://")&lt;0){K.setAttribute("action",bb.uri.resolveUri(u,this.src));}break;case"script":if(K.getAttribute("type")=="text/backbase+xml"||K.getAttribute("type")=="application/backbase+xml"||K.getAttribute("type")=="application/backbase+ssr"){K.setAttribute("xml:base",this.src);m(K);}else{bb.command.trace(null,\'Script tag with type "\'+K.getAttribute("type")+\'" than text/backbase+xml detected in body of gadget. This script tag is ignored\');}break;}break;}}this.buildTDL(D);this.buildIncludes(D);for(var O in this.preferences){if(this.preferences[O]["type"]!="hidden"&amp;&amp;this.preferences[O]["type"]!="readonly"){this.noVisiblePreferences=false;break;}}this.content=bb.string.trim(bb.xml.serialize(D,true).replace(/&lt;([\\w:]+)([^&gt;]*)\\/&gt;/gi,"&lt;$1$2&gt;&lt;/$1&gt;"));this.htmlClass=E.getAttribute("class");this.htmlStyle=E.getAttribute("style");this.bodyClass=D.getAttribute("class");this.bodyStyle=D.getAttribute("style");var t=D.attributes;for(var w=0,I,B;I=t[w];w++){B=portal.xml.getLocalName(I);if(I.namespaceURI=="http://www.backbase.com/2008/gadget"&amp;&amp;B.substr(0,2)=="on"){this.handlers[B.substr(2)]=I.nodeValue;}}l(this.src,"internal");};c.prototype.buildTDL=function(t){var w=bb.xml.getElementsByTagNameNS(t,r,"tdl").concat(bb.xml.getElementsByTagNameNS(t,r,"namespace")),s=c.builders[r],v=0,u=null;while(u=w[v++]){s[portal.xml.getLocalName(u)].call(this,u);}};c.prototype.buildIncludes=function(t){var v=bb.xml.getElementsByTagNameNS(t,o,"include"),s=c.builders[o]["include"],u=null,w=0;while(u=v[w++]){this.includes.push(s(u));}};c.prototype.executeQueue=function(){var s=this.callbackQueue;while(s.length){s.shift().apply(this,arguments);}};c.builders={};c.builders[o]={};c.builders[o]["include"]=function(u){var t=u.ownerDocument.createElement("div"),v=new portal.gadget.IncludeConfig({url:String(u.getAttribute("src")||""),proxy:(u.getAttribute("proxy")||"").toLowerCase()=="true",method:(u.getAttribute("method")||"GET").toUpperCase()});for(var s=0,w=null;s&lt;u.childNodes.length;++s){w=u.childNodes[s];var x=portal.xml.getLocalName(w);if(w.namespaceURI==o&amp;&amp;/http-(proxy-)?param/.test(x)){v.httpParams.add(new portal.gadget.HttpParam(w.getAttribute("name"),w.getAttribute("value"),x=="http-proxy-param"?"proxy":"target",w.getAttribute("method")));}else{if(w.namespaceURI==o&amp;&amp;x=="http-preference-param"){v.httpParams.add(new portal.gadget.HttpPreferenceParam(w.getAttribute("name"),w.getAttribute("method")));}else{if(w.nodeType!=1||w.namespaceURI==a){t.appendChild(w.cloneNode(true));}}}}t.setAttribute("class",portal.gadget.IncludeConfig.CSS_CLASS);u.parentNode.replaceChild(t,u);return v;};c.builders[r]={};c.builders[r]["tdl"]=c.builders[r]["namespace"]=function(s){s.setAttribute("xml:base",this.src);m(s);return bb.construct(s);};var g={};g["about:blank"]=g[""]=new c({src:"about:blank",isLoaded:true});portal._unload=function(){g=null;e=null;q=null;};var e={};var q=[];var h=null;var p=false;function f(A,t,s){A.requiresQueue[t]=false;var y=A.src;if(!p){p=true;var z=document.getElementsByTagName("script"),u,w=0,B;while(u=z[w++]){if(B=u.src){if(B.indexOf("://")&lt;0){B=bb.uri.resolveUri(B,bb.document.getProperty("baseURI"));}e[B]={loaded:true,src:B};}}var x=document.getElementsByTagName("link"),v,w=0;while(v=x[w++]){if(B=v.href){if(B.indexOf("://")&lt;0){B=bb.uri.resolveUri(B,bb.document.getProperty("baseURI"));}e[B]={loaded:true,src:B};}}}var C=e[t];if(C){if(C.loaded){setTimeout(function(){l(y,t);},1);}else{C.queue.push(y);}}else{q.push([y,t,s]);if(q.length==1){b(q[0]);}}}function b(s){var v=s[0];var t=s[1];var y=s[2];var x={};x.loaded=false;x.src=t;x.queue=[v];e[t]=x;h=x;var w=document.getElementsByTagName("head")[0];switch(y){case"internal_javascript":t=t+";\\nportal.loadExternalQueueReadyHelper();";if(bb.browser.ie){window.execScript(t);}else{var u=document.createElement("script");u.type="text/javascript";u.appendChild(document.createTextNode(t));w.appendChild(u);}break;case"external_javascript":var u=document.createElement("script");u.type="text/javascript";if(!bb.browser.opera){u.onreadystatechange=function(){if(this.readyState=="loaded"||this.readyState=="complete"){portal.loadExternalQueueReadyHelper();}};}u.onerror=u.onload=portal.loadExternalQueueReadyHelper;if(bb.browser.opera){setTimeout(function(){u.src=t;},0);}else{u.src=t;}w.appendChild(u);break;}}portal.loadExternalQueueReadyHelper=function(){var t=h;if(!t||t.loaded){return;}t.loaded=true;var s;while(s=t.queue.shift()){l(s,t.src);}h=null;q.shift();if(q.length){b(q[0]);}};function l(t,s){var v=g[t];if(s){v.requiresQueue[s]=true;}for(var u in v.requiresQueue){if(v.requiresQueue[u]==false){return;}}v.isLoaded=true;v.executeQueue(v);}function m(z,s){var A={};var x=z;if(!s){s=z;x=z.parentNode;}while(x){var v=x.attributes,u=0,y;if(v){while(y=v[u++]){if(y.namespaceURI=="http://www.w3.org/2000/xmlns/"||(!y.namespaceURI&amp;&amp;y.prefix=="xmlns")){var w=String(y.nodeName).toLowerCase();if(!(w in A)){A[w]=y.nodeValue;}}}}x=x.parentNode;}for(var t in A){if("setAttributeNS" in s){if(!s.getAttributeNS("http://www.w3.org/2000/xmlns/",t)){s.setAttributeNS("http://www.w3.org/2000/xmlns/",t,A[t]);}}else{if(!s.getAttribute(t)){s.setAttribute(t,A[t]);}}}}var n=/url\\s*\\([^;}]+\\)/gi;var d=/(url\\s*)\\(\\s*([\'"]?)(.+)[\'"]?\\s*\\)/i;var k=/@import\\s+[\'"][^\'"]+[\'"]/gi;var j=/(@import\\s+[\'"])([^\'"]+)([\'"])/i;function i(x,w){var v=x.match(n),u,t,s;if(v){for(t=0,s=v.length;t&lt;s;t++){u=v[t].match(d);x=x.replace(u[0],"url(\'"+bb.uri.resolveUri(u[3].replace(/(\'|")$/,""),w)+"\')");}}v=x.match(k);if(v){for(t=0,s=v.length;t&lt;s;t++){u=v[t].match(j);x=x.replace(u[0],u[1]+bb.uri.resolveUri(u[2],w)+u[3]);}}return x;}portal._getButtons=function(y,A){var s=y.split(",");var w=0;var x,v=[];while(x=s[w++]){x=x.split(";");var u=A+" "+A+"-"+x[0];var z="";if(x[1]){z=\' title="\'+portal.getLocale(x[1])+\'"\';}var t="";if(x[2]){u+=" "+A+"-text";t=portal.getLocale(x[2]);}v.push(\'&lt;a class="\',u,\'"\',z,\' href="javascript:void(0)"&gt;\',t,"&lt;/a&gt;");}return v;};portal._getButtonType=function(s,t){return s.className.match(new RegExp(t+" "+t+"-([^- ]{1,})"))[1];};portal._getButtonClass=function(s,u,t){return u+"-"+this._getButtonType(s,u)+(arguments.length&gt;2?t:"");};portal._gatherValueFromInput=function(x){switch(x.type){case"select-multiple":var t=[];for(var s=0;s&lt;x.options.length;s++){if(x.options[s].selected){t.push(String(x.options[s].value));}}return t.join(",");break;case"radio":case"checkbox":var t=[];var v=x.form.elements;var w,u=0;while(w=v[u++]){if(w.name==x.name&amp;&amp;w.checked){if(x.type=="radio"){return String(w.value);}else{t.push(String(w.value));}}}return t.join(",");break;case"text":case"password":case"textarea":case"select-one":default:return String(x.value);}};portal.setGadgetClass=function(v,t){var s=bb.uri.resolveUri(v,bb.document.getProperty("baseURI"));var u=g[s];if(true){g[s]=u=new c({src:s});u.build(t);}};portal.getGadgetClass=function(v,u){var s=bb.uri.resolveUri(v,bb.document.getProperty("baseURI"));var t=g[s];if(!t){g[s]=t=new c({src:s});gadgets.io.makeRequest(s,function(w){if(w.errors.length){t.executeQueue(false);return delete g[s];}var x=bb.xml.parse(w.text,true);if(!x||!x.documentElement||!x.getElementsByTagName("body")[0]){t.executeQueue(false);return delete g[s];}t.build(x);},{type:"xml"});}if(u){t.executeWhenReady(u);}};})();</d:resource><d:template type="application/xhtml+xml"><div xmlns="http://www.w3.org/1999/xhtml" class="p-portal"><div class="p-column-resize-grippy"/><div class="p-column-resize-line"/><div class="p-portal-dragPlaceholder"/><d:content/></div></d:template><d:property name="containers" type="array" onget="return this.getElementsByTagNameNS(\'http://www.backbase.com/2008/portal\', \'container\')" onset=""/><d:property name="activeContainer" type="object" onset=""><d:getter type="text/javascript">return this._._activeContainer&amp;&amp;this._._activeContainer._?this._._activeContainer:null;</d:getter></d:property><d:property name="session"><d:getter type="text/javascript">return this._._session||null;</d:getter><d:setter type="text/javascript">if(!value){value={};}this._._session=null;clearInterval(this.tLayoutCheck);clearInterval(this.maximizedResize);var g=this.getProperty("containers"),e=0,d;while(d=g[e++]){bb.destruct(d);}this.addToSession(value);var c=this;this.tLayoutCheck=setInterval(function f(){portal._layoutHeightChecker(c);},portal.LAYOUT_CHECK_TIMEOUT);var b=bb.document.createEvent("CustomEvent");b.initEvent("sessionLoaded",false,false);this.dispatchEvent(b);var a=this.getProperty("containers")[0];if(!this.getProperty("activeContainer")&amp;&amp;a){this.activateContainer(a);}this._._loaded=true;</d:setter></d:property><d:method name="getContainersByTemplateId"><d:argument name="templateId" required="true"/><d:body type="text/javascript">var c=this.getProperty("containers");var a=[];for(var b=0;b&lt;c.length;b++){if(c[b].getProperty("templateId")==templateId){a.push(c[b]);}}return a;</d:body></d:method><d:method name="updateSession"><d:argument name="oThat" type="object" required="true"/><d:argument name="oSendData" type="object" required="true"/><d:argument name="oData" type="object" required="true"/><d:argument name="fnCallback" type="function" required="true"/><d:argument name="fnUserCallback" type="function"/><d:body type="application/javascript">if(this.getSetting("portalSyncType")=="delta"){var b=this;gadgets.io.makeRequest(bb.uri.resolveUri(this.getSetting("portalSyncURL"),this.getProperty("baseURI")),function(g){var f=g.errors.length==0;var i=String(g.data);var h=(i.indexOf("{")==0&amp;&amp;i.lastIndexOf("}")==i.length-1);if(f&amp;&amp;!h&amp;&amp;!oData.id){oData.id=i;}if(fnUserCallback){fnUserCallback(f,h?gadgets.json.parse(i):i);}if(f&amp;&amp;!h){fnCallback(oData);}if(!f){var e=bb.document.createEvent("CustomEvent");e.initCustomEventNS(null,"sessionError",false,false,i);b.dispatchEvent(e);}},{method:"POST",data:gadgets.io.encodeValues(oSendData)});}else{var d=this.getProperty("session");var c=oThat.getProperty("localName")=="gadgetWindow"?"gadgets":oThat.getProperty("localName")+"s";var a=c.substr(0,1);setTimeout(function(){var e=true||confirm("Allow / Deny?");var f="";if(!oData.id){var g=1;while(d[c][a+g]){g++;}f=a+g;oData.id=f;}if(fnUserCallback){fnUserCallback(e,oData.id);}fnCallback(oData);},10);}</d:body></d:method><d:method name="addToSession"><d:argument name="sessionToAdd" type="object" required="true"/><d:body type="text/javascript">portal.overRideAnimation=true;var k=this._._session;if(!k){k=this._._session={};}if(!k.portals){k.portals={};}if(!k.containers){k.containers={};}if(!k.gadgets){k.gadgets={};}if(!k.settings){k.settings={};}if(!sessionToAdd.portals){sessionToAdd.portals={};}if(!sessionToAdd.containers){sessionToAdd.containers={};}if(!sessionToAdd.gadgets){sessionToAdd.gadgets={};}if(!sessionToAdd.settings){sessionToAdd.settings={};}var e,m;for(e in sessionToAdd.settings){k.settings[e]=sessionToAdd.settings[e];}for(e in sessionToAdd.portals){m=sessionToAdd.portals[e];m.preferences=m.preferences||{};this.setPortal(null,m.preferences,m.settings?k.settings[m.settings]:{},m.tid);this._._id=e;break;}var g,l,n;for(e in sessionToAdd.gadgets){m=k.gadgets[e]=sessionToAdd.gadgets[e];m.preferences=m.preferences||{};g=m.instance||this.createGadgetWindowFromConfig(e,m);if(m.instance){g._._src=m.src;g._._preferences=new portal._object(m.preferences||{});g._._settings=m.settings?k.settings[m.settings]:{};g._._templateId=m.tid||"";g.setAttribute("id",e);g._._id=e;}else{this.appendChild(g);}}for(e in sessionToAdd.containers){m=k.containers[e]=sessionToAdd.containers[e];m.preferences=m.preferences||{};l=m.instance||this.createContainer(m.src,m.preferences,m.settings?k.settings[m.settings]:{},m.tid);if(m.instance){l._._preferences=new portal._object(m.preferences||{});l._._settings=m.settings?k.settings[m.settings]:{};l._._templateId=m.tid||"";}l.setAttribute("id",e);l._._id=e;if(!m.instance||l.getProperty("parentNode")!=this){this.appendChild(l);}l.load();}for(e in sessionToAdd.portals){if(e in k.portals){}else{for(var d in k.portals){return;}m=k.portals[e]=sessionToAdd.portals[e];var b=m.content||{},c,h,l;var a=[];for(h in b){c=b[h];l=bb.document.getElementById(h);if(l&amp;&amp;c){a[parseInt(c.pos,10)||0]=l;}}var f=this.getProperty("containers"),d=0,l;while(l=f[d++]){if(bb.array.indexOf(a,l)==-1){a.push(l);}}for(d=0;d&lt;a.length;d++){l=a[d];if(l){this.appendChild(l);}}}break;}portal.overRideAnimation=false;</d:body></d:method><d:method name="activateContainer"><d:argument name="oContainer"/><d:body type="text/javascript">var d=this.getProperty("activeContainer");if(d!=oContainer){if(d&amp;&amp;d._){var b=d.getSetting("className","string");if(b.length){bb.html.removeClass(this.viewNode,b);}var g=d.getProperty("gadgets");var a,e=0;while(a=g[e++]){a.viewNode.style.display="none";}var c=bb.document.createEvent("CustomEvent");c.initEvent("deactivateContainer",true,false);d.dispatchEvent(c);}if(!oContainer||!oContainer._||!oContainer.instanceOf("http://www.backbase.com/2008/portal","container")){oContainer=null;}this._._activeContainer=oContainer;if(oContainer){var f=oContainer.getProperty("maximizedGadget");if(f){f.load();f.viewNode.absoluteTop=-1;if(f.viewNode.parentColumn){f.viewNode.parentColumn.isChanged=true;}f.viewNode.style.display="";}else{var g=oContainer.getProperty("gadgets"),e=0,a;while(a=g[e++]){a.load();a.viewNode.absoluteTop=-1;if(a.viewNode.parentColumn){a.viewNode.parentColumn.isChanged=true;}a.viewNode.style.display="";}}var b=oContainer.getSetting("className","string");if(b.length){bb.html.addClass(this.viewNode,b);}var c=bb.document.createEvent("CustomEvent");c.initEvent("activateContainer",true,false);oContainer.dispatchEvent(c);}portal._layoutHeightChecker(this);}</d:body></d:method><d:method name="createContainer"><d:argument name="oDefinition" type="object"/><d:argument name="oPreferences" type="object"/><d:argument name="oSettings" type="object"/><d:argument name="sTemplateId" type="string"/><d:body type="text/javascript">portal._currentPortal=this;var a=bb.document.createElementNS("http://www.backbase.com/2008/portal","container");delete portal._currentPortal;a._._preferences=new portal._object(oPreferences||{});a._._settings=oSettings||{};a._._templateId=sTemplateId||"l"+this.getSetting("defaultContainerTemplate");return a;</d:body></d:method><d:method name="setPortal"><d:argument name="oDefinition" type="object"/><d:argument name="oPreferences" type="object"/><d:argument name="oSettings" type="object"/><d:argument name="sTemplateId" type="string"/><d:body type="text/javascript">this._._preferences=new portal._object(oPreferences||{});this._._settings=oSettings||{};this._._templateId=sTemplateId||"";gadgets.config.proxyUrl=bb.uri.resolveUri(this.getSetting("portalPTCURL"),this.getProperty("baseURI"));</d:body></d:method><d:method name="resetPortal"><d:body type="text/javascript">var a=this;this.synchronize("reset",function(c,b){if(c){a.setProperty("session",b);}});</d:body></d:method><d:method name="addContainer"><d:argument name="oContainer" required="true"/><d:argument name="oBeforeContainer" type="object"/><d:argument name="bMakeActive" type="boolean"/><d:body type="text/javascript">this.insertBefore(oContainer,oBeforeContainer||null);var b;if(bMakeActive){b=this.getProperty("activeContainer");this.activateContainer(oContainer);}var a=this;oContainer.synchronize("add",function(c,g,e){if(c){if(typeof g=="string"){oContainer.setAttribute("id",g);oContainer._._id=g;}else{var f=g;for(var d in f.containers||{}){f.containers[d].instance=oContainer;break;}a.addToSession(f);delete f.containers[d].instance;}oContainer.load();}else{if(bMakeActive){a.activateContainer(b);}bb.destruct(oContainer);}});</d:body></d:method><d:method name="removeContainer"><d:argument name="oContainer" required="true"/><d:body type="text/javascript">if(oContainer.getSetting("closable","boolean")){var a=oContainer.getProperty("nextSibling");oContainer.synchronize("remove",function(c){if(c){bb.destruct(oContainer);}else{oContainer.getProperty("portal").moveContainer(oContainer,a);}});if(this.getProperty("activeContainer")==oContainer){for(var b=oContainer.getProperty("nextSibling");b&amp;&amp;b._&amp;&amp;!b.instanceOf("http://www.backbase.com/2008/portal","container");b=b.getProperty("nextSibling")){}if(b){this.activateContainer(b);}else{for(var b=oContainer.getProperty("previousSibling");b&amp;&amp;b._&amp;&amp;!b.instanceOf("http://www.backbase.com/2008/portal","container");b=b.getProperty("previousSibling")){}this.activateContainer(b);}}oContainer.getProperty("portal").removeChild(oContainer);}</d:body></d:method><d:method name="moveContainer"><d:argument name="container" required="true"/><d:argument name="before"/><d:body type="text/javascript">this.insertBefore(container,before||null);container.synchronize("update");</d:body></d:method><d:method name="resetContainer"><d:argument name="container" required="true"/><d:body type="text/javascript">var a=this;container.synchronize("reset",function(c,h){if(c){var f=container.getProperty("gadgets"),b,e=0;while(b=f[e++]){bb.destruct(b);}if(typeof h!="string"){var g=h;for(var d in g.containers||{}){g.containers[d].instance=container;break;}container._._loadMethodCalled=false;container._._loaded=false;a.addToSession(g);delete g.containers[d].instance;}}});</d:body></d:method><d:method name="createGadget"><d:argument name="sSrc" type="string"/><d:argument name="oPreferences" type="object"/><d:argument name="oSettings" type="object"/><d:argument name="sTemplateId" type="string"/><d:body type="text/javascript">portal._currentPortal=this;var a=bb.document.createElementNS("http://www.backbase.com/2008/portal","gadgetWindow");delete portal._currentPortal;a._._src=sSrc;a._._preferences=new portal._object(oPreferences||{});a._._settings=oSettings||{};a._._templateId=sTemplateId||"";return a;</d:body></d:method><d:method name="createGadgetWindowFromConfig"><d:argument name="sId" type="string"/><d:argument name="oConfig" type="object"/><d:body type="text/javascript">var b=this._._session,a=null;a=this.createGadget(oConfig.src,oConfig.preferences,oConfig.settings?b.settings[oConfig.settings]:{},oConfig.tid);a.setAttribute("id",sId);a._._id=sId;return a;</d:body></d:method><d:method name="addGadget"><d:argument name="oGadget" required="true"/><d:argument name="oContainer" type="object"/><d:argument name="oOccurrence" type="variant"/><d:argument name="iIndex" type="number"/><d:body type="text/javascript">var a=oContainer.getProperty("maximizedGadget");if(a){a.restore();}if(typeof oOccurrence=="number"){bb.command.trace(this,"the addGadget API currently used has been deprecated, please use the new API",1);oOccurrence={pos:iIndex,col:oOccurrence};}else{oOccurrence=oOccurrence||{};}if(oOccurrence[portal.GADGET_UNMANAGED]!=="true"&amp;&amp;oGadget.viewNode.parentNode!=this.viewGate){this.viewGate.appendChild(oGadget.viewNode);}portal.overRideAnimation=true;this.moveGadget(oGadget,oContainer,oOccurrence);portal.overRideAnimation=false;var b=this;oGadget.synchronize("add",function(c,f){if(c){if(typeof f=="string"){oGadget.setAttribute("id",f);oGadget._._id=f;}else{var e=f;for(var d in e.gadgets||{}){e.gadgets[d].instance=oGadget;break;}b.addToSession(e);delete e.gadgets[d].instance;}if(oContainer=b.getProperty("activeContainer")){oGadget.load();}}else{bb.destruct(oGadget);}});</d:body></d:method><d:method name="removeGadget"><d:argument name="oGadget" required="true"/><d:body type="text/javascript">var b=oGadget.getProperty("container"),d=oGadget.viewNode.parentColumn,a,c;if(b&amp;&amp;d){a=bb.array.indexOf(b.getProperty("columns"),d);c=bb.array.indexOf(d.items,oGadget.viewNode);}oGadget.synchronize("remove",function(e){if(e){bb.destruct(oGadget);}else{if(b&amp;&amp;d){b.appendToColumn(d,oGadget.viewNode,c);}}});if(b&amp;&amp;d){b.removeFromColumn(oGadget.viewNode);if(oGadget.getProperty("maximized")){b.setProperty("maximizedGadget",null);}}</d:body></d:method><d:method name="moveGadget"><d:argument name="oGadget"/><d:argument name="oContainer" type="object"/><d:argument name="oOccurrence" type="variant"/><d:argument name="iIndex" type="number"/><d:body type="text/javascript">oContainer.appendChild(oGadget);oOccurrence=oOccurrence||{};if(typeof oOccurrence=="number"){bb.command.trace(this,"the moveGadget API currently used has been deprecated, please use the new API",1);oOccurrence={pos:iIndex,col:oOccurrence};}if(oOccurrence[portal.GADGET_UNMANAGED]==="true"){var b=portal.GADGET_PLACEHOLDER+"-"+oContainer.getProperty("templateId")+"-"+oGadget.getProperty("templateId");var a=document.getElementById(b);oGadget.viewNode.style.position="static";if(a){if(oGadget.viewNode.parentNode!=a){a.appendChild(oGadget.viewNode);}}else{bb.command.trace(this,\'Trying to add unmanaged gadget but placeholder doesnt exist with id="\'+b+\'", adding it before the portal now\');oPortal.viewNode.parentNode.insertBefore(oGadget.viewNode,oPortal.viewNode);}}else{oGadget.viewNode.colSpanMax=oOccurrence.colspan?parseInt(oOccurrence.colspan,10)-1:0;var d=oContainer.getProperty("columns");var c=d[parseInt(oOccurrence.col,10)]||d[0];oContainer.appendToColumn(c,oGadget.viewNode,parseInt(oOccurrence.pos,10));}oGadget.synchronize("update");</d:body></d:method><d:method name="resetGadget"><d:argument name="gadget" required="true"/><d:body type="text/javascript">var a=this;gadget.synchronize("reset",function(k,f){if(k){if(typeof f!="string"){var g=f,j,i=gadget.getProperty("class"),d=0;for(var e in g.gadgets||{}){j=g.gadgets[e].preferences||{};break;}for(var c in i.preferences){var b=i.preferences[c];d=Math.max(d,gadget._setPreference(c,j[c]||b["default"]));}if(d&gt;0){var h=bb.selector.query(gadget.viewNode,".p-gadget-preferences form");if(bb.html.hasClass(gadget.viewNode,"p-gadget-preferences-open")&amp;&amp;h){gadget.applyPreferencesToForm(h);}var l=bb.document.createEvent("CustomEvent");l.initEvent("change",false,false);gadget.dispatchEvent(l);}}}});</d:body></d:method><d:method name="_addDragOverlay"><d:body type="text/javascript">var a=bb.html.createElementFromString(\'&lt;div class="p-portal-dragOverlay"&gt;&lt;/div&gt;\');this.viewGate.appendChild(a);</d:body></d:method><d:method name="_removeDragOverlay"><d:body type="text/javascript">var a=bb.selector.query(this.viewGate,".p-portal-dragOverlay");if(a&amp;&amp;a.parentNode==this.viewGate){this.viewGate.removeChild(a);}</d:body></d:method><d:method name="getOccurrence"><d:argument name="oContainer"/><d:body type="application/javascript">return new portal._object({pos:String(bb.array.indexOf(this.getProperty("containers"),oContainer))});</d:body></d:method><d:method name="updateOccurrences"><d:argument name="newSessionData"/><d:body type="text/javascript">var b=this.getProperty("session").portals;var c=newSessionData.pid in b?b[newSessionData.pid].content:null;var e=newSessionData.opid||newSessionData.pid;var d=(e in b?b[e].content:null)||{};var a=c?c[newSessionData.id]:null;if(a){var f=parseInt(a.pos,10);for(var g in c){var h=c[g];if(g==newSessionData.id){delete c[g];}else{if(parseInt(h.pos,10)&gt;f){h.pos=String(parseInt(h.pos,10)-1);}}}}var i=parseInt(newSessionData.occurrences.pos,10);for(var g in d){var h=d[g];if(parseInt(h.pos,10)&gt;=i){h.pos=String(parseInt(h.pos,10)+1);}}d[newSessionData.id]=newSessionData.occurrences;</d:body></d:method><d:handler event="destruct" type="text/javascript">portal._unload();</d:handler><d:handler event="drag" type="text/javascript">var l=event.dragSource;if(!(l&amp;&amp;l._&amp;&amp;l.instanceOf("http://www.backbase.com/2008/portal","gadgetWindow"))){return;}var m=bb.html.getBoxObject(this.viewGate);var c=event.pageX-m.left;var b=event.pageY-m.top;var g=bb.selector.query(this.viewNode,".p-portal-dragPlaceholder");var a=this.getProperty("activeContainer");var k=event.dragSource.viewNode==btl.drag.dragManager.symbol?bb.selector.query(l.viewNode,".p-gadget-header"):btl.drag.dragManager.symbol;var e=this;if(!e._._autoScroll){e._._autoScroll={newTop:0,curTop:0,animation:0,newGTop:0};}if(!e._._autoScroll.animation){e._._autoScroll.animation=setInterval(function(){var y=true;var w=e._._autoScroll;if(btl.drag&amp;&amp;btl.drag.dragManager.isDragging&amp;&amp;btl.drag.dragManager.source==l){var C=bb.html.getBoxObject(e.viewNode);var x=C.top+C.height;var i=bb.html.getBoxObject(bb.viewport);var B=Math.max(i.top,bb.viewport.scrollTop);var z=B+i.height;var j=bb.html.getBoxObject(k);j.bottom=j.top+j.height+20;w.newGTop=parseInt(l.viewNode.style.top);if((j.bottom&gt;z)&amp;&amp;((z-j.height)&lt;x)){y=false;w.newTop=B+150;}else{if(j.top&lt;B&amp;&amp;B&gt;0){y=false;w.newTop=0;w.curTop=bb.viewport.scrollTop;}}}if(y){clearInterval(w.animation);w.animation=null;return;}var A=w.newTop-w.curTop;if(A!=0){A=Math.floor(A/3);if(Math.abs(A)&gt;50){A=A&gt;0?50:-50;}w.curTop+=A;if(Math.abs(w.newTop-w.curTop)&lt;10){w.curTop=w.newTop;}l.viewNode.style.top=(w.newGTop+A)+"px";bb.viewport.scrollTop=w.curTop;}else{clearInterval(w.animation);w.animation=null;}},50);}var p=a.getProperty("columns");var q=this.getSetting("gadgetWindowMargin","integer");for(var t=0,u=p.length-l.viewNode.colSpan;t&lt;u;t++){var h=p[t];if(c&gt;h.pixLeft&amp;&amp;c&lt;h.pixLeft+h.pixWidth){var o=-1;if(!h.items[0]||b&lt;portal._getGadgetHeight(h,h.items[0])/2){o=0;}else{for(var r=0;r&lt;h.items.length;r++){var n=h.items[r];var d=portal._getGadgetHeight(h,n);if(b&gt;=n.absoluteTop&amp;&amp;b&lt;=n.absoluteTop+d+q){if(d/4&gt;b-n.absoluteTop){if(h.items[r-1]==g){o=r-1;}else{o=r;}}else{if(h.items[r+1]==g){o=r+1;}else{o=r;}}break;}}}if(a==this.dragContainer&amp;&amp;this.dragColumn==t&amp;&amp;this.dragIndex==o){return;}this.dragContainer=a;this.dragColumn=t;this.dragIndex=o;var n=event.dragSource.viewNode;var d=portal._getGadgetHeight(h,n);if(bb.html.getStyle(g,"box-sizing")=="content-box"){d-=(bb.html.getBoxObject(g,"border").height-bb.html.getBoxObject(g,"content").height);}bb.html.setStyle(g,"height",d+"px");var v=this.getSetting("animationSpeed","integer");var s=portal._getGadgetWidth(h,n);if(s&lt;-btl.drag.dragManager.offsetLeft){btl.drag.dragManager.offsetLeft=btl.drag.dragManager.offsetLeft+(-btl.drag.dragManager.offsetLeft-s+100);}if(v===0){bb.html.setStyle(n,"width",s+"px");}else{var f={attributeName:"width",dur:v+"ms",to:s+"px",fill:"freeze"};bb.smil.animate(n,f);}n.style.display="";a.appendToColumn(h,g,o);break;}}</d:handler><d:handler event="dragEnd" type="text/javascript">var a=event.dragSource;if(!(a&amp;&amp;a._&amp;&amp;a.instanceOf("http://www.backbase.com/2008/portal","gadgetWindow")&amp;&amp;a.getProperty("loaded"))){return;}event.preventDefault();var h=bb.selector.query(this.viewNode,".p-portal-dragPlaceholder");var e=this.getProperty("activeContainer");var g=h.parentColumn;var f=bb.array.indexOf(g.items,h);e.removeFromColumn(h);e.appendChild(a);e.appendToColumn(g,a.viewNode,f);this._removeDragOverlay();bb.html.setStyle(a.viewNode,"opacity",1);h.style.visibility="";var b=a.viewNode.style;var d=this.getSetting("animationSpeed","integer");var c=function(){b.zIndex="";h.style.top="";h.style.left="";h.style.height="";h.style.width="";};if(d){setTimeout(c,d);}else{c();}if(e!=a._orgContainer||g!=a._orgColumn||f!=a._orgIndex){a.synchronize("update");}a._orgContainer=null;a._orgColumn=null;a._orgIndex=null;</d:handler><d:handler event="mousemove" type="text/javascript">var r=this.getProperty("activeContainer");if(!window.btl||(btl.drag&amp;&amp;btl.drag.dragManager.isDragging)||(btl.resize&amp;&amp;btl.resize.isResizing)||!r||r.getProperty("maximizedGadget")||!r.getSetting("colResizable","boolean")){return;}var h=bb.html.getBoxObject(this.viewGate);var g=event.pageX-h.left;var b=event.pageY-h.top;if(b&lt;0){return;}var n=bb.selector.query(this.viewGate,".p-column-resize-grippy");var q=(n.offsetHeight&amp;65534)/2;var p=b+q&gt;h.height?h.height-n.offsetHeight:b-q;var f=r.getProperty("columns");for(var k=0,a=f.length;k&lt;a;k++){var m=f[k];var e=f[k+1];if(g&gt;m.pixLeft+m.pixWidth&amp;&amp;g&lt;(e||0).pixLeft){var o=this.getSetting("gadgetWindowMargin","integer");var d=o,c=0;while(oItem=m.items[c++]){if(oItem.colSpan||(oItem.colSpanItem&amp;&amp;oItem.colSpanItem.colSpanItems[oItem.colSpanItem.colSpan-1]!=oItem)){d+=portal._getGadgetHeight(m,oItem)+o;}else{break;}}var l=m.pixLeft+m.pixWidth+(o/2)-(n.offsetWidth/2);n.style.top=Math.max(p,d)+"px";n.style.left=l+"px";n.resizeIndex=k;n.resizeTotalWidth=m.pixWidth+e.pixWidth;return;}}if(n.style.left!=""){n.style.left="";}</d:handler><d:handler event="mouseleave" type="text/javascript">var b=this.getProperty("activeContainer");if(!window.btl||(btl.drag&amp;&amp;btl.drag.dragManager.isDragging)||(btl.resize&amp;&amp;btl.resize.isResizing)||!b||b.getProperty("maximizedGadget")||!b.getSetting("colResizable","boolean")){return;}var a=bb.selector.query(this.viewGate,".p-column-resize-grippy");if(a.style.left!=""){a.style.left="";}</d:handler><d:handler event="mousedown" type="text/javascript" match=".p-column-resize-grippy">if(!bb.instanceOf(this,"http://www.backbase.com/2006/btl","resizeBase")){bb.addBehavior(this,"http://www.backbase.com/2006/btl","resizeBase");}var e=bb.html.getBoxObject(this.viewNode);var d=event.pageX-e.left;var b=event.pageY-e.top;var c=this.getProperty("activeContainer").getProperty("columns");var g=event.currentView;var i=g.resizeTotalWidth;var f=c[g.resizeIndex];this._nowResize=f;var h=bb.selector.query(this.viewNode,".p-column-resize-line");h.style.top=g.style.top;h.style.left=f.pixLeft+"px";h.style.width=f.pixWidth+"px";g.style.left="";g.style.top="";var a=bb.html.convertToPixels(this.getSetting("minColWidth"),this.viewNode);btl.resize.startResize(this,h,btl.resize.RIGHT,event.pageX,0,h,a,0,i-a,0,null);event.preventDefault();</d:handler><d:handler event="resizeEnd" type="text/javascript">var f=this._nowResize;if(f){this._nowResize=null;var k=this.getSetting("gadgetWindowMargin","integer");var b=this.getProperty("activeContainer").getProperty("columns");var m=f.cachedTotalWidth-((b.length-1)*k);var h=event.newWidth;if(f.width.match(/%$/)){h=Math.round(h/(m/100)*1000)/1000+"%";}else{h=h+"px";}var g=bb.array.indexOf(b,f);var c=b[g+1];var a=c.pixWidth+(f.pixWidth-event.newWidth);if(c.width.match(/%$/)){a=Math.round(a/(m/100)*1000)/1000+"%";}else{a=a+"px";}var l="";bFirst=false;for(var d=0;d&lt;b.length;d++){if(!bFirst){bFirst=true;}else{l+=",";}if(d==g){l+=h;}else{if(d==g+1){l+=a;}else{l+=b[d].width;}}}var j=bb.selector.query(this.viewNode,".p-column-resize-line");j.style.top="";j.style.left="";j.style.width="";var e=this.getProperty("activeContainer");e.setPreference("columns",l);}</d:handler><d:constructor type="application/javascript">this._._portal=this;this._._preferences=new portal._object();</d:constructor></d:element><d:element name="container" extends="p:portalContainerItem"><d:attribute name="id"/><d:property name="columns"><d:setter type="text/javascript">if(typeof value=="string"){var b=value.split(",");var s=this.getProperty("portal");var q=s.getSetting("gadgetWindowMargin","integer");var f=this._._columns||[];var l=0;var d=0;for(var h=0,c=Math.max(b.length,f.length);h&lt;c;h++){if(f[h]){var n=f[h];if(b[h]){d=h;n.width=b[h];n.pixLeft=l;n.cachedTotalWidth=-1;n.pixWidth=portal._getColumnWidth(s,n,b.length);l+=n.pixWidth+q;}else{while(n.items[0]){this.appendToColumn(f[d],n.items[0]);}f.splice(h--,1);}}else{if(b[h]){var n={};var p=f[d];d=h;n.items=[];n.width=b[h];n.pixLeft=l;n.pixWidth=portal._getColumnWidth(s,n,b.length);l+=n.pixWidth+q;f.push(n);var m=[];if(p){for(var e=0;e&lt;p.items.length;e++){var o=p.items[e];if(o.colSpanItem||!o.occurrence){continue;}var r=parseInt(o.occurrence.col,10)||0;if(r&gt;=h){m.push(o);}}}while(o=m.shift()){this.appendToColumn(n,o);}}}}var g=b.length-1&gt;=0?b.length-1:0;var k=[];for(var h=0,c=f.length;h&lt;c;h++){var n=f[h];n.previousColumn=f[h-1];n.nextColumn=f[h+1];for(var e=0,a=n.items.length;e&lt;a;e++){if(n.items[e].colSpanMax){k[k.length]={item:n.items[e],colSpan:g-h};}}}for(var h=0;h&lt;k.length;h++){portal._updateColSpan(this,k[h].item,k[h].colSpan);}for(var h=0,c=f.length;h&lt;c;h++){portal._applyColumnWidth(s,f[h],0,0);}this._._columns=f;}else{bb.command.trace(this,"Unsupported value set, columns property currently only accepts string type");}</d:setter><d:getter type="text/javascript">return this._._columns||(this._._columns=[]);</d:getter></d:property><d:property name="maximizedGadget"><d:getter type="text/javascript">if(this._._maximizedGadget&amp;&amp;!this._._maximizedGadget._){this.setProperty(name,null);}return this._._maximizedGadget;</d:getter><d:setter type="text/javascript">var d=this._._maximizedGadget;if(d&amp;&amp;!value){var c=this.getProperty("gadgets"),a,b=0;while(a=c[b++]){a.load();a.viewNode.absoluteTop=-1;if(a.viewNode.parentColumn){a.viewNode.parentColumn.isChanged=true;}a.viewNode.style.display="";}}if(value){var c=this.getProperty("gadgets"),a,b=0;while(a=c[b++]){a.viewNode.style.display=(a==value)?"":"none";}}this._._maximizedGadget=value;if(d&amp;&amp;value){portal.overRideAnimation=true;d.restore();portal.overRideAnimation=false;}portal._layoutHeightChecker(this.getProperty("portal"));</d:setter></d:property><d:constructor type="application/javascript">if(!portal._currentPortal){bb.command.trace(this,"A container needs to be created using createContainer method");}this._._portal=portal._currentPortal;</d:constructor><d:handler event="destruct" type="text/javascript">var a=bb.document.createEvent("CustomEvent");a.initEvent("unload",false,false);this.dispatchEvent(a);this._._portal=null;this._._columns=null;</d:handler><d:method name="__attach"><d:argument name="sFnName" type="string"/><d:argument name="oNode" type="object" required="true"/><d:argument name="oRefNode" type="object"/><d:body type="text/javascript"/></d:method><d:method name="getSmallestColumn"><d:body type="text/javascript">var c=this.getProperty("columns"),b=0,e;var a=0;var d=Infinity;while(e=c[b++]){var f=e.items[e.items.length-1];if(f){if(d&gt;f.absoluteTop+f.offsetHeight){d=f.absoluteTop+f.offsetHeight;a=b-1;}}else{d=0;a=b-1;break;}}return a;</d:body></d:method><d:method name="appendToColumn"><d:argument name="oColumn" type="object" required="true"/><d:argument name="oItem" type="object" required="true"/><d:argument name="iIndex" type="number"/><d:body type="text/javascript">if(!(iIndex&gt;=0)){iIndex=-1;}var a=this.getProperty("portal");var d=a.getSetting("gadgetWindowMargin","integer");if(oItem.parentColumn==oColumn){if(iIndex==-1&amp;&amp;oColumn.items[oColumn.items.length-1]==oItem){return;}if(oColumn.items[iIndex]==oItem){return;}}if(oItem.parentColumn){this.removeFromColumn(oItem);}oItem.parentColumn=oColumn;if(iIndex==-1){iIndex=oColumn.items.length;}var c=oColumn.items[iIndex-1];var b=0;if(c&amp;&amp;c.denyInsert=="after"){c=oColumn.items[--iIndex-1];}else{if(oColumn.items[iIndex]&amp;&amp;(oColumn.items[iIndex].denyInsert=="before"||oColumn.items[iIndex].colSpanMax||oColumn.items[iIndex].colSpanItem)){c=oColumn.items[++iIndex-1];}}b=portal._getGadgetNextTop(oColumn,c,b,d);if(oColumn.items[iIndex-1]&amp;&amp;oColumn.items[iIndex-1].colSpanItem&amp;&amp;oColumn.items[iIndex-1].iInitIndex&gt;iIndex){delete oColumn.items[iIndex-1].iInitIndex;iIndex--;}oColumn.items.splice(iIndex,0,oItem);portal._updateColSpan(this,oItem,oItem.colSpanMax);if(this==a.getProperty("activeContainer")){portal._applyColumnWidth(a,oColumn,iIndex,b);}else{if(!oItem.colSpanItem){oItem.style.display="none";oItem.style.width="1px";}}</d:body></d:method><d:method name="removeFromColumn"><d:argument name="oItem" type="object" required="true"/><d:body type="text/javascript">if(oItem.parentColumn){var f=oItem.parentColumn;var g=bb.array.indexOf(f.items,oItem);if(g!=-1){if(oItem.colSpan){for(var e=0;e&lt;oItem.colSpan;e++){this.removeFromColumn(oItem.colSpanItems[e]);}}f.items.splice(g,1);oItem.parentColumn=null;var h=this.getProperty("portal").getSetting("animationSpeed","integer");var k=this.getProperty("portal").getSetting("gadgetWindowMargin","integer");var c=0;var oItem,d=f.items,b=0;while(oItem=d[b++]){oItem.absoluteTop=c;if(!oItem.colSpanItem){if(h===0){bb.html.setStyle(oItem,"top",c+"px");}else{var a={attributeName:"top",dur:h+"ms",to:c+"px",fill:"freeze"};oItem.iAniTop=bb.smil.animate(oItem,a);}}c=portal._getGadgetNextTop(f,oItem,0,k);c=portal._calculateColSpanTop(oItem,c,k);}}}</d:body></d:method><d:method name="load"><d:body type="application/javascript">if(this._._loadMethodCalled||this.getProperty("loaded")||!this.getAttribute("id")){return;}this._._loadMethodCalled=false;var h=this.getProperty("portal");var p=bb.document.createEvent("CustomEvent");p.initEvent("beforeload",false,false);this.dispatchEvent(p);this.setProperty("columns",this.getPreference("columns")||"100%");var q=this.getProperty("columns");var u=h.getProperty("session").containers[this.getAttribute("id")]||{};var d=u.content||{},r,x;var a=[];var o=[];for(var b in d){var m={id:b,col:parseInt(d[b]["col"],10)||0,pos:parseInt(d[b]["pos"],10)||0,data:d[b]};if(d[b][portal.GADGET_UNMANAGED]==="true"){o.push(m);continue;}if(!a[m.col]){a[m.col]=[];}a[m.col][m.pos]=m;}var v=[];for(var s=0;s&lt;a.length;s++){if(a[s]){v=v.concat(a[s]);}}v=v.concat(o);for(var s=0;s&lt;v.length;s++){if(v[s]==undefined){continue;}var r=v[s].data;x=v[s].id;var n=bb.document.getElementById(x);if(n&amp;&amp;r){this.appendChild(n);n.viewNode.occurrence=r;if(r[portal.GADGET_UNMANAGED]==="true"){var l=n.getProperty("templateId");var c=n.getProperty("container").getProperty("templateId");var g=portal.GADGET_PLACEHOLDER+"-"+c+"-"+l;var k=document.getElementById(g);n.viewNode.style.position="static";if(k){if(n.viewNode.parentNode!=k){k.appendChild(n.viewNode);}}else{bb.command.trace(this,\'Trying to add unmanaged gadget but placeholder doesnt exist with id="\'+g+\'", adding it before the portal now\');h.viewNode.parentNode.insertBefore(n.viewNode,h.viewNode);}}else{var t=parseInt(r.col,10);var i=parseInt(r.pos,10);var f=q[t]||q[q.length-1];if(!q[t]){i+=9999;}n.viewNode.colSpanMax=r.colspan?parseInt(r.colspan,10)-1:0;if(f.items[i]){var w=f.items[i].colSpanItem;while(w){if(f.items[i]&amp;&amp;f.items[i].colSpanItem){var e=bb.array.indexOf(f.items[i].colSpanItem.parentColumn.items,f.items[i].colSpanItem);if(e==i){i++;w=f.items[i]&amp;&amp;f.items[i].colSpanItem;}else{w=false;}}else{w=false;}}}f.isChanged=true;this.appendToColumn(f,n.viewNode,i);}if(r.minimized=="true"){bb.html.addClass(n.viewNode,n.minimizeClass);}if(this==h.getProperty("activeContainer")){n.load();}}}this._._loaded=true;var p=bb.document.createEvent("CustomEvent");p.initEvent("load",false,false);this.dispatchEvent(p);</d:body></d:method><d:method name="unload"><d:body type="application/javascript">if(this.getSetting("closable","boolean")){var a=bb.document.createEvent("CustomEvent");a.initEvent("beforeunload",false,true);this.dispatchEvent(a);if(!a.defaultPrevented){var b=this.getProperty("portal");b.removeContainer(this);}}</d:body></d:method><d:method name="getOccurrence"><d:argument name="oGadget"/><d:body type="application/javascript">var a={};if(oGadget.viewNode.parentColumn){a.pos=String(bb.array.indexOf(oGadget.viewNode.parentColumn.items,oGadget.viewNode));a.col=String(bb.array.indexOf(this.getProperty("columns"),oGadget.viewNode.parentColumn));if(oGadget.viewNode.colSpanMax){a.colspan=String(oGadget.viewNode.colSpanMax+1);}}else{a[portal.GADGET_UNMANAGED]="true";}if(oGadget.getProperty("minimized")){a.minimized="true";}return new portal._object(a);</d:body></d:method><d:method name="updateOccurrences"><d:argument name="newSessionData"/><d:body type="text/javascript">var b=this.getProperty("portal").getProperty("session").containers;var d=newSessionData.pid in b?b[newSessionData.pid].content:null;var f=newSessionData.opid||newSessionData.pid;var e=(f in b?b[f].content:null)||{};var a=d?d[newSessionData.id]:null;if(a){var c=a.col;var g=parseInt(a.pos,10);for(var i in d){var j=d[i];if(i==newSessionData.id){delete d[i];}else{if(j.col==c&amp;&amp;parseInt(j.pos,10)&gt;g){j.pos=String(parseInt(j.pos,10)-1);}}}}var k=newSessionData.occurrences.col;var l=parseInt(newSessionData.occurrences.pos,10);for(var i in e){var j=e[i];if(j.col==k&amp;&amp;parseInt(j.pos,10)&gt;=l){j.pos=String(parseInt(j.pos,10)+1);}}var h=bb.document.getElementById(newSessionData.id);if(h){h.viewNode.occurrence=newSessionData.occurrences;}e[newSessionData.id]=newSessionData.occurrences;</d:body></d:method><d:handler event="preferenceModified" type="text/javascript">if(event.attrName=="columns"){this.setProperty("columns",event.newValue);}</d:handler><d:handler event="DOMNodeRemoved" type="text/javascript">if(event.target.instanceOf("http://www.backbase.com/2008/portal","gadgetWindow")){this.removeFromColumn(event.target.viewNode);}</d:handler></d:element></d:namespace><d:namespace xmlns:b="http://www.backbase.com/2006/btl" xmlns:p="http://www.backbase.com/2008/portal" name="http://www.backbase.com/2008/portal" xml:base="bindings/www.backbase.com.2008.portal/gadgetWindow/gadgetWindow.xml"><d:element name="gadgetWindow" extends="p:portalItem b:dragBase"><d:template type="text/javascript">if(!portal._currentPortal){bb.command.trace(this,"A gadget needs to be created using createGadget method");}this.init();var i=portal._currentPortal,a=i.getSetting("gadgetWindowTemplate");if(a){if(!window[a]){bb.command.trace(this,\'Cannot find javascript function "\'+a+\'"\');}return window[a].apply(this);}else{if(!arguments.callee.oCloneCache){var f=i.getSetting("gadgetWindowButtons");var b=portal._getButtons(f,"p-gadget-button");b.push(\'&lt;div class="p-gadget-icon"&gt;&lt;/div&gt;&lt;div class="p-gadget-title-wrapper"&gt;&lt;div class="p-gadget-title"&gt;\',portal.getLocale("Loading..."),"&lt;/div&gt;&lt;/div&gt;");var c="";if(!(bb.browser.ie&amp;&amp;bb.browser.version&lt;"7")){c=\'&lt;div class="p-gadget-shadow"&gt;&lt;div class="p-gadget-shadow-top-left"&gt;&lt;div class="p-gadget-shadow-top-right"&gt;&lt;div class="p-gadget-shadow-top-center"&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class="p-gadget-shadow-middle-left"&gt;&lt;/div&gt;&lt;div class="p-gadget-shadow-middle-right"&gt;&lt;/div&gt;&lt;div class="p-gadget-shadow-bottom-left"&gt;&lt;div class="p-gadget-shadow-bottom-right"&gt;&lt;div class="p-gadget-shadow-bottom-center"&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;\';}var h=\'&lt;div class="p-gadget-top-left"&gt;&lt;div class="p-gadget-top-right"&gt;&lt;div class="p-gadget-top-center"&gt;&lt;div onselectstart="return false;" class="p-gadget-header"&gt;\'+b.join("")+"&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;";var d=\'&lt;div class="p-gadget-middle-left"&gt;&lt;div class="p-gadget-middle-right"&gt;&lt;div class="p-gadget-center"&gt;&lt;div class="p-gadget-preferences" style="display:none;"&gt;&lt;/div&gt;&lt;div class="p-gadget-content"&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;\';var e=\'&lt;div class="p-gadget-bottom-left"&gt;&lt;div class="p-gadget-bottom-right"&gt;&lt;div class="p-gadget-bottom-center"&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;\';a=\'&lt;div class="p-gadget \'+this.loadingClass[0]+\'"&gt;\'+c+h+d+e+"&lt;/div&gt;";arguments.callee.oCloneCache=bb.html.createElementFromString(a);}this._._showLoadingCount=1;var g=arguments.callee.oCloneCache.cloneNode(true);g.colSpan=0;return[g,bb.selector.query(g,".p-gadget-content")];}</d:template><d:attribute name="id"/><d:property name="gadget"/><d:property name="class"><d:getter type="text/javascript">if(this._._class===undefined){bb.command.trace(this,\'The "class" property is not set probably because the gadget is not loaded yet.\');}return this._._class||null;</d:getter></d:property><d:property name="container" onset=""><d:getter type="text/javascript">var a=this.getProperty("parentNode");if(a&amp;&amp;a.instanceOf("http://www.backbase.com/2008/portal","container")){return a;}else{return null;}</d:getter></d:property><d:property name="maximized"><d:getter type="application/javascript">return bb.selector.match(this.viewNode,"."+this.maximizeClass[0]);</d:getter><d:setter type="application/javascript">if(value){this.maximize();}else{this.restore();}</d:setter></d:property><d:property name="minimized"><d:getter type="application/javascript">return bb.selector.match(this.viewNode,"."+this.minimizeClass[0]);</d:getter><d:setter type="application/javascript">if(value){this.minimize();}else{this.restore();}</d:setter></d:property><d:constructor type="text/javascript">this.init();</d:constructor><d:method name="init"><d:body type="text/javascript">if(!this._.__initialized){this._._portal=portal._currentPortal;this.minimizeClass=["p-gadget-minimized"];this.maximizeClass=["p-gadget-maximized"];this.hoverClass=["p-gadget-hover"];this.loadingClass=["p-gadget-loading"];this._._showLoadingCount=0;this._.__initialized=true;}</d:body></d:method><d:method name="load"><d:body type="text/javascript">if(this._._loadMethodCalled||this.getProperty("loaded")||!this.getAttribute("id")){return;}this._._loadMethodCalled=true;var b=bb.document.createEvent("CustomEvent");b.initEvent("beforeload",false,false);this.dispatchEvent(b);var c=this;var a=function(h){if(!c._){return;}var e=c.getAttribute("id");if(!h||!e.length){var g=bb.document.createEvent("CustomEvent");g.initCustomEventNS(null,"gadgetError",true,false,"gadgetClass could not be loaded or gadget ID is not defined");c.dispatchEvent(g);return;}var d=new portal.gadget.Gadget(e,c.viewGate,h,c);c.setProperty("class",h);c.setProperty("gadget",d);if(h.icon){d.setIcon(h.icon);}d.setTitle(h.title||"");if(h.noVisiblePreferences){((bb.selector.query(c.viewNode,".p-gadget-button-showPreferences")||0).style||0).display="none";((bb.selector.query(c.viewNode,".p-gadget-button-hidePreferences")||0).style||0).display="none";}if(h.bodyClass){bb.html.addClass(c.viewGate,h.bodyClass.split(" "));}if(h.bodyStyle){c.viewGate.style.cssText=h.bodyStyle;}if(h.htmlClass){bb.html.addClass(c.viewNode,h.htmlClass.split(" "));}c.buildContent(h);var i=bb.selector.queryAll(c.viewGate,"."+portal.gadget.IncludeConfig.CSS_CLASS);for(var f=0;f&lt;h.includes.length;++f){d.registerInclude(new portal.gadget.Include(d,i[f],h.includes[f]));}c.initIncludes(function(){var p;var o=c.viewGate.getElementsByTagName("script");var n=0;var m;var l=[];var k=[];while(m=o[n++]){if(m.getAttribute("type")=="text/backbase+xml"||m.getAttribute("type")=="application/backbase+xml"||m.getAttribute("type")=="application/backbase+ssr"){k.push(m);}}var q=function(){if(m=k.shift()){var H=m.textContent||m.innerHTML||m.text||"";var y={};var w=[\'&lt;?xml version="1.0"?&gt;\',"\\n",\'&lt;client:fragment xmlns:client="http://www.backbase.com/2006/client"\'];var E=m.attributes,D=0,x,u;while(x=E[D++]){if(x.specified){u=String(x.nodeName).toLowerCase();if((u=="xmlns"||u.indexOf("xmlns:")==0)&amp;&amp;!(u in y)){w.push(" ",u,\'="\',bb.string.escapeXml(y[u]=x.nodeValue),\'"\');}else{var C=x.nodeValue;if(!C){switch(u){case"class":C=m.className;break;case"style":C=m.style.cssText;break;default:C="";}}w.push(" ",u,\'="\',bb.string.escapeXml(C),\'"\');}}}if(!("xmlns" in y)){w.push(\' xmlns="http://www.w3.org/1999/xhtml"\');}w.push("&gt;",H,"&lt;/client:fragment&gt;");var t=bb.xml.parse(w.join(""),true).documentElement;bb.construct(t,function(){var L=bb.getControllerFromModel(t);if(m.getAttribute("fragment")=="true"){var K=L.getProperty("childNodes"),I=0,J;while(J=K[I++]){c.appendChild(J);m.parentNode.insertBefore(J.viewNode,m);}}else{c.appendChild(L);m.parentNode.insertBefore(L.viewNode,m);}m.parentNode.removeChild(m);q();});}else{for(var r in h.handlers){try{var z=h.handlers[r].replace(portal.TEMPLATE_NAME,e);c.addEventListener(r,new Function("event",z),false);}catch(G){var B=bb.document.createEvent("CustomEvent");B.initCustomEventNS(null,"gadgetError",true,false,\'Error while attaching event "\'+r+\'" of gadget: \'+(G.message||G));c.dispatchEvent(B);}}bb.html.removeClass(c.viewNode,c.loadingClass);c._._loaded=true;try{var B=bb.document.createEvent("CustomEvent");B.initEvent("load",false,false);c.dispatchEvent(B);}catch(G){bb.command.trace(c,G.message||G);}c.hideLoading();var v=c.getProperty("portal");var j=v.getProperty("activeContainer");if(j&amp;&amp;!j._._gLoadedEventFired){var s=j.getProperty("gadgets"),A,F=0;j._._gLoadedEventFired=true;while(A=s[F++]){if(!A.getProperty("loaded")){j._._gLoadedEventFired=false;break;}}if(j._._gLoadedEventFired){try{var B=bb.document.createEvent("CustomEvent");B.initEvent("gadgetsLoaded",false,false);v.dispatchEvent(B);}catch(G){bb.command.trace(c,G.message||G);}}}}};q();});};portal.getGadgetClass(this._._src,a);</d:body></d:method><d:method name="buildContent"><d:argument name="oGadgetClass"/><d:body type="text/javascript">var a=this.getAttribute("id"),b=document.createElement("div");b.innerHTML="x&lt;div&gt;"+oGadgetClass.content.replace(portal.TEMPLATE_NAME,a)+"&lt;/div&gt;";b=b.lastChild;while(b.firstChild){this.viewGate.appendChild(b.firstChild);}</d:body></d:method><d:method name="initIncludes"><d:argument name="fCallback"/><d:body type="text/javascript">this.getProperty("gadget").refreshIncludes(fCallback);</d:body></d:method><d:method name="minimize"><d:body type="text/javascript">if(!this.getProperty("maximized")&amp;&amp;this.getSetting("minimizable","boolean")&amp;&amp;!this.getProperty("minimized")){var b=this.getProperty("portal");var a=bb.document.createEvent("CustomEvent");a.initEvent("beforeminimize",false,true);var d=this;a.minimize=function e(){bb.html.addClass(d.viewNode,d.minimizeClass);var g=bb.document.createEvent("CustomEvent");g.initEvent("minimize",false,false);d.dispatchEvent(g);d.synchronize("update");};this.dispatchEvent(a);if(!a.defaultPrevented){var c=b.getSetting("animationSpeed","integer");if(c===0){a.minimize();}else{bb.html.setStyle(this.viewGate,"height",Math.max(this.viewGate.offsetHeight,1)+"px");var f={attributeName:"height",to:"0px",dur:c+"ms",fill:"freeze"};bb.smil.animate(this.viewGate,f,a.minimize);}}}</d:body></d:method><d:method name="getPreference"><d:argument name="sKey" type="string" required="true"/><d:body type="application/javascript">var a=(this.getProperty("class").preferences[sKey]||0);return(sKey in this._._preferences?this._._preferences[sKey]:a["default"])||"";</d:body></d:method><d:method name="setPreference"><d:argument name="sKey" type="string" required="true"/><d:argument name="sValue" type="string" required="true"/><d:body type="application/javascript">var a=this._setPreference(sKey,sValue);if(a==2){this.synchronize("update");}</d:body></d:method><d:method name="_setPreference"><d:argument name="sKey" type="string" required="true"/><d:argument name="sValue" type="string" required="true"/><d:body type="application/javascript">var e=this.getProperty("class");var a=0;if(e){var f=e.preferences[sKey];if(f){var g=f["default"];var d=this._._preferences[sKey];if(!d&amp;&amp;d!==""){d=g;}var c=d!=sValue;if(c){a=f.type=="readonly"?1:2;if(sKey in this._._preferences&amp;&amp;sValue==g){delete this._._preferences[sKey];}else{this._._preferences[sKey]=sValue;}var b=bb.document.createEvent("MutationEvent");b.initMutationEvent("preferenceModified",true,false,null,d,sValue,sKey);this.dispatchEvent(b);}}else{bb.command.trace(this,\'The preference "\'+sKey+\'" is not defined for gadget: \'+this._._src);}}return a;</d:body></d:method><d:method name="setPreferenceFromElement"><d:argument name="oInput" type="object" required="true"/><d:body type="application/javascript">var h=this,f=this.getProperty("class"),b=this.getProperty("gadget"),d=String(oInput.tagName).toLowerCase();if(f.requireSubmit&amp;&amp;d!="form"){return;}var a=0;switch(d){case"input":case"select":case"textarea":a=this._setPreference(oInput.name,portal._gatherValueFromInput(oInput));break;case"form":for(var g in f.preferences){oPreference=f.preferences[g];var e=oInput.elements[g];if(e&amp;&amp;e.nodeType!=1&amp;&amp;e.length){e=e[0];}if(oPreference.type=="hidden"||oPreference.type=="readonly"||!e){continue;}a=Math.max(a,this._setPreference(g,portal._gatherValueFromInput(e)));}break;}if(a&gt;0){var c=bb.document.createEvent("CustomEvent");c.initEvent("change",false,false);this.dispatchEvent(c);if(a==2){this.synchronize("update");}}</d:body></d:method><d:method name="maximize"><d:body type="text/javascript">if(this.getSetting("maximizable","boolean")&amp;&amp;!this.getProperty("maximized")){if(this.getProperty("minimized")){portal.overRideAnimation=true;this.restore();portal.overRideAnimation=false;}var a=bb.document.createEvent("CustomEvent");a.initEvent("beforemaximize",false,true);var e=this;var b=e.getProperty("portal");this._.oldOffsetHeight=this.viewGate.offsetHeight;a.maximize=function d(){b.pauseLayout=false;var g=e.getProperty("container");g.setProperty("maximizedGadget",e);bb.html.addClass(e.viewNode,e.maximizeClass);e.viewNode.style.zIndex="";var f=bb.document.createEvent("CustomEvent");f.initEvent("maximize",false,false);e.dispatchEvent(f);};this.dispatchEvent(a);if(!a.defaultPrevented){b.pauseLayout=true;var c=b.getSetting("animationSpeed","integer");this.viewNode.style.zIndex=999;if(c===0){a.maximize();}else{bb.smil.animate(this.viewNode,{attributeName:"left",to:"0px",dur:c+"ms",fill:"freeze"});bb.smil.animate(this.viewNode,{attributeName:"top",to:"0px",dur:c+"ms",fill:"freeze"});bb.smil.animate(this.viewNode,{attributeName:"width",to:portal._getMaximizedGadgetWidth(b,this)+"px",dur:c+"ms",fill:"freeze"});bb.smil.animate(this.viewGate,{attributeName:"height",to:"400px",dur:c+"ms",fill:"freeze"},a.maximize);}}}</d:body></d:method><d:method name="restore"><d:body type="text/javascript">var i=bb.document.createEvent("CustomEvent");i.initEvent("beforerestore",false,true);var b=this;var j=b.getProperty("portal");var e=j.getSetting("animationSpeed","integer");var h=this.getProperty("minimized");i.restore=function f(){if(h){bb.html.removeClass(b.viewNode,b.minimizeClass);bb.html.setStyle(b.viewGate.parentNode.parentNode.parentNode,"display","");}else{bb.html.removeClass(b.viewNode,b.maximizeClass);}b.viewGate.style.height="";var l=b.getProperty("container");if(l&amp;&amp;l.getProperty("maximizedGadget")==b){l.setProperty("maximizedGadget",null);}j.pauseLayout=false;var k=bb.document.createEvent("CustomEvent");k.initEvent("restore",false,false);b.dispatchEvent(k);b.synchronize("update");};this.dispatchEvent(i);if(!i.defaultPrevented){var j=this.getProperty("portal");if(e===0){i.restore();}else{if(h){i.isMinimized=true;var d=this.viewGate.style.height;bb.html.setStyle(this.viewGate.parentNode.parentNode.parentNode,"display","block");bb.html.setStyle(this.viewGate,"height","auto");var g=this.viewGate.offsetHeight;bb.html.setStyle(this.viewGate,"height",d);var a={attributeName:"height",to:g+"px",dur:e+"ms",fill:"freeze"};bb.smil.animate(this.viewGate,a,i.restore);}else{j.pauseLayout=true;var c=portal._getGadgetDimensions(this.viewNode);bb.smil.animate(this.viewNode,{attributeName:"left",to:c.left+"px",dur:e+"ms",fill:"freeze"});bb.smil.animate(this.viewNode,{attributeName:"top",to:c.top+"px",dur:e+"ms",fill:"freeze"});bb.smil.animate(this.viewNode,{attributeName:"width",to:c.width+"px",dur:e+"ms",fill:"freeze"});bb.smil.animate(this.viewGate,{attributeName:"height",to:this._.oldOffsetHeight+"px",dur:e+"ms",fill:"freeze"},i.restore);}}}</d:body></d:method><d:method name="showPreferences"><d:body type="text/javascript">var c=bb.selector.query(this.viewNode,".p-gadget-preferences");if(this.getSetting("editable")!="false"){var p=bb.document.createEvent("CustomEvent");p.initEvent("beforeShowPreferences",false,true);this.dispatchEvent(p);if(!p.defaultPrevented){bb.html.addClass(this.viewNode,"p-gadget-preferences-open");var o=this.getProperty("class");var k=this.getProperty("gadget");var i=k.identifier;var n=c.getElementsByTagName("form")[0];if(!n){var p=bb.document.createEvent("CustomEvent");p.initCustomEventNS(null,"editcreate",false,true,c);p.preferencePane=c;this.dispatchEvent(p);if(!p.defaultPrevented){var g=[],e;for(var f in o.preferences){e=o.preferences[f];if(e.type=="hidden"||e.type=="readonly"){continue;}var a=e.onchange||"";if(a.length){a="var __GADGET__ = "+i+";"+a;}g.push(\'&lt;tr&gt;&lt;td class="p-gadget-preferences-name"&gt;&lt;label for="\'+i+f+\'"&gt;\'+(e.label||f)+\'&lt;/label&gt;&lt;/td&gt;&lt;td class="p-gadget-preferences-value"&gt;\');switch(e.type){case"checkbox":g.push(\'&lt;input id="\'+i+f+\'" onclick="if (this.oldChecked != this.checked) { this.oldChecked = this.checked;\'+a+"; "+i+\'.setPreferenceFromElement(this); }" type="checkbox" name="\'+f+\'" value="true" /&gt;\');break;case"select-one":case"select-multiple":case"range":g.push(\'&lt;select id="\'+i+f+\'" name="\'+f+\'" onchange="\'+a+";"+i+\'.setPreferenceFromElement(this);"\');if(e.type=="select-multiple"){g.push(\' multiple="multiple"\');}g.push("&gt;");for(var b=0,l;l=e.values[b];b++){g.push(\'&lt;option value="\'+l.value+\'"&gt;\'+(l.label||l.value)+"&lt;/option&gt;");}g.push("&lt;/select&gt;");break;case"textarea":g.push(\'&lt;textarea id="\'+i+f+\'" name="\'+f+\'" onchange="\'+a+";"+i+\'.setPreferenceFromElement(this);"&gt;&lt;/textarea&gt;\');break;case"checkbox-multiple":for(var b=0,l;l=e.values[b];b++){g.push(\'&lt;div&gt;&lt;label for="\'+i+f+l.value+\'"&gt;\',(l.label||l.value),\'&lt;/label&gt; &lt;input id="\'+i+f+l.value+\'" onclick="if (this.oldChecked != this.checked) { this.oldChecked = this.checked;\'+a+";"+i+\'.setPreferenceFromElement(this);}" type="checkbox" name="\'+f+\'" value="\'+l.value+\'" /&gt;&lt;/div&gt;\');}break;case"radio":for(var b=0,l;l=e.values[b];b++){g.push(\'&lt;div&gt;&lt;label for="\'+i+f+l.value+\'"&gt;\',(l.label||l.value),\'&lt;/label&gt; &lt;input id="\'+i+f+l.value+\'" onclick="\'+a+";"+i+\'.setPreferenceFromElement(this);" type="radio" name="\'+f+\'" value="\'+l.value+\'" /&gt;&lt;/div&gt;\');}break;case"password":g.push(\'&lt;input id="\'+i+f+\'" onchange="\'+a+";"+i+\'.setPreferenceFromElement(this);" type="password" name="\'+f+\'" /&gt;\');break;case"text":default:g.push(\'&lt;input id="\'+i+f+\'" onchange="\'+a+";"+i+\'.setPreferenceFromElement(this);" type="text" name="\'+f+\'" /&gt;\');break;}g.push("&lt;/td&gt;&lt;/tr&gt;");}if(o.requireSubmit){g.push(\'&lt;tr&gt;&lt;td colspan="2"&gt; &lt;input class="p-gadget-options-submit" type="submit" onclick="\'+i+\'.hidePreferences()" value="Save" /&gt; &lt;input class="p-gadget-options-cancel" onclick="\'+i+\'.hidePreferences()" type="button" value="Cancel" /&gt;&lt;/td&gt;&lt;/tr&gt;\');}c.innerHTML=\'&lt;form class="\'+i+\'-p-gadget-preferences-form" onsubmit="\'+i+\'.setPreferenceFromElement(this); return false;"&gt;&lt;table style="width:100%"&gt;&lt;tbody&gt;\'+g.join("")+"&lt;/tbody&gt;&lt;/table&gt;&lt;/form&gt;";}n=c.getElementsByTagName("form")[0];if(!n){bb.command.trace(this,"Could not find FORM element inside preference pane, this element is required");}}this.applyPreferencesToForm(n);var q=this.getProperty("portal");var j=q.getSetting("animationSpeed","integer");if(j===0){c.style.display="";}else{c.style.display="";var m=c.offsetHeight;c.style.height="1px";var d={attributeName:"height",to:m+"px",dur:j+"ms",fill:"freeze"};var h=function(){c.style.height="";};bb.smil.animate(c,d,h);}}}</d:body></d:method><d:method name="applyPreferencesToForm"><d:argument name="oForm" type="object" required="true"/><d:body type="text/javascript">var k=this.getProperty("class");var f=this.getProperty("gadget");var j;for(var c in k.preferences){var b=k.preferences[c];var j=String(f.getPreference(c));if(!oForm.elements[c]){continue;}switch(b.type){case"checkbox":oForm.elements[c].checked=(j=="true"||j=="on");break;case"select-one":case"range":var d=oForm.elements[c];d.value=j;break;case"select-multiple":var d=oForm.elements[c];var h=j.split(/\\s*,\\s*/);for(var a=0;a&lt;d.options.length;a++){var g=d.options[a];for(var e=0;e&lt;h.length;e++){if(g.value==h[e]){g.selected=true;break;}}}break;case"checkbox-multiple":var h=j.split(/\\s*,\\s*/);for(var a=0;a&lt;oForm.elements.length;a++){var g=oForm.elements[a];if(g.name==c){var i=false;for(var e=0;e&lt;h.length;e++){if(g.value==h[e]){i=true;break;}}g.checked=i;}}break;case"radio":for(var a=0;a&lt;oForm.elements.length;a++){if(oForm.elements[a].name==c){oForm.elements[a].checked=(oForm.elements[a].value==j);}}break;case"text":case"password":case"hidden":case"readonly":default:oForm.elements[c].value=j;break;}}var l=bb.document.createEvent("CustomEvent");l.initCustomEventNS(null,"preferencesApplied",false,false,oForm);this.dispatchEvent(l);</d:body></d:method><d:method name="hidePreferences"><d:body type="text/javascript">if(!bb.html.hasClass(this.viewNode,"p-gadget-preferences-open")){return;}var g=bb.selector.query(this.viewNode,".p-gadget-preferences");if(document.activeElement&amp;&amp;bb.selector.queryAncestor(document.activeElement,".p-gadget-preferences")==g){document.activeElement.blur();}var a=bb.document.createEvent("CustomEvent");a.initEvent("beforeHidePreferences",false,true);this.dispatchEvent(a);if(!a.defaultPrevented){bb.html.removeClass(this.viewNode,"p-gadget-preferences-open");var c=this.getProperty("portal");var d=c.getSetting("animationSpeed","integer");var e=this;var b=function(){var i=bb.document.createEvent("CustomEvent");i.initEvent("hidePreferences",false,false);e.dispatchEvent(i);};if(d===0){g.style.display="none";b();}else{bb.html.setStyle(g,"height",Math.max(g.offsetHeight,1)+"px");var h={attributeName:"height",to:"1px",dur:d+"ms",fill:"freeze"};var f=function(){g.style.height="";g.style.display="none";b();};bb.smil.animate(g,h,f);}}</d:body></d:method><d:method name="showLoading"><d:body type="text/javascript">this._._showLoadingCount++;this.getProperty("gadget").loading=true;bb.html.addClass(this.viewNode,this.loadingClass);</d:body></d:method><d:method name="hideLoading"><d:body type="text/javascript">if(this._._showLoadingCount&gt;0){this._._showLoadingCount--;}if(this._._showLoadingCount==0){this.getProperty("gadget").loading=false;bb.html.removeClass(this.viewNode,this.loadingClass);var b=this.getProperty("portal");var d=b.getProperty("activeContainer");if(d&amp;&amp;!d._._gReadyEventFired){var e=d.getProperty("gadgets"),f,c=0;d._._gReadyEventFired=true;while(f=e[c++]){if(f._._showLoadingCount&gt;0){d._._gReadyEventFired=false;break;}}if(d._._gReadyEventFired){var a=bb.document.createEvent("CustomEvent");a.initEvent("gadgetsReady",false,false);b.dispatchEvent(a);d._._gReadyEventFired=false;}}return true;}return false;</d:body></d:method><d:method name="setTitle"><d:argument name="sTitle" type="string" required="true"/><d:body type="text/javascript">this.getProperty("gadget").title=sTitle;bb.selector.query(this.viewNode,".p-gadget-title").innerHTML=sTitle;</d:body></d:method><d:method name="setIcon"><d:argument name="sIcon" type="string" required="true"/><d:body type="text/javascript">if(!sIcon){return;}this.getProperty("gadget").icon=sIcon;var a=bb.selector.query(this.viewNode,".p-gadget-icon");if(sIcon.indexOf("url(")==-1){bb.html.setStyle(a,"background-image","url("+sIcon+")");bb.html.setStyle(a,"background-position","0 0");}else{bb.html.setStyle(a,"background",sIcon);}</d:body></d:method><d:method name="unload"><d:body type="application/javascript">if(this.getSetting("closable","boolean")){var c=this.getProperty("container");if(c&amp;&amp;c.getProperty("maximizedGadget")==this){c.setProperty("maximizedGadget",null);}var a=bb.document.createEvent("CustomEvent");a.initEvent("beforeunload",false,true);this.dispatchEvent(a);if(!a.defaultPrevented){var b=this.getProperty("portal");b.removeGadget(this);}}</d:body></d:method><d:method name="refresh"><d:body type="application/javascript">var a=bb.document.createEvent("CustomEvent");a.initEvent("refresh",false,false);this.dispatchEvent(a);</d:body></d:method><d:method name="setAutoRefresh"><d:argument name="minutes"/><d:body type="application/javascript">return portal._autoRefresh.set(this,minutes);</d:body></d:method><d:handler event="beforeload" type="application/javascript">if(!this.getSetting("closable","boolean")){((bb.selector.query(this.viewNode,".p-gadget-button-unload")||0).style||0).display="none";}if(!this.getSetting("editable","boolean")){((bb.selector.query(this.viewNode,".p-gadget-button-showPreferences")||0).style||0).display="none";((bb.selector.query(this.viewNode,".p-gadget-button-hidePreferences")||0).style||0).display="none";}if(!this.getSetting("minimizable","boolean")){((bb.selector.query(this.viewNode,".p-gadget-button-minimize")||0).style||0).display="none";}if(!this.getSetting("maximizable","boolean")||!this.viewNode.parentColumn){((bb.selector.query(this.viewNode,".p-gadget-button-maximize")||0).style||0).display="none";}if(!this.getSetting("refreshable","boolean")){((bb.selector.query(this.viewNode,".p-gadget-button-refresh")||0).style||0).display="none";}if(this.viewNode.colSpan||!this.viewNode.parentColumn||!this.getSetting("draggable","boolean")){((bb.selector.query(this.viewNode,".p-gadget-top-left")||0).style||0).cursor="default";}this.viewNode.denyInsert=this.getSetting("denyInsert")||"none";this.setAutoRefresh(parseInt(this.getSetting("autoRefresh")||0));var d=this.getSetting("className");if(d){var a=d.split(" ");var b=0;bb.html.addClass(this.viewNode,a);while(d=a[b++]){this.minimizeClass.push(d+"-minimized");this.maximizeClass.push(d+"-maximized");this.hoverClass.push(d+"-hover");this.loadingClass.push(d+"-loading");}if(bb.selector.match(this.viewNode,"."+this.minimizeClass[0])){bb.html.addClass(this.viewNode,this.minimizeClass);}if(bb.selector.match(this.viewNode,"."+this.loadingClass[0])){bb.html.addClass(this.viewNode,this.loadingClass);}}</d:handler><d:handler event="dragStart" type="text/javascript">var l=this.getProperty("portal");var k=this.getProperty("container");if(k&amp;&amp;l&amp;&amp;!this.viewNode.colSpanMax&amp;&amp;this.viewNode.parentColumn&amp;&amp;this.getSetting("draggable","boolean")&amp;&amp;!this.getProperty("maximized")&amp;&amp;bb.selector.match(event.viewTarget,".p-gadget-top-left, .p-gadget-top-left *")&amp;&amp;!bb.selector.match(event.viewTarget,".p-gadget-button, .p-gadget-button *")){var h=this.viewNode;var j=bb.selector.query(l.viewNode,".p-portal-dragPlaceholder");j.style.left=h.style.left;j.style.top=h.style.top;var b=h.offsetWidth;var a=h.offsetHeight;if(bb.html.getStyle(j,"box-sizing")=="content-box"){b-=(bb.html.getBoxObject(j,"border").width-bb.html.getBoxObject(j,"content").width);a-=(bb.html.getBoxObject(j,"border").height-bb.html.getBoxObject(j,"content").height);}bb.html.setStyle(j,"width",b+"px");bb.html.setStyle(j,"height",a+"px");j.style.visibility="visible";j.colSpan=h.colSpan;var f=h.parentColumn;var g=bb.array.indexOf(f.items,h);this._orgContainer=k;this._orgColumn=f;this._orgIndex=g;k.removeFromColumn(h);k.appendToColumn(f,j,g);h.style.zIndex=2;var d=bb.html.getBoxObject(h);var i=d.left-event.startX;var c=d.top-event.startY;var e=bb.selector.queryAll(document.body,".portal-droppable");l._addDragOverlay();btl.drag.dragManager.doDrag(l,this,event.startX,event.startY,h,i,c,1,false,e);}</d:handler><d:handler event="DOMNodeInsertedIntoDocument" type="text/javascript">bb.html.disableUserSelect(bb.selector.query(this.viewNode,".p-gadget-top-left"));</d:handler><d:handler event="mouseenter" type="text/javascript" match=".p-gadget-top-left">bb.html.addClass(event.currentView,"p-gadget-top-hover");</d:handler><d:handler event="mouseleave" type="text/javascript" match=".p-gadget-top-left">bb.html.removeClass(event.currentView,"p-gadget-top-hover");</d:handler><d:handler event="mouseenter" type="text/javascript" match=".p-gadget-header &gt; a.p-gadget-button">var a=event.currentView;bb.html.addClass(a,portal._getButtonClass(a,"p-gadget-button","-hover"));</d:handler><d:handler event="mouseenter" type="text/javascript" match=".p-gadget-header &gt; a.p-gadget-button.p-gadget-button-press">var a=event.currentView;bb.html.addClass(a,portal._getButtonClass(a,"p-gadget-button","-press"));</d:handler><d:handler event="mousedown" type="text/javascript" match=".p-gadget-header &gt; a.p-gadget-button">var b=event.currentView;var c=["p-gadget-button-press",portal._getButtonClass(b,"p-gadget-button","-press")];bb.html.addClass(b,c);var a=function(){bb.html.removeClass(b,c);this.removeEventListener("mouseup",a,false);};bb.document.addEventListener("mouseup",a,false);event.preventDefault();</d:handler><d:handler event="mouseleave" type="text/javascript" match=".p-gadget-header &gt; a.p-gadget-button">var a=event.currentView;var b=portal._getButtonClass(a,"p-gadget-button");bb.html.removeClass(a,[b+"-hover",b+"-press"]);</d:handler><d:handler event="click" type="text/javascript" match=".p-gadget-header &gt; a.p-gadget-button">var b=event.currentView;if(bb.selector.match(this.viewNode,"."+this.loadingClass[0])){return;}var a=bb.document.createEvent("CustomEvent");a.initCustomEventNS(null,"buttonClick",false,false,portal._getButtonType(b,"p-gadget-button"));this.dispatchEvent(a);event.preventDefault();</d:handler><d:handler event="buttonClick" type="text/javascript">switch(event.detail){case"refresh":this.refresh();break;case"maximize":this.maximize();break;case"minimize":this.minimize();break;case"restore":this.restore();break;case"showPreferences":this.showPreferences();break;case"hidePreferences":this.hidePreferences();break;case"unload":this.unload();break;default:}</d:handler><d:handler event="mouseenter" type="text/javascript">bb.html.addClass(this.viewNode,this.hoverClass);</d:handler><d:handler event="destruct" type="text/javascript">var a=bb.document.createEvent("CustomEvent");a.initEvent("unload",false,false);this.dispatchEvent(a);this._._portal=null;this.viewNode.occurrence=null;var b=this._._gadget;if(b){window[b.identifier]=null;b.body=null;b._window=null;}this._._gadget=null;if(this.viewNode.parentNode){this.viewNode.parentNode.removeChild(this.viewNode);}</d:handler><d:handler event="mouseleave" type="text/javascript">bb.html.removeClass(this.viewNode,this.hoverClass);</d:handler></d:element></d:namespace><d:namespace name="http://www.backbase.com/2008/portal" xml:base="bindings/www.backbase.com.2008.portal/portalObserver/portalObserver.xml"><d:element name="portalObserver" abstract="true"><d:attribute name="portal"/><d:property name="portal"><d:getter type="text/javascript">var a=this._._portal;if(!a||!a._){a=this._._portal=null;}return a;</d:getter><d:setter type="text/javascript">var c=this.getProperty("portal");if(c===value){return;}if(c){var a=bb.document.createEvent("Events");a.initEvent("disconnected",false,false);a.relatedTarget=c;this.dispatchEvent(a);this._._portal=null;}if(Boolean(value&amp;&amp;value.instanceOf("http://www.backbase.com/2008/portal","portal"))){this._._portal=value;var a=bb.document.createEvent("Events");a.initEvent("connected",false,false);a.relatedTarget=value;this.dispatchEvent(a);}else{if(value!=null){var b="An invalid value for the "+name+" property was set: "+value+".";b+=" Make sure a valid http://www.backbase.com/2008/portal#portal is set.";bb.command.trace(this,b);}}</d:setter></d:property><d:handler event="DOMNodeInsertedIntoDocument" type="text/javascript">if(!this.hasAttribute("portal")){bb.command.trace(this,"The portal attribute is not specified on an element which is a portalObserver, this attribute is mandatory");}if(!this.getProperty("portal")&amp;&amp;this.hasAttribute("portal")){var b=this;var d=function(){var f=b.getAttribute("portal");var e=null;if(f){e=bb.evaluateSmart(f,b,b);}return e;};var a=d();if(a){this.setProperty("portal",a);}else{var c=function(e){b.setProperty("portal",d());bb.document.removeEventListener("load",arguments.callee,false);};bb.document.addEventListener("load",c,false);}}</d:handler><d:handler event="destruct" type="text/javascript">this.setProperty("portal",null);</d:handler></d:element></d:namespace><d:namespace xmlns:ssr="http://www.backbase.com/2009/ssr" name="http://www.backbase.com/2009/ssr" xml:base="bindings/www.backbase.com.2009.ssr/ssr.xml"><d:resource type="text/javascript">portal.ssr={};portal.ssr.namespaceURI="http://www.backbase.com/2009/ssr";portal.ssr.Error=function(a){this.toString=function(){return"[SSR Error: "+a+"]";};};portal.ssr.ElementNotFoundError=function(a){portal.ssr.Error.call(this,"The template with id \'"+a+"\' was not found in the document!");};portal.ssr.tryToGetElementById=function(a){var b=document.getElementById(a);if(!b){throw new portal.ssr.ElementNotFoundError(a);}return b;};portal.ssr.readGadgetClasses=function(b){var c=b.firstChild,a="";while(c){if(c.nodeType==1){a=c.getAttribute("src");if(a){portal.setGadgetClass(a,bb.xml.parse(c.textContent?c.textContent:c.innerHTML,true));}}c=c.nextSibling;}};</d:resource><d:behavior name="pickupView"><d:attribute name="viewNode"/><d:attribute name="viewGate"/><d:method name="__beforeTemplate"><d:body type="application/javascript">var a=this.getAttribute("viewNode");if(a){var c=document.documentElement;var b=a!="body"?bb.selector.query(c,a):document.body;if(b){this.viewNode=b;var d=this.getAttribute("viewGate");if(d){this.viewGate=bb.selector.query(b,d);}if(!this.viewGate){this.viewGate=b;}}else{bb.command.trace(this,\'http://www.backbase.com/2009/ssr#pickupView behavior could not find element: "\'+a+\'"\');}return true;}return false;</d:body></d:method></d:behavior><d:behavior name="portal"><d:attribute name="pickGadgetsContentOnly" default="false"/><d:method name="__beforeTemplate"><d:body type="text/javascript">var a=portal.ssr.tryToGetElementById(this.getAttribute("id"));a.removeAttribute("style");this.viewNode=this.viewGate=a;return true;</d:body></d:method><d:method name="createGadgetWindowFromConfig"><d:argument name="sId" type="string"/><d:argument name="oConfig" type="object"/><d:body type="text/javascript">var c=this._._session,a=null,b=this.getAttribute("pickGadgetsContentOnly")==="true";if(oConfig.preRendered){portal._currentPortal=this;a=bb.construct(bb.xml.parse(\'&lt;g:gadgetWindow xmlns:g="http://www.backbase.com/2008/portal" xmlns:ssr="http://www.backbase.com/2009/ssr" xmlns:e="http://www.backbase.com/2006/xel" id="\'+sId+\'" e:behavior="\'+(b?"ssr:gadgetWindowContent":"ssr:gadgetWindow")+\'" /&gt;\'));delete portal._currentPortal;a._._src=oConfig.src;a._._preferences=new portal._object(oConfig.preferences||{});a._._settings=oConfig.settings&amp;&amp;c.settings[oConfig.settings]||{};a._._templateId=oConfig.tid||"";a._._showLoadingCount=1;a._._id=sId;delete oConfig.preRendered;}else{bb.removeBehavior(this,portal.ssr.namespaceURI,"portal");a=this.createGadgetWindowFromConfig(sId,oConfig);bb.addBehavior(this,portal.ssr.namespaceURI,"portal");}return a;</d:body></d:method><d:method name="__attach"><d:argument name="sFnName" type="string"/><d:argument name="oNode" type="object" required="true"/><d:argument name="oRefNode" type="object"/><d:body type="text/javascript">if(!bb.instanceOf(oNode,portal.ssr.namespaceURI,"gadgetWindow")){bb.removeBehavior(this,portal.ssr.namespaceURI,"portal");this.__attach(sFnName,oNode,oRefNode);bb.addBehavior(this,portal.ssr.namespaceURI,"portal");}</d:body></d:method></d:behavior><d:behavior name="gadgetWindow"><d:method name="__beforeTemplate"><d:body type="text/javascript">var a=portal.ssr.tryToGetElementById(this.getAttribute("id"));a.removeAttribute("style");a.removeAttribute("id");this.viewNode=a;this.viewGate=bb.selector.query(a,".p-gadget-content");return true;</d:body></d:method><d:method name="buildContent"><d:argument name="oGadgetClass"/><d:body type="text/javascript"/></d:method><d:method name="initIncludes"><d:argument name="fCallback"/><d:body type="text/javascript">bb.removeBehavior(this,portal.ssr.namespaceURI,"gadgetWindow");fCallback();</d:body></d:method></d:behavior><d:behavior name="gadgetWindowContent"><d:method name="buildContent"><d:argument name="oGadgetClass"/><d:body type="text/javascript">var a=portal.ssr.tryToGetElementById("SSR-body-"+this.getAttribute("id"));while(a.firstChild){this.viewGate.appendChild(a.firstChild);}</d:body></d:method><d:method name="initIncludes"><d:argument name="fCallback"/><d:body type="text/javascript">bb.removeBehavior(this,portal.ssr.namespaceURI,"gadgetWindowContent");fCallback();</d:body></d:method></d:behavior></d:namespace><d:namespace xmlns:p="http://www.backbase.com/2008/portal" name="http://www.backbase.com/2009/portal/navigation" xml:base="bindings/www.backbase.com.2009.portal.navigation/rules/rules.xml"><d:element name="rules" extends="p:portalObserver"><d:resource type="text/javascript" xml:base="rules.js">portal.navigation={};(function(){var k="http://www.backbase.com/2009/portal/navigation";function h(q,p,r){this.collection=q;if(r&amp;&amp;p){this.test=function(s){return(portal.xml.getLocalName(s)==r&amp;&amp;s.namespaceURI==p);};}else{if(p){this.test=function(s){return(s.namespaceURI==p);};}}}h.prototype.each=function(q){var p=this.collection,s=null;for(var r=0;r&lt;p.length;++r){s=p[r];s.nodeType==1&amp;&amp;this.test(s)&amp;&amp;q(s);}};h.prototype.test=function(p){return true;};function f(){}f.prototype.execute=function(p,q){};f.prototype.executeWhenReady=function(p,q){};function n(p){this._container=p;f.call(this);}n.prototype=new f();n.prototype.getContainer=function(q,t){var u=q.getProperty("containers"),s=null,p=0,r=t.apply(this._container);while(s=u[p++]){if(s.getProperty("templateId")==r){return s;}}s=q.createContainer(null,null,null,r);q.addContainer(s,null,false);return s;};n.prototype.executeWhenReady=function(q,r){var p=this.getContainer(q,r),s=this;if(p.getProperty("loaded")){s.execute(p,q,r);}else{p.addEventListener("load",function(){s.execute(p,q,r);this.removeEventListener("load",arguments.callee,false);},false);}};function b(p){n.call(this,p);}b.prototype=new n();b.prototype.execute=function(r,p,q){r&amp;&amp;p.activateContainer(r);};function d(p){n.call(this,p);}d.prototype=new n();d.prototype.execute=function(r,p,q){var s=r?r.getProperty("maximizedGadget"):null;s&amp;&amp;s.restore();};function o(p,q,r){this._name=q;this._value=r;n.call(this,p);}o.prototype=new n();o.prototype.execute=function(r,p,q){r&amp;&amp;r.setPreference(q.apply(this._name),q.apply(this._value));};function i(q,s,r,p){this._type=s;this._cancelable=p||false;this._bubbles=r||false;n.call(this,q);}i.prototype=new n();i.prototype.createEvent=function(){var p=bb.document.createEvent("CustomEvent");p.initEvent(this._type,this._cancelable,this._bubbles);return p;};i.prototype.execute=function(r,p,q){r&amp;&amp;r.dispatchEvent(this.createEvent());};function g(q,p){this._gadget=p;n.call(this,q);}g.prototype=new n();g.prototype.getGadget=function(r,t){var q=t.apply(this._gadget),s=this.getContainer(r,t),v=s.getGadgetsByTemplateId(q),p=null,u=0;while(p=v[u++]){p.load();return p;}p=r.createGadget(null,null,null,q);r.addGadget(p,s,{col:s.getSmallestColumn()});return p;};g.prototype.executeWhenContainerIsReady=function(q,r){var p=this.getGadget(q,r),s=this;if(p.getProperty("loaded")){s.execute(p,q,r);}else{p.addEventListener("load",function(){s.execute(p,q,r);this.removeEventListener("load",arguments.callee,false);},false);}};g.prototype.executeWhenReady=function(q,r){var p=this.getContainer(q,r),s=this;if(p.getProperty("loaded")){s.executeWhenContainerIsReady(q,r);}else{p.addEventListener("load",function(){s.executeWhenContainerIsReady(q,r);this.removeEventListener("load",arguments.callee,false);},false);}};function m(r,p,q){this._aPrefs=q;g.call(this,r,p);}m.prototype=new g();m.prototype.execute=function(q,s,u){var p=0;for(var t=0;t&lt;this._aPrefs.length;t++){p=q._setPreference(u.apply(this._aPrefs[t].name),u.apply(this._aPrefs[t].value))|p;}if(p){var r=bb.document.createEvent("CustomEvent");r.initEvent("change",false,false);q.dispatchEvent(r);if(p&gt;=2){q.synchronize("update");}}};function l(q,p){g.call(this,q,p);}l.prototype=new g();l.prototype.execute=function(p,q,r){p&amp;&amp;p.maximize();};function e(r,p,t,s,q){this._type=t;this._cancelable=q||false;this._bubbles=s||false;g.call(this,r,p);}e.prototype=new g();e.prototype.createEvent=i.prototype.createEvent;e.prototype.execute=function(p,q,r){p&amp;&amp;p.dispatchEvent(this.createEvent());};function a(p){this._matchExpr=new RegExp(p);this._actions=[];}a.prototype.match=function(q){var p=String(q).match(this._matchExpr);this._matches=p||[];this._matches.apply=function(s){var r=this;return s.replace(/\\$(\\d)+/g,function(t,u){return r[u]||"";});};return Boolean(p);};a.prototype.addAction=function(p){if(!(p instanceof f)){bb.command.trace(this,"Attempt to add non portal.navigation.Action instance to the rule actions sequence!");}this._actions.push(p);};a.prototype.removeAction=function(p){if(!(p instanceof f)){bb.command.trace(this,"Attempt to remove non portal.navigation.Action instance from the rule actions sequence!");}bb.array.removeObject(this._actions,p);};a.prototype.apply=function(q){var p=this._actions;for(var r=0;r&lt;p.length;++r){p[r].executeWhenReady(q,this._matches);}};function j(){}j.prototype.buildGadgetActions=function(s,t){var p=t.getAttribute("tid"),r=[],q=[];t.getAttribute("maximized")=="maximized"&amp;&amp;r.push(new l(s,p));(new h(t.childNodes,k,"preference")).each(function(u){q.push({name:u.getAttribute("name"),value:u.getAttribute("value")});});if(q.length){r.push(new m(s,p,q));}return r;};j.prototype.buildContainerActions=function(u){var t=u.getAttribute("tid"),p=this,s=[],r=false,q=false;u.getAttribute("selected")=="selected"&amp;&amp;s.push(new b(t));(new h(u.childNodes,k)).each(function(v){if(portal.xml.getLocalName(v)=="gadget"){s.push.apply(s,p.buildGadgetActions(t,v));r=r||(v.getAttribute("maximized")=="maximized");}else{if(portal.xml.getLocalName(v)=="preference"){s.push(new o(t,v.getAttribute("name"),v.getAttribute("value")));q=true;}}});q&amp;&amp;s.push(new i(t,"change",false,false));!r&amp;&amp;s.push(new d(t));return s;};j.prototype.buildActions=function(r){var q=[],p=this;(new h(r,k,"container")).each(function(s){q.push.apply(q,p.buildContainerActions(s));});return q;};function c(){}c.prototype.buildRule=function(q){var p=new portal.navigation.Rule(q.getAttribute("match")),r=(new j()).buildActions(q.childNodes);for(var s=0;s&lt;r.length;++s){p.addAction(r[s]);}return p;};c.prototype.buildRules=function(q){var s=new h(q,k,"rule"),r=[],p=this;s.each(function(t){r.push(p.buildRule(t));});return r;};this.Rule=a;this.RuleBuilder=c;this.namespaceURI=k;}).call(portal.navigation);</d:resource><d:method name="__children"><d:body type="text/javascript"/></d:method><d:constructor type="text/javascript">var b=this.getProperty("navigationBaseURI");this._._rules=(new portal.navigation.RuleBuilder()).buildRules(this.modelNode.childNodes).concat(new portal.navigation.Rule(b));var a=this;bb.document.addEventListener("history",function(c){a.execBookmark(c.bookmark);},false);bb.html.addEventListener(document,"click",function(e){if(!bb.browser.ie&amp;&amp;e.button!=0){return;}var c=e.target||e.srcElement;var d=bb.selector.queryAncestor(c,"a");if(d){var f=String(d.href);if(f.indexOf(b)==0){f=f.substr(b.length);try{bb.history.add(f);}catch(g){bb.command.trace(null,String(g.message||g));}if(e.preventDefault){e.preventDefault();}e.returnValue=false;return false;}}},false);this.execBookmark(bb.history.current);</d:constructor><d:property name="navigationBaseURI"><d:getter type="text/javascript">var a=this.getAttribute("targetURI")||".";return bb.uri.resolveUri(a,document.location.href);</d:getter></d:property><d:method name="execBookmark"><d:argument name="sBookmark" type="string" required="true"/><d:argument name="oPortal" type="object"/><d:body type="application/javascript">oPortal=oPortal||this.getProperty("portal");var a=null;if(oPortal){a=this.match(sBookmark);a&amp;&amp;a.apply(oPortal);}else{this._currentBookmark=sBookmark;}</d:body></d:method><d:method name="match"><d:argument name="location"/><d:body type="text/javascript">var c=this._._rules,a=null;for(var b=0;b&lt;c.length;++b){a=c[b];if(a.match(location)){return a;}}return null;</d:body></d:method></d:element></d:namespace></d:tdl>');
var absa = window.absa || {};
absa.version = "@VERSION@";
absa.touch = absa.touch || {};
absa.gadgets = absa.gadgets || {};
absa.apps = absa.apps || {};
absa.initializeNewContent = function(b) {
    phe.initializePHE(b);
    absa.form.attachHandlers(b)
};
absa.lazyLoadNode = function(g, b, f, c) {
    var d = g.getAttribute("proxyurl");
    if (!d) {
        return
    }
    if (!g._isLoaded || b) {
        var e = bb.selector.query(g, ".ap-loading-message");
        if (e) {
            e.parentNode.removeChild(e)
        } else {
            e = document.createElement("div");
            e.className = "ap-loading-message"
        }
        g.innerHTML = "";
        g.appendChild(e);
        e.style.display = "";
        phe.loadingMessage.showLoadingMessage(e);
        if (typeof f === "function") {
            g._fnCallBack = f
        }
        var f = f || null;
        absa.io.makeRequest(d, function(j) {
            if (e) {
                e.style.display = "none";
                phe.loadingMessage.hideLoadingMessage(e)
            }
            g.innerHTML = "";
            if (!j.errors.length) {
                var i = bb.html.createElementFromString(j.text);
                if (i != null) {
                    g.appendChild(i)
                }
                g._isLoaded = true;
                absa.initializeNewContent(g);
                if (g._fnCallBack) {
                    g._fnCallBack.call(this, g)
                }
                var h = absa.util.attributeToFunction(g, "onlazyloadnode");
                if (h) {
                    h.call(g)
                }
                g._hasIOError = false;
                if (!c) {
                    var l = bb.selector.query(g, ".ui-form-field");
                    if (l) {
                        if (absa.VI == "true") {
                            var k = bb.selector.queryAncestor(l, ".ui-tabBody");
                            absa.vi.addActiveContentDiv(k)
                        }
                    }
                }
            } else {
                absa.showIOErrorMessage(g);
                g._hasIOError = true
            }
        })
    }
};
absa.showIOErrorMessage = function(l) {
    l.innerHTML = "";
    var i = phe.message.createElement("error");
    l.appendChild(i);
    phe.message.setMessage(i, absa.locale["Common/General/Error/IOErrorMessage"]);
    var e = 0;
    var j = bb.selector.queryAncestor(l, ".ui-form");
    var b = bb.selector.query(j, ".ui-formFoot");
    if (b != null) {
        var d = bb.selector.query(b, ".ap-button-reset");
        var g = bb.selector.query(b, ".ap-button-back");
        var m = bb.selector.query(b, ".ap-button-cancel");
        var h = bb.selector.query(b, ".ap-button-next");
        if (d != null) {
            phe.common.hide(d);
            e++
        }
        if (g != null) {
            phe.common.hide(g);
            e++
        }
        if (h != null) {
            phe.common.hide(h);
            e++
        }
        if (e > 0) {
            var f = absa.createButton("ap-button-cancel", "absa.wizard.finishButton(this)", absa.locale["Common/General/Label/Close"], absa.locale["Common/General/Label/Close"]);
            var k = bb.selector.queryAncestor(l, ".ui-buttonFooter");
            var c = bb.selector.query(k, ".ui-exception-container");
            c.appendChild(f)
        }
    }
};
absa.createButton = function(e, c, d, g) {
    var b = [];
    b[b.length] = "<button ";
    if (c && c != "") {
        b[b.length] = 'onclick="' + c + '" '
    }
    b[b.length] = 'aria-label="." type="button" tooltip="' + d + '" ';
    b[b.length] = 'class="ui-button ' + e + '">';
    b[b.length] = '<div class="ui-button-left">';
    b[b.length] = '<div class="ui-button-right">';
    b[b.length] = '<div class="ui-button-center">';
    b[b.length] = "" + g + "";
    b[b.length] = "</div>";
    b[b.length] = "</div>";
    b[b.length] = "</div>";
    b[b.length] = "</button>";
    var f = bb.html.createElementFromString(b.join(""));
    return f
};
absa.openReport = function(b, c, d) {
    b += (b.indexOf("?") == -1 ? "?" : "&") + "uniq=" + new Date().getTime();
    b += "&nonce=" + absa.NONCE;
    b += "#toolbar=1";
    window.open(b, c || "", d || "top=0,left=0,width=850,height=600,resizable")
};
absa.createButtonHTMLString = function(f, d, b, c) {
    var d = d.length > 0 ? 'tooltip="' + d + '"' : "";
    var c = c && c.length > 0 ? 'onclick="' + c + '"' : "";
    var e = "";
    if (f.indexOf("ui-modal-genericButton") > -1) {
        e = '<button xmlns="http://www.w3.org/1999/xhtml" tabindex="0" type="button" class="' + f + '" ' + d + " " + c + '><div class="ui-button-left"><div class="ui-button-right"><div class="ui-button-center"><span class="vi-screenreader-line ">. ' + b + "</span></div></div></div></button>"
    } else {
        e = '<button xmlns="http://www.w3.org/1999/xhtml" tabindex="0" type="button" class="ui-button ' + f + '" ' + d + " " + c + '><div class="ui-button-left"><div class="ui-button-right"><div class="ui-button-center"><span class="vi-screenreader-line ">. ' + b + "</span></div></div></div></button>"
    }
    return e
};
absa.showPleaseWait = function(d) {
    var c = document.getElementById("pleasewait"),
        b = document.getElementById("pleasewait-viewport"),
        e = document.getElementById("pleasewait-label");
    c.style.display = "";
    e.innerHTML = arguments.length ? d : "";
    absa.showPleaseWait.timeout = setTimeout(function() {
        c.style.height = document.body.clientHeight + "px";
        c.style.width = document.body.clientWidth + "px";
        b.style.height = ("innerHeight" in window ? window.innerHeight : document.documentElement.clientHeight) + "px";
        b.style.width = ("innerWidth" in window ? window.innerWidth : document.documentElement.clientWidth) + "px";
        b.style.top = document.documentElement.scrollTop + "px";
        b.style.left = document.documentElement.scrollLeft + "px";
        absa.showPleaseWait.timeout = setTimeout(arguments.callee, 20)
    }, 0)
};
absa.hidePleaseWait = function() {
    var b = document.getElementById("pleasewait");
    b.style.display = "none";
    if (absa.showPleaseWait.timeout) {
        absa.showPleaseWait.timeout = clearTimeout(absa.showPleaseWait.timeout)
    }
};
absa.util = absa.util || {};
absa.util.copyAttributes = function(b, d) {
    for (var c = 0; c < b.attributes.length; c++) {
        if (b.attributes[c] && b.attributes[c].nodeValue && b.attributes[c].specified) {
            if (bb.browser.ie && bb.browser.version <= 6 && b.attributes[c].nodeName == "class") {
                d.className = b.attributes[c].nodeValue
            } else {
                d.setAttribute(b.attributes[c].nodeName, b.attributes[c].nodeValue)
            }
        }
    }
};
absa.util.attributeToFunction = function(g, i, d) {
    var b = g.getAttribute(i);
    var h = null;
    if (b) {
        var c = (d || []).concat(b);
        try {
            h = Function.apply(window, c)
        } catch (f) {
            bb.command.trace(null, "Error in " + i + " attribute: " + f.message || f)
        }
    }
    return h
};
absa.util.escapeJavaScriptHandler = function(b) {
    return b.replace(/'/g, "\\'").replace(/"/g, "&#34")
};
absa.util.formatCurrency = function(f) {
    f = f.toString().replace(/\$|\,/g, "");
    var e = parseFloat(f);
    var c = (e == (e = Math.abs(e)));
    e = Math.floor(e * 100 + 0.50000000001);
    var g = e % 100;
    var b = g.toString();
    e = Math.floor(e / 100).toString();
    if (g < 10) {
        b = "0" + b
    }
    for (var d = 0; d < Math.floor((e.length - (1 + d)) / 3); d++) {
        e = e.substring(0, e.length - (4 * d + 3)) + "," + e.substring(e.length - (4 * d + 3))
    }
    return (((c) ? "" : "-") + "R " + e + "." + b)
};
absa.util.validateKeyPressEnter = function(d, b) {
    if (d) {
        var c;
        if (d.keyIdentifier) {
            c = d.keyIdentifier.toLowerCase()
        } else {
            if (window.event) {
                c = d.keyCode
            } else {
                if (d.which) {
                    c = d.which
                }
            }
        }
        if (c == "13" || c == "32" || c == "enter" || c == "u+0020") {
            b();
            bb.html.handlePreventDefault(d)
        }
    }
};
absa.util.validateKeyPressEnterNotSpace = function(d, b) {
    if (d) {
        var c;
        if (d.keyIdentifier) {
            c = d.keyIdentifier.toLowerCase()
        } else {
            if (window.event) {
                c = d.keyCode
            } else {
                if (d.which) {
                    c = d.which
                }
            }
        }
        if (c == "13" || c == "enter") {
            b();
            bb.html.handlePreventDefault(d)
        }
    }
};
absa.util.validateKeyPressTab = function(d, b) {
    if (d) {
        var c;
        if (d.keyIdentifier) {
            c = d.keyIdentifier.toLowerCase()
        } else {
            if (window.event) {
                c = d.keyCode
            } else {
                if (d.which) {
                    c = d.which
                }
            }
        }
        if (d.shiftKey == false) {
            if (d.keyCode == "9" || c == "9" || c == "tab" || c == "u+0009") {
                b();
                bb.html.handlePreventDefault(d)
            }
        }
    }
};
absa.util.validateKeyPressShiftTab = function(d, b) {
    if (d) {
        var c;
        if (d.keyIdentifier) {
            c = d.keyIdentifier.toLowerCase()
        } else {
            if (window.event) {
                c = d.keyCode
            } else {
                if (d.which) {
                    c = d.which
                }
            }
        }
        if (d.shiftKey == true) {
            if (d.keyCode == "9" || c == "9" || c == "tab" || c == "u+0009") {
                b();
                bb.html.handlePreventDefault(d)
            }
        }
    }
};
absa.util.stripTag = function(c) {
    var b = c.indexOf(">");
    if (b != -1) {
        c = c.substring(b + 1, c.length);
        var b = c.lastIndexOf("<");
        c = c.substring(0, b)
    }
    return c
};
absa.util.seperate = function(d) {
    var c = d.length;
    var e = "";
    for (var b = 0; b < c; b++) {
        e = e + d[b] + " "
    }
    return e
};
absa.modal = absa.modal || {};
absa.modal.loadModal = function(f, m, e, l, j, h) {
    var m = m || "";
    var h = h || "";
    var i = absa.locale["Common/General/Label/Processing"];
    if (j == "en") {
        var d = absa.locale["Common/General/Label/Print~en"];
        var b = absa.locale["Common/General/Label/Close~en"]
    } else {
        var d = absa.locale["Common/General/Label/Print"];
        var b = absa.locale["Common/General/Label/Close"]
    }
    var g = [];
    if (h != "" && isNaN(h) == false) {
        g[g.length] = '<div class="ui-modal" style="width:' + h + 'px;">'
    } else {
        g[g.length] = '<div class="ui-modal ui-modal-standard">'
    }
    g[g.length] = '<div class="ui-modalHeader">';
    g[g.length] = '<div class="ui-modalHeader-title" tabindex="0">' + m + "</div>";
    g[g.length] = '<div class="ui-modalHeader-icons">';
    g[g.length] = '<button tooltip="' + d + '" type="button" class="ui-modal-printButton" onclick="absa.print.printPopupGeneric(this)" anchorpoint="mouse" offsetx="0" offsety="10">';
    g[g.length] = '<div class="ui-button-left">';
    g[g.length] = '<div class="ui-button-right">';
    g[g.length] = '<div class="ui-button-center">';
    g[g.length] = '<span class="vi-screenreader-line">' + d + "</span>";
    g[g.length] = "</div>";
    g[g.length] = "</div>";
    g[g.length] = "</div>";
    g[g.length] = "</button>";
    g[g.length] = '<button tooltip="' + b + '" type="button" class="ui-modal-closeButton" onclick="phe.modal.onCloseModalButtonClick(this)" anchorpoint="mouse" offsetx="0" offsety="10">';
    g[g.length] = '<div class="ui-button-left">';
    g[g.length] = '<div class="ui-button-right">';
    g[g.length] = '<div class="ui-button-center">';
    g[g.length] = '<span class="vi-screenreader-line">' + b + "</span>";
    g[g.length] = "</div>";
    g[g.length] = "</div>";
    g[g.length] = "</div>";
    g[g.length] = "</button>";
    g[g.length] = "</div>";
    g[g.length] = "</div>";
    g[g.length] = '<div class="ui-modalBody"></div>';
    g[g.length] = "</div>";
    var k = bb.html.createElementFromString(g.join(""));
    k._onClose = l;
    var c = bb.selector.query(k, ".ui-modalBody");
    c.setAttribute("proxyurl", f);
    phe.modal.showModal("0.2", k, document.body, false);
    absa.lazyLoadNode(c, true, function() {
        if (typeof e === "function") {
            e.call(this, k)
        }
        phe.modal.updatePosition()
    });
    return k
};
absa.modal.addModalHeaderButton = function(f, d, l, i) {
    var c = ".ui-modalHeader";
    var j = bb.selector.query(f, c);
    if (j) {
        var k = "ui-modalHeader-icons";
        var b = bb.selector.query(j, "." + k);
        if (!b) {
            b = document.createElement("div");
            b.className = k;
            j.appendChild(b)
        }
        var h = absa.locale[i] || i || "";
        var e = absa.createButtonHTMLString("ui-modal-genericButton " + d, h, h);
        var g = bb.html.createElementFromString(e);
        if (b.firstChild) {
            b.insertBefore(g, b.firstChild)
        } else {
            b.appendChild(g)
        }
        if (l) {
            bb.html.addEventListener(g, "click", function() {
                l.call(this, this)
            })
        }
    }
};

function triggerModal4Body(b) {
    phe.modal.showModal(0.5, bb.selector.query(document.body, b), null, true)
}
absa.history = absa.history || {};
absa.history.add = function(c) {
    function b() {
        c = c.toLowerCase();
        bb.history.add(c)
    }
    if (absa.unconfirmedChanges) {
        return absa.unconfirmedChanges.cancelNavigation(document.body, b)
    } else {
        return b()
    }
};
absa.form = absa.form || {};
absa.form.attachHandlers = function(k, i) {
    if (!i) {
        i = absa.form.handlers
    }
    var g = bb.selector.queryAll(k, ".ui-form");
    if (g.length) {
        for (var h = 0; h < g.length; h++) {
            bb.html.addEventListener(g[h], "submit", function(c) {
                if (c.stopPropagation) {
                    c.stopPropagation()
                }
                if (c.preventDefault) {
                    c.preventDefault()
                }
                if (bb.browser.ie) {
                    c.returnValue = false
                }
                if (this.getAttribute("formtype") != "nosubmit") {
                    absa.form.validateAndSubmit(this)
                }
                return false
            });
            bb.html.addEventListener(g[h], "reset", function(c) {
                var m = c.target || c.srcElement;
                absa.form.cleanValidate(m);
                if (m && m._trackUnconfirmedChanges) {
                    m._changed = false
                }
            });
            absa.form.attachFormFieldHandlers(g[h], i)
        }
    } else {
        var l = bb.selector.queryAncestor(k, ".ui-form");
        if (l) {
            var e = bb.selector.queryAll(k, "input, select, button, textarea");
            if (e) {
                absa.form.attachFormFieldHandlers(l, i, e)
            }
        }
    }
    var d = bb.selector.query(k, ".ui-form-field[bbf_autofocus=true]");
    if (d && d.offsetHeight > 0) {
        d.focus();
        d.focus()
    }
    var f = bb.selector.query(k, ".ap-SVM-form");
    if (f) {
        var b = phe.form.getAttribute(f, "data-timeRemaining") * 1;
        if (b == absa.SVM.initialTimeRemaining) {
            gadgets.pubsub.publish("SVM-form-loaded", f)
        }
    }
    var j = bb.selector.query(k, ".ap-simSwopHold-form");
    if (j) {
        gadgets.pubsub.publish("simSwopHold-form-loaded", j)
    }
};
absa.form.disableEnableFormButtons = function(f, b) {
    var e = b == "disable" ? true : false;
    for (var g = 0; g < f.elements.length; g++) {
        var d = f.elements[g];
        if (d.tagName.toLowerCase() == "button" || d.getAttribute("type") == "submit" || d.getAttribute("type") == "reset" || d.getAttribute("type") == "button") {
            if (e) {
                phe.button.disableButton(d)
            } else {
                phe.button.enableButton(d)
            }
        }
    }
};
absa.form.validateAndSubmit = function(d) {
    if (bb.browser.ie) {
        phe.helpText.hideHelptext()
    }
    absa.form.disableEnableFormButtons(d, "disable");
    var b = absa.form.validate(d);
    if (b) {
        var e = absa.util.attributeToFunction(d, "oncallback", ["response"]);
        var c = absa.util.attributeToFunction(d, "onbeforesubmit");
        absa.form.submit(d, e, c)
    } else {
        absa.form.disableEnableFormButtons(d, "enable")
    }
};
absa.form.attachFormFieldHandlers = function(p, q, s) {
    var h = p.getAttribute("formtype");
    if (p.getAttribute("trackUnconfirmedChanges") === "true") {
        p._trackUnconfirmedChanges = true
    } else {
        p._trackUnconfirmedChanges = false
    }
    var r = (h != null) ? ((absa[h] != null) ? absa[h]["handlers"] : null) : null;
    var g = (r != null) ? ((r.blur != null) ? r.blur : q.blur) : q.blur;
    var i = (r != null) ? ((r.change != null) ? r.change : q.change) : q.change;
    var l = (r != null) ? ((r.focus != null) ? r.focus : q.focus) : q.focus;
    var d = (r != null) ? ((r.mouseover != null) ? r.mouseover : q.mouseover) : q.mouseover;
    var f = (r != null) ? ((r.mouseout != null) ? r.mouseout : q.mouseout) : q.mouseout;
    var k = s || p.elements || [];
    var o = bb.selector.queryAll(p, ".ap-icon-info");
    if (o[0]) {
        for (var n = 0; n < o.length; n++) {
            bb.html.addEventListener(o[n], "mouseover", function(b) {
                if (bb.browser.ie) {
                    b.currentView = b.srcElement
                } else {
                    b.currentView = b.currentTarget
                }
                absa.showMeHow.showHelpText(b.currentView)
            });
            bb.html.addEventListener(o[n], "mouseout", function(b) {
                phe.helpText.hideHelptext()
            })
        }
    }
    for (var j = 0; j < k.length; j++) {
        var m = k[j];
        var e = m.tagName.toLowerCase();
        if ((e == "input" && (m.getAttribute("type") != "submit")) || e == "select" || e == "textarea") {
            bb.html.addEventListener(m, "blur", function(b) {
                if (bb.browser.ie) {
                    b.currentView = b.srcElement
                } else {
                    b.currentView = b.currentTarget
                }
                g(b.currentView)
            });
            bb.html.addEventListener(m, "change", function(b) {
                if (bb.browser.ie) {
                    b.currentView = b.srcElement
                } else {
                    b.currentView = b.currentTarget
                }
                i(b.currentView)
            });
            bb.html.addEventListener(m, "focus", function(b) {
                if (bb.browser.ie) {
                    b.currentView = b.srcElement
                } else {
                    b.currentView = b.currentTarget
                }
                l(b.currentView)
            });
            bb.html.addEventListener(m, "mouseover", function(b) {
                if (bb.browser.ie) {
                    b.currentView = b.srcElement
                } else {
                    b.currentView = b.currentTarget
                }
                d(b.currentView)
            });
            bb.html.addEventListener(m, "mouseout", function(b) {
                if (bb.browser.ie) {
                    b.currentView = b.srcElement
                } else {
                    b.currentView = b.currentTarget
                }
                f(b.currentView)
            })
        }
    }
};
absa.form.handlers = absa.form.handlers || {};
absa.form.handlers.blur = function(b) {
    b.isFocus = false;
    if (!b.name) {
        return
    }
    var c = absa.form.validate.checkElement(b);
    phe.helpText.hideHelptext()
};
absa.form.handlers.change = function(d) {
    if (!d.name) {
        return
    }
    if (d.form && d.form._trackUnconfirmedChanges && d.getAttribute("trackUnconfirmedChanges") != "false") {
        d.form._changed = true
    }
    var e = absa.form.validate.checkElement(d);
    if (e) {
        phe.helpText.hideHelptext()
    }
    var c = bb.selector.queryAncestor(d, ".ap-container") || bb.selector.queryAncestor(d, ".ui-modal-content");
    if (c) {
        var b = bb.selector.query(c, ".p-gadget-header");
        if (d.offsetHeight > 0 && d.offsetWidth > 0) {
            if (b != null) {
                bb.html.addEventListener(b, "click", function() {
                    if (d.form) {
                        d.form._changed = false
                    }
                })
            }
        } else {
            if (b) {
                bb.html.removeEventListener(b, "click", function() {
                    return
                })
            }
        }
    }
};
absa.form.handlers.focus = function(b) {
    var d = bb.selector.queryAncestor(b, ".ui-tableBodyRowExpandableExtension") || bb.selector.queryAncestor(b, ".p-gadget-content") || bb.selector.queryAncestor(b, ".ui-modal-content") || bb.selector.queryAncestor(b, ".ap-container") || bb.selector.queryAncestor(b, ".ap-container-content");
    if (d && bb.selector.match(d, ".ui-showMeHow")) {
        absa.showMeHow.showHelpText(b)
    } else {
        if (bb.selector.match(b, ".ui-incorrect-value")) {
            phe.helpText.showHelptext(b);
            absa.vi.setState(b, "aria-invalid", "true");
            var c = ". " + absa.locale["Common/General/Label/ErrorMessage"];
            c += " " + b.getAttribute("helpText");
            if (bb.browser.ie) {
                c += ". " + absa.locale["Common/General/Label/Invalid"]
            }
            absa.vi.applyInputLabel(b, c, absa.vi.getLabelObject(b))
        } else {
            phe.helpText.hideHelptext();
            absa.vi.setState(b, "aria-invalid", "false");
            absa.vi.setInputLabel(b)
        }
    }
    b.isFocus = true
};
absa.form.handlers.mouseover = function(b) {
    var c = bb.selector.queryAncestor(b, ".ui-tableBodyRowExpandableExtension") || bb.selector.queryAncestor(b, ".p-gadget-content") || bb.selector.queryAncestor(b, ".ap-container-content") || bb.selector.queryAncestor(b, ".ui-modal-content");
    if (c && bb.selector.match(c, ".ui-showMeHow")) {
        absa.showMeHow.showHelpText(b)
    } else {
        if (bb.selector.match(b, ".ui-incorrect-value")) {
            phe.helpText.showHelptext(b)
        }
    }
};
absa.form.handlers.mouseout = function(b) {
    var c = bb.selector.queryAncestor(b, ".p-gadget-content") || bb.selector.queryAncestor(b, ".ap-container-content") || bb.selector.queryAncestor(b, ".ui-modal-content");
    if (bb.selector.match(b, ".ui-incorrect-value") && (!b.isFocus) || c && bb.selector.match(c, ".ui-showMeHow")) {
        phe.helpText.hideHelptext()
    }
};
absa.form.submit = function(m, g, h) {
    if (h) {
        h.call(m)
    }
    absa.form.hideValidationErrors(m);
    var i = String(m.getAttribute("method")).toUpperCase();
    var d = String(m.getAttribute("action"));
    var k = "";
    var o = bb.selector.queryAll(m, ".ap-table-stickyRow");
    if (o.length > 0) {
        var e = document.createElement("form");
        var f = document.createElement("table");
        var l = document.createElement("tbody");
        for (var c = 0; c < o.length; c++) {
            var n = o[c].cloneNode(true);
            l.appendChild(n)
        }
        f.appendChild(l);
        e.appendChild(f);
        k = absa.form.buildQueryString(e.elements)
    } else {
        k = absa.form.buildQueryString(m.elements)
    }
    if (i == "POST") {
        if (!m) {
            return
        }
        bb.html.addClass(m, "p-include-loading");
        var j = {};
        j[gadgets.io.RequestParameters.METHOD] = gadgets.io.MethodType.POST;
        j[gadgets.io.RequestParameters.POST_DATA] = k;
        phe.loadingMessage.showLoadingMessage(m, absa.locale["Common/General/Label/Processing"] + "...");
        var b = m.style.position;
        m.style.position = "relative";
        phe.form.displayIOErrorMessage(m, false);
        absa.io.makeRequest(d, function(p) {
            absa.form.disableEnableFormButtons(m, "enable");
            m.style.position = b;
            bb.html.removeClass(m, "p-include-loading");
            phe.loadingMessage.hideLoadingMessage(m);
            if (!p.errors.length) {
                if (g) {
                    g.apply(m, arguments)
                } else {
                    var q = bb.html.createElementFromString(p.text);
                    var r = bb.selector.query(q, ".validationErrors");
                    if (r) {
                        absa.form.showValidationErrors(m, r)
                    } else {
                        m.parentNode.replaceChild(q, m);
                        absa.initializeNewContent(q)
                    }
                }
            } else {
                phe.form.displayIOErrorMessage(m, true)
            }
        }, j)
    } else {
        bb.history.add(d + (d.indexOf("?") == -1 ? "?" : "&") + k)
    }
    return false
};
absa.form.validate = function(m) {
    var f = true;
    var d = 0;
    for (var k = 0; k < m.elements.length; k++) {
        var l = m.elements[k];
        if (!l.disabled && l.name && l.getAttribute("type") != "hidden" && (l.offsetHeight > 0 && l.offsetWidth > 0)) {
            var e = l.tagName.toLowerCase();
            if (e == "input" || e == "select" || e == "textarea" || e == "checkbox") {
                var b;
                if (e == "select") {
                    b = "select"
                } else {
                    if (e == "textarea") {
                        b = "textarea"
                    } else {
                        b = (l.getAttribute("type") != null) ? l.getAttribute("type").toLowerCase() : "text"
                    }
                }
                if ((b == "checkbox") || (b == "text") || (b == "tel") || (b == "email") || (b == "number") || (b == "password") || (b == "select") || (b == "textarea")) {
                    var i;
                    if (bb.html.hasClass(l, "ui-fileUpload--value")) {
                        var j = bb.selector.queryAncestor(l, ".ui-fileUpload"),
                            h = bb.selector.query(j, ".ui-fileUpload--input");
                        if (bb.html.hasClass(l, "ui-fileUpload_working")) {
                            d++;
                            f = false;
                            i = phe.inputReadOnlyText.getAttribute(h, "data-fileUploadValidationText");
                            h.setAttribute("helptext", i);
                            bb.html.addClass(h, "ui-incorrect-value")
                        } else {
                            h.setAttribute("helptext", phe.inputReadOnlyText.getAttribute(h, "requiredText"));
                            if (!absa.form.validate.checkElement(l)) {
                                d++;
                                f = false;
                                bb.html.addClass(h, "ui-incorrect-value")
                            } else {
                                bb.html.removeClass(h, "ui-incorrect-value")
                            }
                        }
                    } else {
                        if (!absa.form.validate.checkElement(l)) {
                            d++;
                            f = false;
                            if (d == 1) {
                                l.focus()
                            }
                        }
                    }
                }
            }
        }
    }
    var g = absa.util.attributeToFunction(m, "customValidation");
    if (g) {
        if (!g.call(m)) {
            f = false
        }
    }
    absa.form.validate.toggleErrorMessage(m, f);
    return f
};
absa.form.cleanValidate = function(e) {
    for (var g = 0; g < e.elements.length; g++) {
        var d = e.elements[g];
        if (!d.disabled) {
            var b = d.tagName.toLowerCase();
            if (b == "input" || b == "select" || b == "textarea") {
                var f;
                if (b == "select") {
                    f = "select"
                } else {
                    if (b == "textarea") {
                        f = "textarea"
                    } else {
                        f = (d.getAttribute("type") != null) ? d.getAttribute("type").toLowerCase() : "text"
                    }
                }
                if ((d.name) && ((f == "checkbox") || (f == "text") || (f == "password") || (f == "select") || (f == "textarea"))) {
                    absa.form.validate.toggleErrorMessage(d, true)
                }
            }
        }
    }
    absa.form.validate.toggleErrorMessage(e, true)
};
absa.form.validate.REQUIRED_VALIDATION_ERROR = 1;
absa.form.validate.SCHEMA_TYPE_VALIDATION_ERROR = 2;
absa.form.validate.DATE_PICKER_VALIDATION_ERROR = 3;
absa.form.validate.CUSTOM_VALIDATION_ERROR = 4;
absa.form.validate.FILE_NOT_UPLOADED_VALIDATION_ERROR = 5;
absa.form.validate.DATE_PICKER2_VALIDATION_ERROR = 6;
absa.form.validate.checkElement = function(g, f, k, n) {
    var j = bb.selector.query(g, "input");
    if (j) {
        g = j
    }
    var c = true;
    var m = g.getAttribute("bbf_required") == "true";
    var l = (f ? f.join("-") : g.value);
    var b = (f ? k : bb.string.trim(l) == "");
    var o = g.getAttribute("bbf_type");
    var i = 0;
    if (g.getAttribute("type") && g.getAttribute("type").toLowerCase() == "checkbox") {
        b = !g.checked
    }
    if ((absa.VI == "true") && g.getAttribute("type") && g.getAttribute("type").toLowerCase() == "text") {
        var e = j.value;
        j.value = bb.string.trim(e)
    }
    if (m) {
        c = !b;
        if (!c) {
            i = absa.form.validate.REQUIRED_VALIDATION_ERROR
        }
    }
    if (c && o && !b) {
        o = o.split(":")[1] || o;
        var h = bb.schema.getType("http://ws.online.absa.co.za/common/simpleTypes/", o);
        if (h) {
            c = c && bb.schema.validateSimpleType(l, h, null);
            if (!c) {
                i = absa.form.validate.SCHEMA_TYPE_VALIDATION_ERROR
            }
        }
    }
    if (c && bb.html.hasClass(g, "ui-datePicker--input")) {
        c = c && phe.datePicker.validateDate(g);
        if (!c) {
            i = absa.form.validate.DATE_PICKER_VALIDATION_ERROR
        }
    }
    if (c && bb.html.hasClass(g, "ui-datePicker2--input")) {
        c = c && phe.datePicker2.validateDate(g);
        if (!c) {
            i = absa.form.validate.DATE_PICKER2_VALIDATION_ERROR
        }
    }
    var d = absa.util.attributeToFunction(g, "customValidation");
    if (c && d) {
        c = c && d.call(g);
        if (!c) {
            i = absa.form.validate.CUSTOM_VALIDATION_ERROR
        }
    }
    if (!n) {
        absa.form.validate.toggleErrorMessage(g, c, i)
    }
    return c
};
absa.form.validate.toggleErrorMessage = function(f, e, g) {
    var i = f.form || f;
    var d = "";
    if (!bb.selector.match(f, ".ui-form")) {
        if (e) {
            bb.html.removeClass(f, "ui-incorrect-value");
            f.removeAttribute("helpText");
            if (bb.browser.ie && (bb.browser.version < 8) && (f.tagName.toLowerCase() == "select")) {
                f.parentNode.style.border = ""
            }
        } else {
            bb.html.addClass(f, "ui-incorrect-value");
            switch (g) {
                case absa.form.validate.REQUIRED_VALIDATION_ERROR:
                    d = f.getAttribute("requiredText");
                    break;
                case absa.form.validate.SCHEMA_TYPE_VALIDATION_ERROR:
                    d = f.getAttribute("schemaTypeText");
                    break;
                case absa.form.validate.DATE_PICKER_VALIDATION_ERROR:
                    d = f.getAttribute("datePickerErrorMsg");
                    break;
                case absa.form.validate.DATE_PICKER2_VALIDATION_ERROR:
                    d = f.getAttribute("datePicker2ErrorMsg");
                    break;
                case absa.form.validate.CUSTOM_VALIDATION_ERROR:
                    d = f.getAttribute("customValidationText");
                    break;
                default:
                    d = g
            }
            f.setAttribute("helptext", d)
        }
    } else {
        if (e) {
            bb.html.removeClass(f, "ui-form-incorrect-values")
        } else {
            bb.html.addClass(f, "ui-form-incorrect-values")
        }
    }
    var b = f.getAttribute("validate-as");
    if (b) {
        for (var h = bb.selector.queryAll(i, ".absa-for-" + b), j = 0; j < h.length; j++) {
            if (h[j]) {
                h[j].style.display = (e ? "none" : "block")
            }
        }
    }
};
absa.form.buildQueryString = function(h) {
    var f = [];
    for (var e = 0, b = h.length; e < b; e++) {
        var d = h[e];
        if (!d.disabled && d.name) {
            switch (d.tagName.toLowerCase()) {
                case "input":
                    switch (d.type) {
                        case "radio":
                        case "checkbox":
                            if (d.checked) {
                                f.push(d.name + "=" + encodeURIComponent(d.value))
                            }
                            break;
                        default:
                            var k = d.value;
                            f.push(d.name + "=" + encodeURIComponent(k))
                    }
                    break;
                case "select":
                    if (d.multiple) {
                        for (var c = 0; c < d.options.length; c++) {
                            var g = d.options[c];
                            if (g.selected) {
                                if (bb.browser.ie && (!g.attributes.value || !g.attributes.value.specified)) {
                                    f.push(d.name + "=" + encodeURIComponent(g.innerText))
                                } else {
                                    f.push(d.name + "=" + encodeURIComponent(g.value))
                                }
                            }
                        }
                    } else {
                        if (d.selectedIndex != -1) {
                            var g = d.options[d.selectedIndex];
                            if (bb.browser.ie && (!g.attributes.value || !g.attributes.value.specified)) {
                                f.push(d.name + "=" + encodeURIComponent(g.innerText))
                            } else {
                                f.push(d.name + "=" + encodeURIComponent(g.value))
                            }
                        }
                    }
                    break;
                case "textarea":
                    f.push(d.name + "=" + encodeURIComponent(d.value));
                    break;
                case "button":
                    if (d.type == "submit" && document.activeElement == d) {
                        f.push(d.name + "=" + encodeURIComponent((d.innerText || d.textContent)))
                    }
                    break
            }
        }
    }
    return f.join("&")
};
absa.form.isFormChanged = function(d) {
    var b = bb.selector.queryAll(d, '.ui-form[trackUnconfirmedChanges="true"]');
    for (var c = 0; c < b.length; c++) {
        var e = b[c];
        if (e._changed && e.offsetHeight > 0 && e.offsetWidth > 0) {
            return true
        }
    }
    return false
};
absa.form.hideValidationErrors = function(b) {
    var c = bb.selector.query(b, ".validation-place-holder");
    if (c) {
        c.innerHTML = ""
    }
};
absa.form.showValidationErrors = function(l, d) {
    var h = bb.selector.query(l, ".validation-place-holder");
    var f = bb.selector.queryAll(d, ".validationError");
    var b = bb.selector.query(d, ".validationMessages");
    if (f.length > 0) {
        for (var e = 0; e < f.length; e++) {
            var k = f[e].getAttribute("field");
            var c = k.indexOf("[");
            var m = f[e].getAttribute("key");
            var g = bb.selector.query(l, '*[name="' + k + '"]');
            if (g == null) {
                g = bb.selector.query(l, '*[ac="' + k + '"]')
            }
            if (c >= 0) {
                g = bb.selector.query(l, "." + k.substring(0, c) + "_" + k.substring(c, k.indexOf("]")));
                if (g == null) {
                    g = bb.selector.query(l, '*[ac="' + k.substring(0, c) + "_" + k.substring(c, k.indexOf("]")) + '"]')
                }
            }
            if (k != "" && g && g.type != "hidden") {
                absa.form.validate.toggleErrorMessage(g, false, m);
                g.focus();
                var j = bb.selector.queryAncestor(g, ".ui-form");
                phe.form.displayErrorMessage(j, true)
            } else {
                if (h) {
                    h.innerHTML = b.innerHTML
                }
            }
        }
    } else {
        if (b) {
            if (h) {
                h.innerHTML = b.innerHTML
            }
        }
    }
};
absa.form.wizardBridge = absa.form.wizardBridge || {};
absa.form.wizardBridge.handleResponseIIP = function(e, f, g, c) {
    var b = /ui-form--TVNForm/.test(f.text);
    if (b) {
        var d = bb.selector.queryAncestor(e, ".ap-paySingle");
        if (d == null) {
            d = bb.selector.queryAncestor(e, ".ap-payMultiple-root")
        }
        phe.loadingMessage.hideLoadingMessage(d)
    }
    absa.form.wizardBridge.handleResponse(e, f, g, c)
};
absa.form.wizardBridge.handleResponse = function(x, s, t, m) {
    var g = false;
    var A = bb.selector.queryAncestor(x, ".ui-wizard");
    var o = bb.selector.query(A, ".ui-wizard-body-wrapper");
    var u = bb.selector.query(o, ".ap-registration-inRegProcess");
    if (u) {
        g = true
    }
    var z = /ui-form--TVNForm/.test(s.text);
    if (z) {
        var A = bb.selector.queryAncestor(x, ".ui-wizard");
        var F = bb.selector.query(A, ".ui-wizard-heads .ui-wizard-titles");
        var y = (bb.selector.queryAll(F, ".ui-wizard-head").length - 1);
        var k = absa.locale["Common/General/Label/Confirm"];
        if (!(k == "Confirm" || k == "Bevestig")) {
            k = "Confirm"
        }
        var q = bb.html.createElementFromString('<label xmlns="http://www.w3.org/1999/xhtml" for="ui-wizard-body' + y + 'b" class="ui-wizard-head ui-wizard-head--TVN">Step ' + y + " of " + (y + 1) + ' <span class="ui-wizard-step-name">' + k + '</span><span class="vi-screenreader-line ">. </span></label>');
        F.insertBefore(q, F.lastChild);
        var p = bb.html.createElementFromString('<div id="ui-wizard-body' + y + 'b" class="ui-wizard-body ui-wizard-body--TVN" tabindex="0"></div>');
        o.insertBefore(p, o.lastChild)
    }
    var l = !/class=["']+validationErrors["']+/.test(s.text);
    if (l) {
        var A = bb.selector.queryAncestor(x, ".ui-wizard");
        var c = phe.wizard.getNextStepBody(A);
        phe.wizard.setShowMeHow(c);
        phe.wizard.setCallMeButton(c);
        phe.wizard.setAdvisorButton(c);
        var h = bb.selector.query(A, ".ui-wizard--showMeHow");
        absa.showMeHow.switchOff(h);
        if (c) {
            c.innerHTML = s.text;
            absa.initializeNewContent(c)
        }
        phe.wizard.selectStep(c);
        var j = bb.selector.queryAll(c, ".ui-slider");
        if (j) {
            if (j.length) {
                for (var C = 0; C < j.length; C++) {
                    phe.slider.initializeBehavior(j[C])
                }
            }
        }
        var D = bb.selector.query(c, ".ap-TVM-form");
        if (D) {
            var u = bb.selector.query(o, ".ap-registration-inRegProcess");
            if (u) {
                absa.TVM.updateFormStatus(D, false, true)
            } else {
                gadgets.pubsub.publish("TVM-form-loaded", D)
            }
        }
        var n = bb.selector.query(c, ".ui-form--TVNForm-code");
        if (n && n.offsetHeight > 0) {
            if (bb.browser.ie) {
                setTimeout(function() {
                    n.focus()
                }, 10)
            } else {
                n.focus()
            }
        }
        if (g && z) {
            var r = bb.selector.query(c, ".ui-form--TVNForm");
            phe.common.setAttribute(r, "action", "webservice/AccessControlWebService/processTVN?registration=true&tempSessionId=" + absa.apps.register.sessionID)
        }
        var B = bb.selector.queryAll(A, ".ui-wizard-body");
        var G = B[B.length - 1];
        var J = bb.selector.query(c, "form");
        if (!(bb.html.hasClass(G, "ui-wizard-body-selected")) && x._changed && J) {
            J._changed = true
        }
        if (t) {
            try {
                if (c != null) {
                    t.call(c, c)
                } else {
                    t.call(x, x)
                }
            } catch (E) {
                bb.command.trace(null, "Error when calling success method:" + E.message || E)
            }
        }
        if (absa.VI == "true") {
            if ((bb.html.hasClass(G, "ui-wizard-body-selected"))) {
                var b = bb.selector.query(c, ".validation-place-holder");
                var I = bb.selector.query(b, ".ui-message");
                if (I) {
                    I.focus()
                }
            }
        }
    } else {
        var H = bb.html.createElementFromString(s.text);
        var f = bb.selector.query(H, ".validationErrors");
        var A = bb.selector.queryAncestor(x, ".ui-wizard");
        var w = bb.selector.queryAll(A, ".ui-wizard-head");
        var v = phe.wizard.getAttribute(A, "validationKickBackStep");
        if (v && v == "-1") {
            phe.wizard.selectStepRelative(A.firstChild, parseInt("0"))
        } else {
            if (v) {
                phe.wizard.selectStepAbsolute(A, parseInt(v))
            } else {
                if (w.length > 2) {
                    if ((w.length - 3) > (phe.wizard.getCurrentStepIndex(A) + 1)) {
                        phe.wizard.selectStepAbsolute(A, phe.wizard.getCurrentStepIndex(A))
                    } else {
                        phe.wizard.selectStepAbsolute(A, w.length - 3)
                    }
                } else {
                    phe.wizard.selectStepAbsolute(A, 0)
                }
            }
        }
        var d = bb.selector.query(A, ".ui-wizard-body-selected");
        absa.form.showValidationErrors(d, f);
        try {
            if (m) {
                m.call(x, x)
            }
        } catch (E) {
            bb.command.trace(null, "Error when calling error method:" + E.message || E)
        }
    }
};
absa.form.wizardBridge.openRVNForm = function(e, f, h, b) {
    var d = bb.selector.queryAncestor(e, ".ui-wizard");
    var g = e.parentNode;
    g.style.display = "none";
    var c = bb.html.createElementFromString(f.text);
    g.parentNode.appendChild(c);
    absa.form.attachHandlers(c)
};
absa.form.wizardBridge.cancelRVNForm = function(d) {
    var f = bb.selector.queryAncestor(d, "form");
    if (f) {
        f.reset();
        if (f._trackUnconfirmedChanges) {
            f._changed = false
        }
    }
    var b = bb.selector.queryAncestor(d, ".ui-modal");
    if (b) {
        phe.modal.hideModal()
    } else {
        var e = bb.selector.queryAncestor(d, ".p-gadget");
        var c = bb.getControllerFromView(e);
        if (c) {
            c.minimize();
            e.focus()
        }
    }
};
absa.form.wizardBridge.resendRVNForm = function(f) {
    var e = "proxy?pipe=genericWebservice&ws=AccessControlWebService&action=resendRVN";
    var b = bb.selector.queryAncestor(f, ".ui-form--RVNForm");
    var d = bb.selector.query(b, ".ui-formFoot");
    var c = bb.selector.query(d, ".RVNCodeError");
    if (c) {
        d.removeChild(c)
    }
    phe.loadingMessage.showLoadingMessage(b);
    absa.io.makeRequest(e, function(i) {
        phe.loadingMessage.hideLoadingMessage(b);
        if (!i.errors.length) {
            var k = bb.html.createElementFromString(i.text);
            var h = bb.selector.query(k, ".ui-message-error");
            if (h) {
                d.insertBefore(k, d.firstChild)
            } else {
                var g = bb.selector.query(b, ".ui-textBox");
                b.reset();
                var j = bb.selector.query(b, ".ap-sendRVN-timestamp");
                j.innerHTML = k.innerHTML
            }
            phe.form.displayIOErrorMessage(b, false)
        } else {
            phe.form.displayIOErrorMessage(b, true)
        }
    })
};
absa.form.wizardBridge.handleRVN = function(o, g, i, j, k) {
    var p = !/RVNCodeError/.test(g.text);
    if (p) {
        var c;
        if (k) {
            c = bb.selector.queryAncestor(o, ".ap-forceLoadNode")
        }
        var r = bb.selector.queryAncestor(o, "[proxyurl]");
        var f = bb.selector.queryAncestor(o, ".ui-tabBody");
        var b = bb.selector.queryAncestor(o, ".ui-tableBodyRowExpandableExtension");
        var n = bb.selector.queryAncestor(o, ".ui-modalBody[proxyurl]");
        var d = bb.selector.queryAncestor(o, ".ap-gadget-lazyContent");
        if (c) {
            absa.lazyLoadNode(c, true)
        } else {
            if (b && b.getAttribute("dataFileView")) {
                var m = bb.selector.queryAncestor(o, ".ui-form");
                if (m == null) {
                    m = bb.selector.query(o, ".ui-form")
                }
                if (m != null) {
                    phe.form.setAttribute(m, "trackUnconfirmedChanges", "false");
                    m._trackUnconfirmedChanges = false;
                    m._changed = false
                }
                phe.tableBodyRow.expandRow(b.previousSibling, phe.tableBodyRowExpandableExtention.getAttribute(b, "dataFileView"), false)
            } else {
                if (r) {
                    absa.lazyLoadNode(r, true)
                } else {
                    if (f) {
                        phe.tabBody.reload(f)
                    } else {
                        if (n) {
                            absa.lazyLoadNode(n, true)
                        } else {
                            if (d) {
                                absa.lazyLoadNode(d, true)
                            }
                        }
                    }
                }
            }
        }
    } else {
        var q = bb.html.createElementFromString(g.text);
        var e = bb.selector.query(o, ".RVNCodeError");
        var h = bb.selector.query(o, ".ui-formFoot");
        var l = bb.selector.query(o, ".ui-formFoot-backup");
        phe.form.displayIOErrorMessage(o, false);
        if (e) {
            if (h) {
                h.removeChild(e)
            } else {
                if (l) {
                    l.removeChild(e)
                }
            }
        }
        if (h) {
            h.insertBefore(q, h.firstChild)
        } else {
            if (l) {
                l.insertBefore(q, l.firstChild)
            }
        }
    }
};
absa.form.wizardBridge.cancelTVNForm = function(c) {
    var b = bb.selector.queryAncestor(c, ".ui-wizard");
    phe.wizard.selectStepAbsolute(b, 0);
    absa.form.wizardBridge.removeTVNStep(c)
};
absa.form.wizardBridge.resendTVNForm = function(h, c) {
    var i = bb.selector.queryAncestor(h, ".ui-form--TVNForm");
    var e = bb.selector.query(i, ".ap-sendTVN-correlationId");
    var d = phe.hiddenField.getValue(e);
    var g = bb.selector.query(i, ".ui-formFoot");
    var b = bb.selector.query(g, ".TVNCodeError");
    var f = "proxy?pipe=genericWebservice&ws=AccessControlWebService&action=resendTVN&correlationId=" + d;
    if (c == "registerForAOLStep2") {
        f = "webservice/AccessControlWebService/resendTVN?registration=true&correlationId=" + d + "&tempSessionId=" + absa.apps.register.sessionID
    }
    if (b) {
        g.removeChild(b)
    }
    phe.loadingMessage.showLoadingMessage(i);
    absa.io.makeRequest(f, function(l) {
        phe.loadingMessage.hideLoadingMessage(i);
        if (!l.errors.length) {
            var n = bb.html.createElementFromString(l.text);
            var k = bb.selector.query(n, ".ui-message-error");
            if (k) {
                g.insertBefore(n, g.firstChild)
            } else {
                var j = bb.selector.query(i, ".ui-textBox");
                i.reset();
                var m = bb.selector.query(i, ".ap-sendTVN-timestamp");
                m.innerHTML = n.innerHTML
            }
            phe.form.displayIOErrorMessage(i, false)
        } else {
            phe.form.displayIOErrorMessage(i, true)
        }
    })
};
absa.form.wizardBridge.handleTVN = function(n, c, f, g) {
    var o = !/TVNCodeError/.test(c.text);
    if (o && c.status == "200") {
        var b = bb.selector.queryAncestor(n, ".ui-wizard");
        if (b) {
            var l = bb.selector.query(b, ".ui-wizard-body--TVN");
            if (l) {
                var h = l.previousSibling;
                if (h) {
                    var k = bb.selector.query(h, "form");
                    var m = bb.selector.query(n, "input[name=correlationID]");
                    if (k) {
                        if (m) {
                            var e = m.cloneNode(true);
                            k.appendChild(e)
                        }
                        phe.wizard.selectStep(h);
                        absa.form.wizardBridge.removeTVNStep(n);
                        bb.html.fireEvent(k, "submit", true, true)
                    }
                }
            }
        }
    } else {
        var p = bb.html.createElementFromString(c.text);
        var i = bb.selector.query(n, ".TVNCodeError");
        var d = bb.selector.query(n, ".ui-formFoot");
        var j = bb.selector.query(n, ".ui-formFoot-backup");
        phe.form.displayIOErrorMessage(n, false);
        if (i) {
            if (d) {
                d.removeChild(i)
            } else {
                if (j) {
                    j.removeChild(i)
                }
            }
        }
        if (d) {
            d.insertBefore(p, d.firstChild)
        } else {
            if (j) {
                j.insertBefore(p, j.firstChild)
            }
        }
    }
};
absa.form.wizardBridge.removeTVNStep = function(e) {
    var c = bb.selector.queryAncestor(e, ".ui-wizard");
    if (c) {
        var b = bb.selector.query(c, ".ui-wizard-body--TVN");
        var d = bb.selector.query(c, ".ui-wizard-head--TVN");
        if (d) {
            d.parentNode.removeChild(d)
        }
        if (b) {
            b.parentNode.removeChild(b)
        }
    }
};
absa.showMeHow = absa.showMeHow || {};
absa.showMeHow.toggle = function(c, d, b) {
    if (absa.showMeHow.isShowMeHowOn(c)) {
        absa.showMeHow.switchOff(c)
    } else {
        absa.showMeHow.switchOn(c, d, b)
    }
};
absa.showMeHow.isShowMeHowOn = function(b) {
    var c = bb.selector.queryAncestor(b, ".ui-tableBodyRowExpandableExtension");
    if (!c) {
        c = bb.selector.queryAncestor(b, ".p-gadget-content");
        if (!c) {
            c = bb.selector.queryAncestor(b, ".ap-container-content");
            if (!c) {
                c = bb.selector.queryAncestor(b, ".ui-modal-content")
            }
        }
    }
    if (c) {
        if (bb.html.hasClass(c, "ui-showMeHow")) {
            return true
        } else {
            return false
        }
    }
};
absa.showMeHow.switchOff = function(d) {
    var e = bb.selector.queryAncestor(d, ".ui-tableBodyRowExpandableExtension");
    if (!e) {
        e = bb.selector.queryAncestor(d, ".p-gadget-content");
        if (!e) {
            e = bb.selector.queryAncestor(d, ".ap-container-content");
            if (!e) {
                e = bb.selector.queryAncestor(d, ".ui-modal-content")
            }
        }
    }
    var b = phe.button.getAttribute(d, "data-showMeHowActive");
    if (b != "") {
        phe.button.setAttribute(d, "tooltip", b)
    } else {
        phe.button.setAttribute(d, "tooltip", absa.locale["Common/General/Label/ShowMeHowActivate"])
    }
    bb.html.replaceClass(d, "ap-icon-help-active", "ap-icon-help");
    var c = phe.button.getAttribute(d, "showMeHow");
    if (c) {
        phe.button.setAttribute(d, "tooltip", c)
    }
    bb.html.removeClass(d, "ui-showMeHow--icon");
    if (e) {
        bb.html.removeClass(e, "ui-showMeHow")
    }
};
absa.showMeHow.switchOn = function(h, j, d) {
    var k = bb.selector.queryAncestor(h, ".ui-tableBodyRowExpandableExtension");
    var c = bb.selector.queryAncestor(h, ".ui-wizard");
    if (!k) {
        k = bb.selector.queryAncestor(h, ".p-gadget-content");
        if (!k) {
            k = bb.selector.queryAncestor(h, ".ap-container-content");
            if (!k) {
                k = bb.selector.queryAncestor(h, ".ui-modal-content")
            }
        }
    }
    if (!c) {
        bb.html.addClass(h, "ui-showMeHow--icon")
    }
    if ((c && !bb.html.hasClass(c, "ui-wizard--showMeHow_disabled")) || bb.html.hasClass(h, "ui-showMeHow--icon")) {
        bb.html.replaceClass(h, "ap-icon-help", "ap-icon-help-active");
        var e = phe.button.getAttribute(h, "data-showMeHowInactive");
        if (e != "") {
            phe.button.setAttribute(h, "tooltip", e)
        } else {
            phe.button.setAttribute(h, "tooltip", absa.locale["Common/General/Label/ShowMeHowDeactivate"])
        }
    }
    if (k) {
        if (c && bb.html.hasClass(c, "ui-wizard--showMeHow_disabled")) {
            return false
        }
        bb.html.addClass(k, "ui-showMeHow");
        if (d && j) {
            var b = bb.selector.queryAncestor(h, d);
            if (b) {
                var f = bb.selector.queryAll(b, ".ui-form-field");
                for (var g = 0; g < f.length; g++) {
                    if (!f[g].disabled && f[g].offsetHeight > 0 && f[g].offsetWidth > 0) {
                        f[g].focus();
                        break
                    }
                }
            }
        }
    }
};
absa.showMeHow.showHelpText = function(c) {
    var b = c.getAttribute("showMeHow");
    if (b) {
        if (bb.html.hasClass(c, "ap-icon-info")) {
            phe.helpText.showHelptext(c, "<span class='ap-helpText-showMeHow-black'> " + b + "</span>")
        } else {
            phe.helpText.showHelptext(c, "<span class='ap-helpText-showMeHow'> " + b + "</span>")
        }
    }
};
absa.showMeHow.toggleLogin = function(c, e, b) {
    var d = bb.selector.query(document.body, b);
    if (d) {
        if (bb.html.hasClass(d, "ui-showMeHow")) {
            absa.showMeHow.switchOffLogin(c, d)
        } else {
            absa.showMeHow.switchOnLogin(d, c, e, b)
        }
    }
};
absa.showMeHow.switchOnLogin = function(e, d, g, c) {
    if (!e) {
        bb.html.addClass(d, "ui-showMeHow--icon")
    }
    if (e) {
        bb.html.addClass(e, "ui-showMeHow");
        if (c && g) {
            var f = bb.selector.queryAll(e, "select, input, textarea");
            for (var b = 0; b < f.length; b++) {
                if (bb.html.hasClass(f[b], "ap-showMeHow-focus") && !f[b].disabled && !(f[b].getAttribute("type") == "hidden") && f[b].offsetHeight > 0 && f[b].offsetWidth > 0) {
                    f[b].focus();
                    break
                }
            }
        }
    }
};
absa.showMeHow.switchOffLogin = function(c, d) {
    phe.button.setAttribute(c, "tooltip", absa.locale["Common/General/Label/ShowMeHowActivate"]);
    var b = phe.button.getAttribute(c, "showMeHow");
    if (b) {
        phe.button.setAttribute(c, "tooltip", b)
    }
    bb.html.removeClass(c, "ui-showMeHow--icon");
    if (d) {
        bb.html.removeClass(d, "ui-showMeHow")
    }
};
absa.wizard = absa.wizard || {};
absa.wizard.backButton = function(d, b, c) {
    b = b || window.event;
    if (b) {
        bb.html.handlePreventDefault(b)
    }
    phe.wizard.selectStepRelative(d, parseInt("-1"));
    if (c) {
        try {
            c.call(d, d)
        } catch (f) {
            bb.command.trace(null, "Error when calling method:" + f.message || f)
        }
    }
};
absa.wizard.finishButton = function(c) {
    var e = bb.selector.queryAncestor(c, "form");
    if (e) {
        e.reset();
        if (e._trackUnconfirmedChanges) {
            e._changed = false
        }
    }
    var d = bb.selector.queryAncestor(c, ".p-gadget");
    var b = bb.getControllerFromView(d);
    if (b) {
        b.minimize();
        d.focus()
    }
};
absa.gadgetHeaderIcons = {
    dispatchEvents: function(d) {
        var c = d.currentView;
        var b = bb.string.trim(c.className.replace(/ui-button ap-|-inactivated/ig, ""));
        switch (b) {
            case "icon-configure":
                this.configureGadget(d, c, b);
                break;
            case "icon-arrowRight":
            case "icon-remove":
            case "icon-removeHistory":
            case "icon-3060":
            case "icon-removeStopPayments":
            case "icon-unsubscribeGadget":
            case "icon-logOn":
                break;
            default:
                this.switchTab(d, c, b)
        }
    },
    switchTab: function(e, d, c) {
        var b = e.target;
        if (b.getProperty("minimized")) {
            b.restore()
        }
        b.setPreference("selectedTab", c);
        var f = bb.selector.query(b.viewGate, ".ap-option2Tab-" + c);
        if (f && !b._dragging) {
            phe.tabBox.selectTab(f)
        }
    },
    configureGadget: function(e, d, c) {
        if (absa.gadgetHeaderIcons.selected == 0) {
            absa.gadgetHeaderIcons.selected = 1;
            e = e || window.event;
            var b = e.target;
            this.oOldTitleObj = bb.selector.query(b.headerRef, ".p-gadget-title");
            bb.selector.query(this.oOldTitleObj, ".ap-bar-section-Accounts").style.display = "none";
            bb.selector.query(this.oOldTitleObj.parentNode, ".p-gadget-subTitle").style.display = "none";
            this.oldTitle = bb.selector.query(b.headerRef, ".p-gadget-title-view").innerHTML;
            var f = "";
            f += '<div style="position:absolute;top:8px">';
            f += '<input class="ui-form-field newAccountName" maxlength="15" style="width:95px; font-weight:normal; vertical-align:middle;" bbf_required="true" bbf_type="simple:accountName" name="newAccountName" value="' + this.oldTitle + '" onmouseover="this.focus()" onmouseup="absa.apps.changeAccountName.onAccountNameTextBoxMouseUp(this)" onmousemove="bb.html.handlePreventDefaultAndStop(event)" onblur="if(!absa.form.validate.checkElement(this)){phe.helpText.showHelptext(this);}else{phe.helpText.hideHelptext();}" bbf_type="simple:accountName" bbf_required="true" messageref=".errorMessage" type="text"';
            f += ' requiredText="' + absa.locale["Common/General/Label/Required"] + '" ';
            f += ' schemaTypeText="' + absa.locale["Common/General/Validation/ChangeAccountName"] + '" />';
            f += '<button type="submit" onclick="absa.gadgetHeaderIcons.displayGadgetHeading(this,true)" class="ap-button" style="color:rgb(0,118,0); margin-left:2px; vertical-align:middle; border:none; background-color:transparent;cursor:pointer">';
            f += '<div class="ap-button-left">';
            f += '<div class="ap-button-right">';
            f += '<div class="ap-button-center" style=" font-size:xx-small;">' + absa.locale["Common/General/Button/Save"] + "</div>";
            f += "</div></div></button>";
            f += '<button type="button" onclick="absa.gadgetHeaderIcons.cancelGadgetHeadingChange(this)" class="ap-button" style="color:rgb(237,27,47); margin-left:2px; vertical-align:middle; border:none; background-color:transparent;cursor:pointer">';
            f += '<div class="ap-button-left">';
            f += '<div class="ap-button-right">';
            f += '<div class="ap-button-center" style=" font-size:xx-small;">' + absa.locale["Common/General/Button/Cancel"] + "</div>";
            f += "</div></div></button>";
            f += "</div>";
            f += this.oOldTitleObj.innerHTML;
            b.setTitle(f);
            bb.selector.query(b.headerRef, ".p-gadget-title .newAccountName").focus();
            bb.html.enableUserSelect(b.headerRef)
        }
    },
    oldTitle: undefined,
    selected: 0,
    cancelGadgetHeadingChange: function(c) {
        var b = bb.getControllerFromView(c.parentNode);
        this.setGadgetNewName(b, absa.gadgetHeaderIcons.oldTitle)
    },
    displayGadgetHeading: function(j, e) {
        var m = bb.selector.query(j.parentNode, ".newAccountName");
        var d = m.value;
        var h = bb.selector.query(j.parentNode, ".newAccountName");
        var f = bb.getControllerFromView(j.parentNode);
        var l = bb.selector.query(j.parentNode, ".errorMessage");
        var k = bb.selector.queryAncestor(j, ".p-gadget-title-container");
        var c = bb.selector.query(k, ".p-gadget-subTitle");
        if (e == false) {
            d = this.oldTitle
        }
        if (d != this.oldTitle) {
            var b = absa.form.validate.checkElement(m);
            if (b) {
                m.style.border = "";
                var g = {};
                g[gadgets.io.RequestParameters.METHOD] = gadgets.io.MethodType.POST;
                var i = c.innerHTML;
                g[gadgets.io.RequestParameters.POST_DATA] = gadgets.io.encodeValues({
                    accountName: d,
                    accountId: i
                });
                absa.io.makeRequest("proxy?pipe=genericWebservice&ws=ProfileWebService&action=setAccountName", function(s) {
                    if (s.status == "200") {
                        var t = bb.html.createElementFromString(s.text);
                        var q = d;
                        var p = bb.selector.queryAll(t, ".ui-message-error");
                        var r = bb.selector.query(t, ".ui-message-help");
                        var n = bb.selector.query(t, ".ui-message-warning");
                        if (p[2] || r || n) {
                            q = absa.gadgetHeaderIcons.oldTitle;
                            phe.modal.showModal(0.5, t, document.body, false)
                        } else {
                            absa.gadgetHeaderIcons.setGadgetNewName(f, q)
                        }
                    } else {
                        if (s.errors.length) {
                            var o = bb.selector.query(document.body, ".ap-HTTP500Template div").cloneNode(true);
                            phe.modal.showModal(0.5, o, document.body)
                        }
                    }
                }, g)
            } else {
                phe.helpText.showHelptext(m);
                m.focus()
            }
        } else {
            this.setGadgetNewName(f, absa.gadgetHeaderIcons.oldTitle)
        }
    },
    setGadgetNewName: function(b, c) {
        bb.selector.query(this.oOldTitleObj, ".p-gadget-title-view").innerHTML = c;
        bb.selector.query(this.oOldTitleObj, ".ap-bar-section-Accounts").style.display = "block";
        bb.selector.query(this.oOldTitleObj.parentNode, ".p-gadget-subTitle").style.display = "block";
        this.oOldTitleObj.removeChild(this.oOldTitleObj.firstChild);
        var d = this.oOldTitleObj.innerHTML;
        b.setTitle(d);
        this.showGadgetIcons(b);
        absa.gadgetHeaderIcons.selected = 0;
        bb.html.disableUserSelect(b.headerRef)
    },
    showGadgetIcons: function(b) {
        var c = bb.selector.query(b.headerRef, ".ap-bar-section-icons-options");
        c.style.display = "block"
    }
};
absa.gadgets.positionRefresh = function(d) {
    var l = bb.document.getElementById("portal");
    if (l != null) {
        var e = l.getProperty("containers");
        var k = e[0];
        if (k != null) {
            var i = k.getProperty("gadgets");
            if (i != null) {
                if (i.length > 0) {
                    for (var f = 0; f < i.length; f++) {
                        if (i[f] != null) {
                            var b = i[f]._._id;
                            for (var c = 0; c < d.length; c++) {
                                if (b == d[c].gadgetId) {
                                    var h = d[b];
                                    h = {
                                        col: "0",
                                        pos: d[c].position
                                    };
                                    l.moveGadget(i[f], k, h);
                                    break
                                }
                            }
                        }
                    }
                }
            }
        }
    }
};
absa.gadgets.collapseGadgets = function() {
    var e = bb.document.getElementById("portal").getProperty("gadgets");
    for (var d = 0; d < e.length; d++) {
        var b = e[d];
        var c = b.getProperty("container");
        if (b.getSetting("minimizable", "boolean")) {
            b.minimize()
        }
    }
};
absa.gadgets.addGadgetHeaderTooltip = function(c, b) {
    if (c.headerTooltip) {
        return
    }
    if (b && b.length > 0) {
        c.headerTooltip = b
    }
    if (typeof(c.headerRef) == "undefined") {
        c.headerRef = bb.selector.query(c.viewNode, ".p-gadget-header")
    }
    c.headerRef.setAttribute("anchorpoint", "topleft");
    c.headerRef.setAttribute("offsetx", "30");
    c.headerRef.setAttribute("offsety", "-20")
};
absa.gadgets.doChangeAccountNameClick = function(b) {
    var d = bb.selector.queryAncestor(b, ".p-gadget-header");
    var c = bb.selector.query(d, ".ap-icon-configure");
    bb.html.fireEvent(c, "click", true, false)
};
absa.gadgets.addGadgetHeaderButton = function(e, d, l, j) {
    var c = ".p-gadget-header";
    if (e._window && bb.html.hasClass(e._window.viewNode, "ap-dashboard-dummy")) {
        c = ".p-gadget-content " + c
    }
    var i;
    if (e._window) {
        i = bb.selector.query(e._window.viewNode, c)
    } else {
        i = bb.selector.query(e.viewNode, c)
    }
    if (i) {
        var k = "ap-gadget-button-container";
        var b = bb.selector.query(i, "." + k);
        if (!b) {
            b = document.createElement("div");
            b.className = k;
            i.appendChild(b)
        }
        var h = absa.locale[j] || j || "";
        var f = absa.createButtonHTMLString(d, h, h);
        var g = bb.html.createElementFromString(f);
        b.appendChild(g);
        if (l) {
            bb.html.addEventListener(g, "click", function() {
                l.call(this, this)
            })
        }
    }
};
absa.gadgets.loadLazyContent = function(c, b, e) {
    var d = bb.selector.query(c.body, ".ap-gadget-lazyContent");
    absa.lazyLoadNode(d, b, e)
};
absa.gadgets.setSubtitle = function(b, c) {
    var d = bb.selector.query(b.body.parentNode, ".p-gadget-subTitle");
    if (d) {
        d.innerHTML = c
    }
};

function absaGadgetTemplate() {
    if (!arguments.callee.oCloneCache) {
        var d = portal._currentPortal;
        var c = '<div class="ap-titlebar p-gadget-top-left p-gadget-header"><div role="button" tabindex="0" class="p-gadget-button p-gadget-button-restore ap-bar-section ap-icon-bar-status"><span class="vi-screenreader-line "></span></div><div role="button" tabindex="0" class="p-gadget-button p-gadget-button-minimize ap-bar-section ap-icon-bar-status"><span class="vi-screenreader-line "></span></div><div class="p-gadget-title-container"><div tabindex="0" class="p-gadget-title ap-bar-section ap-bar-title"></div><div class="p-gadget-subTitle"></div></div><div class="p-gadget-draggable-section"><button class="p-gadget-draggable-button"></button></div></div>';
        var f = '<div tabindex="-1" role="application" class="p-gadget-content"></div>';
        var e = '<div class="p-gadget ' + this.loadingClass[0] + '"><div class="ap-container">' + c + f + "</div></div>";
        arguments.callee.oCloneCache = bb.html.createElementFromString(e)
    }
    this._._showLoadingCount = 1;
    var b = arguments.callee.oCloneCache.cloneNode(true);
    b.colSpan = 0;
    return [b, bb.selector.query(b, ".p-gadget-content")]
}(function() {
    var b = portal.gadget.Gadget.prototype.setTitle;
    portal.gadget.Gadget.prototype.setTitle = function(h) {
        var g;
        if (h in absa.locale) {
            g = absa.locale[h]
        } else {
            g = h
        }
        b.call(this, g);
        var e = bb.selector.query(this._window.viewNode, ".p-gadget-header .p-gadget-button-restore");
        var c = bb.selector.query(this._window.viewNode, ".p-gadget-header .p-gadget-button-minimize");
        absa.vi.setElementLabel(e, absa.locale["Common/General/Label/ShowSection"] + " " + g);
        absa.vi.setElementLabel(c, absa.locale["Common/General/Label/HideSection"] + " " + g);
        if (bb.html.hasClass(this._window.viewNode, "ap-accountBalances")) {
            var d = bb.selector.query(e, ".vi-screenreader-line");
            var f = d.textContent || d.innerText;
            absa.vi.setElementLabel(e, f);
            d = bb.selector.query(c, ".vi-screenreader-line");
            var f = d.textContent || d.innerText;
            absa.vi.setElementLabel(c, f)
        }
    }
})();
absa.vi = absa.vi || {};
absa.vi.setElementLabel = function(b, c) {
    var d = bb.selector.query(b, ".vi-screenreader-line");
    if (d) {
        d.innerHTML = absa.vi.formatForDataType(b, c)
    }
};
absa.vi.getElementLabel = function(b) {
    var c = bb.selector.query(b, ".vi-screenreader-line");
    if (c) {
        return c.innerHTML
    }
    return ""
};
absa.vi.formatForDataType = function(c, d) {
    if (bb.html.hasClass(c, "dataType-numberAsText")) {
        var b = d.replace(/(\d)/g, "$1 ");
        if (b != "") {
            d = b
        }
    }
    return d
};
absa.vi.setDefaultLabels = function(k, b, j, d) {
    if (bb.browser.ie && bb.browser.version <= 8) {
        var h = bb.selector.queryAll(k, b);
        var e = j || "";
        var g = d || "";
        for (var f = 0, c = h.length; f < c; f++) {
            absa.vi.setElementLabel(h[f], "&nbsp;" + e + " " + (f + 1) + " of " + c + " " + g + " ")
        }
    }
};
absa.vi.getLabelObject = function(b) {
    var c = bb.selector.queryAncestor(b, ".ui-form") || bb.selector.queryAncestor(b, ".ui-modal-content") || bb.selector.queryAncestor(b, ".ap-keypad-inputs");
    if (b.getAttribute("id")) {
        return bb.selector.query(c, "*[for=" + b.getAttribute("id") + "]")
    }
};
absa.vi.setInputLabel = function(e) {
    var o = bb.selector.query(window.document, ".vi-activeElement");
    if (o) {
        o.removeAttribute("accesskey");
        bb.html.removeClass(o, "vi-activeElement")
    }
    bb.html.addClass(e, "vi-activeElement");
    if (e.getAttribute("type") == "hidden") {
        return false
    }
    var d = "";
    var l = e.getAttribute("viLabel");
    var j = e.getAttribute("id");
    var h = absa.vi.getLabelObject(e);
    var m = e.value;
    var b = e.getAttribute("showMeHow");
    if (l) {
        d = l + ". "
    }
    if (bb.browser.ie) {
        if (e.getAttribute("type") == "radio") {
            var n = bb.selector.queryAncestor(e, ".ui-radioItem");
            if (n) {
                var k = bb.selector.queryAncestor(e, ".ui-radioGroup").children;
                if (k != null) {
                    if (k.length > 0) {
                        for (var f = 0; f < k.length; f++) {
                            if (n == k[f]) {
                                break
                            }
                        }
                        d = d + ". " + String(f + 1) + " " + absa.locale["Common/General/Label/Of"] + " " + k.length
                    }
                }
            }
        }
    }
    if (bb.html.hasClass(e, "dataType-numberAsText") && m != "" && m[0] !== 0) {
        if (e.tagName.toLowerCase() == "select") {
            m = e.options[e.selectedIndex].text
        } else {
            m = e.value
        }
        d = d + ". " + m.replace(/(\d)/g, "$1 ") + " ."
    } else {
        if (bb.html.hasClass(e, "dataType-textAsEmail") && m != "") {
            var g = m.replace(/\./g, " . dot . ");
            g = g.replace(/\@/g, " . at . ");
            d += g + ". "
        } else {
            if (bb.html.hasClass(e, "dataType-numberAsDate") && m != "") {
                var c = m.split("-");
                if (c.length == 3) {
                    var g = ". " + absa.locale["Common/General/Label/Year"] + ". " + c[0] + ". ";
                    g += absa.locale["Common/General/Label/Month"] + ". " + c[1] + ". ";
                    g += absa.locale["Common/General/Label/Day"] + ". " + c[2] + ". ";
                    d += g
                }
            }
        }
    }
    if (b) {
        d += ". " + b
    }
    absa.vi.applyInputLabel(e, d, h)
};
absa.vi.applyInputLabel = function(b, g, h) {
    if (b.getAttribute("bbf_required") == "true") {
        absa.vi.setState(b, "aria-required", "true");
        if (bb.browser.ie) {
            g += ". " + absa.locale["Common/General/Label/Required"] + ". "
        }
    }
    if (g == null) {
        g = "-"
    }
    if (h) {
        var e = bb.selector.query(h, ".vi-screenreader-line");
        if (e) {
            try {
                e.innerHTML = g
            } catch (d) {}
            return true
        } else {
            var f = '<span class="vi-screenreader-line">' + g + "</span>";
            h.appendChild(bb.html.createElementFromString(f))
        }
    } else {
        if (g != "") {
            if (!b.getAttribute("id")) {
                b.setAttribute("id", "id-" + parseInt(Math.random() * 10000))
            }
            var c = '<label class="vi-hidden" for="' + b.getAttribute("id") + '"><span class="vi-screenreader-line">' + g + "</span></label>";
            h = bb.html.createElementFromString(c);
            b.parentNode.insertBefore(h, b)
        }
    }
    if (h != null) {
        if (!h.getAttribute("id")) {
            h.setAttribute("id", "id-" + parseInt(Math.random() * 10000))
        }
        b.setAttribute("aria-labelledby", h.getAttribute("id"))
    }
};
absa.vi.setState = function(b, c, d) {
    b.setAttribute(c, d)
};
absa.vi.tableHeader = absa.vi.tableHeader || {};
absa.vi.tableHeader.changeSortOrderLabel = function(g) {
    var j = bb.selector.queryAncestor(g, ".ui-table");
    var b = bb.selector.query(g, ".vi-table-head-item-suffix");
    var h = b.innerHTML;
    var e = "";
    var c = absa.locale["Common/General/Label/Descending"];
    var d = absa.locale["Common/General/Label/Ascending"];
    var i = absa.locale["Common/General/Label/None"];
    if (bb.html.hasClass(g, "sorted-DESC")) {
        e = c
    } else {
        if (bb.html.hasClass(g, "sorted-ASC")) {
            e = d
        } else {
            e = i
        }
    }
    var f = new RegExp(c + "|" + d + "|" + i, "i");
    h = h.replace(f, e);
    b.innerHTML = h
};
absa.vi.toggleAriaLabels = function(d, b) {
    var c = d.getAttribute("viLabel");
    if (c) {
        var e = c.split(" ");
        e.pop();
        e.push(d.getAttribute(b));
        d.setAttribute("viLabel", e.join(" "))
    }
};
absa.vi.activeElementNavigation = function() {
    var b = bb.selector.query(window.document, ".vi-activeElement");
    if (b) {
        b.focus()
    } else {
        var c = bb.selector.query(window.document, ".vi-activeContent");
        if (c) {
            c.focus()
        }
    }
};
absa.vi.addActiveContentDiv = function(d) {
    var e = d.firstChild;
    var c = bb.html.createElementFromString("<div class='vi-activeContent vi-screenreader-line'><a name='section1' href='section1' accesskey='q' class='vi-screenreader-line'>You are now in the active container. Keep pressing tab until you reach the desired field or button. You may have been directed here because your focus may have been lost, or there is no active element available in this active container. You can get back to the active container by using access key q</a></div>");
    var b = bb.selector.query(e, ".vi-activeContent");
    if (b) {
        b.parentNode.removeChild(b)
    }
    e.insertBefore(c, e.firstChild)
};
absa.vi.isEnterButtonPressed = function(d, b, f, c) {
    if (d.keyCode == "13" || (d.keyCode == "32")) {
        if (!f) {
            b()
        } else {
            if (!c) {
                b(f)
            } else {
                b(f, c)
            }
        }
    } else {}
};
absa.vi.showSiteMap = function() {
    oSiteMap = bb.selector.query(window.document, ".ap-vi-siteMap");
    oSiteMapToggle = bb.selector.query(window.document, ".ap-vi-siteMapToggle");
    if (bb.html.hasClass(oSiteMap, "ap-common-hide")) {
        bb.html.removeClass(oSiteMap, "ap-common-hide");
        oSiteMapToggle.innerHTML = "Site map toggle. Press enter to hide site map, or tab to enter the site map. Access key 1 will always get you here.";
        var b = bb.selector.query(oSiteMap, ".ap-vi-siteMapEntryPoint");
        b.focus()
    } else {
        bb.html.addClass(oSiteMap, "ap-common-hide");
        oSiteMapToggle.innerHTML = "Site map toggle. Press enter to show site map. Access key 1 will always get you here.";
        oSiteMapToggle.blur();
        oSiteMapToggle.focus()
    }
};
absa.print = absa.print || {};
absa.print.printFullPageGeneric = function(f) {
    var e = bb.selector.query(document.body, ".ap-container-highlevel");
    var h = document.createElement("div");
    h.innerHTML = e.innerHTML;
    var g = bb.selector.queryAll(h, "input");
    if (g.length > 0) {
        for (var c = 0; c < g.length; c++) {
            g[c].setAttribute("readonly", "true");
            g[c].setAttribute("printMe", "true")
        }
    }
    var d = h.innerHTML;
    popWin = window.open("about:blank", "print", "toolbar=yes,top=0,left=0,width=1000,height=600,scrollbars=yes");
    popWin.document.open();
    popWin.document.write("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>");
    popWin.document.write("<html>");
    popWin.document.write("<head>");
    if (bb.browser.ie & bb.browser.version == 8) {
        popWin.document.write("<meta http-equiv='X-UA-Compatible' content='IE=EmulateIE7'>")
    }
    popWin.document.write("<title>Print</title>");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/absa.css?v=777' />");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/index.css' />");
    popWin.document.write("<style type='text/css'>");
    var b = bb.selector.queryAll(window.document, "style");
    if (b.length > 0) {
        for (var c = 0; c < b.length; c++) {
            popWin.document.write(b[c].innerHTML)
        }
    }
    popWin.document.write(" html { background-color:#FFFFFF; color:#000000 !important; } ");
    popWin.document.write(" table { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ui-form-field { background:transparent; } ");
    popWin.document.write(" .ap-button { display:none; } ");
    popWin.document.write(" .ap-col-content { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ap-page-content{ border-width:0px; padding:0px 13px; color:#000000 !important; } ");
    popWin.document.write(" @media print { .ui-modal{ display:none; } .ui-modal-content{ display:none; }} ");
    popWin.document.write(" .ui-modalHeader-icons { display:none; }");
    popWin.document.write(" .ap-icon-help { display:none !important; }");
    popWin.document.write(" .ap-icon-print { display:none !important; }");
    popWin.document.write(" .ap-icon-callMe { display:none !important; }");
    if (bb.browser.ie & bb.browser.version == 8) {
        popWin.document.write(" .ap-viewTransactionHistory-rowFilter { display:none !important; }")
    }
    popWin.document.write(" @page { margin:0in; color:#000000 !important; } ");
    popWin.document.write("</style>");
    popWin.document.write("</head>");
    popWin.document.write("<body class='ssr-enabled' id='ap-page-body' onload='setTimeout(\"window.print()\",\"2000\")'>");
    popWin.document.write("<div class='ap-page-container' id='ap-page-container-div' style='z-index:1;'>");
    popWin.document.write("  <div class='ap-main-content-wrapper'>");
    popWin.document.write("    <div class='ap-main-content-wrapper-top'></div>");
    popWin.document.write("    <div class='ap-page-content ap-container'>");
    popWin.document.write("      <div class='ap-container-highlevel' style='border-bottom:1px solid #CFCFCF;'>");
    popWin.document.write(d);
    popWin.document.write("      </div>");
    popWin.document.write("    </div>");
    popWin.document.write("  </div>");
    popWin.document.write("</div>");
    popWin.document.write("<div class='ap-print-transparent_class'></div>");
    popWin.document.write("</body>");
    popWin.document.write("</html>");
    popWin.document.close()
};
absa.print.printGadgetGeneric = function(g) {
    if (g == null) {
        return
    }
    var f = bb.selector.queryAncestor(g, ".ap-container-highlevel") || bb.selector.queryAncestor(g, ".p-gadget");
    var d = bb.selector.query(f, ".ap-heading-titlebar");
    var h = bb.selector.queryAncestor(g, ".p-gadget");
    var c = document.createElement("div");
    c.innerHTML = h.innerHTML;
    var b = bb.selector.query(c, ".p-gadget-content");
    bb.html.removeClass(b, "p-gadget-content");
    var e = bb.selector.queryAll(c, "input");
    if (e.length > 0) {
        for (var j = 0; j < e.length; j++) {
            e[j].setAttribute("readonly", "true");
            e[j].setAttribute("printMe", "true")
        }
    }
    popWin = window.open("about:blank", "print", "toolbar=yes,top=0,left=0,width=1000,height=600,scrollbars=no");
    popWin.document.open();
    popWin.document.write("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>");
    popWin.document.write("<html>");
    popWin.document.write("<head>");
    if (bb.browser.ie & bb.browser.version == 8) {
        popWin.document.write("<meta http-equiv='X-UA-Compatible' content='IE=EmulateIE7'>")
    }
    popWin.document.write("<title>Print</title>");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/absa.css?v=777' />");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/index.css' />");
    popWin.document.write("<style type='text/css'>");
    var i = bb.selector.queryAll(window.document, "style");
    for (var j = 0; j < i.length; j++) {
        popWin.document.write(i[j].innerHTML)
    }
    popWin.document.write(" html { background-color: #FFFFFF; color:#000000 !important; } ");
    popWin.document.write(" table { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ai-button { display:none; } ");
    popWin.document.write(" .ap-col-content { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ap-page-content { border-width:0px; padding:0px 13px; color:#000000 !important; } ");
    popWin.document.write(" @media print { .ui-modal{ display:none; } .ui-modal-content{ display:none; }} ");
    popWin.document.write(" .ui-wizard-head-wrapper .ui-button { display:block; } ");
    popWin.document.write(" .ui-modalHeader-icons { display:none; }");
    popWin.document.write(" .ui-table--scrollContainer { overflow:visible; height:auto !important; }");
    popWin.document.write(" .ui-wizard-head-wrapper .ui-button { display:inline; color:#000000 !important; } ");
    popWin.document.write(" .ap-icon-help { display:none !important; }");
    popWin.document.write(" .ap-icon-print { display:none !important; }");
    popWin.document.write(" .ap-icon-callMe { display:none !important; }");
    popWin.document.write(" @page { margin:0in; color:#000000 !important; } ");
    popWin.document.write(" @page { size:landscape; color:#000000 !important; } ");
    popWin.document.write("</style>");
    popWin.document.write("</head>");
    popWin.document.write("<body class='ssr-enabled' id='ap-page-body' onload='setTimeout(\"window.print()\",\"2000\")'>");
    popWin.document.write("<div class='ap-page-container' id='ap-page-container-div' style='z-index:1;'>");
    popWin.document.write("  <div class='ap-main-content-wrapper'>");
    popWin.document.write("    <div class='ap-main-content-wrapper-top'></div>");
    popWin.document.write("    <div class='ap-page-content ap-container'>");
    popWin.document.write("      <div class='ap-container-highlevel' style='border-bottom:1px solid #CFCFCF;'>");
    popWin.document.write("        <div class='ap-titlebar ap-heading-titlebar'>");
    popWin.document.write(d.innerHTML);
    popWin.document.write("			</div>");
    popWin.document.write("        <div id='ap-container-wrapper' class='ap-container-content'>");
    popWin.document.write(c.innerHTML);
    popWin.document.write("        </div>");
    popWin.document.write("      </div>");
    popWin.document.write("    </div>");
    popWin.document.write("  </div>");
    popWin.document.write("</div>");
    popWin.document.write("<div class='ap-print-transparent_class'></div>");
    popWin.document.write("</body>");
    popWin.document.write("</html>");
    popWin.document.close()
};
absa.print.printGadgetGenericNettWorth = function(i) {
    if (i == null) {
        return
    }
    var b = bb.selector.queryAncestor(i, ".ui-modal");
    var h = bb.selector.queryAncestor(b, "div");
    var f = bb.selector.query(h, ".ui-modalHeader-title");
    var c = bb.selector.query(document.body, ".ap-container-top-show");
    var e = bb.selector.query(c, ".ap-bar-title");
    if (e != null & e != "") {
        f = e
    }
    var j = bb.selector.queryAncestor(i, ".ui-modal");
    var d = document.createElement("div");
    d.innerHTML = j.innerHTML;
    var g = bb.selector.queryAll(d, "input");
    if (g.length > 0) {
        for (var l = 0; l < g.length; l++) {
            g[l].setAttribute("readonly", "true");
            g[l].setAttribute("printMe", "true")
        }
    }
    popWin = window.open("about:blank", "print", "toolbar=yes,top=0,left=0,width=1000,height=600,scrollbars=no");
    popWin.document.open();
    popWin.document.write("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>");
    popWin.document.write("<html>");
    popWin.document.write("<head>");
    if (bb.browser.ie & bb.browser.version == 8) {
        popWin.document.write("<meta http-equiv='X-UA-Compatible' content='IE=EmulateIE7'>")
    }
    popWin.document.write("<title>Print</title>");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/absa.css?v=777' />");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/index.css' />");
    popWin.document.write("<style type='text/css'>");
    var k = bb.selector.queryAll(window.document, "style");
    for (var l = 0; l < k.length; l++) {
        popWin.document.write(k[l].innerHTML)
    }
    popWin.document.write("</style>");
    popWin.document.write("<style type='text/css'>");
    popWin.document.write(" html { background-color: #FFFFFF; color:#000000 !important; } ");
    popWin.document.write(" table { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ap-col-content { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ap-page-content { border-width:0px; padding:0px 13px; color:#000000 !important; } ");
    popWin.document.write(" @media print { .ui-modal{ display:none; } .ui-modal-content{ display:none; }} ");
    popWin.document.write(" .ui-wizard-head-wrapper .ui-button { display:block; color:#000000 !important; } ");
    popWin.document.write(" .ui-modalHeader { position:relative; color:#000000 !important; }");
    popWin.document.write(" .ap-container-content { border-top: 1px solid #CFCFCF; color:#000000 !important; } ");
    popWin.document.write(" .ap-heading-titlebar { display:none; color:#000000 !important; } ");
    popWin.document.write(" .ap-container-content { padding:0px; margin:0px; width:876px; color:#000000 !important; } ");
    popWin.document.write(" .ui-table--scrollContainer { overflow:visible; height:auto !important; color:#000000 !important; }");
    popWin.document.write(" .ap-updateNettworth-modalBody { width:auto !important; color:#000000 !important; }");
    popWin.document.write(" .ap-updateNettworth-modalScroller { height:auto !important; overflow-y:auto; color:#000000 !important; }");
    popWin.document.write(" .ap-icon-help { display:none !important; }");
    popWin.document.write(" .ap-icon-print { display:none !important; }");
    popWin.document.write(" .ap-icon-callMe { display:none !important; }");
    popWin.document.write(" @page { margin:0in; color:#000000 !important; } ");
    popWin.document.write("</style>");
    popWin.document.write("</head>");
    popWin.document.write("<body class='ssr-enabled' id='ap-page-body' onload='setTimeout(\"window.print()\",\"2000\")'>");
    popWin.document.write("<div class='ap-page-container' id='ap-page-container-div' style='z-index:1;'>");
    popWin.document.write("  <div class='ap-main-content-wrapper'>");
    popWin.document.write("    <div class='ap-main-content-wrapper-top'></div>");
    popWin.document.write("    <div class='ap-page-content ap-container'>");
    popWin.document.write("      <div class='ap-container-highlevel' style='border-bottom:1px solid #CFCFCF;'>");
    popWin.document.write("        <div class='ap-titlebar ap-heading-titlebar'>");
    popWin.document.write("				<h2 style='width: 200px;' class='ap-bar-section ap-bar-title'>" + f.innerHTML + "</h2>");
    popWin.document.write("			</div>");
    popWin.document.write("        <div id='ap-container-wrapper' class='ap-container-content'>");
    popWin.document.write(d.innerHTML);
    popWin.document.write("        </div>");
    popWin.document.write("      </div>");
    popWin.document.write("    </div>");
    popWin.document.write("  </div>");
    popWin.document.write("</div>");
    popWin.document.write("<div class='ap-print-transparent_class'><br/></div>");
    popWin.document.write("</body>");
    popWin.document.write("</html>");
    popWin.document.close()
};
absa.print.printGadgetDashboardGeneric = function(f) {
    var d = bb.selector.queryAncestor(f, ".p-gadget");
    var h = document.createElement("div");
    h.innerHTML = d.innerHTML;
    var e = bb.selector.query(h, ".p-gadget-content");
    bb.html.removeClass(e, "p-gadget-content");
    var g = bb.selector.queryAll(h, "input");
    if (g.length > 0) {
        for (var c = 0; c < g.length; c++) {
            g[c].setAttribute("readonly", "true");
            g[c].setAttribute("printMe", "true")
        }
    }
    popWin = window.open("about:blank", "print", "toolbar=yes,top=0,left=0,width=1000,height=600,scrollbars=no");
    popWin.document.open();
    popWin.document.write("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>");
    popWin.document.write("<html>");
    popWin.document.write("<head>");
    if (bb.browser.ie & bb.browser.version == 8) {
        popWin.document.write("<meta http-equiv='X-UA-Compatible' content='IE=EmulateIE7'>")
    }
    popWin.document.write("<title>Print</title>");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/absa.css?v=777' />");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/index.css' />");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/dashboard.css' />");
    popWin.document.write("<style type='text/css'>");
    var b = bb.selector.queryAll(window.document, "style");
    for (var c = 0; c < b.length; c++) {
        popWin.document.write(b[c].innerHTML)
    }
    popWin.document.write(" html { background-color: #FFFFFF; color:#000000 !important; } ");
    popWin.document.write(" table { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ap-col-content { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ap-page-content { border-width:0px; padding:0px 13px; color:#000000 !important; } ");
    popWin.document.write(" @media print { .ui-modal{ display:none; } .ui-modal-content{ display:none; }} ");
    popWin.document.write(" .ap-dashboard-dummy .ap-titlebar .ui-tabHeads {width:880px; color:#000000 !important;} ");
    popWin.document.write(" .ui-table--scrollContainer { overflow:visible; height:auto !important; color:#000000 !important; }");
    popWin.document.write(" .ap-dashboard-dummy .p-gadget-header { display:block !important; color:#000000 !important; }");
    popWin.document.write(" .ap-dashboard-dummy .p-gadget-content { border-bottom: 1px solid #C0C0C0;border-left: 1px solid #C0C0C0;border-right: 1px solid #C0C0C0; color:#000000 !important; }");
    popWin.document.write(" .ap-page-content { padding:0px 0px !important; color:#000000 !important; } ");
    popWin.document.write(" .ap-container-content { padding:13px 0px !important; width:944px !important; color:#000000 !important; } ");
    popWin.document.write(" .ap-icon-help { display:none !important; }");
    popWin.document.write(" .ap-icon-print { display:none !important; }");
    popWin.document.write(" .ap-icon-callMe { display:none !important; }");
    popWin.document.write(" @page { margin:0in; color:#000000 !important; } ");
    popWin.document.write(" @page { size:landscape; color:#000000 !important; } ");
    popWin.document.write("</style>");
    popWin.document.write("<script type='text/javascript'>");
    popWin.document.write("function initPagePrint(){ ");
    popWin.document.write("	var oBody = document.getElementById('ap-page-body'); ");
    popWin.document.write("	setTimeout('window.print()','2000'); ");
    popWin.document.write("}");
    popWin.document.write("<\/script>");
    popWin.document.write("</head>");
    popWin.document.write("<body class='ssr-enabled' id='ap-page-body' onload='initPagePrint();'>");
    popWin.document.write("<div class='ap-page-container ap-dashboard-dummy' id='ap-page-container-div' style='z-index:999;'>");
    popWin.document.write("  <div class='ap-main-content-wrapper'>");
    popWin.document.write("    <div class='ap-main-content-wrapper-top'></div>");
    popWin.document.write("    <div class='ap-page-content ap-container'>");
    popWin.document.write("      <div class='ap-container-highlevel' style='border-bottom:1px solid #CFCFCF;'>");
    popWin.document.write("        <div class='ap-titlebar ap-heading-titlebar'>");
    popWin.document.write("        <div id='ap-container-top-l4' class='ap-heading-titlebar-item  ap-container-top-show'>");
    popWin.document.write("        <h2 id='ap-bar-section-saveInvest' style='width: 200px;' class='ap-bar-section ap-bar-title'>Dashboard</h2>");
    popWin.document.write("        </div>");
    popWin.document.write("			</div>");
    popWin.document.write("        <div id='ap-container-wrapper' class='ap-container-content'>");
    popWin.document.write(h.innerHTML);
    popWin.document.write("        </div>");
    popWin.document.write("      </div>");
    popWin.document.write("    </div>");
    popWin.document.write("  </div>");
    popWin.document.write("</div>");
    popWin.document.write("<div class='ap-print-transparent_class'></div>");
    popWin.document.write("</body>");
    popWin.document.write("</html>");
    popWin.document.close()
};
absa.print.printPopupGeneric = function(i) {
    var b = bb.selector.queryAncestor(i, ".ui-modal");
    var h = bb.selector.queryAncestor(b, "div");
    var f = bb.selector.query(h, ".ui-modalHeader-title");
    var c = bb.selector.query(document.body, ".ap-container-top-show");
    if (c) {
        var e = bb.selector.query(c, ".ap-bar-title");
        if (e != null & e != "") {
            f = e
        }
    }
    var j = bb.selector.queryAncestor(i, ".ui-modal");
    var d = document.createElement("div");
    d.innerHTML = j.innerHTML;
    var g = bb.selector.queryAll(d, "input");
    if (g.length > 0) {
        for (var l = 0; l < g.length; l++) {
            g[l].setAttribute("readonly", "true");
            g[l].setAttribute("printMe", "true")
        }
    }
    popWin = window.open("about:blank", "print", "toolbar=yes,top=0,left=0,width=1000,height=600,scrollbars=no");
    popWin.document.open();
    popWin.document.write("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>");
    popWin.document.write("<html>");
    popWin.document.write("<head>");
    if (bb.browser.ie & bb.browser.version == 8) {
        popWin.document.write("<meta http-equiv='X-UA-Compatible' content='IE=EmulateIE7'>")
    }
    popWin.document.write("<title>Print</title>");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/absa.css?v=777' />");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/index.css' />");
    popWin.document.write("<style type='text/css'>");
    var k = bb.selector.queryAll(window.document, "style");
    for (var l = 0; l < k.length; l++) {
        popWin.document.write(k[l].innerHTML)
    }
    popWin.document.write(" html { background-color: #FFFFFF; color:#000000 !important; } ");
    popWin.document.write(" table { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ap-col-content { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ap-page-content { border-width:0px; padding:0px 13px; color:#000000 !important; } ");
    popWin.document.write(" @media print { .ui-modal{ display:none; } .ui-modal-content{ display:none; }} ");
    popWin.document.write(" .ui-wizard-head-wrapper .ui-button { display:block; } ");
    popWin.document.write(" .ui-modalHeader {position:relative; color:#000000 !important; }");
    popWin.document.write(" .ap-container-content { border-top: 1px solid #CFCFCF; color:#000000 !important; } ");
    popWin.document.write(" .ap-heading-titlebar { display:none; color:#000000 !important; } ");
    popWin.document.write(" .ap-container-content { padding:0px; margin:0px; width:876px; color:#000000 !important; } ");
    popWin.document.write(" .ui-table--scrollContainer { overflow:visible; height:auto !important; color:#000000 !important; }");
    popWin.document.write(" .ap-container-highlevel { border-bottom:0px !important; width:878px; color:#000000 !important;} ");
    popWin.document.write(" .ap-page-container { width:813px !important; color:#000000 !important; } ");
    popWin.document.write(" .ap-main-content-wrapper { width:813px !important; margin-bottom:0px !important; color:#000000 !important; } ");
    popWin.document.write(" .ap-page-content { padding:0 0px !important; color:#000000 !important; } ");
    popWin.document.write(" .ap-container-content { width:813px !important; color:#000000 !important; } ");
    popWin.document.write(" .ap-icon-print { display:none !important; }");
    popWin.document.write(" .ui-modal-printButton { display:none !important; }");
    popWin.document.write(" .ui-modal-closeButton { display:none !important; }");
    popWin.document.write(" .ap-icon-help { display:none !important; }");
    popWin.document.write(" .ap-icon-help-inactive { display:none !important; }");
    popWin.document.write(" .ap-icon-callMe { display:none !important; }");
    popWin.document.write(" @page { margin:0in; color:#000000 !important; } ");
    popWin.document.write(" @page { size:landscape; color:#000000 !important; } ");
    popWin.document.write("</style>");
    popWin.document.write("</head>");
    popWin.document.write("<body class='ssr-enabled' id='ap-page-body' onload='setTimeout(\"window.print()\",\"2000\")'>");
    popWin.document.write("<div class='ap-page-container' id='ap-page-container-div' style='z-index:1;'>");
    popWin.document.write("  <div class='ap-main-content-wrapper'>");
    popWin.document.write("    <div class='ap-main-content-wrapper-top'></div>");
    popWin.document.write("    <div class='ap-page-content ap-container'>");
    popWin.document.write("      <div class='ap-container-highlevel' style='border-bottom:1px solid #CFCFCF;'>");
    popWin.document.write("        <div class='ap-titlebar ap-heading-titlebar'>");
    popWin.document.write("				<h2 style='width: 200px;' class='ap-bar-section ap-bar-title'>" + f.innerHTML + "</h2>");
    popWin.document.write("			</div>");
    popWin.document.write("        <div id='ap-container-wrapper' class='ap-container-content'>");
    popWin.document.write(d.innerHTML);
    popWin.document.write("        </div>");
    popWin.document.write("      </div>");
    popWin.document.write("    </div>");
    popWin.document.write("  </div>");
    popWin.document.write("</div>");
    popWin.document.write("<div class='ap-print-transparent_class'><br/></div>");
    popWin.document.write("</body>");
    popWin.document.write("</html>");
    popWin.document.close()
};
absa.print.printBeneficiaryListAndHistory = function(f) {
    if (f == null) {
        return
    }
    var e = bb.selector.queryAncestor(f, ".ap-manageBeneficiaries-expandableRow");
    var d = bb.selector.query(e, ".manageBeneficiaries-beneficiaryName-display").value;
    var h = document.createElement("div");
    h.innerHTML = e.innerHTML;
    var g = bb.selector.queryAll(h, "input");
    if (g.length > 0) {
        for (var c = 0; c < g.length; c++) {
            g[c].setAttribute("readonly", "true");
            g[c].setAttribute("printMe", "true")
        }
    }
    popWin = window.open("about:blank", "print", "toolbar=yes,top=0,left=0,width=1000,height=600,scrollbars=no");
    popWin.document.open();
    popWin.document.write("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>");
    popWin.document.write("<html>");
    popWin.document.write("<head>");
    if (bb.browser.ie & bb.browser.version == 8) {
        popWin.document.write("<meta http-equiv='X-UA-Compatible' content='IE=EmulateIE7'>")
    }
    popWin.document.write("<title>Print</title>");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/absa.css?v=777' />");
    popWin.document.write("<link rel='stylesheet' type='text/css' href='" + absa.CONTEXT + "/static/style/index.css' />");
    popWin.document.write("<style type='text/css'>");
    var b = bb.selector.queryAll(window.document, "style");
    for (var c = 0; c < b.length; c++) {
        popWin.document.write(b[c].innerHTML)
    }
    popWin.document.write(" html { background-color: #FFFFFF; color:#000000 !important; } ");
    popWin.document.write(" table { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ai-button { display:none; } ");
    popWin.document.write(" .ap-col-content { font-size:11px; color:#000000 !important; } ");
    popWin.document.write(" .ap-page-content { border-width:0px; padding:0px 13px; color:#000000 !important; } ");
    popWin.document.write(" @media print { .ui-modal{ display:none; } .ui-modal-content{ display:none; }} ");
    popWin.document.write(" .ui-wizard-head-wrapper .ui-button { display:block; } ");
    popWin.document.write(" .ui-modalHeader-icons { display:none; }");
    popWin.document.write(" .ui-table--scrollContainer { overflow:visible; height:auto !important; color:#000000 !important; }");
    popWin.document.write(" .ui-wizard-head-wrapper .ui-button { display:inline; color:#000000 !important; } ");
    popWin.document.write(" .ap-icon-help { display:none !important; }");
    popWin.document.write(" .ap-icon-print { display:none !important; }");
    popWin.document.write(" .ap-icon-callMe { display:none !important; }");
    popWin.document.write(" @page { margin:0in; color:#000000 !important; } ");
    popWin.document.write(" @page { size:landscape; color:#000000 !important; } ");
    popWin.document.write("</style>");
    popWin.document.write("</head>");
    popWin.document.write("<body class='ssr-enabled' id='ap-page-body' onload='setTimeout(\"window.print()\",\"2000\")'>");
    popWin.document.write("<div class='ap-page-container' id='ap-page-container-div' style='z-index:1;'>");
    popWin.document.write("  <div class='ap-main-content-wrapper'>");
    popWin.document.write("    <div class='ap-main-content-wrapper-top'></div>");
    popWin.document.write("    <div class='ap-page-content ap-container'>");
    popWin.document.write("      <div class='ap-container-highlevel' style='border-bottom:1px solid #CFCFCF;'>");
    popWin.document.write("        <div class='ap-titlebar ap-heading-titlebar'>");
    popWin.document.write("<h2 id='ap-bar-section-Payments' style='width:400px' class='ap-bar-section ap-bar-title' tabindex='0'>" + d + "</h2>");
    popWin.document.write("			</div>");
    popWin.document.write("        <div id='ap-container-wrapper' class='ap-container-content'>");
    popWin.document.write(h.innerHTML);
    popWin.document.write("        </div>");
    popWin.document.write("      </div>");
    popWin.document.write("    </div>");
    popWin.document.write("  </div>");
    popWin.document.write("</div>");
    popWin.document.write("<div class='ap-print-transparent_class'></div>");
    popWin.document.write("</body>");
    popWin.document.write("</html>");
    popWin.document.close()
};
absa.print.printPopupSaveInvest = function(c) {
    var b = bb.selector.query(document.body, ".modalPrintTotalInvestment");
    phe.modal.showModal(0.5, b, document.body, true)
};
absa.io = absa.io || {};
absa.io.makeRequest = function(f, m, g) {
    if (!g) {
        g = {}
    }
    var k = {};
    if (!g[gadgets.io.RequestParameters.METHOD]) {
        if (f) {
            if (f.indexOf("?") == -1) {
                k.nonce = absa.NONCE;
                k.uniq = new Date().getTime()
            } else {
                var h = new Array();
                h[0] = f.substring(0, f.indexOf("?"));
                h[1] = f.substring((f.indexOf("?") + 1));
                if (h.length == 2) {
                    f = "";
                    for (var l = 0; l < h.length; l++) {
                        if (l == 0) {
                            f += h[0];
                            k.nonce = absa.NONCE;
                            k.uniq = new Date().getTime()
                        } else {
                            var e = h[l].split("&");
                            if (e && e != "") {
                                for (a in e) {
                                    var c = e[a].split("=");
                                    if (c && c != "") {
                                        var i = c[0];
                                        var b = c[1];
                                        if (i) {
                                            if (b == null || b == "undefined") {
                                                b = ""
                                            }
                                            if (k[i]) {
                                                k[i].push(decodeURIComponent(b))
                                            } else {
                                                k[i] = new Array();
                                                k[i].push(decodeURIComponent(b))
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    k.nonce = absa.NONCE;
                    k.uniq = new Date().getTime()
                }
            }
        } else {
            k.nonce = absa.NONCE;
            k.uniq = new Date().getTime()
        }
        g[gadgets.io.RequestParameters.METHOD] = gadgets.io.MethodType.POST;
        g[gadgets.io.RequestParameters.POST_DATA] = gadgets.io.encodeValues(k)
    } else {
        if (!g[gadgets.io.RequestParameters.POST_DATA]) {
            k.nonce = absa.NONCE;
            k.uniq = new Date().getTime();
            g[gadgets.io.RequestParameters.POST_DATA] = gadgets.io.encodeValues(k)
        } else {
            var j = g[gadgets.io.RequestParameters.POST_DATA];
            j += "&";
            var h = f.split("?");
            if (h) {
                f = "";
                for (var l = 0; l < h.length; l++) {
                    if (l == 0) {
                        f += h[0]
                    } else {
                        j += h[l]
                    }
                }
            }
            j = j + "&nonce=" + absa.NONCE + "&uniq=" + new Date().getTime();
            g[gadgets.io.RequestParameters.POST_DATA] = j
        }
    }
    if (!g[gadgets.io.RequestParameters.TIMEOUT]) {
        g[gadgets.io.RequestParameters.TIMEOUT] = 230000
    }

    function d(o) {
        if (o.headers["Logon-Jsp"]) {
            document.location = o.headers["Logon-Jsp"]
        } else {
            if (o.status == 999) {
                if (typeof absa.index != "undefined") {
                    var n = bb.selector.query(document.body, "#modalSessionDied");
                    phe.modal.showModal(0.5, n, document.body, true)
                }
            } else {
                if ((o.status == 500) & (o.headers["Content-Length"] == "1000") & (o.headers.Connection == "close")) {
                    var n = bb.selector.query(document.body, "#modalSessionDied");
                    phe.modal.showModal(0.5, n, document.body, true)
                } else {
                    if (m) {
                        if ((o.status == 302) & (o.headers["Content-Length"] == "20") & (o.headers.Connection == "Keep-Alive") & (o.headers.Location != null)) {
                            if (o.headers.Location.indexOf("Logoff") > -1) {
                                var n = bb.selector.query(document.body, "#modalSessionDied");
                                phe.modal.showModal(0.5, n, document.body, true)
                            } else {
                                m(o)
                            }
                        } else {
                            m(o)
                        }
                    }
                }
            }
        }
    }
    if (typeof absa.index != "undefined") {
        absa.index.resetTimerFromIO()
    }
    return gadgets.io.makeRequest(f, d, g)
};
var absa = window.absa || {};
absa.gadgets = absa.gadgets || {};
absa.apps = absa.apps || {};
absa.notifications = absa.notifications || {};
absa.notifications.onNotificationTypeSelect = function(d, f, b) {
    var c = bb.selector.queryAncestor(d, ".ap-notifications");
    if (!c) {
        var e = bb.selector.queryAncestor(d, "form");
        c = bb.selector.query(e, ".ap-notifications")
    }
    switch (f) {
        case "S":
            f = "sms";
            break;
        case "E":
            f = "email";
            break;
        case "F":
            f = "fax";
            break;
        default:
            f = "none";
            break
    }
    if (b == "ap-icon-notMy") {
        absa.notifications.showOwnContent(c, f)
    } else {
        if (b == "ap-icon-notBen") {
            absa.notifications.showBeneficiaryContent(c, f)
        }
    }
    absa.notifications.showHideRow(c)
};
absa.notifications.showBeneficiaryContent = function(p, b) {
    var o = bb.selector.queryAll(p, ".ap-notifications-ben");
    var c = bb.selector.query(p, ".ap-notifications-ben-Name");
    var m = bb.selector.queryAll(p, ".ap-notifications-ben-email-options");
    for (var h = 0; h < o.length; h++) {
        if (bb.html.hasClass(o[h], "ap-notifications-ben-" + b)) {
            var l = bb.selector.queryAll(o[h], ".ap-notifications-inputBen-" + b);
            if (l[0]) {
                for (var g = 0; g < l.length; g++) {
                    phe.textBox.setAttribute(l[g], "required", "true");
                    switch (b) {
                        case "email":
                            phe.textBox.setAttribute(l[g], "dataType", "simple:email");
                            if (absa.touch.enabled) {
                                phe.textBox.setAttribute(l[g], "type", "email")
                            }
                            break;
                        case "fax":
                            phe.textBox.setAttribute(l[g], "dataType", "simple:faxNumber");
                            if (absa.touch.enabled && (l[g].type != "hidden")) {
                                phe.textBox.setAttribute(l[g], "type", "tel")
                            }
                            break;
                        case "sms":
                            phe.textBox.setAttribute(l[g], "dataType", "simple:cellNumber");
                            if (absa.touch.enabled && (l[g].type != "hidden")) {
                                phe.textBox.setAttribute(l[g], "type", "tel")
                            }
                            break
                    }
                }
            }
            o[h].style.display = "";
            if ((b == "email" || b == "fax") && m) {
                var f = bb.selector.query(p, ".ui-form-field[name=notBenPaymentMadeBy]");
                if (f) {
                    phe.textBox.setAttribute(f, "required", "true")
                }
                var n = bb.selector.query(p, ".ap-notifications-inputBen-name");
                if (n) {
                    phe.textBox.setAttribute(n, "required", "true")
                }
                for (var g = 0; g < m.length; g++) {
                    m[g].style.display = ""
                }
            }
        } else {
            o[h].style.display = "none";
            var e = bb.selector.queryAll(o[h], "input");
            if (e[0]) {
                for (var d = 0; d < e.length; d++) {
                    phe.textBox.setAttribute(e[d], "dataType", "");
                    phe.textBox.setAttribute(e[d], "required", "");
                    absa.form.validate.checkElement(e[d])
                }
            }
            if (b != "email" && b != "fax" && m) {
                var f = bb.selector.query(p, ".ui-form-field[name=notBenPaymentMadeBy]");
                if (f) {
                    phe.textBox.setAttribute(f, "required", "");
                    absa.form.validate.checkElement(f)
                }
                var n = bb.selector.query(p, ".ap-notifications-inputBen-name");
                if (n) {
                    phe.textBox.setAttribute(n, "required", "");
                    absa.form.validate.checkElement(n)
                }
                for (var d = 0; d < m.length; d++) {
                    m[d].style.display = "none"
                }
            }
        }
    }
    if (c && (b == "email" || b == "fax")) {
        c.style.display = ""
    } else {
        if (c) {
            c.style.display = "none"
        }
    }
};
absa.notifications.showOwnContent = function(m, g) {
    var l = bb.selector.queryAll(m, ".ap-notifications-my");
    var k = bb.selector.query(m, ".ap-notifications-my-Name");
    var e;
    if (k) {
        e = bb.selector.query(k, ".ui-textBox")
    }
    if (g == "sms") {} else {
        if (k) {
            phe.textBox.setAttribute(e, "required", "false");
            phe.row.hide(k)
        }
    }
    for (var d = 0; d < l.length; d++) {
        if (bb.html.hasClass(l[d], "ap-notifications-my-" + g)) {
            l[d].style.display = "";
            var f = bb.selector.queryAll(l[d], ".ap-notifications-inputMy-" + g);
            if (f[0]) {
                for (var c = 0; c < f.length; c++) {
                    phe.textBox.setAttribute(f[c], "required", "true");
                    switch (g) {
                        case "email":
                            phe.textBox.setAttribute(f[c], "dataType", "simple:email");
                            if (absa.touch.enabled) {
                                phe.textBox.setAttribute(f[c], "type", "email")
                            }
                            if (e) {
                                phe.row.show(k);
                                phe.textBox.setAttribute(e, "required", "true")
                            }
                            break;
                        case "fax":
                            phe.textBox.setAttribute(f[c], "dataType", "simple:faxNumber");
                            if (absa.touch.enabled && (f[c].type != "hidden")) {
                                phe.textBox.setAttribute(f[c], "type", "tel")
                            }
                            if (e) {
                                phe.row.show(k);
                                phe.textBox.setAttribute(e, "required", "true")
                            }
                            break;
                        default:
                            if (e) {
                                phe.textBox.setAttribute(e, "required", "false");
                                phe.row.hide(k)
                            }
                    }
                }
            }
        } else {
            l[d].style.display = "none";
            var b = bb.selector.queryAll(l[d], "input");
            if (b[0]) {
                for (var h = 0; h < b.length; h++) {
                    b[h].setAttribute("bbf_required", "");
                    b[h].setAttribute("bbf_type", "")
                }
            }
        }
    }
};
absa.notifications.showHideRow = function(b) {
    var c = bb.selector.query(b, ".ap-notification-options");
    var g = bb.selector.query(b, ".ap-notMyType");
    var e = bb.selector.query(b, ".ap-notBenType");
    var d;
    var f;
    if (!e || phe.select.getValue(e) == "") {
        d = "N"
    } else {
        d = phe.select.getValue(e)
    }
    if (!g || phe.select.getValue(g) == "") {
        f = "N"
    } else {
        f = phe.select.getValue(g)
    }
    if (f == "N" && d != "N") {
        phe.row.show(c)
    } else {
        if (f == "N" && d == "N") {
            phe.row.hide(c)
        } else {
            phe.row.show(c)
        }
    }
};
absa.notifications.getNotifications = function(c) {
    var e = c.form;
    var b = bb.selector.query(e, ".ap-notBenType-default").value;
    var d = bb.selector.query(e, ".ap-notMyType-default").value;
    absa.notifications.resetNotifications(b, "ap-icon-notBen", c);
    absa.notifications.resetNotifications(d, "ap-icon-notMy", c)
};
absa.notifications.resetNotifications = function(e) {
    var g = bb.selector.queryAncestor(e, ".ui-form");
    var f = bb.selector.query(g, ".ap-notBenType-default");
    var c = bb.selector.query(g, ".ap-notMyType-default");
    var d = bb.selector.query(g, ".ap-notMyType");
    var b = bb.selector.query(g, ".ap-notBenType");
    if (f) {
        bb.html.removeClass(b, "ui-incorrect-value");
        phe.select.setValue(b, phe.hiddenField.getValue(f));
        absa.notifications.onNotificationTypeSelect(e, f.value, "ap-icon-notBen")
    }
    bb.html.removeClass(d, "ui-incorrect-value");
    phe.select.setValue(d, phe.hiddenField.getValue(c));
    absa.notifications.onNotificationTypeSelect(e, c.value, "ap-icon-notMy");
    g.reset()
};
absa.notifications.setValidation = function(c) {
    phe.textBox.setAttribute(c, "dataType", "simple:cellNumber");
    if (absa.touch.enabled && (c.type != "hidden")) {
        phe.textBox.setAttribute(c, "type", "tel")
    }
    if (absa.form.validate.checkElement(c)) {
        var b = bb.selector.query(c.parentNode, ".ap-notifications-inputMy-sms");
        phe.hiddenField.setValue(b, phe.textBox.getValue(c))
    }
};
absa.date = absa.date || {};
absa.date.getDaysDiff = function(b, e) {
    if (b != "" & e != "") {
        var d = new Date(Number(b.substring(0, 4)), (Number(b.substring(5, 7)) - 1), Number(b.substring(8, 10)));
        var c = new Date(Number(e.substring(0, 4)), (Number(e.substring(5, 7)) - 1), Number(e.substring(8, 10)));
        return Math.round((c - d) / (1000 * 60 * 60 * 24))
    } else {
        return 0
    }
};
absa.date.getDateTimeNow = function() {
    var i = new Date();
    var f = i.getFullYear();
    var h;
    var b;
    var c;
    var g;
    var e;
    if (i.getMonth() < 9) {
        h = "0" + (i.getMonth() + 1)
    } else {
        h = "" + (i.getMonth() + 1)
    }
    if (i.getDate() < 10) {
        b = "0" + i.getDate()
    } else {
        b = i.getDate()
    }
    if (i.getHours() < 10) {
        c = "0" + i.getHours()
    } else {
        c = i.getHours()
    }
    if (i.getMinutes() < 10) {
        g = "0" + i.getMinutes()
    } else {
        g = i.getMinutes()
    }
    if (i.getSeconds() < 10) {
        e = "0" + i.getSeconds()
    } else {
        e = i.getSeconds()
    }
    return f + "-" + h + "-" + b + " " + c + ":" + g + ":" + e
};
absa.date.getDateNow = function() {
    var f = new Date();
    var c = f.getFullYear();
    var e;
    var b;
    if (f.getMonth() < 9) {
        e = "0" + (f.getMonth() + 1)
    } else {
        e = "" + (f.getMonth() + 1)
    }
    if (f.getDate() < 10) {
        b = "0" + f.getDate()
    } else {
        b = f.getDate()
    }
    return c + "-" + e + "-" + b
};
absa.date.getTimeNow = function() {
    var b = new Date();
    if (b.getHours() < 10) {
        curr_hrs = "0" + b.getHours()
    } else {
        curr_hrs = b.getHours()
    }
    if (b.getMinutes() < 10) {
        curr_mins = "0" + b.getMinutes()
    } else {
        curr_mins = b.getMinutes()
    }
    if (b.getSeconds() < 10) {
        curr_sec = "0" + b.getSeconds()
    } else {
        curr_sec = b.getSeconds()
    }
    return curr_hrs + ":" + curr_mins + ":" + curr_sec
};
absa.date.getTimeNowHourOnly = function() {
    var b = new Date();
    if (b.getHours() < 10) {
        curr_hrs = "0" + b.getHours()
    } else {
        curr_hrs = b.getHours()
    }
    return curr_hrs
};
absa.date.getTimeNowMinutesOnly = function() {
    var b = new Date();
    if (b.getMinutes() < 10) {
        curr_mins = "0" + b.getMinutes()
    } else {
        curr_mins = b.getMinutes()
    }
    return curr_mins
};
absa.date.formatDate = function(d) {
    var b = d.getDate();
    var e = d.getMonth();
    e++;
    var c = d.getFullYear();
    if (e < 10) {
        sCurrMonth = "0" + e
    } else {
        sCurrMonth = e
    }
    if (b < 10) {
        sCurrDate = "0" + b
    } else {
        sCurrDate = b
    }
    return c + "-" + sCurrMonth + "-" + sCurrDate
};
absa.date.isValidDate = function(i) {
    var h = new String(i);
    var g = Number(h.substring(0, 4));
    var f = h.substring(4, 5);
    var l = Number(h.substring(5, 7));
    var k = h.substring(7, 8);
    var j = Number(h.substring(8, 10));
    if (isNaN(g) == false & isNaN(l) == false & isNaN(j) == false) {
        if (f != "-" | k != "-") {
            return false
        } else {
            return true
        }
    } else {
        return false
    }
};
absa.date.parseXPathDateTime = function(j) {
    var n = null;
    var l = j.match(/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})\.(\d{3})([+-])(\d{2}):(\d{2})$/);
    if (l) {
        var g = l[1] * 1,
            c = l[2] * 1 - 1,
            b = l[3] * 1,
            f = l[4] * 1,
            d = l[5] * 1,
            i = l[6] * 1,
            h = l[7] * 1,
            e = l[8],
            m = l[9] * 1,
            k = l[10] * 1;
        n = new Date;
        n.setYear(g);
        n.setMonth(c);
        n.setDate(b);
        n.setHours(f);
        n.setMinutes(d - (e == "+" ? 1 : -1) * (m * 60 + k) - n.getTimezoneOffset());
        n.setSeconds(i);
        n.setMilliseconds(h)
    }
    return n
};
absa.date.addToDate = function(c, g, f, d, e) {
    var b = new Date(Number(c.substring(0, 4)), (Number(c.substring(5, 7)) - 1), Number(c.substring(8, 10)));
    b.setYear(b.getFullYear() + d);
    b.setMonth(b.getMonth() + f);
    b.setDate(b.getDate() + g);
    if (e) {
        return absa.date.formatDate(b)
    } else {
        return b
    }
};
absa.date.getNextCapDate = function(c, b, d) {
    var f = new Date();
    f.setYear(c.getFullYear());
    if (d === 1) {
        if (c.getDate() < b) {
            f.setMonth(c.getMonth())
        } else {
            f.setMonth(c.getMonth() + d)
        }
    } else {
        f.setMonth(c.getMonth() + d)
    }
    var e = new Date(f.getFullYear(), f.getMonth() + 1, 0);
    if (b > e.getDate()) {
        f.setDate(e.getDate())
    } else {
        f.setDate(b)
    }
    return f
};
absa.util.Observer = function() {
    this.topics = {}
};
absa.util.Observer.prototype = {
    subscribe: function(b, c) {
        this.topics[b] = this.topics[b] || [];
        this.topics[b].push(c)
    },
    unsubscribe: function(e, g) {
        var c = this.topics[e];
        if (c) {
            var d = [];
            for (var f = 0; f < c.length; f++) {
                var b = c[f];
                if (b != g) {
                    d[d.lengh] = b
                }
            }
            this.topics[e] = d
        }
    },
    publish: function(c, h, g) {
        var e = g || window;
        var b = this.topics[c];
        if (b) {
            for (var d = 0; d < b.length; d++) {
                var f = b[d];
                f.call(e, h)
            }
        }
    }
};
absa.util.observer = new absa.util.Observer;
absa.unconfirmedChanges = absa.unconfirmedChanges || {};
absa.unconfirmedChanges.bDisplayed = false;
absa.unconfirmedChanges.oRestoredGadget = null;
absa.unconfirmedChanges.cancelNavigation = function(c, f, e) {
    if (!absa.unconfirmedChanges.content) {
        absa.unconfirmedChanges.content = bb.selector.query(document.body, ".ap-unconfirmedChangesModal .ui-modal")
    }
    absa.unconfirmedChanges.fContinue = function() {
        phe.modal.hideModal();
        absa.unconfirmedChanges.bDisplayed = false;
        if (typeof f === "function") {
            f()
        }
        if (absa.unconfirmedChanges.oRestoredGadget) {
            absa.unconfirmedChanges.oRestoredGadget.restore();
            absa.unconfirmedChanges.oRestoredGadget = null
        }
    };
    absa.unconfirmedChanges.cancel = function() {
        phe.modal.hideModal();
        absa.unconfirmedChanges.bDisplayed = false;
        if (typeof e === "function") {
            e()
        }
        if (absa.unconfirmedChanges.oRestoredGadget) {
            absa.unconfirmedChanges.oRestoredGadget = null
        }
        c.focus()
    };
    var d = bb.selector.query(c, "*[customcancelnavigation]");
    if (d) {
        var b = absa.util.attributeToFunction(d, "customcancelnavigation", ["fnOnContinue", "fnOnCancel"]);
        b.call(d, f, e)
    } else {
        if ((absa.VI != "true") && (absa.form.isFormChanged(c))) {
            absa.unconfirmedChanges.bDisplayed = true;
            phe.modal.showModal(0.5, absa.unconfirmedChanges.content)
        } else {
            absa.unconfirmedChanges.fContinue = null;
            absa.unconfirmedChanges.cancel = null;
            f()
        }
    }
};
absa.xd = absa.xd || {};
absa.xd.timeout = 60000;
absa.xd._requests = {};
absa.xd.ERROR_TIMEOUT = 1;
absa.xd.ERROR_CONTENT = 2;
absa.xd.ERROR_REQUEST = 3;
absa.xd.makeXDRequest = function(b, h, k, j, c, f) {
    var e = Math.round(Math.random() * 10000000000000000);
    var d = {};
    d.url = h + k;
    d.data = j;
    d.handler = c;
    absa.xd._requests[e] = d;
    var g = document.body.appendChild(document.createElement("iframe"));
    g.setAttribute("name", "xdr-" + e);
    g.setAttribute("id", "xdr-" + e);
    g.style.cssText = "position:absolute; visibility:hidden; top:1px; left:1px; width:1px; height:1px";
    var i = new Date().getTime();
    g.src = h + "/static/xd/proxy.jsp?uniq=" + i + "&url=" + encodeURIComponent(h + k) + "&callback=" + encodeURIComponent(b + "/static/xd/callback.html?uniq=" + i + "&xdr=" + e);
    g.contentWindow.name = encodeURIComponent(j);
    d._timeout = setTimeout(function() {
        absa.xd._onTimeout(e)
    }, f || absa.xd.timeout)
};
absa.xd.callback = function(i, b) {
    absa.xd._removeIFrame(i);
    var c = absa.xd._removeRequest(i);
    clearTimeout(c._timeout);
    var g = {};
    if (decodeURIComponent(b).match(/xhrSuccess=(true|false)&xhrResponse=([\s\S]*)$/)) {
        g.xhrSuccess = RegExp.$1;
        g.xhrResponse = RegExp.$2
    }
    var d = c.handler;
    if (typeof d == "function") {
        if (g.xhrSuccess == "true") {
            var h;
            try {
                h = JSONRequest.parse(g.xhrResponse)
            } catch (f) {
                h = {
                    success: false,
                    errorCode: absa.xd.ERROR_CONTENT,
                    errorMessage: "Server did not respond"
                }
            }
        } else {
            h = {
                success: false,
                errorCode: absa.xd.ERROR_REQUEST,
                errorMessage: "Server did not respond"
            }
        }
        d(h, i)
    }
};
absa.xd._onTimeout = function(d) {
    absa.xd._removeIFrame(d);
    var b = absa.xd._removeRequest(d);
    var c = b.handler;
    if (typeof c == "function") {
        c({
            success: "false",
            errorCode: absa.xd.ERROR_TIMEOUT,
            errorMessage: "Server did not respond"
        }, d)
    }
};
absa.xd._removeIFrame = function(c) {
    var b = document.getElementById("xdr-" + c);
    b.parentNode.removeChild(b)
};
absa.xd._removeRequest = function(c) {
    var b = absa.xd._requests[c];
    delete absa.xd._requests[c];
    return b
};
absa.touch = absa.touch || {};
absa.touch = (function() {
    var f = null;
    var c = {
        touchstart: "mousedown",
        touchmove: "mousemove",
        touchend: "mouseup"
    };

    function b(g) {
        g.preventDefault();
        e(g)
    }

    function d(g) {
        document.removeEventListener("touchmove", b, false);
        document.removeEventListener("touchend", d, false);
        e(g)
    }

    function e(h) {
        var i = f = (h.targetTouches[0] || f);
        var g = document.createEvent("MouseEvents");
        g.initMouseEvent(c[h.type], true, true, h.view, h.detail, h.screenX || i.screenX, h.screenY || i.screenY, h.clientX || i.clientX, h.clientY || i.clientY, h.ctrlKey, h.altKey, h.shiftKey, h.metaKey, h.button || 0, h.relatedTarget);
        g.pageX = h.pageX || i.pageX;
        g.pageY = h.pageY || i.pageY;
        h.target.dispatchEvent(g);
        h.stopPropagation();
        h.preventDefault()
    }
    return {
        enabled: false,
        register: function(g) {
            g.addEventListener("touchstart", function(h) {
                document.addEventListener("touchmove", b, false);
                document.addEventListener("touchend", d, false);
                e(h)
            }, false)
        }
    }
})();
var absa = window.absa || {};
absa.SVM = absa.SVM || {};
absa.SVM.initSVM = function() {
    absa.SVM.loadInitialTime();
    gadgets.pubsub.subscribe("SVM-form-loaded", function(b) {
        absa.SVM.updateFormStatus(b)
    })
};
absa.SVM.loadInitialTime = function() {
    var b = "proxy?pipe=genericEmptyResponse&xslFile=accessControl/SVMTimers";
    absa.io.makeRequest(b, function(c) {
        if (!c.errors.length) {
            var e = bb.html.createElementFromString(c.text);
            var d = phe.common.getAttribute(e, "data-initialTime");
            if (d) {
                absa.SVM.initialTimeRemaining = d * 1
            } else {
                absa.SVM.initialTimeRemaining = 60
            }
        } else {
            absa.SVM.initialTimeRemaining = 60
        }
    })
};
absa.SVM.onProcessSVMFormCallBack = function(d, c, b) {
    absa.SVM.updateFormStatus(d, "", b)
};
absa.SVM.updateFormStatus = function(q, g, o) {
    var p = phe.form.getAttribute(q, "data-timeInterval") * 1;
    var i = phe.form.getAttribute(q, "data-timeRemaining") * 1;
    var n = bb.selector.query(q, ".ap-SVM-countDownTimer");
    var l = phe.form.getAttribute(q, "data-cellphone");
    var d = "proxy?pipe=genericWebService&ws=AccessControlWebService&action=processSVM";
    var m = phe.common.getAttribute(n, "data-timeRemaining");
    var f = bb.selector.query(q, ".ap-SVM-errorMessageContainer");
    var h = bb.selector.query(q, ".ap-SVM-resendButton");
    var k = bb.selector.query(q, ".ap-SVM-sendRVNButton");
    if (i > 55) {
        var c = bb.selector.queryAncestor(q, ".ui-wizard");
        if (c) {
            var e = bb.selector.query(c, ".ui-wizard-buttons");
            if (e) {
                var j = bb.selector.query(e, ".ap-icon-help");
                if (j) {
                    bb.html.replaceClass(j, "ap-icon-help", "ap-icon-help-inactive")
                }
                var b = bb.selector.query(e, ".ap-icon-price");
                if (b) {
                    phe.common.hide(b)
                }
            }
        }
    }
    phe.common.hide(f);
    phe.button.hide(h);
    phe.button.hide(k);
    if (g) {
        d = "proxy?pipe=genericWebService&ws=AccessControlWebService&action=resendSVM"
    }
    if (phe.form.isVisible(q)) {
        absa.io.makeRequest(d, function(v) {
            if (!v.errors.length) {
                var w = bb.html.createElementFromString(v.text);
                var u = phe.common.getAttribute(w, "data-status");
                var s = bb.selector.query(q, ".ap-SVM-retries");
                var r = phe.hiddenField.getValue(s);
                var t = 0;
                if (g) {
                    t = phe.common.getAttribute(w, "data-retries") * 1;
                    if (r == "") {
                        phe.hiddenField.setValue(s, t)
                    } else {
                        r++;
                        phe.hiddenField.setValue(s, r)
                    }
                    r = phe.hiddenField.getValue(s)
                }
                if (u == "Processed") {
                    absa.SVM.goToStepOne(q, o)
                } else {
                    if (u == "Processing" && m >= p && t < 4) {
                        n.innerHTML = i;
                        absa.SVM.doCountdown(n, p, i);
                        absa.SVM.pollProcessSVM(q, n, u, i, p, l)
                    } else {
                        if (m < p && u == "Processing") {
                            absa.SVM.showErrorMessage(q, w, "frontEndTimeoutError");
                            phe.common.show(h)
                        } else {
                            if (t > 3 || r == "4") {
                                absa.SVM.showErrorMessage(q, w, "frontEndRetriesExceededError")
                            } else {
                                if (u == "RevertBack") {
                                    absa.SVM.showErrorMessage(q, w, "servicesError");
                                    phe.common.show(k)
                                } else {
                                    absa.SVM.showErrorMessage(q, w, "servicesError");
                                    if (t < 3 && u == "") {} else {
                                        if (t < 3 && u != "Rejected") {
                                            phe.common.show(h)
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        })
    }
};
absa.SVM.doCountdown = function(d, c, b) {
    if (((c * 1) - 1) <= 0) {
        return
    } else {
        c -= 1;
        b -= 1;
        phe.common.setAttribute(d, "data-timeRemaining", b);
        d.innerHTML = b;
        absa.SVM._timer2 = setTimeout(function() {
            absa.SVM.doCountdown(d, c, b)
        }, 1000)
    }
};
absa.SVM.pollProcessSVM = function(h, g, d, c, f, b) {
    var e = {};
    e._timeout = setTimeout(function() {
        c -= f;
        phe.form.setAttribute(h, "data-timeRemaining", c);
        phe.form.setAttribute(h, "data-timeInterval", f);
        absa.form.validateAndSubmit(h)
    }, f * 1000)
};
absa.SVM.goToStepOne = function(m, j) {
    var c;
    if (j) {
        c = bb.selector.queryAncestor(m, ".ap-forceLoadNode")
    }
    var n = bb.selector.queryAncestor(m, "[proxyurl]");
    var h = bb.selector.queryAncestor(m, ".ui-tabBody");
    var d = bb.selector.queryAncestor(m, ".ui-tableBodyRowExpandableExtension");
    var l = bb.selector.queryAncestor(m, ".ui-modalBody[proxyurl]");
    var g = bb.selector.queryAncestor(m, ".ap-gadget-lazyContent");
    if (c) {
        absa.lazyLoadNode(c, true)
    } else {
        if (d && d.getAttribute("dataFileView")) {
            var k = bb.selector.queryAncestor(m, ".ui-form");
            if (k == null) {
                k = bb.selector.query(m, ".ui-form")
            }
            if (k != null) {
                phe.form.setAttribute(k, "trackUnconfirmedChanges", "false");
                k._trackUnconfirmedChanges = false;
                k._changed = false
            }
            phe.tableBodyRow.expandRow(d.previousSibling, phe.tableBodyRowExpandableExtention.getAttribute(d, "dataFileView"), false)
        } else {
            if (n) {
                absa.lazyLoadNode(n, true)
            } else {
                if (h) {
                    phe.tabBody.reload(h)
                } else {
                    if (l) {
                        absa.lazyLoadNode(l, true)
                    } else {
                        if (g) {
                            absa.lazyLoadNode(g, true)
                        }
                    }
                }
            }
        }
    }
    var e = bb.selector.queryAncestor(m, ".ui-wizard");
    if (e) {
        var f = bb.selector.query(e, ".ui-wizard-buttons");
        if (f) {
            var i = bb.selector.query(f, ".ap-icon-help-inactive");
            if (i) {
                bb.html.replaceClass(i, "ap-icon-help-inactive", "ap-icon-help")
            }
            var b = bb.selector.query(f, ".ap-icon-price");
            if (b) {
                phe.common.show(b)
            }
        }
    }
};
absa.SVM.showErrorMessage = function(h, i, g) {
    var b = 0;
    var c = bb.selector.query(h, ".ap-SVM-errorMessageContainer");
    var f = bb.selector.query(h, ".ap-SVM-countDownTimer");
    var d = bb.selector.query(c, ".ap-SVM-frontEndMessage");
    var e = bb.selector.query(c, ".ap-SVM-backEndErrorMessageContainer");
    phe.common.setAttribute(f, "data-timeRemaining", b);
    f.innerHTML = b;
    phe.common.show(c);
    phe.common.hide(e);
    phe.message.hide(d);
    if (g == "frontEndTimeoutError") {
        phe.message.setMessage(d, absa.locale["Common/SVM/Error/FrontEndTimeOut"]);
        phe.message.show(d)
    } else {
        if (g == "frontEndRetriesExceededError") {
            phe.message.setMessage(d, absa.locale["Security/AccessControl/Error/SVMRetriesExceeded"]);
            phe.message.show(d)
        } else {
            e.innerHTML = i.innerHTML;
            phe.common.show(e)
        }
    }
};
absa.SVM.onResendButtonClick = function(c) {
    var e = bb.selector.queryAncestor(c, ".ap-SVM-form");
    var b = absa.SVM.initialTimeRemaining;
    var d = bb.selector.query(e, ".ap-SVM-countDownTimer");
    phe.common.setAttribute(d, "data-timeRemaining", b);
    phe.form.setAttribute(e, "data-timeRemaining", b);
    absa.SVM.updateFormStatus(e, true)
};
absa.SVM.onSendRVNButtonClick = function(b) {
    var c = bb.selector.queryAncestor(b, ".ap-SVM-form");
    absa.SVM.goToStepOne(c)
};
absa.SVM.onCancelButtonClick = function(d) {
    var f = bb.selector.queryAncestor(d, "form");
    if (f) {
        f.reset();
        if (f._trackUnconfirmedChanges) {
            f._changed = false
        }
    }
    var b = bb.selector.queryAncestor(d, ".ui-modal");
    if (b) {
        phe.modal.hideModal()
    } else {
        var e = bb.selector.queryAncestor(d, ".p-gadget");
        var c = bb.getControllerFromView(e);
        if (c) {
            c.minimize();
            e.focus()
        }
    }
};
absa.TVM = absa.TVM || {};
absa.TVM.initTVM = function(b) {
    absa.TVM.loadInitialTime(b);
    if (!b) {
        gadgets.pubsub.subscribe("TVM-form-loaded", function(c) {
            absa.TVM.updateFormStatus(c)
        })
    }
};
absa.TVM.loadInitialTime = function(c) {
    var b = "proxy?pipe=genericEmptyResponse&xslFile=accessControl/TVMTimers";
    if (!c) {
        absa.io.makeRequest(b, function(d) {
            if (!d.errors.length) {
                var f = bb.html.createElementFromString(d.text);
                var e = phe.common.getAttribute(f, "data-initialTime");
                if (e) {
                    absa.TVM.initialTimeRemaining = e * 1
                } else {
                    absa.TVM.initialTimeRemaining = 60
                }
            } else {
                absa.TVM.initialTimeRemaining = 60
            }
        })
    }
    absa.TVM.initialTimeRemaining = 60
};
absa.TVM.onProcessTVMFormCallBack = function(d, b, c) {
    absa.TVM.updateFormStatus(d, false, c)
};
absa.TVM.updateFormStatus = function(q, g, r) {
    var p = phe.form.getAttribute(q, "data-timeInterval") * 1;
    var j = phe.form.getAttribute(q, "data-timeRemaining") * 1;
    var n = bb.selector.query(q, ".ap-TVM-countDownTimer");
    var o = phe.form.getAttribute(q, "data-correlationID");
    var l = phe.form.getAttribute(q, "data-cellphone");
    var m = phe.common.getAttribute(n, "data-timeRemaining");
    var f = bb.selector.query(q, ".ap-TVM-errorMessageContainer");
    var i = bb.selector.query(q, ".ap-TVM-resendButton");
    var h = bb.selector.query(q, ".ap-TVM-sendTVNButton");
    var d;
    if (g) {
        if (r) {
            d = "webservice/AccessControlWebService/resendTVM?registration=true&tempSessionId=" + absa.apps.register.sessionID + "&correlationID=" + o
        } else {
            d = "proxy?pipe=genericWebService&ws=AccessControlWebService&action=resendTVM&correlationID=" + o
        }
    } else {
        if (r) {
            d = "webservice/AccessControlWebService/processTVM?registration=true&tempSessionId=" + absa.apps.register.sessionID + "&correlationID=" + o
        } else {
            d = "proxy?pipe=genericWebService&ws=AccessControlWebService&action=processTVM&correlationID=" + o
        }
    }
    if (j > 55) {
        var c = bb.selector.queryAncestor(q, ".ui-wizard");
        var e = bb.selector.query(c, ".ui-wizard-buttons");
        if (e) {
            var b = bb.selector.query(e, ".ap-icon-price");
            if (b) {
                phe.common.hide(b)
            }
            var k = bb.selector.query(e, ".ap-icon-help");
            if (k) {
                bb.html.replaceClass(k, "ap-icon-help", "ap-icon-help-inactive")
            }
        }
    }
    phe.common.hide(f);
    phe.button.hide(i);
    phe.button.hide(h);
    if (phe.form.isVisible(q)) {
        absa.io.makeRequest(d, function(u) {
            if (!u.errors.length) {
                var v = bb.html.createElementFromString(u.text);
                var t = phe.common.getAttribute(v, "data-status");
                var s = 0;
                if (g) {
                    s = phe.common.getAttribute(v, "data-retries") * 1
                }
                if (t == "Processed") {
                    absa.TVM.goToLastStep(q)
                } else {
                    if (t == "Processing" && m >= p && s < 4) {
                        n.innerHTML = j;
                        absa.TVM.doCountdown(n, p, j);
                        absa.TVM.pollProcessTVM(q, n, t, j, p, l)
                    } else {
                        if (m < p && t == "Processing") {
                            absa.TVM.showErrorMessage(q, v, "frontEndTimeoutError");
                            phe.button.show(i)
                        } else {
                            if (s > 3) {
                                absa.TVM.showErrorMessage(q, v, "frontEndRetriesExceededError")
                            } else {
                                if (t == "RevertBack") {
                                    absa.TVM.showErrorMessage(q, v, "servicesError");
                                    phe.button.show(h)
                                } else {
                                    absa.TVM.showErrorMessage(q, v, "servicesError");
                                    if (s < 3 && t != "Rejected" && t != "") {
                                        phe.button.show(i)
                                    }
                                }
                            }
                        }
                    }
                }
            }
        })
    }
};
absa.TVM.goToLastStep = function(j) {
    var d = bb.selector.queryAncestor(j, ".ui-wizard");
    var f = phe.wizard.getStepsCount(d) - 1;
    var i = bb.selector.queryAll(d, ".ui-wizard-body");
    var c = i[f - 1];
    var h = bb.selector.query(c, ".ui-form");
    var k = bb.selector.query(d, ".ui-wizard-body-selected");
    var g = k.previousSibling;
    phe.wizard.selectStep(g);
    bb.html.fireEvent(h, "submit", true, true);
    var e = bb.selector.query(d, ".ui-wizard-buttons");
    if (e) {
        var b = bb.selector.query(e, ".ap-icon-price");
        if (b) {
            phe.common.show(b)
        }
    }
};
absa.TVM.doCountdown = function(d, c, b) {
    if (((c * 1) - 1) <= 0) {
        return
    } else {
        c -= 1;
        b -= 1;
        phe.common.setAttribute(d, "data-timeRemaining", b);
        d.innerHTML = b;
        absa.TVM._timer2 = setTimeout(function() {
            absa.TVM.doCountdown(d, c, b)
        }, 1000)
    }
};
absa.TVM.pollProcessTVM = function(h, g, d, c, f, b) {
    var e = {};
    e._timeout = setTimeout(function() {
        c -= f;
        phe.form.setAttribute(h, "data-timeRemaining", c);
        phe.form.setAttribute(h, "data-timeInterval", f);
        absa.form.validateAndSubmit(h)
    }, f * 1000)
};
absa.TVM.showErrorMessage = function(h, i, g) {
    var b = 0;
    var c = bb.selector.query(h, ".ap-TVM-errorMessageContainer");
    var f = bb.selector.query(h, ".ap-TVM-countDownTimer");
    var d = bb.selector.query(c, ".ap-TVM-frontEndMessage");
    var e = bb.selector.query(c, ".ap-TVM-backEndErrorMessageContainer");
    phe.common.setAttribute(f, "data-timeRemaining", b);
    f.innerHTML = b;
    phe.common.show(c);
    if (g == "frontEndTimeoutError") {
        phe.message.setMessage(d, absa.locale["Common/TVM/Error/FrontEndTimeOut"]);
        phe.common.hide(e);
        phe.message.show(d)
    } else {
        if (g == "frontEndRetriesExceededError") {
            phe.message.setMessage(d, absa.locale["Security/AccessControl/Error/TVMResendsExceeded"]);
            phe.common.hide(e);
            phe.message.show(d)
        } else {
            e.innerHTML = i.innerHTML;
            phe.common.show(e);
            phe.message.hide(d)
        }
    }
};
absa.TVM.onResendButtonClick = function(c, f) {
    var e = bb.selector.queryAncestor(c, ".ap-TVM-form");
    var b = absa.TVM.initialTimeRemaining;
    var d = bb.selector.query(e, ".ap-TVM-countDownTimer");
    phe.common.setAttribute(d, "data-timeRemaining", b);
    phe.form.setAttribute(e, "data-timeRemaining", b);
    absa.TVM.updateFormStatus(e, true, f)
};
absa.TVM.onSendTVNButtonClick = function(b) {
    var c = bb.selector.queryAncestor(b, ".ap-TVM-form");
    absa.TVM.goToLastStep(c)
};
absa.TVM.onCancelButtonClick = function(c) {
    var b = bb.selector.queryAncestor(c, ".ui-wizard");
    phe.wizard.selectStepAbsolute(b, 0);
    absa.TVM.removeTVMStep(c)
};
absa.TVM.removeTVMStep = function(e) {
    var c = bb.selector.queryAncestor(e, ".ui-wizard");
    if (c) {
        var b = bb.selector.query(c, ".ui-wizard-body--TVN");
        var d = bb.selector.query(c, ".ui-wizard-head--TVN");
        if (d) {
            d.parentNode.removeChild(d)
        }
        if (b) {
            b.parentNode.removeChild(b)
        }
    }
};
absa.intercept = absa.intercept || {};
absa.intercept.linkDelinkDevices = absa.intercept.linkDelinkDevices || {};
absa.intercept.linkDelinkDevices.nickname = null;
absa.intercept.linkDelinkDevices.manufacturer = null;
absa.intercept.linkDelinkDevices.model = null;
absa.intercept.linkDelinkDevices.IMEISerialNumber = null;
absa.intercept.clientResidentType = "";
absa.intercept.checkDeviceAlert = function() {
    var b = "proxy?pipe=genericWebservice&ws=PortfolioWebService&action=getLinkDeLinkDevices&mode=checkPendingDevices";
    absa.io.makeRequest(b, function(f) {
        if (!f.errors.length) {
            var e = bb.html.createElementFromString(f.text);
            if (e) {
                absa.intercept.linkDelinkDevices.nickname = phe.common.getAttribute(e, "nickname");
                absa.intercept.linkDelinkDevices.manufacturer = phe.common.getAttribute(e, "manufacturer");
                absa.intercept.linkDelinkDevices.model = phe.common.getAttribute(e, "model");
                absa.intercept.linkDelinkDevices.IMEISerialNumber = phe.common.getAttribute(e, "IMEISerialNumber");
                var c = document.getElementById("linkDelinkDevicesModal");
                phe.modal.showModal(0.5, c, document.body, true);
                var d = bb.selector.queryAll(window.document, ".ap-linkDelinkDevice-deviceCount");
                phe.inputReadOnlyText.setValue(d[1], phe.common.getAttribute(e, "iPendingDevices"))
            } else {
                absa.freeCover.init()
            }
        }
    })
};
absa.intercept.onLinkDeviceClick = function() {
    var b = "proxy?pipe=genericEmptyResponse&xslFile=LinkDelinkDevices/linkDevice&fromView=linkOnLogin&step=1&nickname=" + encodeURIComponent(absa.intercept.linkDelinkDevices.nickname) + "&manufacturer=" + encodeURIComponent(absa.intercept.linkDelinkDevices.manufacturer) + "&model=" + encodeURIComponent(absa.intercept.linkDelinkDevices.model) + "&IMEISerialNumber=" + encodeURIComponent(absa.intercept.linkDelinkDevices.IMEISerialNumber);
    absa.modal.loadModal(b, absa.locale["Portfolio/LinkDelinkDevices/Label/LinkDeviceToProfile"], null, null)
};
absa.intercept.init = function() {
    if ((absa.ENABLEUSSDMODALPREALERT == "true") && (absa.USSDMODALPREALERTSHOWN == false)) {
        var b = absa.USSDMODALPREALERTCLIENTTYPE;
        var d = false;
        for (var c = 0; c < b.length; c++) {
            if (b[c].toLowerCase() == absa.CLIENTTYPE.toLowerCase()) {
                d = true;
                break
            }
        }
        if (d == true) {
            if (absa.ENABLEUSSDMODALFORRVNVIASMSONLY == "true") {
                var e = "proxy?pipe=genericWebservice&ws=NotificationWebService&action=viewOnlineBankingAlert&view=getNotificationMethod";
                absa.io.makeRequest(e, function(h) {
                    if (!h.errors.length) {
                        var g = bb.html.createElementFromString(h.text);
                        var i = bb.selector.query(g, ".ap-notification-alertMethod");
                        sNotificationAlertMethod = phe.hiddenField.getValue(i);
                        var f = false;
                        if (sNotificationAlertMethod.toLowerCase().charAt(0) == "s" || sNotificationAlertMethod.toLowerCase().charAt(0) == "c") {
                            f = true
                        }
                        if (f == true) {
                            absa.intercept.showUssdModalPreAlert()
                        } else {
                            absa.intercept.checkIfTransactionalUser()
                        }
                    }
                })
            } else {
                absa.intercept.showUssdModalPreAlert()
            }
        } else {
            absa.intercept.checkIfTransactionalUser()
        }
    } else {
        absa.intercept.checkIfTransactionalUser()
    }
};
absa.intercept.checkIfTransactionalUser = function() {
    if (absa.TRANSACTIONALUSER == "false") {
        var b = "proxy?pipe=genericWebservice&ws=PortfolioWebService&action=processTransactionalSnooze&actionType=E&mode=enquire";
        absa.io.makeRequest(b, function(e) {
            var h = bb.html.createElementFromString(e.text);
            var d = bb.selector.query(h, ".ap-processTransactionalSnooze-result");
            var c = phe.hiddenField.getValue(d);
            if (c == "true") {
                var g = "proxy?pipe=genericEmptyResponse&xslFile=NonTransactional/convert-step1&mode=modal";
                var f = absa.locale["NonTransactional/General/Label/AbsaOnlineConversion"];
                absa.modal.loadModal(g, f)
            } else {
                absa.intercept.loadUSSDModal()
            }
        })
    } else {
        absa.intercept.loadUSSDModal()
    }
};
absa.intercept.loadUSSDModal = function() {
    var b = "proxy?pipe=genericEmptyResponse&xslFile=intercept/ussdModal&mode=checkIfUssdModalIsEnabled";
    absa.io.makeRequest(b, function(d) {
        if (!d.errors.length) {
            var c = bb.html.createElementFromString(d.text);
            if (c.innerHTML == "true") {
                absa.intercept.showUssdModal()
            } else {
                absa.intercept.checkDeviceAlert()
            }
        } else {
            absa.intercept.checkDeviceAlert()
        }
    })
};
absa.intercept.showUssdModalPreAlert = function() {
    var b = "proxy?pipe=genericEmptyResponse&xslFile=intercept/ussdModalPreAlert";
    absa.io.makeRequest(b, function(f) {
        if (!f.errors.length) {
            var e = bb.html.createElementFromString(f.text);
            var d = bb.selector.query(e, ".tmpInterceptBody");
            var c = d.value;
            var g = bb.selector.query(e, ".interceptBody");
            g.innerHTML = c;
            phe.modal.showModal(0.5, e, document.body, true)
        } else {
            absa.intercept.checkDeviceAlert()
        }
    })
};
absa.intercept.showUssdModal = function() {
    var b = "proxy?pipe=genericEmptyResponse&xslFile=intercept/ussdModal&mode=showUssdModal";
    absa.io.makeRequest(b, function(f) {
        if (!f.errors.length) {
            var e = bb.html.createElementFromString(f.text);
            var d = bb.selector.query(e, ".tmpInterceptBody");
            var c = d.value;
            var g = bb.selector.query(e, ".interceptBody");
            g.innerHTML = c;
            phe.modal.showModal(0.5, e, document.body, true)
        } else {
            absa.intercept.checkDeviceAlert()
        }
    })
};
absa.intercept.showUssdModalOLD = function() {
    var b = "proxy?pipe=genericEmptyResponse&xslFile=intercept/ussdModal&mode=showUssdModal";
    absa.io.makeRequest(b, function(d) {
        if (!d.errors.length) {
            var c = bb.html.createElementFromString(d.text);
            phe.modal.showModal(0.5, c, document.body, true)
        } else {
            absa.intercept.checkDeviceAlert()
        }
    })
};
absa.intercept.onUnderstandProcessButtonClick = function() {
    phe.modal.hideModal();
    absa.intercept.checkDeviceAlert()
};
absa.intercept.onUssdModalPreAlertClose = function() {
    absa.USSDMODALPREALERTSHOWN = true;
    absa.intercept.init()
};
absa.intercept.onAddBeneficiaryLinkClick = function() {
    absa.intercept.goToAddBeneficiary()
};
absa.intercept.onAddBeneficiaryButtonClick = function() {
    absa.intercept.goToAddBeneficiary()
};
absa.intercept.goToAddBeneficiary = function() {
    phe.modal.hideModal();
    gadgets.pubsub.publish("goTo:payments/mainBeneficiaries/addBeneficiary")
};
var absa = window.absa || {};
absa.creditLimit = absa.creditLimit || {};
absa.creditLimit.globals = absa.creditLimit.globals || {};
absa.creditLimit.globals.dCreditMaxLimit = 0;
absa.creditLimit.creditLimitCheck = function() {
    if (absa.creditLimit.globals.dCreditMaxLimit < -1) {} else {
        if (absa.creditLimit.globals.dCreditMaxLimit == 0) {
            absa.io.makeRequest("proxy?pipe=genericWebservice&ws=CreditLimitsWebService&action=getCreditLimits&view=getMaxLimit", function(b) {
                if (!b.errors.length) {
                    try {
                        var d = JSONRequest.parse(absa.util.stripTag(b.text));
                        absa.creditLimit.globals.dCreditMaxLimit = parseFloat(d.maxLimit);
                        if (absa.creditLimit.globals.dCreditMaxLimit > 0) {
                            gadgets.pubsub.publish("showHide:offersSpoofContainer", "SHOW");
                            absa.index.plInitialised = 1;
                            phe.common.show(document.getElementById("gadget-placeholder-l2-g3010136"));
                            phe.common.show(document.getElementById("gadget-placeholder-l5-g3010136"))
                        }
                    } catch (c) {
                        absa.creditLimit.globals.dCreditMaxLimit = 0
                    }
                }
                setTimeout(function() {
                    absa.creditLimit.updateBalancesAndLimits(absa.creditLimit.globals.dCreditMaxLimit)
                }, 2000)
            })
        } else {
            setTimeout(function() {
                absa.creditLimit.updateBalancesAndLimits(absa.creditLimit.globals.dCreditMaxLimit)
            }, 2000)
        }
        if (absa.creditLimit.globals.dCreditMaxLimit == 0) {
            absa.creditLimit.globals.dCreditMaxLimit = -1
        }
    }
};
absa.creditLimit.updateBalancesAndLimits = function(b) {
    if (b == null || isNaN(b)) {
        b = 0
    }
    absa.index.refreshUpdaters(false);
    absa.util.observer.publish("load-creditLimits-maxLimit", b)
};
absa.freeCover = absa.freeCover || {};
absa.freeCover.freeCoverLife = absa.freeCover.freeCoverLife || {};
absa.freeCover.init = function() {
    absa.freeCover.freeCoverLifeApply()
};
absa.freeCover.onCheckClick = function() {
    var d = "proxy?pipe=genericWebservice&ws=ApplyForNewPolicyWebService&action=freeCoverStatus&status=D";
    var b = false;
    var c = "";
    absa.io.makeRequest(d, function(g) {
        if (!g.errors.length) {
            var h = bb.html.createElementFromString(g.text);
            if (bb.html.hasClass(h, "ap-applyFreeCoverDiv-Status")) {
                var e = bb.selector.queryAll(h, ".ap-applyFreeCover-Status");
                if (e.length > 0) {
                    for (var f = 0; f < e.length; f++) {
                        c = phe.hiddenField.getValue(e[f])
                    }
                }
            }
        }
    })
};
absa.freeCover.freeCoverLifeApply = function() {
    var c = absa.FREECOVER_LIMIT;
    var g = absa.CLIENTTYPE;
    if (g == "I" || g == "S") {
        var h = absa.locale["AFS/ApplyFreeCover/Label/ImformationMsg"];
        var f = "proxy?pipe=genericWebservice&ws=ApplyForNewPolicyWebService&action=getFreeCoverStatus";
        var b = false;
        var d;
        var i;
        var e = c;
        absa.io.makeRequest(f, function(l) {
            if (!l.errors.length) {
                var n = bb.html.createElementFromString(l.text);
                if (bb.html.hasClass(n, "ap-applyFreeCoverDiv-Status")) {
                    var m = bb.selector.query(n, ".ap-applyFreeCover-Status");
                    var j = bb.selector.query(n, ".ap-applyFreeCover-countFreeCoverApplied");
                    if (j) {
                        e = phe.hiddenField.getValue(j)
                    }
                    if (m) {
                        d = phe.hiddenField.getValue(m);
                        if ((Number(c) > 0) && (Number(e) < Number(c))) {
                            if (d == "D" || d == "A" || d == "NA") {} else {
                                var k = bb.selector.query(n, ".ap-applyFreeCover-freeCoverLimit");
                                phe.hiddenField.setValue(k, c);
                                absa.modal.loadModal("proxy?pipe=genericEmptyResponse&xslFile=freecover/freeCover", h, "", "");
                                absa.freeCover.hideModalPrint();
                                absa.freeCover.hideModalClose()
                            }
                        }
                    }
                }
            }
        })
    }
};
absa.freeCover.hideModalPrint = function() {
    var b = bb.selector.query(window.document, ".ui-modal-printButton");
    phe.Element.prototype.setAttribute(b, "class", "ui-modal-printButton ap-common-hide")
};
absa.freeCover.hideModalClose = function() {
    var b = bb.selector.query(window.document, ".ui-modal-closeButton");
    phe.Element.prototype.setAttribute(b, "class", "ui-modal-closeButton ap-common-hide")
};
absa.freeCover.onInceptionClick = function() {
    phe.modal.hideModal();
    gadgets.pubsub.publish("goTo:apply/insurance/applyInsurance", {
        productType: "Free"
    })
};
absa.callMeBack = absa.callMeBack || {};
absa.callMeBack.selectTypeOfQuery = function(e, b, d) {
    var c = b;
    var d = d;
    absa.modal.loadModal("proxy?pipe=genericWebService&ws=ManagePolicyDetailsWebService&action=getPortfolioInfo&productType=" + d + "&queryType=" + c, absa.locale["AFS/General/Label/CallMeBack"], "", "");
    absa.callMeBack.hideModalPrint()
};
absa.callMeBack.onCallMeBackWills = function(b) {
    absa.modal.loadModal("proxy?pipe=genericWebService&ws=ManagePolicyDetailsWebService&action=getPortfolioInfo&view=will", absa.locale["AFS/General/Label/CallMeBack"], "", "");
    absa.callMeBack.hideModalPrint()
};
absa.callMeBack.hideModalPrint = function() {
    var b = bb.selector.query(window.document, ".ui-modal-printButton");
    phe.Element.prototype.setAttribute(b, "class", "ui-modal-printButton ap-common-hide")
};
absa.callMeBack.selectType = function(f) {
    var d = bb.selector.queryAncestor(f, ".ap-callMeBack-Root");
    var g = bb.selector.query(d, ".ap-callMeBack-cellTextBox");
    var c = phe.textBox.getValue(g);
    var b = bb.selector.query(d, ".ap-callMeBack-emailTextBox");
    var e = phe.select.getValue(f);
    if ("Telephone" == e) {
        phe.textBox.setAttribute(g, "required", "true");
        phe.textBox.setAttribute(b, "required", "false")
    } else {
        phe.textBox.setAttribute(g, "required", "false");
        phe.textBox.setAttribute(b, "required", "true")
    }
};
absa.simSwopHold = absa.simSwopHold || {};
absa.simSwopHold.initSimSwopHold = function() {
    gadgets.pubsub.subscribe("simSwopHold-form-loaded", function(b) {
        absa.simSwopHold.updateButtons(b)
    })
};
absa.simSwopHold.updateButtons = function(f) {
    var b = bb.selector.queryAncestor(f, ".ui-wizard");
    if (b) {
        var e = bb.selector.query(b, ".ui-wizard-buttons");
        if (e) {
            var c = bb.selector.query(e, ".ap-icon-help");
            if (c) {
                bb.html.replaceClass(c, "ap-icon-help", "ap-icon-help-inactive")
            }
            var d = bb.selector.query(e, ".ap-icon-price");
            if (d) {
                phe.common.hide(d)
            }
        }
    }
};
absa.advisorService = absa.advisorService || {};
var onReturn;
absa.advisorService.hideModalPrint = function() {
    var b = bb.selector.query(window.document, ".ui-modal-printButton");
    phe.Element.prototype.setAttribute(b, "class", "ui-modal-printButton ap-common-hide")
};
absa.advisorService.selectAdvisorForNewbusiness = function(f, b) {
    onReturn = f;
    var e = ".ap-applyNewBusinessRA-referenceNumber";
    var d = bb.selector.query(window.document, e);
    var c = bb.selector.query(window.document, ".ap-applyNewBusinessRA-withCalculator");
    absa.modal.loadModal("proxy?pipe=genericEmptyResponse&xslFile=abcap/ApplyNewBusinessForRA/advisorServiceRA&actionFlag=" + f + "&referenceNumber=" + d.value + "&withCalculator=" + c.value, absa.locale["ABCAP/General/Label/Advisor"], "", "")
};
absa.advisorService.selectAdvisorForRAaddition = function(v, am) {
    onReturn = am;
    var t = "proxy?pipe=genericEmptyResponse&xslFile=abcap/ApplyNewBusinessForRA/advisorServiceRA&actionFlag=addition";
    var T = "";
    var y = bb.selector.query(v, ".ap-additionForRA-rootForm");
    var aC = bb.selector.query(y, ".ap-additionForRA-completionStatus");
    var X = bb.selector.query(y, ".ap-additionForRA-screenId");
    var ay = bb.selector.query(y, ".ap-additionRA-referenceNumber");
    var af = bb.selector.query(y, ".ap-additionRA-policyNumber");
    var av = bb.selector.query(y, ".ap-additionRA-clientName");
    var az = bb.selector.query(y, ".ap-additionForRA-clientNumber");
    var au = bb.selector.query(y, ".ap-additionForRA-stockAccountNum");
    var aA = bb.selector.query(y, ".ap-additionForRA-portfolioName");
    var aa = bb.selector.query(y, ".ap-additionForRA-portfolioCode");
    var J = phe.hiddenField.getValue(aC);
    var G = phe.hiddenField.getValue(X);
    var w = phe.hiddenField.getValue(ay);
    var Z = phe.hiddenField.getValue(az);
    var r = phe.hiddenField.getValue(au);
    var q = phe.hiddenField.getValue(aA);
    var aE = phe.hiddenField.getValue(aa);
    t = t + "&screenId=" + G + "&referenceNumber=" + w + "&isComplete=" + J + "&clientNumber=" + Z + "&stockAccountNum=" + r + "&portfolioName=" + q + "&fundCode=" + aE;
    var ax = "false";
    var ap = "true";
    t = t + "&regularContribution=" + ax + "&lumpsumContribution=" + ap;
    if (G == 1) {
        var F = phe.hiddenField.getValue(av);
        var z = phe.hiddenField.getValue(af);
        t = t + "&clientName=" + F + "&policyNumber=" + z;
        var E = "false";
        var b = "false";
        var aw = "";
        var ac = "0";
        var p = "";
        var j = "";
        var ao = "";
        var aB = "";
        var k = "";
        var aF = "";
        var h = "";
        if (ap == "true") {
            var u = bb.selector.query(y, ".ap-additionRA-paymentMethodRadio");
            var R = phe.radioGroup.getValue(u);
            var Y = bb.selector.query(y, ".ap-additionRA-sourceOfFunds");
            var B = bb.selector.query(y, ".ap-additionRA-Amount");
            var ab = bb.selector.query(y, ".ap-additionRA-beneficiaryReference");
            var at = bb.selector.query(y, ".ap-additionRA-paymntDt");
            aw = phe.select.getValue(Y);
            ac = phe.textBox.getValue(B);
            p = phe.inputReadOnlyText.getValue(at);
            sBeneficiaryReference = phe.inputReadOnlyText.getValue(ab);
            t = t + "&sourceOfFunds=" + aw + "&lumpsumAmount=" + ac + "&paymentDebitDate=" + p + "&beneficiaryReference=" + sBeneficiaryReference;
            if (R == "OnceOff") {
                E = "true";
                var l = bb.selector.query(y, ".ap-additionRA-myReference");
                var ak = bb.selector.query(y, ".ap-additionRA-accountToBeDebitedLinked");
                j = phe.textBox.getValue(l);
                ao = phe.select.getValue(ak);
                if (ao != "") {
                    var A = ao.split(" - ");
                    aB = A[0];
                    k = A[1]
                }
                aF = "ABSA";
                h = "632005";
                t = t + "&myReference=" + j + "&accountToBeDebitedOnceOffPayment=" + ao + "&accountTypeOnceOffPayment=" + aB + "&accountNumberOnceOffPayment=" + k + "&bankNameOnceOffPayment=" + aF + "&branchCodeOnceOffPayment=" + h + "&methodPaymentOnline=" + E + "&methodPaymentManualDeposit=" + b
            } else {
                if (R == "Manual") {
                    b = "true";
                    t = t + "&methodPaymentOnline=" + E + "&methodPaymentManualDeposit=" + b
                }
            }
        }
    } else {
        if (G == 2) {
            var F = phe.hiddenField.getValue(av);
            var z = phe.hiddenField.getValue(af);
            t = t + "&clientName=" + F + "&policyNumber=" + z;
            var E = "false";
            var b = "false";
            var aw = "";
            var ac = "0";
            var p = "";
            var j = "";
            var ao = "";
            var aB = "";
            var k = "";
            var aF = "";
            var h = "";
            if (ap == "true") {
                var u = bb.selector.query(y, ".ap-additionRA-paymentMethodRadio");
                var R = phe.radioGroup.getValue(u);
                var Y = bb.selector.query(y, ".ap-additionRA-sourceOfFunds");
                var B = bb.selector.query(y, ".ap-additionRA-Amount");
                var ab = bb.selector.query(y, ".ap-additionRA-beneficiaryReference");
                var at = bb.selector.query(y, ".ap-additionRA-paymntDt");
                aw = phe.hiddenField.getValue(Y);
                ac = phe.hiddenField.getValue(B);
                p = phe.hiddenField.getValue(at);
                sBeneficiaryReference = phe.hiddenField.getValue(ab);
                t = t + "&sourceOfFunds=" + aw + "&lumpsumAmount=" + ac + "&paymentDebitDate=" + p + "&beneficiaryReference=" + sBeneficiaryReference;
                if (R == "OnceOff") {
                    E = "true";
                    var l = bb.selector.query(y, ".ap-additionRA-myReference");
                    var ak = bb.selector.query(y, ".ap-additionRA-accountToBeDebitedLinked");
                    j = phe.hiddenField.getValue(l);
                    ao = phe.hiddenField.getValue(ak);
                    if (ao != "") {
                        var A = ao.split(" - ");
                        aB = A[0];
                        k = A[1]
                    }
                    aF = "ABSA";
                    h = "632005";
                    t = t + "&myReference=" + j + "&accountToBeDebitedOnceOffPayment=" + ao + "&accountTypeOnceOffPayment=" + aB + "&accountNumberOnceOffPayment=" + k + "&bankNameOnceOffPayment=" + aF + "&branchCodeOnceOffPayment=" + h + "&methodPaymentOnline=" + E + "&methodPaymentManualDeposit=" + b
                } else {
                    if (R == "Manual") {
                        b = "true";
                        t = t + "&methodPaymentOnline=" + E + "&methodPaymentManualDeposit=" + b
                    }
                }
            }
            var aj = bb.selector.query(y, ".ap-additionRA-quoteDate");
            var an = bb.selector.query(y, ".ap-additionRA-quoteDescription");
            var ae = bb.selector.query(y, ".ap-additionRA-quoteReference");
            var S = bb.selector.query(y, ".ap-additionRA-fundCode");
            var H = bb.selector.query(y, ".ap-additionRA-fundPercentage");
            var al = bb.selector.query(y, ".ap-additionRA-monthlyContributionNetAmount");
            var M = bb.selector.query(y, ".ap-additionRA-lumpsumContributionNetAmount");
            var N = bb.selector.query(y, ".ap-additionRA-annualFee");
            var d = bb.selector.query(y, ".ap-additionRA-initialFee");
            var g = bb.selector.query(y, ".ap-additionRA-platformFee");
            var L = bb.selector.query(y, ".ap-additionRA-presumedReturn");
            var m = bb.selector.query(y, ".ap-additionRA-reduction");
            var ad = bb.selector.query(y, ".ap-additionRA-actualReturn");
            var c = bb.selector.query(y, ".ap-additionRA-investmentPeriod");
            var f = phe.inputReadOnlyText.getValue(aj);
            var o = phe.hiddenField.getValue(an);
            var ag = phe.hiddenField.getValue(ae);
            var P = phe.hiddenField.getValue(S);
            var I = phe.hiddenField.getValue(H);
            var aD = phe.hiddenField.getValue(al);
            var W = phe.hiddenField.getValue(M);
            var U = phe.hiddenField.getValue(N);
            var V = phe.hiddenField.getValue(d);
            var e = phe.hiddenField.getValue(g);
            var O = phe.hiddenField.getValue(L);
            var s = phe.hiddenField.getValue(m);
            var D = phe.hiddenField.getValue(ad);
            var K = phe.hiddenField.getValue(c);
            t = t + "&quotationDate=" + f + "&quoteDescription=" + o + "&quoteReference=" + ag + "&fundPercentage=" + I + "&monthlyContributionNetAmount=" + aD + "&lumpsumContributionNetAmount=" + W + "&annualFee=" + U + "&initialFee=" + V + "&platformFee=" + e + "&presumedReturn=" + O + "&reduction=" + s + "&actualReturn=" + D + "&investmentPeriod=" + K;
            var ar = bb.selector.queryAll(y, ".ap-additionRA-feesDetails");
            for (var C = 0; C < ar.length; C++) {
                var ah = bb.selector.query(ar[C], ".ap-additionRA-categoryId");
                var ai = bb.selector.query(ar[C], ".ap-additionRA-typeId");
                var Q = bb.selector.query(ar[C], ".ap-additionRA-totalPercentage");
                var x = phe.hiddenField.getValue(ah);
                var n = phe.hiddenField.getValue(ai);
                var aq = phe.hiddenField.getValue(Q);
                t = t + "&feesNumber=" + C + "&categoryId=" + x + "&typeId=" + n + "&totalPercentage=" + aq
            }
        }
    }
    absa.modal.loadModal(t, absa.locale["ABCAP/General/Label/Advisor"], "", "");
    absa.advisorService.hideModalPrint()
};
absa.advisorService.selectAdvisorForReview = function(d0, a6) {
    var t = "proxy?pipe=genericEmptyResponse&xslFile=abcap/ApplyNewBusinessForRA/advisorServiceRA&actionFlag=review";
    var b9 = "";
    onReturn = a6;
    var cw;
    var dh = bb.selector.query(d0, ".ap-reviewRA-calculatorForm");
    var B = bb.selector.query(d0, ".ap-reviewRA-calcResultForm");
    var Z = bb.selector.query(d0, ".ap-reviewRA-personalDetails");
    var u = bb.selector.query(d0, ".ap-reviewRA-investmentDetails");
    var bT = bb.selector.query(d0, ".ap-reviewRA-document");
    var eg = bb.selector.query(d0, ".ap-reviewRA-reviewAndAccept");
    if (dh != null) {
        cw = dh
    } else {
        if (B != null) {
            cw = B
        } else {
            if (Z != null) {
                cw = Z
            } else {
                if (u != null) {
                    cw = u
                } else {
                    if (bT != null) {
                        cw = bT
                    } else {
                        if (eg != null) {
                            cw = eg
                        }
                    }
                }
            }
        }
    }
    if (cw != null) {
        var ek = bb.selector.query(cw, ".ap-reviewRA-screenId");
        var en = bb.selector.query(cw, ".ap-reviewRA-withCalculator");
        var a2 = bb.selector.query(cw, ".ap-reviewRA-referenceNumber");
        var ap = bb.selector.query(cw, ".ap-reviewRA-policyNumber");
        var dS = bb.selector.query(cw, ".ap-reviewRA-retirementAgeCalc");
        var b4 = bb.selector.query(cw, ".ap-reviewRA-currentSavingsCalc");
        var o = bb.selector.query(cw, ".ap-reviewRA-currentOtherMonthlyContriCalc");
        var O = bb.selector.query(cw, ".ap-reviewRA-currentValueThisRACalc");
        var v = bb.selector.query(cw, ".ap-reviewRA-lumpsumContributionCalc");
        var aw = bb.selector.query(cw, ".ap-reviewRA-currentAgeCalc");
        var ai = bb.selector.query(cw, ".ap-reviewRA-genderCalc");
        var a4 = bb.selector.query(cw, ".ap-reviewRA-periodPostRetirementCalc");
        var E = bb.selector.query(cw, ".ap-reviewRA-monthlySalaryCalc");
        var aK = bb.selector.query(cw, ".ap-reviewRA-cellPhoneCalc");
        var c0 = bb.selector.query(cw, ".ap-reviewRA-firstNameCalc");
        var dA = bb.selector.query(cw, ".ap-reviewRA-surnameCalc");
        var dn = bb.selector.query(cw, ".ap-reviewRA-emailCalc");
        var dr = bb.selector.query(cw, ".ap-reviewRA-sourceOfIncomeCode");
        var j = bb.selector.query(cw, ".ap-reviewRA-sourceOfIncomeDescription");
        var dp = bb.selector.query(cw, ".ap-reviewRA-sourceOfFundsCode");
        var dy = bb.selector.query(cw, ".ap-reviewRA-sourceOfFundsDescription");
        var aG = bb.selector.query(cw, ".ap-reviewRA-riskFactorCalc");
        var V = bb.selector.query(cw, ".ap-reviewRA-monthlyOtherSavings");
        var ag = bb.selector.query(cw, ".ap-reviewRA-monthlyThisRA");
        var cW = bb.selector.query(cw, ".ap-reviewRA-monthlyTotal");
        var aS = bb.selector.query(cw, ".ap-reviewRA-monthlyTarget");
        var h = bb.selector.query(cw, ".ap-reviewRA-capitalOtherSavings");
        var cv = bb.selector.query(cw, ".ap-reviewRA-capitalThisRA");
        var cz = bb.selector.query(cw, ".ap-reviewRA-capitalShortfall");
        var bz = bb.selector.query(cw, ".ap-reviewRA-jsHiddenGoal");
        var J = bb.selector.query(cw, ".ap-reviewRA-jsHiddenMonthlyContribution");
        var dd = bb.selector.query(cw, ".ap-reviewRA-finalMonthlySal");
        var k = bb.selector.query(cw, ".ap-reviewRA-jsPortfolio");
        var aM = bb.selector.query(cw, ".ap-reviewRA-monthlyOtherSavingsPer");
        var bg = bb.selector.query(cw, ".ap-reviewRA-monthlyThisRAPer");
        var bq = bb.selector.query(cw, ".ap-reviewRA-monthlyTotalPer");
        var ax = bb.selector.query(cw, ".ap-reviewRA-monthlyTargetPer");
        var q = bb.selector.query(cw, ".ap-reviewRA-timeToRetire");
        var af = bb.selector.query(cw, ".ap-reviewRA-capitalThisRAPlus");
        var ad = bb.selector.query(cw, ".ap-reviewRA-capitalThisRAMinus");
        var ak = bb.selector.query(cw, ".ap-reviewRA-interestNACAExpected");
        var ei = bb.selector.query(cw, ".ap-reviewRA-clientNumber");
        var bp = bb.selector.query(cw, ".ap-reviewRA-stockAccountNo");
        var bM = bb.selector.query(cw, ".ap-reviewRA-clientCasaRefNo");
        var p = bb.selector.query(cw, ".ap-reviewRA-clientCasaResult");
        var bB = bb.selector.query(cw, ".ap-reviewRA-initials");
        var c = bb.selector.query(cw, ".ap-reviewRA-clientNationality");
        var cf = bb.selector.query(cw, ".ap-reviewRA-clientType");
        var cg = bb.selector.query(cw, ".ap-reviewRA-title");
        var dw = bb.selector.query(cw, ".ap-reviewRA-gender");
        var f = bb.selector.query(cw, ".ap-reviewRA-firstName");
        var c7 = bb.selector.query(cw, ".ap-reviewRA-surname");
        var aQ = bb.selector.query(cw, ".ap-reviewRA-dateOfBirthCif");
        var r = bb.selector.query(cw, ".ap-reviewRA-typeOfIdentity");
        var d = bb.selector.query(cw, ".ap-reviewRA-identityNumber");
        var b7 = bb.selector.query(cw, ".ap-reviewRA-taxNumber");
        var a0 = bb.selector.query(cw, ".ap-reviewRA-telephoneNumber");
        var dx = bb.selector.query(cw, ".ap-reviewRA-cellphoneNumber");
        var a7 = bb.selector.query(cw, ".ap-reviewRA-emailAddress");
        var bY = bb.selector.query(cw, ".ap-reviewRA-maritalStatus");
        var av = bb.selector.query(cw, ".ap-reviewRA-countryOfOrigin");
        var cI = bb.selector.query(cw, ".ap-reviewRA-countryOfResidence");
        var co = bb.selector.query(cw, ".ap-reviewRA-communicationLanguage");
        var dX = bb.selector.query(cw, ".ap-reviewRA-preferredNotificationMethod");
        var R = bb.selector.query(cw, ".ap-reviewRA-marketingConsent");
        var bG = bb.selector.query(cw, ".ap-reviewRA-marketingChannels");
        var cA = bb.selector.query(cw, ".ap-reviewRA-postalAddressLine1");
        var cy = bb.selector.query(cw, ".ap-reviewRA-postalAddressLine2");
        var aH = bb.selector.query(cw, ".ap-reviewRA-postalCity");
        var bl = bb.selector.query(cw, ".ap-reviewRA-postalCode");
        var cC = bb.selector.query(cw, ".ap-reviewRA-postalSuburb");
        var aC = bb.selector.query(cw, ".ap-reviewRA-residentialAddressLine1");
        var aB = bb.selector.query(cw, ".ap-reviewRA-residentialAddressLine2");
        var cY = bb.selector.query(cw, ".ap-reviewRA-residentialCity");
        var D = bb.selector.query(cw, ".ap-reviewRA-residentialPostalCode");
        var ae = bb.selector.query(cw, ".ap-reviewRA-residentialSuburb");
        var ec = phe.hiddenField.getValue(ek);
        var bP = phe.hiddenField.getValue(en);
        var az = phe.hiddenField.getValue(ap);
        var ej = phe.hiddenField.getValue(a2);
        if (ec == "1") {
            var dV = bb.selector.query(cw, ".ap-reviewRA-cellNumberCif");
            var cF = bb.selector.query(cw, ".ap-reviewRA-emailAddressCif");
            var U = phe.textBox.getValue(dS);
            var ba = phe.textBox.getValue(b4);
            var l = phe.textBox.getValue(o);
            var de = phe.inputReadOnlyText.getValue(O);
            var b8 = phe.textBox.getValue(v);
            var cT = phe.textBox.getValue(aw);
            var ah = phe.radioGroup.getValue(ai);
            var W = phe.textBox.getValue(a4);
            var aW = phe.textBox.getValue(E);
            var ca = phe.inputReadOnlyText.getValue(c0);
            var bI = phe.inputReadOnlyText.getValue(dA);
            var bD = phe.hiddenField.getValue(dV);
            var a5 = phe.hiddenField.getValue(cF);
            var M = "";
            var y = "";
            if (bD != "") {
                M = bD
            } else {
                M = phe.textBox.getValue(aK)
            }
            if (a5 != "") {
                y = a5
            } else {
                y = phe.textBox.getValue(dn)
            }
            t = t + "&screenId=" + ec + "&withCalculator=" + bP + "&referenceNumber=" + ej + "&policyNumber=" + az + "&retirementAgeCalc=" + U + "&currentSavingsCalc=" + ba + "&currentOtherMonthlyContriCalc=" + l + "&currentValueThisRACalc=" + de + "&lumpsumContributionCalc=" + b8 + "&currentAgeCalc=" + cT + "&genderCalc=" + ah + "&periodPostRetirementCalc=" + W + "&monthlySalaryCalc=" + aW + "&cellPhoneCalc=" + M + "&firstNameCalc=" + ca + "&surnameCalc=" + bI + "&emailCalc=" + y + "&gender=" + ah + "&firstName=" + ca + "&surname=" + bI + "&cellphoneNumber=" + M + "&emailAddress=" + y
        } else {
            if (ec == "2") {
                var U = phe.hiddenField.getValue(dS);
                var ba = phe.hiddenField.getValue(b4);
                var l = phe.hiddenField.getValue(o);
                var de = phe.hiddenField.getValue(O);
                var b8 = phe.hiddenField.getValue(v);
                var cT = phe.hiddenField.getValue(aw);
                var ah = phe.hiddenField.getValue(ai);
                var W = phe.hiddenField.getValue(a4);
                var aW = phe.hiddenField.getValue(E);
                var ca = phe.hiddenField.getValue(c0);
                var bI = phe.hiddenField.getValue(dA);
                var M = phe.hiddenField.getValue(aK);
                var y = phe.hiddenField.getValue(dn);
                var c1 = phe.hiddenField.getValue(aG);
                var dk = phe.hiddenField.getValue(V);
                var cU = phe.hiddenField.getValue(ag);
                var c4 = phe.hiddenField.getValue(cW);
                var dz = phe.hiddenField.getValue(aS);
                var cQ = phe.hiddenField.getValue(h);
                var an = phe.hiddenField.getValue(cv);
                var be = phe.hiddenField.getValue(af);
                var d3 = phe.hiddenField.getValue(ad);
                var em = phe.hiddenField.getValue(ak);
                var b2 = phe.hiddenField.getValue(cz);
                var bH = phe.hiddenField.getValue(bz);
                var br = phe.hiddenField.getValue(J);
                var X = bb.selector.query(cw, ".ap-reviewRA-finalMonthlySal-hidden");
                var aN = bb.selector.query(cw, ".ap-reviewRA-jsPortfolioHidden");
                var bt = phe.hiddenField.getValue(X);
                var cH = phe.hiddenField.getValue(aN);
                var aA = phe.hiddenField.getValue(aM);
                var aZ = phe.hiddenField.getValue(bg);
                var C = phe.hiddenField.getValue(bq);
                var Y = phe.hiddenField.getValue(ax);
                var dg = phe.hiddenField.getValue(q);
                t = t + "&screenId=" + ec + "&withCalculator=" + bP + "&referenceNumber=" + ej + "&policyNumber=" + az + "&retirementAgeCalc=" + U + "&currentSavingsCalc=" + ba + "&currentOtherMonthlyContriCalc=" + l + "&currentValueThisRACalc=" + de + "&lumpsumContributionCalc=" + b8 + "&currentAgeCalc=" + cT + "&genderCalc=" + ah + "&periodPostRetirementCalc=" + W + "&monthlySalaryCalc=" + aW + "&cellPhoneCalc=" + M + "&firstNameCalc=" + ca + "&surnameCalc=" + bI + "&emailCalc=" + y + "&gender=" + ah + "&firstName=" + ca + "&surname=" + bI + "&cellphoneNumber=" + M + "&emailAddress=" + y + "&riskFactorCalc=" + c1 + "&monthlyOtherSavings=" + dk + "&monthlyThisRA=" + cU + "&monthlyTotal=" + c4 + "&monthlyTarget=" + dz + "&capitalOtherSavings=" + cQ + "&capitalThisRA=" + an + "&capitalThisRAPlus=" + be + "&capitalThisRAMinus=" + d3 + "&interestNACAExpected=" + em + "&capitalShortfall=" + b2 + "&jsHiddenGoal=" + bH + "&jsHiddenMonthlyContribution=" + br + "&finalMonthlySal=" + bt + "&jsPortfolio=" + cH + "&monthlyOtherSavingsPer=" + aA + "&monthlyThisRAPer=" + aZ + "&monthlyTotalPer=" + C + "&monthlyTargetPer=" + Y + "&timeToRetire=" + dg
            } else {
                if (ec == "3") {
                    var U = phe.hiddenField.getValue(dS);
                    var ba = phe.hiddenField.getValue(b4);
                    var l = phe.hiddenField.getValue(o);
                    var de = phe.hiddenField.getValue(O);
                    var b8 = phe.hiddenField.getValue(v);
                    var cT = phe.hiddenField.getValue(aw);
                    var ah = phe.hiddenField.getValue(ai);
                    var W = phe.hiddenField.getValue(a4);
                    var aW = phe.hiddenField.getValue(E);
                    var ca = phe.hiddenField.getValue(c0);
                    var bI = phe.hiddenField.getValue(dA);
                    var M = phe.hiddenField.getValue(aK);
                    var y = phe.hiddenField.getValue(dn);
                    var c1 = phe.hiddenField.getValue(aG);
                    var dk = phe.hiddenField.getValue(V);
                    var cU = phe.hiddenField.getValue(ag);
                    var c4 = phe.hiddenField.getValue(cW);
                    var dz = phe.hiddenField.getValue(aS);
                    var cQ = phe.hiddenField.getValue(h);
                    var an = phe.hiddenField.getValue(cv);
                    var be = phe.hiddenField.getValue(af);
                    var d3 = phe.hiddenField.getValue(ad);
                    var em = phe.hiddenField.getValue(ak);
                    var b2 = phe.hiddenField.getValue(cz);
                    var bH = phe.hiddenField.getValue(bz);
                    var br = phe.hiddenField.getValue(J);
                    var bt = phe.hiddenField.getValue(dd);
                    var cH = phe.hiddenField.getValue(k);
                    var aA = phe.hiddenField.getValue(aM);
                    var aZ = phe.hiddenField.getValue(bg);
                    var C = phe.hiddenField.getValue(bq);
                    var Y = phe.hiddenField.getValue(ax);
                    var dg = phe.hiddenField.getValue(q);
                    var cR = phe.hiddenField.getValue(ei);
                    var dT = phe.hiddenField.getValue(bp);
                    var ac = phe.hiddenField.getValue(bM);
                    var aO = phe.hiddenField.getValue(p);
                    var bw = phe.hiddenField.getValue(bB);
                    var aD = phe.hiddenField.getValue(c);
                    var ce = phe.hiddenField.getValue(cf);
                    var g = phe.hiddenField.getValue(cg);
                    var ds = phe.hiddenField.getValue(dw);
                    var aV = phe.inputReadOnlyText.getValue(f);
                    var ao = phe.inputReadOnlyText.getValue(c7);
                    var dR = phe.inputReadOnlyText.getValue(aQ);
                    var bX = phe.hiddenField.getValue(r);
                    var bU = phe.inputReadOnlyText.getValue(d);
                    var eb = phe.inputReadOnlyText.getValue(a0);
                    var bO = phe.hiddenField.getValue(dx);
                    var z = phe.textBox.getValue(a7);
                    var N = phe.select.getValue(bY);
                    var dM = phe.select.getValue(av);
                    var bJ = phe.select.getValue(cI);
                    var dQ = phe.hiddenField.getValue(dr);
                    var au = phe.hiddenField.getValue(j);
                    var er = phe.hiddenField.getValue(dp);
                    var ck = phe.hiddenField.getValue(dy);
                    var bo = phe.select.getValue(co);
                    var aL = phe.select.getValue(dX);
                    var cL = phe.radioGroup.getValue(R);
                    var L = "";
                    var a3 = "N";
                    var dU = "N";
                    var bA = "N";
                    var cV = "N";
                    var b = "N";
                    if (cL == "Y") {
                        a3 = "Y";
                        L = phe.radioGroup.getValue(bG);
                        if (L == "Telephone") {
                            var bA = "Y"
                        } else {
                            if (L == "SMS") {
                                var dU = "Y"
                            } else {
                                if (L == "Email") {
                                    var cV = "Y"
                                } else {
                                    var b = "Y"
                                }
                            }
                        }
                    }
                    var dc = phe.textBox.getValue(cA);
                    var da = phe.textBox.getValue(cy);
                    var aE = phe.textBox.getValue(aH);
                    var bk = phe.textBox.getValue(bl);
                    var bi = phe.textBox.getValue(cC);
                    var c3 = phe.inputReadOnlyText.getValue(aC);
                    var c2 = phe.inputReadOnlyText.getValue(aB);
                    var bh = phe.inputReadOnlyText.getValue(cY);
                    var dD = phe.inputReadOnlyText.getValue(D);
                    var a9 = phe.inputReadOnlyText.getValue(ae);
                    t = t + "&screenId=" + ec + "&withCalculator=" + bP + "&referenceNumber=" + ej + "&policyNumber=" + az + "&retirementAgeCalc=" + U + "&currentSavingsCalc=" + ba + "&currentOtherMonthlyContriCalc=" + l + "&currentValueThisRACalc=" + de + "&lumpsumContributionCalc=" + b8 + "&currentAgeCalc=" + cT + "&genderCalc=" + ah + "&periodPostRetirementCalc=" + W + "&monthlySalaryCalc=" + aW + "&cellPhoneCalc=" + M + "&firstNameCalc=" + ca + "&surnameCalc=" + bI + "&emailCalc=" + y + "&riskFactorCalc=" + c1 + "&monthlyOtherSavings=" + dk + "&monthlyThisRA=" + cU + "&monthlyTotal=" + c4 + "&monthlyTarget=" + dz + "&capitalOtherSavings=" + cQ + "&capitalThisRA=" + an + "&capitalThisRAPlus=" + be + "&capitalThisRAMinus=" + d3 + "&interestNACAExpected=" + em + "&capitalShortfall=" + b2 + "&jsHiddenGoal=" + bH + "&jsHiddenMonthlyContribution=" + br + "&finalMonthlySal=" + bt + "&jsPortfolio=" + cH + "&monthlyOtherSavingsPer=" + aA + "&monthlyThisRAPer=" + aZ + "&monthlyTotalPer=" + C + "&monthlyTargetPer=" + Y + "&timeToRetire=" + dg + "&clientNumber=" + cR + "&stockAccountNum=" + dT + "&clientCasaRefNo=" + ac + "&clientCasaResult=" + aO + "&initials=" + bw + "&clientNationality=" + aD + "&sourceOfIncomeCode=" + dQ + "&sourceOfIncomeDescription=" + au + "&sourceOfFundsCode=" + er + "&sourceOfFundsDescription=" + ck + "&clientType=" + ce + "&title=" + g + "&gender=" + ds + "&firstName=" + aV + "&surname=" + ao + "&dateOfBirth=" + dR + "&typeOfIdentity=" + bX + "&identityNumber=" + bU + "&telephoneNumber=" + eb + "&cellphoneNumber=" + bO + "&emailAddress=" + z + "&maritalStatus=" + N + "&countryOfOrigin=" + dM + "&countryOfResidence=" + bJ + "&communicationLanguage=" + bo + "&preferredNotificationMethod=" + aL + "&marketingConsent=" + a3 + "&marketingChannelsRadioGroup=" + L + "&smsMarketingInd=" + dU + "&teleMarketingInd=" + bA + "&emailMarketingInd=" + cV + "&mailMarketingInd=" + b + "&postalAddressLine1=" + dc + "&postalAddressLine2=" + da + "&postalCity=" + aE + "&postalCode=" + bk + "&postalSuburb=" + bi + "&residentialAddressLine1=" + c3 + "&residentialAddressLine2=" + c2 + "&residentialCity=" + bh + "&residentialPostalCode=" + dD + "&residentialSuburb=" + a9
                } else {
                    if (ec == "4") {
                        var U = phe.hiddenField.getValue(dS);
                        var cT = phe.hiddenField.getValue(aw);
                        if (bP == "false") {
                            var ct = bb.selector.query(cw, ".ap-reviewRA-retirementAgeCalcInvest");
                            var ab = bb.selector.query(cw, ".ap-reviewRA-currentAgeCalcInvest");
                            U = phe.textBox.getValue(ct);
                            cT = phe.textBox.getValue(ab)
                        }
                        var ba = phe.hiddenField.getValue(b4);
                        var l = phe.hiddenField.getValue(o);
                        var de = phe.hiddenField.getValue(O);
                        var b8 = phe.hiddenField.getValue(v);
                        var ah = phe.hiddenField.getValue(ai);
                        var W = phe.hiddenField.getValue(a4);
                        var aW = phe.hiddenField.getValue(E);
                        var ca = phe.hiddenField.getValue(c0);
                        var bI = phe.hiddenField.getValue(dA);
                        var M = phe.hiddenField.getValue(aK);
                        var y = phe.hiddenField.getValue(dn);
                        var c1 = phe.hiddenField.getValue(aG);
                        var dk = phe.hiddenField.getValue(V);
                        var cU = phe.hiddenField.getValue(ag);
                        var c4 = phe.hiddenField.getValue(cW);
                        var dz = phe.hiddenField.getValue(aS);
                        var cQ = phe.hiddenField.getValue(h);
                        var an = phe.hiddenField.getValue(cv);
                        var be = phe.hiddenField.getValue(af);
                        var d3 = phe.hiddenField.getValue(ad);
                        var em = phe.hiddenField.getValue(ak);
                        var b2 = phe.hiddenField.getValue(cz);
                        var bH = phe.hiddenField.getValue(bz);
                        var br = phe.hiddenField.getValue(J);
                        var bt = phe.hiddenField.getValue(dd);
                        var cH = phe.hiddenField.getValue(k);
                        var aA = phe.hiddenField.getValue(aM);
                        var aZ = phe.hiddenField.getValue(bg);
                        var C = phe.hiddenField.getValue(bq);
                        var Y = phe.hiddenField.getValue(ax);
                        var dg = phe.hiddenField.getValue(q);
                        var cR = phe.hiddenField.getValue(ei);
                        var dT = phe.hiddenField.getValue(bp);
                        var ac = phe.hiddenField.getValue(bM);
                        var aO = phe.hiddenField.getValue(p);
                        var bw = phe.hiddenField.getValue(bB);
                        var aD = phe.hiddenField.getValue(c);
                        var dQ = phe.hiddenField.getValue(dr);
                        var au = phe.hiddenField.getValue(j);
                        var er = phe.hiddenField.getValue(dp);
                        var ck = phe.hiddenField.getValue(dy);
                        var ce = phe.hiddenField.getValue(cf);
                        var g = phe.hiddenField.getValue(cg);
                        var ds = phe.hiddenField.getValue(dw);
                        var aV = phe.hiddenField.getValue(f);
                        var ao = phe.hiddenField.getValue(c7);
                        var dR = phe.hiddenField.getValue(aQ);
                        var bX = phe.hiddenField.getValue(r);
                        var bU = phe.hiddenField.getValue(d);
                        var dB = phe.textBox.getValue(b7);
                        var eb = phe.hiddenField.getValue(a0);
                        var bO = phe.hiddenField.getValue(dx);
                        var z = phe.hiddenField.getValue(a7);
                        var N = phe.hiddenField.getValue(bY);
                        var dM = phe.hiddenField.getValue(av);
                        var bJ = phe.hiddenField.getValue(cI);
                        var bo = phe.hiddenField.getValue(co);
                        var aL = phe.hiddenField.getValue(dX);
                        var cL = phe.hiddenField.getValue(R);
                        var L = "";
                        var a3 = "N";
                        var dU = "N";
                        var bA = "N";
                        var cV = "N";
                        var b = "N";
                        if (cL == "Y") {
                            a3 = "Y";
                            L = phe.hiddenField.getValue(bG);
                            if (L == "Telephone") {
                                var bA = "Y"
                            } else {
                                if (L == "SMS") {
                                    var dU = "Y"
                                } else {
                                    if (L == "Email") {
                                        var cV = "Y"
                                    } else {
                                        var b = "Y"
                                    }
                                }
                            }
                        }
                        var dc = phe.hiddenField.getValue(cA);
                        var da = phe.hiddenField.getValue(cy);
                        var aE = phe.hiddenField.getValue(aH);
                        var bk = phe.hiddenField.getValue(bl);
                        var bi = phe.hiddenField.getValue(cC);
                        var c3 = phe.hiddenField.getValue(aC);
                        var c2 = phe.hiddenField.getValue(aB);
                        var bh = phe.hiddenField.getValue(cY);
                        var dD = phe.hiddenField.getValue(D);
                        var a9 = phe.hiddenField.getValue(ae);
                        t = t + "&screenId=" + ec + "&withCalculator=" + bP + "&referenceNumber=" + ej + "&policyNumber=" + az + "&retirementAgeCalc=" + U + "&currentSavingsCalc=" + ba + "&currentOtherMonthlyContriCalc=" + l + "&currentValueThisRACalc=" + de + "&lumpsumContributionCalc=" + b8 + "&currentAgeCalc=" + cT + "&genderCalc=" + ah + "&periodPostRetirementCalc=" + W + "&monthlySalaryCalc=" + aW + "&cellPhoneCalc=" + M + "&firstNameCalc=" + ca + "&surnameCalc=" + bI + "&emailCalc=" + y + "&riskFactorCalc=" + c1 + "&monthlyOtherSavings=" + dk + "&monthlyThisRA=" + cU + "&monthlyTotal=" + c4 + "&monthlyTarget=" + dz + "&capitalOtherSavings=" + cQ + "&capitalThisRA=" + an + "&capitalThisRAPlus=" + be + "&capitalThisRAMinus=" + d3 + "&interestNACAExpected=" + em + "&capitalShortfall=" + b2 + "&jsHiddenGoal=" + bH + "&jsHiddenMonthlyContribution=" + br + "&finalMonthlySal=" + bt + "&jsPortfolio=" + cH + "&monthlyOtherSavingsPer=" + aA + "&monthlyThisRAPer=" + aZ + "&monthlyTotalPer=" + C + "&monthlyTargetPer=" + Y + "&timeToRetire=" + dg + "&clientNumber=" + cR + "&stockAccountNum=" + dT + "&clientCasaRefNo=" + ac + "&clientCasaResult=" + aO + "&initials=" + bw + "&clientNationality=" + aD + "&sourceOfIncomeCode=" + dQ + "&sourceOfIncomeDescription=" + au + "&sourceOfFundsCode=" + er + "&sourceOfFundsDescription=" + ck + "&clientType=" + ce + "&title=" + g + "&gender=" + ds + "&firstName=" + aV + "&surname=" + ao + "&dateOfBirth=" + dR + "&typeOfIdentity=" + bX + "&identityNumber=" + bU + "&taxNumber=" + dB + "&telephoneNumber=" + eb + "&cellphoneNumber=" + bO + "&emailAddress=" + z + "&maritalStatus=" + N + "&countryOfOrigin=" + dM + "&countryOfResidence=" + bJ + "&communicationLanguage=" + bo + "&preferredNotificationMethod=" + aL + "&marketingConsent=" + a3 + "&marketingChannelsRadioGroup=" + L + "&smsMarketingInd=" + dU + "&teleMarketingInd=" + bA + "&emailMarketingInd=" + cV + "&mailMarketingInd=" + b + "&postalAddressLine1=" + dc + "&postalAddressLine2=" + da + "&postalCity=" + aE + "&postalCode=" + bk + "&postalSuburb=" + bi + "&residentialAddressLine1=" + c3 + "&residentialAddressLine2=" + c2 + "&residentialCity=" + bh + "&residentialPostalCode=" + dD + "&residentialSuburb=" + a9;
                        var aP = bb.selector.query(cw, ".ap-reviewRA-isCompanyLinked");
                        var d2 = phe.hiddenField.getValue(aP);
                        var K = bb.selector.query(cw, ".ap-reviewRA-makeRegularContribution");
                        var du = bb.selector.query(cw, ".ap-reviewRA-makeLumpsumContribution");
                        var w = phe.checkBox.isChecked(K);
                        var bL = phe.checkBox.isChecked(du);
                        t = t + "&regularContribution=" + w + "&lumpsumContribution=" + bL;
                        var aF = "";
                        var dC = "";
                        var ea = "";
                        var aU = "";
                        var aq = "";
                        var cx = "";
                        var cN = "";
                        var cP = "";
                        var bC = "";
                        var eq = "";
                        var cX = "";
                        var bf = "";
                        var bd = "";
                        if (w) {
                            var G = bb.selector.query(cw, ".ap-reviewRA-accountAbsaDebitPayment");
                            var eh = bb.selector.query(cw, ".ap-reviewRA-accountAbsaOtherDebitPayment");
                            var d5 = bb.selector.query(cw, ".ap-reviewRA-accountOtherDebitPayment");
                            var am = phe.hiddenField.getValue(G);
                            var dq = phe.hiddenField.getValue(eh);
                            var d4 = phe.hiddenField.getValue(d5);
                            if (am == "true") {
                                if (d2 == "true") {
                                    var H = bb.selector.query(cw, ".ap-reviewRA-accountHolderNameDebitPaymentLinkedCompanyLinked");
                                    var x = bb.selector.query(cw, ".ap-reviewRA-accountToBeDebitedAbsaLinkedDebitPaymentCompanyLinked");
                                    var aJ = bb.selector.query(cw, ".ap-reviewRA-dayOfDebitAbsaLinkedCompanyLinked");
                                    var aX = bb.selector.query(cw, ".ap-reviewRA-annualEscalationAbsaLinkedCompanyLinked");
                                    var cM = bb.selector.query(cw, ".ap-reviewRA-debitOrderAmountAbsaLinkedCompanyLinked");
                                    bf = phe.inputReadOnlyText.getValue(cM);
                                    aF = phe.hiddenField.getValue(x);
                                    dC = phe.inputReadOnlyText.getValue(aJ);
                                    bd = phe.inputReadOnlyText.getValue(aX);
                                    cP = phe.inputReadOnlyText.getValue(H);
                                    if (aF != "") {
                                        var by = aF.split("-");
                                        ea = by[0];
                                        aU = by[1]
                                    }
                                } else {
                                    var H = bb.selector.query(cw, ".ap-reviewRA-accountHolderNameDebitPaymentLinked");
                                    var x = bb.selector.query(cw, ".ap-reviewRA-accountToBeDebitedAbsaLinkedDebitPayment");
                                    var aJ = bb.selector.query(cw, ".ap-reviewRA-dayOfDebitAbsaLinked");
                                    var aX = bb.selector.query(cw, ".ap-reviewRA-annualEscalationAbsaLinked");
                                    var cM = bb.selector.query(cw, ".ap-reviewRA-debitOrderAmountAbsaLinked");
                                    bf = phe.textBox.getValue(cM);
                                    aF = phe.select.getValue(x);
                                    dC = phe.select.getValue(aJ);
                                    bd = phe.textBox.getValue(aX);
                                    cP = phe.textBox.getValue(H);
                                    if (aF != "") {
                                        var by = aF.split("-");
                                        ea = by[0];
                                        aU = by[1]
                                    }
                                }
                                aq = "ABSA";
                                cN = "632005";
                                bC = "true";
                                eq = "false";
                                cX = "false"
                            }
                            if (dq == "true") {
                                if (d2 == "true") {
                                    var H = bb.selector.query(cw, ".ap-reviewRA-accountHolderNameAbsaOtherDebitPaymentCompanyLinked");
                                    var dY = bb.selector.query(cw, ".ap-reviewRA-accountTypeAbsaOtherDebitPaymentCompanyLinked");
                                    var d1 = bb.selector.query(cw, ".ap-reviewRA-accountNumberAbsaOtherDebitPaymentCompanyLinked");
                                    var aJ = bb.selector.query(cw, ".ap-reviewRA-dayOfDebitAbsaOtherCompanyLinked");
                                    var aX = bb.selector.query(cw, ".ap-reviewRA-annualEscalationAbsaOtherCompanyLinked");
                                    var cM = bb.selector.query(cw, ".ap-reviewRA-debitOrderAmountAbsaOtherCompanyLinked");
                                    bf = phe.inputReadOnlyText.getValue(cM);
                                    dC = phe.inputReadOnlyText.getValue(aJ);
                                    bd = phe.inputReadOnlyText.getValue(aX);
                                    cP = phe.inputReadOnlyText.getValue(H);
                                    ea = phe.hiddenField.getValue(dY);
                                    aU = phe.inputReadOnlyText.getValue(d1);
                                    aF = ea + "-" + aU
                                } else {
                                    var H = bb.selector.query(cw, ".ap-reviewRA-accountHolderNameAbsaOtherDebitPayment");
                                    var dY = bb.selector.query(cw, ".ap-reviewRA-accountTypeAbsaOtherDebitPayment");
                                    var d1 = bb.selector.query(cw, ".ap-reviewRA-accountNumberAbsaOtherDebitPayment");
                                    var aJ = bb.selector.query(cw, ".ap-reviewRA-dayOfDebitAbsaOther");
                                    var aX = bb.selector.query(cw, ".ap-reviewRA-annualEscalationAbsaOther");
                                    var cM = bb.selector.query(cw, ".ap-reviewRA-debitOrderAmountAbsaOther");
                                    bf = phe.textBox.getValue(cM);
                                    dC = phe.select.getValue(aJ);
                                    bd = phe.textBox.getValue(aX);
                                    cP = phe.textBox.getValue(H);
                                    ea = phe.select.getValue(dY);
                                    aU = phe.textBox.getValue(d1);
                                    aF = ea + "-" + aU
                                }
                                aq = "ABSA";
                                cN = "632005";
                                bC = "false";
                                eq = "true";
                                cX = "false"
                            }
                            if (d4 == "true") {
                                if (d2 == "true") {
                                    var H = bb.selector.query(cw, ".ap-reviewRA-accountHolderNameOtherDebitPaymentCompanyLinked");
                                    var b0 = bb.selector.query(cw, ".ap-reviewRA-bankNameCompanyLinked");
                                    var cn = bb.selector.query(cw, ".ap-reviewRA-branchNameDebitPaymentCompanyLinked");
                                    var dY = bb.selector.query(cw, ".ap-reviewRA-accountTypeDebitPaymentCompanyLinked");
                                    var d1 = bb.selector.query(cw, ".ap-reviewRA-accountNumberCompanyLinked");
                                    var aJ = bb.selector.query(cw, ".ap-reviewRA-dayOfDebitOtherCompanyLinked");
                                    var aX = bb.selector.query(cw, ".ap-reviewRA-annualEscalationOtherCompanyLinked");
                                    var cM = bb.selector.query(cw, ".ap-reviewRA-debitOrderAmountOtherCompanyLinked");
                                    bf = phe.inputReadOnlyText.getValue(cM);
                                    dC = phe.inputReadOnlyText.getValue(aJ);
                                    bd = phe.inputReadOnlyText.getValue(aX);
                                    cP = phe.inputReadOnlyText.getValue(H);
                                    aq = phe.inputReadOnlyText.getValue(b0);
                                    sBranchNameOrCode = phe.inputReadOnlyText.getValue(cn);
                                    if (sBranchNameOrCode != "") {
                                        var d9 = sBranchNameOrCode.split(" - ");
                                        cx = d9[0];
                                        cN = d9[1]
                                    }
                                    ea = phe.hiddenField.getValue(dY);
                                    aU = phe.inputReadOnlyText.getValue(d1);
                                    aF = ea + "-" + aU
                                } else {
                                    var H = bb.selector.query(cw, ".ap-reviewRA-accountHolderNameOtherDebitPayment");
                                    var b0 = bb.selector.query(cw, ".ap-reviewRA-bankNameDebitPayment");
                                    var cn = bb.selector.query(cw, ".ap-reviewRA-branchNameDebitPayment");
                                    var dY = bb.selector.query(cw, ".ap-reviewRA-accountTypeOther");
                                    var d1 = bb.selector.query(cw, ".ap-reviewRA-accountNumberOther");
                                    var aJ = bb.selector.query(cw, ".ap-reviewRA-dayOfDebitOther");
                                    var aX = bb.selector.query(cw, ".ap-reviewRA-annualEscalationOther");
                                    var cM = bb.selector.query(cw, ".ap-reviewRA-debitOrderAmountOther");
                                    bf = phe.textBox.getValue(cM);
                                    dC = phe.select.getValue(aJ);
                                    bd = phe.textBox.getValue(aX);
                                    cP = phe.textBox.getValue(H);
                                    aq = phe.suggestBox.getValue(b0);
                                    sBranchNameOrCode = phe.suggestBox.getValue(cn);
                                    if (sBranchNameOrCode != "") {
                                        var d9 = sBranchNameOrCode.split(" - ");
                                        cx = d9[0];
                                        cN = d9[1]
                                    }
                                    ea = phe.select.getValue(dY);
                                    aU = phe.textBox.getValue(d1);
                                    aF = ea + "-" + aU
                                }
                                bC = "false";
                                eq = "false";
                                cX = "true"
                            }
                            t = t + "&accountAbsaDebitPayment=" + bC + "&accountAbsaOtherDebitPayment=" + eq + "&accountOtherDebitPayment=" + cX + "&accountHolderNameDebitPayment=" + cP + "&accountToBeDebitedDebitPayment=" + aF + "&bankNameDebitPayment=" + aq + "&branchNameDebitPayment=" + cx + "&branchCodeDebitPayment=" + cN + "&accountTypeDebitPayment=" + ea + "&accountNumberDebitPayment=" + aU + "&dayOfDebitDebitPayment=" + dC + "&annualEscalationDebitPayment=" + bd + "&debitOrderAmountDebitPayment=" + bf
                        }
                        var aR = "false";
                        var dZ = "false";
                        var bV = "";
                        var T = "0";
                        var cl = "";
                        var c5 = "";
                        var d7 = "";
                        var aT = "";
                        var bK = "";
                        var dv = "";
                        var cJ = "";
                        var bZ = "";
                        var c6 = "";
                        var df = "";
                        var ci = "";
                        var bv = "";
                        if (bL) {
                            var cd = bb.selector.query(cw, ".ap-reviewRA-methodPaymentOnline");
                            var b6 = bb.selector.query(cw, ".ap-reviewRA-methodPaymentManualDeposit");
                            var bj = phe.hiddenField.getValue(cd);
                            var dH = phe.hiddenField.getValue(b6);
                            if (bj == "true") {
                                aR = "true";
                                var bn = bb.selector.query(cw, ".ap-reviewRA-onceOffPaymentDebitDate");
                                var x = bb.selector.query(cw, ".ap-reviewRA-accountToBeDebitedAbsaLinkedOnceOffPayment");
                                var b5 = bb.selector.query(cw, ".ap-reviewRA-onceOffAmountAbsaLinked");
                                var P = bb.selector.query(cw, ".ap-reviewRA-myReferenceOnceOffPaymentAbsaLinked");
                                var cl = phe.inputReadOnlyText.getValue(bn);
                                T = phe.textBox.getValue(b5);
                                c5 = phe.textBox.getValue(P);
                                d7 = phe.select.getValue(x);
                                if (d7 != "") {
                                    var by = d7.split("-");
                                    aT = by[0];
                                    bK = by[1]
                                }
                                dv = "ABSA";
                                cJ = "632005";
                                t = t + "&lumpsumAmount=" + T + "&paymentDebitDate=" + cl + "&myReference=" + c5 + "&accountToBeDebitedOnceOffPayment=" + d7 + "&accountTypeOnceOffPayment=" + aT + "&accountNumberOnceOffPayment=" + bK + "&bankNameOnceOffPayment=" + dv + "&branchCodeOnceOffPayment=" + cJ + "&methodPaymentOnline=" + aR + "&methodPaymentManualDeposit=" + dZ;
                                var cs = bb.selector.query(cw, ".ap-reviewRA-beneficiaryBankNameAbsaOnceOffPayment");
                                var A = bb.selector.query(cw, ".ap-reviewRA-beneficiaryBranchNameOrCodeAbsaOnceOffPayment");
                                var dF = bb.selector.query(cw, ".ap-reviewRA-beneficiaryAccountNumberAbsaOnceOffPayment");
                                var dt = bb.selector.query(cw, ".ap-reviewRA-beneficiaryReferenceNumberAbsaOnceOffPayment");
                                var ee = bb.selector.query(cw, ".ap-reviewRA-beneficiaryNameAbsaOnceOffPayment");
                                bZ = phe.inputReadOnlyText.getValue(cs);
                                c6 = phe.inputReadOnlyText.getValue(A);
                                df = phe.inputReadOnlyText.getValue(dF);
                                ci = phe.inputReadOnlyText.getValue(dt);
                                bv = phe.inputReadOnlyText.getValue(ee)
                            } else {
                                if (dH == "true") {
                                    dZ = "true";
                                    var b5 = bb.selector.query(cw, ".ap-reviewRA-onceOffAmountManualDeposit");
                                    var cs = bb.selector.query(cw, ".ap-reviewRA-beneficiaryBankNameManualDeposit");
                                    var A = bb.selector.query(cw, ".ap-reviewRA-beneficiaryBranchNameOrCodeManualDeposit");
                                    var dF = bb.selector.query(cw, ".ap-reviewRA-beneficiaryAccountNumberManualDeposit");
                                    var dt = bb.selector.query(cw, ".ap-reviewRA-beneficiaryReferenceNumberManualDeposit");
                                    var ee = bb.selector.query(cw, ".ap-reviewRA-beneficiaryNameManualDeposit");
                                    T = phe.textBox.getValue(b5);
                                    bZ = phe.inputReadOnlyText.getValue(cs);
                                    c6 = phe.inputReadOnlyText.getValue(A);
                                    df = phe.inputReadOnlyText.getValue(dF);
                                    ci = phe.inputReadOnlyText.getValue(dt);
                                    bv = phe.inputReadOnlyText.getValue(ee);
                                    t = t + "&methodPaymentOnline=" + aR + "&methodPaymentManualDeposit=" + dZ + "&lumpsumAmount=" + T
                                }
                            }
                            t = t + "&benBankName=" + bZ + "&benBranchNameOrCode=" + c6 + "&benAccountNumber=" + df + "&benReferenceNumber=" + ci + "&benName=" + bv
                        }
                    } else {
                        if (ec == "5" || ec == "6") {
                            var U = phe.hiddenField.getValue(dS);
                            var ba = phe.hiddenField.getValue(b4);
                            var l = phe.hiddenField.getValue(o);
                            var de = phe.hiddenField.getValue(O);
                            var b8 = phe.hiddenField.getValue(v);
                            var cT = phe.hiddenField.getValue(aw);
                            var ah = phe.hiddenField.getValue(ai);
                            var W = phe.hiddenField.getValue(a4);
                            var aW = phe.hiddenField.getValue(E);
                            var ca = phe.hiddenField.getValue(c0);
                            var bI = phe.hiddenField.getValue(dA);
                            var M = phe.hiddenField.getValue(aK);
                            var y = phe.hiddenField.getValue(dn);
                            var c1 = phe.hiddenField.getValue(aG);
                            var dk = phe.hiddenField.getValue(V);
                            var cU = phe.hiddenField.getValue(ag);
                            var c4 = phe.hiddenField.getValue(cW);
                            var dz = phe.hiddenField.getValue(aS);
                            var cQ = phe.hiddenField.getValue(h);
                            var an = phe.hiddenField.getValue(cv);
                            var be = phe.hiddenField.getValue(af);
                            var d3 = phe.hiddenField.getValue(ad);
                            var em = phe.hiddenField.getValue(ak);
                            var b2 = phe.hiddenField.getValue(cz);
                            var bH = phe.hiddenField.getValue(bz);
                            var br = phe.hiddenField.getValue(J);
                            var bt = phe.hiddenField.getValue(dd);
                            var cH = phe.hiddenField.getValue(k);
                            var aA = phe.hiddenField.getValue(aM);
                            var aZ = phe.hiddenField.getValue(bg);
                            var C = phe.hiddenField.getValue(bq);
                            var Y = phe.hiddenField.getValue(ax);
                            var dg = phe.hiddenField.getValue(q);
                            var cR = phe.hiddenField.getValue(ei);
                            var dT = phe.hiddenField.getValue(bp);
                            var ac = phe.hiddenField.getValue(bM);
                            var aO = phe.hiddenField.getValue(p);
                            var bw = phe.hiddenField.getValue(bB);
                            var aD = phe.hiddenField.getValue(c);
                            var dQ = phe.hiddenField.getValue(dr);
                            var au = phe.hiddenField.getValue(j);
                            var er = phe.hiddenField.getValue(dp);
                            var ck = phe.hiddenField.getValue(dy);
                            var ce = phe.hiddenField.getValue(cf);
                            var g = phe.hiddenField.getValue(cg);
                            var ds = phe.hiddenField.getValue(dw);
                            var aV = phe.hiddenField.getValue(f);
                            var ao = phe.hiddenField.getValue(c7);
                            var dR = phe.hiddenField.getValue(aQ);
                            var bX = phe.hiddenField.getValue(r);
                            var bU = phe.hiddenField.getValue(d);
                            var dB = phe.textBox.getValue(b7);
                            var eb = phe.hiddenField.getValue(a0);
                            var bO = phe.hiddenField.getValue(dx);
                            var z = phe.hiddenField.getValue(a7);
                            var N = phe.hiddenField.getValue(bY);
                            var dM = phe.hiddenField.getValue(av);
                            var bJ = phe.hiddenField.getValue(cI);
                            var bo = phe.hiddenField.getValue(co);
                            var aL = phe.hiddenField.getValue(dX);
                            var cL = phe.hiddenField.getValue(R);
                            var L = "";
                            var a3 = "N";
                            var dU = "N";
                            var bA = "N";
                            var cV = "N";
                            var b = "N";
                            if (cL == "Y") {
                                a3 = "Y";
                                L = phe.hiddenField.getValue(bG);
                                if (L == "Telephone") {
                                    var bA = "Y"
                                } else {
                                    if (L == "SMS") {
                                        var dU = "Y"
                                    } else {
                                        if (L == "Email") {
                                            var cV = "Y"
                                        } else {
                                            var b = "Y"
                                        }
                                    }
                                }
                            }
                            var dc = phe.hiddenField.getValue(cA);
                            var da = phe.hiddenField.getValue(cy);
                            var aE = phe.hiddenField.getValue(aH);
                            var bk = phe.hiddenField.getValue(bl);
                            var bi = phe.hiddenField.getValue(cC);
                            var c3 = phe.hiddenField.getValue(aC);
                            var c2 = phe.hiddenField.getValue(aB);
                            var bh = phe.hiddenField.getValue(cY);
                            var dD = phe.hiddenField.getValue(D);
                            var a9 = phe.hiddenField.getValue(ae);
                            t = t + "&screenId=" + ec + "&withCalculator=" + bP + "&referenceNumber=" + ej + "&policyNumber=" + az + "&retirementAgeCalc=" + U + "&currentSavingsCalc=" + ba + "&currentOtherMonthlyContriCalc=" + l + "&currentValueThisRACalc=" + de + "&lumpsumContributionCalc=" + b8 + "&currentAgeCalc=" + cT + "&genderCalc=" + ah + "&periodPostRetirementCalc=" + W + "&monthlySalaryCalc=" + aW + "&cellPhoneCalc=" + M + "&firstNameCalc=" + ca + "&surnameCalc=" + bI + "&emailCalc=" + y + "&riskFactorCalc=" + c1 + "&monthlyOtherSavings=" + dk + "&monthlyThisRA=" + cU + "&monthlyTotal=" + c4 + "&monthlyTarget=" + dz + "&capitalOtherSavings=" + cQ + "&capitalThisRA=" + an + "&capitalThisRAPlus=" + be + "&capitalThisRAMinus=" + d3 + "&interestNACAExpected=" + em + "&capitalShortfall=" + b2 + "&jsHiddenGoal=" + bH + "&jsHiddenMonthlyContribution=" + br + "&finalMonthlySal=" + bt + "&jsPortfolio=" + cH + "&monthlyOtherSavingsPer=" + aA + "&monthlyThisRAPer=" + aZ + "&monthlyTotalPer=" + C + "&monthlyTargetPer=" + Y + "&timeToRetire=" + dg + "&clientNumber=" + cR + "&stockAccountNum=" + dT + "&clientCasaRefNo=" + ac + "&clientCasaResult=" + aO + "&initials=" + bw + "&clientNationality=" + aD + "&sourceOfIncomeCode=" + dQ + "&sourceOfIncomeDescription=" + au + "&sourceOfFundsCode=" + er + "&sourceOfFundsDescription=" + ck + "&clientType=" + ce + "&title=" + g + "&gender=" + ds + "&firstName=" + aV + "&surname=" + ao + "&dateOfBirth=" + dR + "&typeOfIdentity=" + bX + "&identityNumber=" + bU + "&taxNumber=" + dB + "&telephoneNumber=" + eb + "&cellphoneNumber=" + bO + "&emailAddress=" + z + "&maritalStatus=" + N + "&countryOfOrigin=" + dM + "&countryOfResidence=" + bJ + "&communicationLanguage=" + bo + "&preferredNotificationMethod=" + aL + "&marketingConsent=" + a3 + "&marketingChannelsRadioGroup=" + L + "&smsMarketingInd=" + dU + "&teleMarketingInd=" + bA + "&emailMarketingInd=" + cV + "&mailMarketingInd=" + b + "&postalAddressLine1=" + dc + "&postalAddressLine2=" + da + "&postalCity=" + aE + "&postalCode=" + bk + "&postalSuburb=" + bi + "&residentialAddressLine1=" + c3 + "&residentialAddressLine2=" + c2 + "&residentialCity=" + bh + "&residentialPostalCode=" + dD + "&residentialSuburb=" + a9;
                            var aP = bb.selector.query(cw, ".ap-reviewRA-isCompanyLinked");
                            var d2 = phe.hiddenField.getValue(aP);
                            var K = bb.selector.query(cw, ".ap-reviewRA-makeRegularContribution");
                            var du = bb.selector.query(cw, ".ap-reviewRA-makeLumpsumContribution");
                            var dm = phe.hiddenField.getValue(K);
                            var bS = phe.hiddenField.getValue(du);
                            var w = "false";
                            var bL = "false";
                            if (dm == "true") {
                                w = "true"
                            }
                            if (bS == "true") {
                                bL = "true"
                            }
                            t = t + "&regularContribution=" + w + "&lumpsumContribution=" + bL;
                            var aF = "";
                            var dC = "";
                            var ea = "";
                            var aU = "";
                            var aq = "";
                            var cx = "";
                            var cN = "";
                            var cP = "";
                            var bC = "";
                            var eq = "";
                            var cX = "";
                            var bf = "";
                            var bd = "";
                            if (w == "true") {
                                var dJ = bb.selector.query(cw, ".ap-reviewRA-debitedAccountBankDebitPayment");
                                var aa = phe.hiddenField.getValue(dJ);
                                if (aa == "AbsaOnlineLinkedAccount") {
                                    var x = bb.selector.query(cw, ".ap-reviewRA-accountToBeDebitedAbsaLinkedDebitPayment");
                                    var aJ = bb.selector.query(cw, ".ap-reviewRA-dayOfDebitAbsaLinked");
                                    var aX = bb.selector.query(cw, ".ap-reviewRA-annualEscalationAbsaLinked");
                                    var cM = bb.selector.query(cw, ".ap-reviewRA-debitOrderAmountAbsaLinked");
                                    var H = bb.selector.query(cw, ".ap-reviewRA-accountHolderNameDebitPaymentLinked");
                                    cP = phe.hiddenField.getValue(H);
                                    bf = phe.hiddenField.getValue(cM);
                                    aF = phe.hiddenField.getValue(x);
                                    dC = phe.hiddenField.getValue(aJ);
                                    bd = phe.hiddenField.getValue(aX);
                                    if (aF != "") {
                                        var by = aF.split("-");
                                        ea = by[0];
                                        aU = by[1]
                                    }
                                    aq = "ABSA";
                                    cN = "632005";
                                    bC = "true";
                                    eq = "false";
                                    cX = "false"
                                }
                                if (aa == "AbsaOtherAccount") {
                                    var H = bb.selector.query(cw, ".ap-reviewRA-accountHolderNameAbsaOtherDebitPayment");
                                    var dY = bb.selector.query(cw, ".ap-reviewRA-accountTypeAbsaOtherDebitPayment");
                                    var d1 = bb.selector.query(cw, ".ap-reviewRA-accountNumberAbsaOtherDebitPayment");
                                    var aJ = bb.selector.query(cw, ".ap-reviewRA-dayOfDebitAbsaOther");
                                    var aX = bb.selector.query(cw, ".ap-reviewRA-annualEscalationAbsaOther");
                                    var cM = bb.selector.query(cw, ".ap-reviewRA-debitOrderAmountAbsaOther");
                                    bf = phe.hiddenField.getValue(cM);
                                    aF = phe.hiddenField.getValue(x);
                                    dC = phe.hiddenField.getValue(aJ);
                                    bd = phe.hiddenField.getValue(aX);
                                    cP = phe.hiddenField.getValue(H);
                                    ea = phe.select.getValue(dY);
                                    aU = phe.textBox.getValue(d1);
                                    aF = ea + "-" + aU;
                                    aq = "ABSA";
                                    cN = "632005";
                                    bC = "false";
                                    eq = "true";
                                    cX = "false"
                                }
                                if (aa == "OtherBank") {
                                    var H = bb.selector.query(cw, ".ap-reviewRA-accountHolderNameOtherDebitPayment");
                                    var b0 = bb.selector.query(cw, ".ap-reviewRA-bankName");
                                    var cn = bb.selector.query(cw, ".ap-reviewRA-branchName");
                                    var dY = bb.selector.query(cw, ".ap-reviewRA-accountTypeOther");
                                    var d1 = bb.selector.query(cw, ".ap-reviewRA-accountNumberOther");
                                    var aJ = bb.selector.query(cw, ".ap-reviewRA-dayOfDebitOther");
                                    var aX = bb.selector.query(cw, ".ap-reviewRA-annualEscalationOther");
                                    var cM = bb.selector.query(cw, ".ap-reviewRA-debitOrderAmountOther");
                                    cP = phe.hiddenField.getValue(H);
                                    bf = phe.hiddenField.getValue(cM);
                                    dC = phe.hiddenField.getValue(aJ);
                                    bd = phe.hiddenField.getValue(aX);
                                    aq = phe.hiddenField.getValue(b0);
                                    sBranchNameOrCode = phe.hiddenField.getValue(cn);
                                    if (sBranchNameOrCode != "") {
                                        var d9 = sBranchNameOrCode.split(" - ");
                                        cx = d9[0];
                                        cN = d9[1]
                                    }
                                    ea = phe.select.getValue(dY);
                                    aU = phe.textBox.getValue(d1);
                                    aF = ea + "-" + aU;
                                    bC = "false";
                                    eq = "false";
                                    cX = "true"
                                }
                                t = t + "&accountAbsaDebitPayment=" + bC + "&accountAbsaOtherDebitPayment=" + eq + "&accountOtherDebitPayment=" + cX + "&accountToBeDebitedDebitPayment=" + aF + "&accountHolderNameDebitPayment=" + cP + "&bankNameDebitPayment=" + aq + "&branchNameDebitPayment=" + cx + "&branchCodeDebitPayment=" + cN + "&accountTypeDebitPayment=" + ea + "&accountNumberDebitPayment=" + aU + "&dayOfDebitDebitPayment=" + dC + "&annualEscalationDebitPayment=" + bd + "&debitOrderAmountDebitPayment=" + bf
                            }
                            var aR = "false";
                            var dZ = "false";
                            var bV = "";
                            var T = "0";
                            var cl = "";
                            var c5 = "";
                            var d7 = "";
                            var aT = "";
                            var bK = "";
                            var dv = "";
                            var cJ = "";
                            var bZ = "";
                            var c6 = "";
                            var df = "";
                            var ci = "";
                            var bv = "";
                            if (bL == "true") {
                                var e = bb.selector.query(cw, ".ap-reviewRA-methodOfPaymentOnceOffPayment");
                                var dI = phe.hiddenField.getValue(e);
                                if (dI == "Online") {
                                    aR = "true";
                                    var bn = bb.selector.query(cw, ".ap-reviewRA-onceOffPaymentDebitDate");
                                    var x = bb.selector.query(cw, ".ap-reviewRA-accountToBeDebitedAbsaLinkedOnceOffPayment");
                                    var ep = bb.selector.query(cw, ".ap-reviewRA-sourceOfFundsAbsaLinkedOnceOffPayment");
                                    var b5 = bb.selector.query(cw, ".ap-reviewRA-onceOffAmountAbsaLinked");
                                    var P = bb.selector.query(cw, ".ap-reviewRA-myReferenceOnceOffPaymentAbsaLinked");
                                    var cl = phe.hiddenField.getValue(bn);
                                    bV = phe.hiddenField.getValue(ep);
                                    T = phe.hiddenField.getValue(b5);
                                    c5 = phe.hiddenField.getValue(P);
                                    d7 = phe.hiddenField.getValue(x);
                                    if (d7 != "") {
                                        var by = d7.split("-");
                                        aT = by[0];
                                        bK = by[1]
                                    }
                                    dv = "ABSA";
                                    cJ = "632005";
                                    t = t + "&sourceOfFunds=" + bV + "&lumpsumAmount=" + T + "&paymentDebitDate=" + cl + "&myReference=" + c5 + "&accountToBeDebitedOnceOffPayment=" + d7 + "&accountTypeOnceOffPayment=" + aT + "&accountNumberOnceOffPayment=" + bK + "&bankNameOnceOffPayment=" + dv + "&branchCodeOnceOffPayment=" + cJ + "&methodPaymentOnline=" + aR + "&methodPaymentManualDeposit=" + dZ;
                                    var cs = bb.selector.query(cw, ".ap-reviewRA-beneficiaryBankNameAbsaOnceOffPayment");
                                    var A = bb.selector.query(cw, ".ap-reviewRA-beneficiaryBranchNameOrCodeAbsaOnceOffPayment");
                                    var dF = bb.selector.query(cw, ".ap-reviewRA-beneficiaryAccountNumberAbsaOnceOffPayment");
                                    var dt = bb.selector.query(cw, ".ap-reviewRA-beneficiaryReferenceNumberAbsaOnceOffPayment");
                                    var ee = bb.selector.query(cw, ".ap-reviewRA-beneficiaryNameAbsaOnceOffPayment");
                                    bZ = phe.hiddenField.getValue(cs);
                                    c6 = phe.hiddenField.getValue(A);
                                    df = phe.hiddenField.getValue(dF);
                                    ci = phe.hiddenField.getValue(dt);
                                    bv = phe.hiddenField.getValue(ee)
                                } else {
                                    if (dI == "ManualDepositIntoAbsaInvestment") {
                                        dZ = "true";
                                        var ep = bb.selector.query(cw, ".ap-reviewRA-sourceOfFundsManualDeposit");
                                        var b5 = bb.selector.query(cw, ".ap-reviewRA-onceOffAmountManualDeposit");
                                        var cs = bb.selector.query(cw, ".ap-reviewRA-beneficiaryBankNameManualDeposit");
                                        var A = bb.selector.query(cw, ".ap-reviewRA-beneficiaryBranchNameOrCodeManualDeposit");
                                        var dF = bb.selector.query(cw, ".ap-reviewRA-beneficiaryAccountNumberManualDeposit");
                                        var dt = bb.selector.query(cw, ".ap-reviewRA-beneficiaryReferenceNumberManualDeposit");
                                        var ee = bb.selector.query(cw, ".ap-reviewRA-beneficiaryNameManualDeposit");
                                        bV = phe.hiddenField.getValue(ep);
                                        T = phe.hiddenField.getValue(b5);
                                        bZ = phe.hiddenField.getValue(cs);
                                        c6 = phe.hiddenField.getValue(A);
                                        df = phe.hiddenField.getValue(dF);
                                        ci = phe.hiddenField.getValue(dt);
                                        bv = phe.hiddenField.getValue(ee);
                                        t = t + "&methodPaymentOnline=" + aR + "&methodPaymentManualDeposit=" + dZ + "&sourceOfFunds=" + bV + "&lumpsumAmount=" + T
                                    }
                                }
                                t = t + "&benBankName=" + bZ + "&benBranchNameOrCode=" + c6 + "&benAccountNumber=" + df + "&benReferenceNumber=" + ci + "&benName=" + bv
                            }
                            if (ec == "6") {
                                var dK = bb.selector.query(cw, ".ap-reviewRA-quoteDescription");
                                var d8 = bb.selector.query(cw, ".ap-reviewRA-quoteReference");
                                var dO = bb.selector.query(cw, ".ap-reviewRA-fundCode");
                                var n = bb.selector.query(cw, ".ap-reviewRA-fundPercentage");
                                var cm = bb.selector.query(cw, ".ap-reviewRA-monthlyContributionNetAmount");
                                var es = bb.selector.query(cw, ".ap-reviewRA-lumpsumContributionNetAmount");
                                var bm = bb.selector.query(cw, ".ap-reviewRA-annualFee");
                                var db = bb.selector.query(cw, ".ap-reviewRA-initialFee");
                                var eo = bb.selector.query(cw, ".ap-reviewRA-platformFee");
                                var al = bb.selector.query(cw, ".ap-reviewRA-presumedReturn");
                                var ay = bb.selector.query(cw, ".ap-reviewRA-reduction");
                                var cp = bb.selector.query(cw, ".ap-reviewRA-actualReturn");
                                var m = bb.selector.query(cw, ".ap-reviewRA-investmentPeriod");
                                var I = phe.hiddenField.getValue(dK);
                                var bE = phe.hiddenField.getValue(d8);
                                var b3 = phe.hiddenField.getValue(dO);
                                var bW = phe.hiddenField.getValue(n);
                                var cZ = phe.hiddenField.getValue(cm);
                                var S = phe.hiddenField.getValue(es);
                                var cD = phe.hiddenField.getValue(bm);
                                var c9 = phe.hiddenField.getValue(db);
                                var cr = phe.hiddenField.getValue(eo);
                                var cK = phe.hiddenField.getValue(al);
                                var bN = phe.hiddenField.getValue(ay);
                                var a8 = phe.hiddenField.getValue(cp);
                                var d6 = phe.hiddenField.getValue(m);
                                t = t + "&quoteDescription=" + I + "&quoteReference=" + bE + "&fundCode=" + b3 + "&fundPercentage=" + bW + "&monthlyContributionNetAmount=" + cZ + "&lumpsumContributionNetAmount=" + S + "&annualFee=" + cD + "&initialFee=" + c9 + "&platformFee=" + cr + "&presumedReturn=" + cK + "&reduction=" + bN + "&actualReturn=" + a8 + "&investmentPeriod=" + d6;
                                var ar = bb.selector.queryAll(cw, ".ap-reviewRA-feesDetails");
                                for (var dL = 0; dL < ar.length; dL++) {
                                    var bu = bb.selector.query(ar[dL], ".ap-reviewRA-categoryId");
                                    var Q = bb.selector.query(ar[dL], ".ap-reviewRA-typeId");
                                    var cc = bb.selector.query(ar[dL], ".ap-reviewRA-totalPercentage");
                                    var bs = phe.hiddenField.getValue(bu);
                                    var dl = phe.hiddenField.getValue(Q);
                                    var aI = phe.hiddenField.getValue(cc);
                                    t = t + "&feesNumber=" + dL + "&categoryId=" + bs + "&typeId=" + dl + "&totalPercentage=" + aI
                                }
                            }
                        }
                    }
                }
            }
        }
        var cS = bb.selector.queryAll(cw, ".ap-reviewRA-beneficiaryDetails");
        var bx = 0;
        for (var dL = 0; dL < cS.length; dL++) {
            var dG = "false";
            var bF = "false";
            var F = "false";
            var cu = "";
            var dP = "";
            var a1 = "";
            var bc = "";
            var cq = "";
            var cO = "";
            var bQ = "";
            var aY = "";
            var ed = "";
            var bR = "";
            var ch = "";
            var dW = "";
            var at = "";
            var cB = "";
            var cb = "";
            var cE = "";
            var ef = bb.selector.query(cS[dL], ".ap-reviewRA-beneficiaryType");
            var cG = bb.selector.query(cS[dL], ".ap-reviewRA-beneficiaryNumber");
            cu = phe.hiddenField.getValue(ef);
            dP = phe.hiddenField.getValue(cG);
            if (cu == "Individual" || cu == "I") {
                var cj = bb.selector.query(cS[dL], ".ap-reviewRA-benFirstName");
                var s = bb.selector.query(cS[dL], ".ap-reviewRA-benSurname");
                var cI = bb.selector.query(cS[dL], ".ap-reviewRA-benCountryOfResidence");
                var aj = bb.selector.query(cS[dL], ".ap-reviewRA-benNationality");
                var dj = bb.selector.query(cS[dL], ".ap-reviewRA-benIdentityType");
                var d = bb.selector.query(cS[dL], ".ap-reviewRA-benIdentityNumber");
                var el = bb.selector.query(cS[dL], ".ap-reviewRA-benRelationship");
                var aQ = bb.selector.query(cS[dL], ".ap-reviewRA-benDateOfBirth");
                var di = bb.selector.query(cS[dL], ".ap-reviewRA-benPercentAllocation");
                cu = "Individual";
                bc = phe.hiddenField.getValue(cj);
                cq = phe.hiddenField.getValue(s);
                cO = phe.hiddenField.getValue(cI);
                bQ = phe.hiddenField.getValue(aj);
                aY = phe.hiddenField.getValue(dj);
                ed = phe.hiddenField.getValue(d);
                bR = phe.hiddenField.getValue(el);
                ch = phe.hiddenField.getValue(aQ);
                cE = phe.hiddenField.getValue(di);
                dG = "true"
            } else {
                if (cu == "Trust" || cu == "T") {
                    var b1 = bb.selector.query(cS[dL], ".ap-reviewRA-benTrustName");
                    var dN = bb.selector.query(cS[dL], ".ap-reviewRA-benRegistrationNumber");
                    var dE = bb.selector.query(cS[dL], ".ap-reviewRA-benCountryOfRegistration");
                    var c8 = bb.selector.query(cS[dL], ".ap-reviewRA-benInceptionDate");
                    var di = bb.selector.query(cS[dL], ".ap-reviewRA-benPercentAllocation");
                    cu = "Trust";
                    dW = phe.hiddenField.getValue(b1);
                    at = phe.hiddenField.getValue(dN);
                    cB = phe.hiddenField.getValue(dE);
                    cb = phe.hiddenField.getValue(c8);
                    cE = phe.hiddenField.getValue(di);
                    bF = "true"
                } else {
                    if (cu == "Estate" || cu == "E") {
                        var di = bb.selector.query(cS[dL], ".ap-reviewRA-benPercentAllocation");
                        cE = phe.hiddenField.getValue(di);
                        cu = "Estate";
                        F = "true"
                    } else {
                        if (cu == "") {
                            cE = "100";
                            cu = "Estate";
                            F = "true"
                        }
                    }
                }
            }
            bx++;
            t = t + "&beneficiaryIndividual=" + dG + "&beneficiaryTrust=" + bF + "&beneficiaryEstate=" + F + "&beneficiaryType=" + cu + "&beneficiaryNumber=" + bx + "&benFirstName=" + bc + "&benSurname=" + cq + "&benCountryOfResidence=" + cO + "&benNationality=" + bQ + "&benIdentityType=" + aY + "&benIdentityNumber=" + ed + "&benRelationship=" + bR + "&benDateOfBirth=" + ch + "&benTrustName=" + dW + "&benRegistrationNumber=" + at + "&benInceptionDate=" + cb + "&benCountryOfRegistration=" + cB + "&benPercentAllocation=" + cE + "&totalPercentAllocation=100"
        }
    }
    absa.modal.loadModal(t, absa.locale["ABCAP/General/Label/Advisor"], "", "");
    absa.advisorService.hideModalPrint()
};
absa.advisorService.onClose = function(c) {
    var b;
    if ("newbusiness" == onReturn) {
        b = bb.selector.query(window.document, ".ap-tabBody-retirementAnnuity")
    } else {
        if ("addition" == onReturn) {
            b = bb.selector.query(window.document, ".ap-retirementAnnuity-tabBody")
        } else {
            if ("review" == onReturn) {
                b = bb.selector.query(window.document, ".ap-retirementAnnuity-tabBody")
            }
        }
    }
    phe.modal.hideModal();
    phe.tabBody.reload(b)
};
absa.advisorService.onCloseInv = function(c) {
    var b;
    if ("newbusiness" == onReturn) {
        b = bb.selector.query(window.document, ".ap-tabBody-discretionaryIvestments")
    } else {
        if ("addition" == onReturn) {
            b = bb.selector.query(window.document, ".ap-investmentAccount-tabBody")
        }
    }
    phe.modal.hideModal();
    phe.tabBody.reload(b)
};
absa.advisorService.selectAdvisorForNewbusinessINV = function(e, b) {
    onReturn = e;
    var d = ".ap-applyNewBusinessINV-referenceNumber";
    var c = bb.selector.query(window.document, d);
    absa.modal.loadModal("proxy?pipe=genericEmptyResponse&xslFile=abcap/NewBusinessINV/advisorServiceINV&actionFlag=" + e + "&referenceNumber=" + c.value, absa.locale["ABCAP/General/Label/Advisor"], "", "");
    absa.advisorService.hideModalPrint()
};
absa.advisorService.selectAdvisorForINVaddition = function(C, aD) {
    onReturn = aD;
    var A = "proxy?pipe=genericEmptyResponse&xslFile=abcap/NewBusinessINV/advisorServiceINV&actionFlag=addition";
    var ag = "";
    var G = bb.selector.query(C, ".ap-additionForRA-rootForm");
    var aW = bb.selector.query(G, ".ap-additionForRA-completionStatus");
    var al = bb.selector.query(G, ".ap-additionForRA-screenId");
    var aS = bb.selector.query(G, ".ap-additionRA-referenceNumber");
    var au = bb.selector.query(G, ".ap-additionRA-policyNumber");
    var aO = bb.selector.query(G, ".ap-additionRA-clientName");
    var aT = bb.selector.query(G, ".ap-additionForRA-clientNumber");
    var aM = bb.selector.query(G, ".ap-additionForRA-stockAccountNum");
    var aU = bb.selector.query(G, ".ap-additionForRA-portfolioName");
    var ao = bb.selector.query(G, ".ap-additionForRA-portfolioCode");
    var W = phe.hiddenField.getValue(aW);
    var T = phe.hiddenField.getValue(al);
    var D = phe.hiddenField.getValue(aS);
    var an = phe.hiddenField.getValue(aT);
    var z = phe.hiddenField.getValue(aM);
    var x = phe.hiddenField.getValue(aU);
    var aZ = phe.hiddenField.getValue(ao);
    A = A + "&screenId=" + T + "&referenceNumber=" + D + "&isComplete=" + W + "&clientNumber=" + an + "&stockAccountNum=" + z + "&portfolioName=" + x + "&fundCode=" + aZ;
    var aR = "false";
    var aH = "true";
    A = A + "&regularContribution=" + aR + "&lumpsumContribution=" + aH;
    if (T == 1) {
        var R = phe.hiddenField.getValue(aO);
        var I = phe.hiddenField.getValue(au);
        A = A + "&clientName=" + R + "&policyNumber=" + I;
        var Q = "false";
        var b = "false";
        var aP = "";
        var aq = "0";
        var w = "";
        var o = "";
        var aG = "";
        var aV = "";
        var p = "";
        var a0 = "";
        var n = "";
        if (aH == "true") {
            var B = bb.selector.query(G, ".ap-additionRA-paymentMethodRadio");
            var ae = phe.radioGroup.getValue(B);
            var am = bb.selector.query(G, ".ap-additionRA-sourceOfFunds");
            var M = bb.selector.query(G, ".ap-additionRA-Amount");
            var ap = bb.selector.query(G, ".ap-additionRA-beneficiaryReference");
            var aL = bb.selector.query(G, ".ap-additionRA-paymntDt");
            aP = phe.select.getValue(am);
            aq = phe.textBox.getValue(M);
            w = phe.inputReadOnlyText.getValue(aL);
            sBeneficiaryReference = phe.inputReadOnlyText.getValue(ap);
            A = A + "&sourceOfFunds=" + aP + "&lumpsumAmount=" + aq + "&paymentDebitDate=" + w + "&beneficiaryReference=" + sBeneficiaryReference;
            if (ae == "OnceOff") {
                Q = "true";
                var q = bb.selector.query(G, ".ap-additionRA-myReference");
                var aA = bb.selector.query(G, ".apps-changePaymentDetailsST-accountToBeDebitedLinked");
                o = phe.textBox.getValue(q);
                aG = phe.select.getValue(aA);
                if (aG != "") {
                    var J = aG.split(" - ");
                    aV = J[0];
                    p = J[1]
                }
                a0 = "ABSA";
                n = "632005";
                A = A + "&myReference=" + o + "&accountToBeDebitedOnceOffPayment=" + aG + "&accountTypeOnceOffPayment=" + aV + "&accountNumberOnceOffPayment=" + p + "&bankNameOnceOffPayment=" + a0 + "&branchCodeOnceOffPayment=" + n + "&methodPaymentOnline=" + Q + "&methodPaymentManualDeposit=" + b
            } else {
                if (ae == "Manual") {
                    b = "true";
                    A = A + "&methodPaymentOnline=" + Q + "&methodPaymentManualDeposit=" + b
                }
            }
        }
    } else {
        if (T == 2) {
            var R = phe.hiddenField.getValue(aO);
            var I = phe.hiddenField.getValue(au);
            A = A + "&clientName=" + R + "&policyNumber=" + I;
            var Q = "false";
            var b = "false";
            var aP = "";
            var aq = "0";
            var w = "";
            var o = "";
            var aG = "";
            var aV = "";
            var p = "";
            var a0 = "";
            var n = "";
            if (aH == "true") {
                var B = bb.selector.query(G, ".ap-additionRA-paymentMethod");
                var ae = phe.radioGroup.getValue(B);
                var am = bb.selector.query(G, ".ap-additionRA-sourceOfFund");
                var M = bb.selector.query(G, ".ap-additionRA-LumpsumAmount");
                var ap = bb.selector.query(G, ".ap-additionRA-beneficiaryReference");
                var aL = bb.selector.query(G, ".ap-additionRA-paymntDt");
                aP = phe.hiddenField.getValue(am);
                aq = phe.hiddenField.getValue(M);
                w = phe.hiddenField.getValue(aL);
                sBeneficiaryReference = phe.hiddenField.getValue(ap);
                A = A + "&sourceOfFunds=" + aP + "&lumpsumAmount=" + aq + "&paymentDebitDate=" + w + "&beneficiaryReference=" + sBeneficiaryReference;
                if (ae == "OnceOff") {
                    Q = "true";
                    var q = bb.selector.query(G, ".ap-additionRA-myReference");
                    var aA = bb.selector.query(G, ".ap-additionRA-accountToBeDebitedLinked");
                    o = phe.hiddenField.getValue(q);
                    aG = phe.hiddenField.getValue(aA);
                    if (aG != "") {
                        var J = aG.split(" - ");
                        aV = J[0];
                        p = J[1]
                    }
                    a0 = "ABSA";
                    n = "632005";
                    A = A + "&myReference=" + o + "&accountToBeDebitedOnceOffPayment=" + aG + "&accountTypeOnceOffPayment=" + aV + "&accountNumberOnceOffPayment=" + p + "&bankNameOnceOffPayment=" + a0 + "&branchCodeOnceOffPayment=" + n + "&methodPaymentOnline=" + Q + "&methodPaymentManualDeposit=" + b
                } else {
                    if (ae == "Manual") {
                        b = "true";
                        A = A + "&methodPaymentOnline=" + Q + "&methodPaymentManualDeposit=" + b
                    }
                }
            }
            var az = bb.selector.query(G, ".ap-additionRA-quoteDate");
            var aE = bb.selector.query(G, ".ap-additionRA-quoteDescription");
            var at = bb.selector.query(G, ".ap-additionRA-quoteReference");
            var af = bb.selector.query(G, ".ap-additionRA-fundCode");
            var U = bb.selector.query(G, ".ap-additionRA-fundPercentage");
            var aC = bb.selector.query(G, ".ap-additionRA-monthlyContributionNetAmount");
            var Z = bb.selector.query(G, ".ap-additionRA-lumpsumContributionNetAmount");
            var f = bb.selector.query(G, ".ap-additionForRA-advisorFeeOnLumpsum");
            var aK = bb.selector.query(G, ".ap-additionForRA-advisorFeeOnDebitOrder");
            var aw = bb.selector.query(G, ".ap-additionForRA-advisorOngoingFee");
            var aY = bb.selector.query(G, ".ap-additionForRA-aimsFeeOnLumpsum");
            var H = bb.selector.query(G, ".ap-additionForRA-aimsFeeOnDebitOrder");
            var aN = bb.selector.query(G, ".ap-additionForRA-aimsOngoingFee");
            var aa = bb.selector.query(G, ".ap-additionForRA-annualFee");
            var h = bb.selector.query(G, ".ap-additionForRA-initialFee");
            var m = bb.selector.query(G, ".ap-additionForRA-platformFee");
            var Y = bb.selector.query(G, ".ap-additionForRA-presumedReturn");
            var r = bb.selector.query(G, ".ap-additionForRA-reduction");
            var ar = bb.selector.query(G, ".ap-additionForRA-actualReturn");
            var g = bb.selector.query(G, ".ap-additionRA-investmentPeriod");
            var l = phe.inputReadOnlyText.getValue(az);
            var u = phe.hiddenField.getValue(aE);
            var av = phe.hiddenField.getValue(at);
            var ac = phe.hiddenField.getValue(af);
            var V = phe.hiddenField.getValue(U);
            var aX = phe.hiddenField.getValue(aC);
            var ak = phe.hiddenField.getValue(Z);
            var d = phe.hiddenField.getValue(f);
            var S = phe.hiddenField.getValue(aK);
            var L = phe.hiddenField.getValue(aw);
            var K = phe.hiddenField.getValue(aY);
            var F = phe.hiddenField.getValue(H);
            var aQ = phe.hiddenField.getValue(aN);
            var ah = phe.hiddenField.getValue(aa);
            var aj = phe.hiddenField.getValue(h);
            var k = phe.hiddenField.getValue(m);
            var ab = phe.hiddenField.getValue(Y);
            var y = phe.hiddenField.getValue(r);
            var P = phe.hiddenField.getValue(ar);
            var X = phe.hiddenField.getValue(g);
            A = A + "&quotationDate=" + l + "&quoteDescription=" + u + "&quoteReference=" + av + "&fundPercentage=" + V + "&monthlyContributionNetAmount=" + aX + "&lumpsumContributionNetAmount=" + ak + "&advisorFeeOnLumpsum=" + d + "&advisorFeeOnDebitOrder=" + S + "&advisorOngoingFee=" + L + "&aimsFeeOnLumpsum=" + K + "&aimsFeeOnDebitOrder=" + F + "&aimsOngoingFee=" + aQ + "&annualFee=" + ah + "&initialFee=" + aj + "&platformFee=" + k + "&presumedReturn=" + ab + "&reduction=" + y + "&actualReturn=" + P + "&investmentPeriod=" + X;
            var aJ = bb.selector.queryAll(G, ".ap-additionRA-feesDetails");
            for (var O = 0; O < aJ.length; O++) {
                var ax = bb.selector.query(aJ[O], ".ap-additionForRA-categoryId");
                var ay = bb.selector.query(aJ[O], ".ap-additionForRA-typeId");
                var ad = bb.selector.query(aJ[O], ".ap-additionForRA-totalPercentage");
                var E = phe.hiddenField.getValue(ax);
                var s = phe.hiddenField.getValue(ay);
                var aI = phe.hiddenField.getValue(ad);
                A = A + "&feesNumber=" + O + "&categoryId=" + E + "&typeId=" + s + "&totalPercentage=" + aI
            }
            var N = bb.selector.queryAll(G, ".ap-additionINV-fundDetailsAdvisor");
            for (var O = 0; O < N.length; O++) {
                var aF = bb.selector.query(N[O], ".ap-additionForINV-displayStatusAdvisor");
                var v = bb.selector.query(N[O], ".ap-additionForINV-investmentDropdownAdvisor");
                var aB = bb.selector.query(N[O], ".ap-additionForINV-percentageAllocationAdvisor");
                var c = bb.selector.query(N[O], ".ap-additionForINV-additionAmountAdvisor");
                var t = phe.hiddenField.getValue(aF);
                var j = phe.hiddenField.getValue(v);
                var ai = phe.hiddenField.getValue(aB);
                var e = phe.hiddenField.getValue(c);
                A = A + "&displayStatus=" + t + "&investmentDropdown=" + j + "&percentageAllocation=" + ai + "&additionAmount=" + e
            }
        }
    }
    absa.modal.loadModal(A, absa.locale["ABCAP/General/Label/Advisor"], "", "");
    absa.advisorService.hideModalPrint()
};
absa.advisorService.onCloseAdvisor = function(c) {
    var b;
    if ("newbusiness" == onReturn) {
        b = bb.selector.query(window.document, ".ap-tabBody-discretionaryIvestments")
    } else {
        if ("addition" == onReturn) {
            b = bb.selector.query(window.document, ".ap-discretionaryInvestment")
        }
    }
    phe.modal.hideModal();
    phe.tabBody.reload(b)
};
absa.advisorService.selectAdvisorForNewbusinessRR = function(e, b) {
    onReturn = e;
    var d = ".ap-applyNewBusinessRR-referenceNumber";
    var c = bb.selector.query(window.document, d);
    absa.modal.loadModal("proxy?pipe=genericEmptyResponse&xslFile=aims/apply/advisorService&actionFlag=" + e + "&referenceNumber=" + c.value, absa.locale["ABCAP/General/Label/Advisor"], "", "");
    absa.advisorService.hideModalPrint()
};
absa.advisorService.selectAdvisorForRRaddition = function(F, aH) {
    onReturn = aH;
    var D = "proxy?pipe=genericEmptyResponse&xslFile=aims/apply/advisorService&actionFlag=addition";
    var ak = "";
    var J = bb.selector.query(F, ".ap-additionForAims-rootForm");
    var a1 = bb.selector.query(J, ".ap-additionRR-completionStatus");
    var ap = bb.selector.query(J, ".ap-additionRR-screenId");
    var aX = bb.selector.query(J, ".ap-additionRR-referenceNumber");
    var ay = bb.selector.query(J, ".ap-additionRR-policyNumber");
    var aT = bb.selector.query(J, ".ap-additionRR-clientName");
    var aY = bb.selector.query(J, ".ap-additionRR-clientNumber");
    var aR = bb.selector.query(J, ".ap-additionRR-stockAccountNum");
    var aZ = bb.selector.query(J, ".ap-additionRR-portfolioName");
    var at = bb.selector.query(J, ".ap-additionRR-portfolioCode");
    var aa = phe.hiddenField.getValue(a1);
    var W = phe.hiddenField.getValue(ap);
    var G = phe.hiddenField.getValue(aX);
    var ar = phe.hiddenField.getValue(aY);
    var C = phe.hiddenField.getValue(aR);
    var A = phe.hiddenField.getValue(aZ);
    var a4 = phe.hiddenField.getValue(at);
    D = D + "&screenId=" + W + "&referenceNumber=" + G + "&isComplete=" + aa + "&clientNumber=" + ar + "&stockAccountNum=" + C + "&portfolioName=" + A + "&fundCode=" + a4;
    var aW = "false";
    var aM = "true";
    D = D + "&regularContribution=" + aW + "&lumpsumContribution=" + aM;
    if (W == 1) {
        var V = phe.hiddenField.getValue(aT);
        var L = phe.hiddenField.getValue(ay);
        D = D + "&clientName=" + V + "&policyNumber=" + L;
        var U = "false";
        var b = "false";
        var aU = "";
        var av = "0";
        var z = "";
        var q = "";
        var aL = "";
        var a0 = "";
        var r = "";
        var a5 = "";
        var n = "";
        if (aM == "true") {
            var E = bb.selector.query(J, ".ap-additionRR-paymentMethodRadio");
            var ai = phe.radioGroup.getValue(E);
            var aq = bb.selector.query(J, ".ap-additionRR-sourceOfFunds");
            var P = bb.selector.query(J, ".ap-additionRR-Amount");
            var au = bb.selector.query(J, ".ap-additionRR-beneficiaryReference");
            var aQ = bb.selector.query(J, ".ap-additionRR-paymntDt");
            aU = phe.select.getValue(aq);
            av = phe.textBox.getValue(P);
            z = phe.inputReadOnlyText.getValue(aQ);
            sBeneficiaryReference = phe.inputReadOnlyText.getValue(au);
            D = D + "&sourceOfFunds=" + aU + "&lumpsumAmount=" + av + "&paymentDebitDate=" + z + "&beneficiaryReference=" + sBeneficiaryReference;
            if (ai == "OnceOff") {
                U = "true";
                var t = bb.selector.query(J, ".ap-additionRR-myReference");
                var aE = bb.selector.query(J, ".apps-changePaymentDetailsST-accountToBeDebitedLinked");
                q = phe.textBox.getValue(t);
                aL = phe.select.getValue(aE);
                if (aL != "") {
                    var M = aL.split(" - ");
                    a0 = M[0];
                    r = M[1]
                }
                a5 = "ABSA";
                n = "632005";
                D = D + "&myReference=" + q + "&accountToBeDebitedOnceOffPayment=" + aL + "&accountTypeOnceOffPayment=" + a0 + "&accountNumberOnceOffPayment=" + r + "&bankNameOnceOffPayment=" + a5 + "&branchCodeOnceOffPayment=" + n + "&methodPaymentOnline=" + U + "&methodPaymentManualDeposit=" + b
            } else {
                if (ai == "Manual") {
                    b = "true";
                    D = D + "&methodPaymentOnline=" + U + "&methodPaymentManualDeposit=" + b
                }
            }
        }
    } else {
        if (W == 2) {
            var V = phe.hiddenField.getValue(aT);
            var L = phe.hiddenField.getValue(ay);
            D = D + "&clientName=" + V + "&policyNumber=" + L;
            var U = "false";
            var b = "false";
            var aU = "";
            var av = "0";
            var z = "";
            var q = "";
            var aL = "";
            var a0 = "";
            var r = "";
            var a5 = "";
            var n = "";
            if (aM == "true") {
                var E = bb.selector.query(J, ".ap-additionRR-paymentMethod");
                var ai = phe.radioGroup.getValue(E);
                var aq = bb.selector.query(J, ".ap-additionRR-sourceOfFund");
                var P = bb.selector.query(J, ".ap-additionRR-LumpsumAmount");
                var au = bb.selector.query(J, ".ap-additionRR-beneficiaryReference");
                var aQ = bb.selector.query(J, ".ap-additionRR-paymntDt");
                aU = phe.hiddenField.getValue(aq);
                av = phe.hiddenField.getValue(P);
                z = phe.hiddenField.getValue(aQ);
                sBeneficiaryReference = phe.hiddenField.getValue(au);
                D = D + "&sourceOfFunds=" + aU + "&lumpsumAmount=" + av + "&paymentDebitDate=" + z + "&beneficiaryReference=" + sBeneficiaryReference;
                if (ai == "OnceOff") {
                    U = "true";
                    var t = bb.selector.query(J, ".ap-additionRR-myReference");
                    var aE = bb.selector.query(J, ".ap-additionRR-accountToBeDebitedLinked");
                    q = phe.hiddenField.getValue(t);
                    aL = phe.hiddenField.getValue(aE);
                    if (aL != "") {
                        var M = aL.split(" - ");
                        a0 = M[0];
                        r = M[1]
                    }
                    a5 = "ABSA";
                    n = "632005";
                    D = D + "&myReference=" + q + "&accountToBeDebitedOnceOffPayment=" + aL + "&accountTypeOnceOffPayment=" + a0 + "&accountNumberOnceOffPayment=" + r + "&bankNameOnceOffPayment=" + a5 + "&branchCodeOnceOffPayment=" + n + "&methodPaymentOnline=" + U + "&methodPaymentManualDeposit=" + b
                } else {
                    if (ai == "Manual") {
                        b = "true";
                        D = D + "&methodPaymentOnline=" + U + "&methodPaymentManualDeposit=" + b
                    }
                }
            }
            var aD = bb.selector.query(J, ".ap-additionRR-quoteDate");
            var aJ = bb.selector.query(J, ".ap-additionRR-quoteDescription");
            var ax = bb.selector.query(J, ".ap-additionRR-quoteReference");
            var aj = bb.selector.query(J, ".ap-additionRR-fundCode");
            var Y = bb.selector.query(J, ".ap-additionRR-fundPercentage");
            var aG = bb.selector.query(J, ".ap-additionRR-monthlyContributionNetAmount");
            var ad = bb.selector.query(J, ".ap-additionRR-lumpsumContributionNetAmount");
            var f = bb.selector.query(J, ".ap-additionRR-advisorFeeOnLumpsum");
            var aP = bb.selector.query(J, ".ap-additionRR-advisorFeeOnDebitOrder");
            var aA = bb.selector.query(J, ".ap-additionRR-advisorOngoingFee");
            var a3 = bb.selector.query(J, ".ap-additionRR-aimsFeeOnLumpsum");
            var K = bb.selector.query(J, ".ap-additionRR-aimsFeeOnDebitOrder");
            var aS = bb.selector.query(J, ".ap-additionRR-aimsOngoingFee");
            var ac = bb.selector.query(J, ".ap-additionRR-presumedReturn");
            var u = bb.selector.query(J, ".ap-additionRR-reduction");
            var aw = bb.selector.query(J, ".ap-additionRR-actualReturn");
            var g = bb.selector.query(J, ".ap-additionRR-investmentPeriod");
            var m = phe.inputReadOnlyText.getValue(aD);
            m = m.replace(/\//g, "");
            var x = phe.hiddenField.getValue(aJ);
            var az = phe.hiddenField.getValue(ax);
            var ag = phe.hiddenField.getValue(aj);
            var Z = phe.hiddenField.getValue(Y);
            var a2 = phe.hiddenField.getValue(aG);
            var ao = phe.hiddenField.getValue(ad);
            var d = phe.hiddenField.getValue(f);
            var X = phe.hiddenField.getValue(aP);
            var O = phe.hiddenField.getValue(aA);
            var N = phe.hiddenField.getValue(a3);
            var I = phe.hiddenField.getValue(K);
            var aV = phe.hiddenField.getValue(aS);
            var af = phe.hiddenField.getValue(ac);
            var B = phe.hiddenField.getValue(u);
            var T = phe.hiddenField.getValue(aw);
            var ab = phe.hiddenField.getValue(g);
            D = D + "&quotationDate=" + m + "&quoteDescription=" + x + "&quoteReference=" + az + "&fundPercentage=" + Z + "&monthlyContributionNetAmount=" + a2 + "&lumpsumContributionNetAmount=" + ao + "&advisorFeeOnLumpsum=" + d + "&advisorFeeOnDebitOrder=" + X + "&advisorOngoingFee=" + O + "&aimsFeeOnLumpsum=" + N + "&aimsFeeOnDebitOrder=" + I + "&aimsOngoingFee=" + aV + "&presumedReturn=" + af + "&reduction=" + B + "&actualReturn=" + T + "&investmentPeriod=" + ab;
            var aO = bb.selector.queryAll(J, ".ap-additionRR-feesDetails");
            for (var R = 0; R < aO.length; R++) {
                var aB = bb.selector.query(aO[R], ".ap-additionRR-categoryId");
                var aC = bb.selector.query(aO[R], ".ap-additionRR-typeId");
                var ah = bb.selector.query(aO[R], ".ap-additionRR-totalPercentage");
                var H = phe.hiddenField.getValue(aB);
                var v = phe.hiddenField.getValue(aC);
                var aN = phe.hiddenField.getValue(ah);
                D = D + "&feesNumber=" + R + "&categoryId=" + H + "&typeId=" + v + "&totalPercentage=" + aN
            }
            var p = bb.selector.queryAll(J, ".ap-additionRR-fundFees");
            for (var R = 0; R < p.length; R++) {
                var ae = bb.selector.query(p[R], ".ap-additionRR-annualFee");
                var h = bb.selector.query(p[R], ".ap-additionRR-initialFee");
                var l = bb.selector.query(p[R], ".ap-additionRR-platformFee");
                var o = bb.selector.query(p[R], ".ap-additionRR-quoteFundName");
                var aI = bb.selector.query(p[R], ".ap-additionRR-quoteFundCode");
                var al = phe.hiddenField.getValue(ae);
                var an = phe.hiddenField.getValue(h);
                var k = phe.hiddenField.getValue(l);
                var S = phe.hiddenField.getValue(o);
                var s = phe.hiddenField.getValue(aI);
                D = D + "&annualFee=" + al + "&initialFee=" + an + "&platformFee=" + k + "&quoteFundName=" + S + "&quoteFundCode=" + s
            }
            var Q = bb.selector.queryAll(J, ".ap-additionRR-fundDetailsAdvisor");
            for (var R = 0; R < Q.length; R++) {
                var aK = bb.selector.query(Q[R], ".ap-additionRR-displayStatusAdvisor");
                var y = bb.selector.query(Q[R], ".ap-additionRR-investmentDropdownAdvisor");
                var aF = bb.selector.query(Q[R], ".ap-additionRR-percentageAllocationAdvisor");
                var c = bb.selector.query(Q[R], ".ap-additionRR-additionAmountAdvisor");
                var w = phe.hiddenField.getValue(aK);
                var j = phe.hiddenField.getValue(y);
                var am = phe.hiddenField.getValue(aF);
                var e = phe.hiddenField.getValue(c);
                D = D + "&displayStatus=" + w + "&investmentDropdown=" + j + "&percentageAllocation=" + am + "&additionAmount=" + e
            }
        }
    }
    absa.modal.loadModal(D, absa.locale["ABCAP/General/Label/Advisor"], "", "");
    absa.advisorService.hideModalPrint()
};
absa.nonTransactional = absa.nonTransactional || {};
absa.nonTransactional.OnRadioGroupChange = function(d) {
    var e = bb.selector.queryAncestor(d, ".ap-conversion-form-step0");
    var c = bb.selector.query(e, ".ap-conversion-snoozeRow");
    var b = bb.selector.query(e, ".ap-conversion-termsOfUseRow");
    if (phe.radioGroup.getValue(d) == "yes") {
        phe.common.hide(c);
        phe.common.show(b)
    } else {
        phe.common.show(c);
        phe.common.hide(b)
    }
};
absa.nonTransactional.onNextClick = function(k) {
    var l = bb.selector.queryAncestor(k, ".ap-conversion-form-step0");
    var b = bb.selector.query(l, ".ap-conversion-snoozeRow");
    var e = bb.selector.query(l, ".ap-conversion-snoozePeriod");
    var j = bb.selector.query(l, ".ap-conversion-radioGroup");
    var n = phe.select.getValue(e);
    var g = bb.selector.query(l, ".ap-conversion-checkbox");
    if (phe.radioGroup.getValue(j) == "yes" || phe.radioGroup.getValue(j) == "yesno") {
        if (absa.form.validate.checkElement(g)) {
            phe.modal.hideModal();
            var d = bb.selector.queryAll(l, ".ap-conversion-accNoToLink");
            var c = bb.selector.queryAll(l, ".ap-conversion-accTypeNameToLink");
            var m = absa.locale["NonTransactional/General/Label/AbsaOnlineConversion"];
            sUrl = "proxy?pipe=genericEmptyResponse&xslFile=NonTransactional/convert-step1";
            for (var h = 0; h < d.length; h++) {
                sUrl = sUrl + "&accNoToLink=" + phe.hiddenField.getValue(d[h]) + "&accTypeNameToLink=" + phe.hiddenField.getValue(c[h])
            }
            absa.modal.loadModal(sUrl, m, "", absa.nonTransactional.onModalClose, "", "914")
        } else {
            g.focus()
        }
    } else {
        if (absa.form.validate.checkElement(e)) {
            phe.loadingMessage.showLoadingMessage(l);
            var f = "proxy?pipe=genericWebservice&ws=PortfolioWebService&action=processTransactionalSnooze&actionType=I&snoozePeriod=" + n;
            absa.io.makeRequest(f, function(o) {
                phe.loadingMessage.hideLoadingMessage(l);
                var i = bb.html.createElementFromString(o.text);
                l.parentNode.replaceChild(i, l)
            })
        }
    }
};
absa.nonTransactional.onModalClose = function(d) {
    var b = bb.selector.query(d, ".ap-conversion-wizard");
    var c = phe.wizard.getCurrentStepIndex(b);
    if (c == "1") {
        var e = bb.selector.query(d, ".ap-conversion-form3");
        absa.index.doLogout(2)
    }
};
absa.nonTransactional.onFinishButtonClick = function(b) {
    var c = bb.selector.queryAncestor(b, ".ap-conversion-form2");
    absa.index.doLogout(2)
};
absa.nonTransactional.reloadSite = function(b) {
    absa.showPleaseWait();
    absa.index.refreshUpdaters(true, true);
    phe.modal.hideModal()
};
absa.nonTransactional.beforeSubmitAccountsStep1 = function(b) {
    var c = bb.selector.queryAncestor(b, ".ap-conversion-form1");
    absa.form.validateAndSubmit(c)
};
absa.nonTransactional.startAgain = function(c) {
    var b = bb.selector.queryAncestor(c, ".ap-linkUnlink-tabBox");
    var e = phe.tabBox.getCurrentTabBody(b);
    var d = phe.tabBox.getAttribute(e, "proxyurl");
    phe.tabBox.setAttribute(e, "proxyurl", d);
    absa.lazyLoadNode(e, true)
};